/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.remoteimpl.login;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.lib.security.PasswordChangeCallback;
import com.sap.engine.lib.security.ReusableLoginContext;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseIllegalStateException;
import com.sap.engine.services.security.exceptions.BaseUnsupportedCallbackException;
import com.sap.engine.services.security.remote.login.RemoteCallbackHandler;
import com.sap.engine.services.security.remote.login.RemoteLoginContextHelper;
import com.sap.engine.services.security.remote.login.SerializableGetterCallback;
import com.sap.engine.services.security.remote.login.SerializableNameCallback;
import com.sap.engine.services.security.remote.login.SerializablePasswordCallback;
import com.sap.engine.services.security.remote.login.SerializablePasswordChangeCallback;
import com.sap.engine.services.security.remote.login.SerializableSetterCallback;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class RemoteLoginContextHelperImpl
extends PortableRemoteObject
implements CallbackHandler,
RemoteLoginContextHelper {
    private static final String MON_COMPONENT_REMOTE_HANDLE = "AppServer:Security:Authentication:RemoteLoginContextHelperImpl:handle";
    private SecurityContext security = null;
    LoginContext login = null;
    RemoteCallbackHandler handler = null;
    SecuritySession session = null;

    public RemoteLoginContextHelperImpl(SecurityContext security) throws RemoteException {
        this.security = security;
    }

    public void login(RemoteCallbackHandler calbbackHandler) throws LoginException, RemoteException {
        this.handler = calbbackHandler;
        this.login = this.security.getAuthenticationContext().getLoginContext(null, this);
        ThreadContext currentThreadContext = SecurityServerFrame.threadContext.getThreadContext();
        if (currentThreadContext != null) {
            SecurityContextObject object = (SecurityContextObject)((Object)currentThreadContext.getContextObject("security"));
            this.session = object.getSession();
            if (this.session.getAuthenticationConfiguration() != null) {
                object.setSession(null);
            }
        }
        this.login.login();
    }

    public void logout() throws LoginException, RemoteException {
        this.login.logout();
        if (this.login instanceof ReusableLoginContext) {
            ((ReusableLoginContext)this.login).close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(Callback[] acallback) throws IOException, UnsupportedCallbackException {
        IMonitor monitor = null;
        try {
            monitor = TaskMonitor.getRequestMonitor(null, (String)"AppServer:Security:Authentication");
            monitor.startComponent(MON_COMPONENT_REMOTE_HANDLE);
            if (this.handler == null) {
                throw new BaseIllegalStateException("security_6035");
            }
            int i = 0;
            while (i < acallback.length) {
                Serializable callback;
                if (acallback[i] instanceof Remote) {
                    this.handler.handle(acallback[i]);
                } else if (acallback[i] instanceof NameCallback) {
                    callback = new SerializableNameCallback((NameCallback)acallback[i]);
                    callback = (SerializableNameCallback)this.handler.handle(callback);
                    ((NameCallback)acallback[i]).setName(((SerializableNameCallback)callback).getName());
                } else if (acallback[i] instanceof PasswordChangeCallback) {
                    callback = new SerializablePasswordChangeCallback((PasswordChangeCallback)acallback[i]);
                    callback = (SerializablePasswordChangeCallback)this.handler.handle(callback);
                    ((PasswordChangeCallback)acallback[i]).setPassword(((SerializablePasswordChangeCallback)callback).getPassword());
                } else if (acallback[i] instanceof PasswordCallback) {
                    callback = new SerializablePasswordCallback((PasswordCallback)acallback[i]);
                    callback = (SerializablePasswordCallback)this.handler.handle(callback);
                    ((PasswordCallback)acallback[i]).setPassword(((SerializablePasswordCallback)callback).getPassword());
                } else if (acallback[i] instanceof HttpGetterCallback) {
                    HttpGetterCallback getterCallback = (HttpGetterCallback)acallback[i];
                    SerializableGetterCallback serializableGetterCallback2 = new SerializableGetterCallback(getterCallback);
                    serializableGetterCallback2 = (SerializableGetterCallback)this.handler.handle(serializableGetterCallback2);
                    getterCallback.setValue(serializableGetterCallback2.getValue());
                } else {
                    if (!(acallback[i] instanceof HttpSetterCallback)) throw new BaseUnsupportedCallbackException(acallback[i], "security_6040");
                    HttpSetterCallback setterCallback = (HttpSetterCallback)acallback[i];
                    if (!(setterCallback.getValue() instanceof Serializable)) throw new BaseUnsupportedCallbackException(acallback[i], "security_6042", new Object[]{setterCallback.getValue()});
                    SerializableSetterCallback serializableSetterCallback = new SerializableSetterCallback(setterCallback);
                    this.handler.handle(serializableSetterCallback);
                }
                ++i;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.endComponent(MON_COMPONENT_REMOTE_HANDLE);
            throw throwable;
        }
        monitor.endComponent(MON_COMPONENT_REMOTE_HANDLE);
    }
}

