/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.remoteimpl.domains;

import com.sap.engine.interfaces.security.ProtectionDomainContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.services.security.domains.ProtectionDomainsRuntime;
import com.sap.engine.services.security.exceptions.BaseRemoteException;
import com.sap.engine.services.security.remote.domains.RemoteProtectionDomains;
import com.sap.engine.services.security.server.ProtectionDomainContextImpl;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;

public class RemoteProtectionDomainsImpl
extends PortableRemoteObject
implements RemoteProtectionDomains {
    ProtectionDomainContext domains = null;
    ProtectionDomainsRuntime runtime = null;

    public RemoteProtectionDomainsImpl(SecurityContext security) throws RemoteException {
        this.domains = security.getAuthorizationContext().getProtectionDomainContext();
        this.runtime = ((ProtectionDomainContextImpl)this.domains).getProtectionDomainsRuntime();
    }

    public void clearPermission(String domain, String permission, String instance, String action) throws RemoteException {
        this.runtime.clearPermission(domain, permission, instance, action);
    }

    public String[] getDomainsNames() throws RemoteException {
        return this.runtime.getDomainsNames();
    }

    public Vector getAllKnownPermissions() throws RemoteException {
        return this.runtime.getAllKnownPermissions();
    }

    public void addKnownPermission(String className, String[] names, String[] actions) throws RemoteException {
        this.runtime.addKnownPermission(className, names, actions);
    }

    public void removeKnownPermission(String className, String[] names, String[] actions) throws RemoteException {
        this.runtime.addKnownPermission(className, names, actions);
    }

    public void grantPermission(String domain, String permission, String instance, String action) throws RemoteException {
        if (domain != null) {
            this.runtime.grantPermission(domain, permission, instance, action);
        }
    }

    public Vector getPermissions(String domain) throws RemoteException {
        return this.runtime.getPermissions(domain);
    }

    public Vector getInheritedPermissions(String domain) throws RemoteException {
        throw new BaseRemoteException("security_6026", new Object[]{domain});
    }

    public Vector getGrantedPermissions(String domain) throws RemoteException {
        throw new BaseRemoteException("security_6027", new Object[]{domain});
    }

    public Vector getDeniedPermissions(String domain) throws RemoteException {
        throw new BaseRemoteException("security_6028", new Object[]{domain});
    }
}

