/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.remoteimpl;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.security.ModificationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.login.monitor.MonitorTable;
import com.sap.engine.services.security.remote.RemotePolicyConfiguration;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import com.sap.engine.services.security.remote.crypt.RemoteCryptography;
import com.sap.engine.services.security.remote.domains.RemoteProtectionDomains;
import com.sap.engine.services.security.remote.login.RemoteLoginContextHelper;
import com.sap.engine.services.security.remote.sessions.RemoteSecuritySessions;
import com.sap.engine.services.security.remoteimpl.RemotePolicyConfigurationImpl;
import com.sap.engine.services.security.remoteimpl.crypt.RemoteCryptographyImpl;
import com.sap.engine.services.security.remoteimpl.domains.RemoteProtectionDomainsImpl;
import com.sap.engine.services.security.remoteimpl.login.RemoteLoginContextHelperImpl;
import com.sap.engine.services.security.remoteimpl.sessions.RemoteSecuritySessionsImpl;
import com.sap.engine.services.security.userstore.RemoteUserStoreFactoryImpl;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class RemoteSecurityImpl
extends PortableRemoteObject
implements RemoteSecurity {
    private SecurityContext security = null;
    private RemoteUserStoreFactory factory = null;
    private RemoteProtectionDomainsImpl domains = null;
    private RemoteSecuritySessions sessions = null;
    private RemoteCryptographyImpl crypt = null;

    public RemoteSecurityImpl(SecurityContext security) throws RemoteException {
        this.security = security;
        this.factory = new RemoteUserStoreFactoryImpl(security.getUserStoreContext());
        this.domains = new RemoteProtectionDomainsImpl(security);
        this.sessions = new RemoteSecuritySessionsImpl();
        this.crypt = new RemoteCryptographyImpl();
    }

    public RemoteCryptography getCryptography() throws RemoteException {
        return this.crypt;
    }

    public RemotePolicyConfiguration getPolicyConfiguration(String name) throws RemoteException {
        return new RemotePolicyConfigurationImpl(this, this.security.getPolicyConfigurationContext(name), name);
    }

    public synchronized RemoteProtectionDomains getProtectionDomains() throws RemoteException {
        return this.domains;
    }

    public RemoteSecuritySessions getSecuritySessions() throws RemoteException {
        return this.sessions;
    }

    public String[] listPolicyConfigurations() throws RemoteException {
        try {
            return this.security.listPolicyConfigurations();
        }
        catch (Error err) {
            SecurityServerFrame.getLogger().logThrowable((byte)4, err);
        }
        catch (Exception err) {
            SecurityServerFrame.getLogger().logThrowable((byte)4, err);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerPolicyConfiguration(String name) throws RemoteException {
        ModificationContext modification = null;
        ConfigurationHandler handler = null;
        ConfigurationHandlerFactory configurationHandlerFactory = SecurityServerFrame.getServiceContext().getCoreContext().getConfigurationHandlerFactory();
        handler = configurationHandlerFactory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            configuration = handler.openConfiguration("policy_configurations/" + name, 1);
        }
        catch (ConfigurationException ce) {
            try {
                configuration = handler.openConfiguration("policy_configurations", 1).createSubConfiguration(name);
            }
            catch (ConfigurationException cee) {
                try {
                    configuration = handler.createRootConfiguration("policy_configurations").createSubConfiguration(name);
                }
                catch (ConfigurationException ceee) {
                    SecurityServerFrame.getLogger().logThrowable((byte)4, (Throwable)((Object)ceee));
                }
            }
        }
        modification = this.security.getModificationContext();
        modification.beginModifications(configuration).registerPolicyConfiguration(name);
        handler.commit();
        Object var10_11 = null;
        if (handler == null) return;
        try {
            handler.closeAllConfigurations();
            return;
        }
        catch (ConfigurationException ce) {
            SecurityServerFrame.getLogger().logThrowable((byte)4, (Throwable)((Object)ce));
        }
        return;
        {
            catch (Error err) {
                SecurityServerFrame.getLogger().logThrowable((byte)4, err);
                Object var10_12 = null;
                if (handler == null) return;
                try {
                    handler.closeAllConfigurations();
                    return;
                }
                catch (ConfigurationException ce) {
                    SecurityServerFrame.getLogger().logThrowable((byte)4, (Throwable)((Object)ce));
                }
                return;
            }
            catch (Exception err) {
                SecurityServerFrame.getLogger().logThrowable((byte)4, err);
                Object var10_13 = null;
                if (handler == null) return;
                try {
                    handler.closeAllConfigurations();
                    return;
                }
                catch (ConfigurationException ce) {
                    SecurityServerFrame.getLogger().logThrowable((byte)4, (Throwable)((Object)ce));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (handler == null) throw throwable;
            try {
                handler.closeAllConfigurations();
                throw throwable;
            }
            catch (ConfigurationException ce) {
                SecurityServerFrame.getLogger().logThrowable((byte)4, (Throwable)((Object)ce));
            }
            throw throwable;
        }
    }

    public void unregisterPolicyConfiguration(String name) throws RemoteException {
        try {
            this.security.unregisterPolicyConfiguration(name);
        }
        catch (Error err) {
            SecurityServerFrame.getLogger().logThrowable((byte)4, err);
        }
        catch (Exception err) {
            SecurityServerFrame.getLogger().logThrowable((byte)4, err);
        }
    }

    public RemoteLoginContextHelper getRemoteLoginContext() throws RemoteException {
        return new RemoteLoginContextHelperImpl(this.security);
    }

    public RemoteLoginContextHelper getRemoteLoginContext(String policyConfiguration) throws RemoteException {
        return new RemoteLoginContextHelperImpl(this.security.getPolicyConfigurationContext(policyConfiguration));
    }

    public RemoteUserStoreFactory getRemoteUserStoreFactory() throws RemoteException {
        return this.factory;
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public long getUserStoreAccessCount() {
        return 0L;
    }

    public String[] getAuthenticationStacks() {
        return MonitorTable.getAuthenticationStacks();
    }

    public int getActiveSessionsCount(String authenticationStack) {
        return MonitorTable.getMonitor((String)authenticationStack).successLogonCount;
    }

    public int getLoggedUsersCount(String authenticationStack) {
        return 0;
    }

    public long getTotalSessionsCount(String authenticationStack) {
        return MonitorTable.getMonitor((String)authenticationStack).totalSessionCount;
    }

    public long getTimedOutSessionsCount(String authenticationStack) {
        return MonitorTable.getMonitor((String)authenticationStack).tiemoutSessionCount;
    }

    public long getLoggedOffSessionsCount(String authenticationStack) {
        return MonitorTable.getMonitor((String)authenticationStack).logoffSessionCount;
    }

    public long getUnsuccessfullLogonAttemptsCount(String authenticationStack) {
        return MonitorTable.getMonitor((String)authenticationStack).failedLogonCount;
    }

    public long getInvalidSessionsCount(String authenticationStack) {
        return MonitorTable.getMonitor((String)authenticationStack).invalidSessionCount;
    }

    public int getActiveSessionsCount() {
        return MonitorTable.getAggregatedMonitor().successLogonCount;
    }

    public int getLoggedUsersCount() {
        return 0;
    }

    public long getTotalSessionsCount() {
        return MonitorTable.getAggregatedMonitor().totalSessionCount;
    }

    public long getTimedOutSessionsCount() {
        return MonitorTable.getAggregatedMonitor().tiemoutSessionCount;
    }

    public long getLoggedOffSessionsCount() {
        return MonitorTable.getAggregatedMonitor().logoffSessionCount;
    }

    public long getUnsuccessfullLogonAttemptsCount() {
        return MonitorTable.getAggregatedMonitor().failedLogonCount;
    }

    public long getInvalidSessionsCount() {
        return MonitorTable.getAggregatedMonitor().invalidSessionCount;
    }
}

