/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.remote.login;

import java.io.Serializable;
import javax.security.auth.callback.PasswordCallback;

public class SerializablePasswordCallback
implements Serializable {
    static final long serialVersionUID = -8878825117961567329L;
    boolean isEchoOn;
    char[] password;
    String prompt;

    public SerializablePasswordCallback(PasswordCallback callback) {
        this.isEchoOn = callback.isEchoOn();
        this.prompt = callback.getPrompt();
        this.setPassword(callback.getPassword());
    }

    public String getPrompt() {
        return this.prompt;
    }

    public boolean isEchoOn() {
        return this.isEchoOn;
    }

    public void setPassword(char[] chars) {
        this.password = chars != null ? SerializablePasswordCallback.mask(chars) : null;
    }

    public char[] getPassword() {
        return this.password != null ? SerializablePasswordCallback.unmask(this.password) : null;
    }

    public void clearPassword() {
        this.password = null;
    }

    private static final char[] mask(char[] data) {
        int mask = 43690;
        int check = 21845;
        char[] result = new char[data.length + 1];
        int i = 0;
        while (i < data.length) {
            result[i] = mask = (int)((char)(mask ^ data[i]));
            ++i;
        }
        result[data.length] = (char)(mask ^ check);
        return result;
    }

    private static final char[] unmask(char[] data) {
        if (data.length == 0) {
            return data;
        }
        int mask = 43690;
        int check = 21845;
        char[] result = new char[data.length - 1];
        int i = 0;
        while (i < result.length) {
            result[i] = (char)(mask ^ data[i]);
            mask = data[i];
            ++i;
        }
        if (data[result.length] == (char)(mask ^ check)) {
            return result;
        }
        return data;
    }
}

