/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.interfaces.security.SessionListener;
import com.sap.engine.lib.util.cache.Cache;
import com.sap.engine.lib.util.cache.CacheGroup;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.engine.services.security.login.CreateSessionAction;
import com.sap.engine.services.security.login.KeyWrapper;
import com.sap.engine.services.security.login.SecurityContext;
import com.sap.engine.services.security.login.SecuritySession;
import com.sap.engine.services.security.login.SubjectWrapper;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.Subject;

public class SecuritySessionPool {
    private Cache cache = null;

    public SecuritySessionPool() {
        this(160);
    }

    public SecuritySessionPool(int size) {
        this.cache = new Cache(0, size, new CacheGroup());
    }

    SecuritySession add(Subject subject, String authStack) {
        return (SecuritySession)new CreateSessionAction(new SubjectWrapper(subject), authStack, this).run();
    }

    SecuritySession add(SubjectWrapper subject, String authStack) {
        return (SecuritySession)new CreateSessionAction(subject, authStack, this).run();
    }

    SecuritySession getSession(byte[] key) {
        return (SecuritySession)this.cache.getByKey(new KeyWrapper(key));
    }

    void registerSession(byte[] key, SecuritySession session) {
        if (session == SecurityContext.ANONYMOUS_SESSION) {
            return;
        }
        if (key == null) {
            return;
        }
        if (session != null) {
            this.cache.addCache(new KeyWrapper(key), session);
            session.setTicket(key);
        } else {
            this.cache.remove(new KeyWrapper(key));
        }
    }

    void unregisterSession(byte[] key, SecuritySession session) {
        if (key == null) {
            return;
        }
        this.cache.remove(new KeyWrapper(key));
        if (session != null) {
            session.setTicket(null);
        }
    }

    int size() {
        return this.cache.allSize();
    }

    public void rekeySession(SecuritySession session, byte[] oldticket, byte[] newticket) {
        SecuritySession oldsession;
        if (oldticket != null && ((oldsession = this.getSession(oldticket)) == null || session.equals(oldsession))) {
            this.unregisterSession(oldticket, session);
        }
        if (newticket != null) {
            if (session != null) {
                this.registerSession(newticket, session);
            } else {
                this.unregisterSession(newticket, session);
            }
        }
    }

    public Vector getValidSessions() {
        int count = 0;
        Object[] sessionKeys = null;
        Vector<SecuritySession> values = new Vector<SecuritySession>();
        SecuritySession session = null;
        Cache cache = this.cache;
        synchronized (cache) {
            int size = this.cache.allSize();
            sessionKeys = new Object[size];
            Iterator keys = this.cache.keyIterator();
            while (count < size && keys.hasNext()) {
                sessionKeys[count] = keys.next();
                ++count;
            }
        }
        int i = 0;
        while (i < count) {
            session = (SecuritySession)this.cache.getByKey(sessionKeys[i]);
            if (session != null && session.isValid() && !values.contains(session)) {
                values.addElement(session);
            }
            ++i;
        }
        return values;
    }

    public SecuritySession[] listSessions() {
        Vector values = this.getValidSessions();
        SecuritySession[] result = new SecuritySession[values.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (SecuritySession)values.elementAt(i);
            ++i;
        }
        return result;
    }

    void registerSession(Subject key, SecuritySession session) {
        if (session != SecurityContext.ANONYMOUS_SESSION) {
            this.cache.addCache(new Long(session.getSessionNumber()), session);
        }
    }

    void unregisterSession(Subject key, SecuritySession session) {
        this.cache.remove(new Long(session.getSessionNumber()));
    }

    public void removeSessions(SecuritySession session) {
        Subject subjectKey = session.getSubject();
        byte[] ticketKey = session.getTicket();
        if (subjectKey != null) {
            this.cache.remove(new Long(session.getSessionNumber()));
        }
        if (ticketKey != null) {
            this.cache.remove(new KeyWrapper(ticketKey));
            session.setTicket(null);
        }
        this.closeSession(session);
    }

    private void closeSession(SecuritySession session) {
        if (session != null) {
            Object[] listeners = session.getListeners();
            int i = 0;
            while (i < listeners.length) {
                block5: {
                    if (listeners[i] instanceof SessionListener) {
                        try {
                            ((SessionListener)listeners[i]).onUserLogOut();
                        }
                        catch (Exception e) {
                            if (!SecurityResourceAccessor.location.beWarning()) break block5;
                            SecurityResourceAccessor.location.traceThrowableT(400, e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                ++i;
            }
        }
    }
}

