/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.TransferableExt;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecurityContextObjectListener;
import com.sap.engine.interfaces.security.auth.LoginContextReference;
import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.lib.security.Principal;
import com.sap.engine.lib.util.Stack;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.login.ConcurrentSetImpl;
import com.sap.engine.services.security.login.ContextAuthorizationExtension;
import com.sap.engine.services.security.login.RunAsSubjectAndCombiner;
import com.sap.engine.services.security.login.RunAsWeakReference;
import com.sap.engine.services.security.login.SecuritySession;
import com.sap.engine.services.security.login.SecuritySessionPool;
import com.sap.engine.services.security.login.SubjectWrapper;
import com.sap.engine.services.security.login.TicketGenerator;
import com.sap.engine.system.SystemSubjectDomainCombiner;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import javax.security.auth.login.LoginContext;

public class SecurityContext
implements ContextObject,
TransferableExt,
com.sap.engine.lib.security.SecurityContext,
SecurityContextObject {
    public static final String NAME = "security";
    protected static SubjectWrapper SYSTEM_SUBJECT = null;
    protected static java.security.Principal SYSTEM_PRINCIPAL = null;
    protected static SecuritySession ANONYMOUS_SESSION = null;
    private static WeakReference pool = null;
    private static SecurityContext initialValue = null;
    private byte[] ticket = null;
    private SecuritySession session = null;
    private SecuritySession doAsSession = null;
    private ReferenceQueue runAsSessionQueue = new ReferenceQueue();
    private RunAsWeakReference combiner = null;
    private ConcurrentSetImpl runAsHashSet = new ConcurrentSetImpl();
    private LoginContext lazyLoginContext = null;
    private LoginContextReference lazyLoginContextReference = null;
    private Object lazyAuthenticationLock = new Object();
    private static Object anonymousLock = new Object();
    private Object listenersModificationLock = new Object();
    private ArrayList removableListeners = null;
    private ArrayList persistentListeners = null;
    private Hashtable ticketsFromOtherClusters = new Hashtable();
    private static boolean anonymousPrincipalConfigured = false;
    private Stack runAsSubjects = new Stack();

    public SecurityContext() {
        if (SystemProperties.getBoolean("server") && !anonymousPrincipalConfigured) {
            throw new BaseSecurityException("security_5034");
        }
    }

    public SecurityContext(SecuritySessionPool pool) {
        if (SystemProperties.getBoolean("server") && !anonymousPrincipalConfigured) {
            throw new BaseSecurityException("security_5034");
        }
        if (pool != null) {
            SecurityContext.pool = new WeakReference<SecuritySessionPool>(pool);
        }
        this.session = ANONYMOUS_SESSION;
    }

    public SecurityContext(SecurityContext parent) {
        this.session = (SecuritySession)parent.getSession();
        this.ticket = parent.ticket;
        this.ticketsFromOtherClusters = (Hashtable)parent.ticketsFromOtherClusters.clone();
    }

    public ContextObject childValue(ContextObject parent, ContextObject child) {
        if (child == null) {
            child = new SecurityContext((SecurityContext)parent);
        } else {
            ((SecurityContext)child).session = (SecuritySession)((SecurityContext)parent).getSession();
            ((SecurityContext)child).ticket = ((SecurityContext)parent).ticket;
            ((SecurityContext)child).ticketsFromOtherClusters = (Hashtable)((SecurityContext)parent).ticketsFromOtherClusters.clone();
        }
        return child;
    }

    public ContextObject getInitialValue() {
        if (initialValue != null) {
            return new SecurityContext(initialValue);
        }
        return new SecurityContext(this.getPool());
    }

    public void empty() {
        while (this.runAsSessionQueue.poll() != null) {
        }
        this.ticket = null;
        this.session = null;
        this.doAsSession = null;
        this.clearRunAsHashSet();
        this.combiner = null;
        this.lazyLoginContext = null;
        this.lazyLoginContextReference = null;
        this.notifyListeners(1);
        this.removableListeners = null;
        this.runAsSubjects.clear();
        this.ticketsFromOtherClusters.clear();
    }

    public int size() {
        SecuritySession session = (SecuritySession)this.getSession();
        if (initialValue != null) {
            return SecurityContext.initialValue.ticket.length;
        }
        this.ticket = TicketGenerator.generateTicket(this.getTicket(), session, this.getPool());
        return this.ticket.length;
    }

    public int size(Object clusterId) {
        byte[] tempTicket = (byte[])this.ticketsFromOtherClusters.get(clusterId);
        if (tempTicket == null) {
            tempTicket = TicketGenerator.getEmptyTicket();
        }
        return tempTicket.length;
    }

    public void store(byte[] to, int offset) {
        if (initialValue != null) {
            System.arraycopy(SecurityContext.initialValue.ticket, 0, to, offset, SecurityContext.initialValue.ticket.length);
        } else {
            System.arraycopy(this.ticket, 0, to, offset, this.ticket.length);
        }
    }

    public void store(Object clusterId, byte[] to, int offset) {
        byte[] tempTicket = (byte[])this.ticketsFromOtherClusters.get(clusterId);
        if (tempTicket == null) {
            tempTicket = TicketGenerator.getEmptyTicket();
        }
        System.arraycopy(tempTicket, 0, to, offset, tempTicket.length);
    }

    public void load(byte[] from, int offset) {
        byte[] newticket = TicketGenerator.getTicket(from, offset);
        if (this.equalArrays(this.ticket, newticket)) {
            return;
        }
        this.ticket = newticket;
        this.session = TicketGenerator.getSecuritySession(this.ticket, this.getPool());
        this.notifyListeners(2);
    }

    public void load(Object clusterId, byte[] from, int offset) {
        byte[] newticket = TicketGenerator.getTicket(from, offset);
        if (this.equalArrays(this.ticket, newticket)) {
            return;
        }
        this.ticketsFromOtherClusters.put(clusterId, newticket);
        if (!SystemProperties.getBoolean("server")) {
            this.ticket = newticket;
            this.session = TicketGenerator.getSecuritySession(this.ticket, this.getPool());
        }
        this.notifyListeners(2);
    }

    public long getCreationTime() {
        SecuritySession session = (SecuritySession)this.getSession();
        if (session != null) {
            return this.getSession().getCreationTime();
        }
        return -1L;
    }

    public long getExpirationPeriod() {
        SecuritySession session = (SecuritySession)this.getSession();
        if (session != null) {
            return this.getSession().getExpirationPeriod();
        }
        return -1L;
    }

    public long getLastAccessed() {
        SecuritySession session = (SecuritySession)this.getSession();
        if (session != null) {
            return this.getSession().getLastAccessed();
        }
        return -1L;
    }

    public java.security.Principal getPrincipal() {
        SecuritySession session = (SecuritySession)this.getSession();
        if (session != null) {
            return this.getSession().getPrincipal();
        }
        if (SYSTEM_SUBJECT != null) {
            return SYSTEM_SUBJECT.getPrincipal();
        }
        return null;
    }

    public Subject getSubject() {
        SecuritySession session = (SecuritySession)this.getSession();
        if (session != null) {
            return this.getSession().getSubject();
        }
        return SYSTEM_SUBJECT.getSubject();
    }

    public com.sap.engine.interfaces.security.SecuritySession getSession() {
        DomainCombiner domainCombiner = AccessController.getContext().getDomainCombiner();
        RunAsSubjectAndCombiner subjectAndCombiner = (RunAsSubjectAndCombiner)this.runAsSubjects.getLast();
        if (subjectAndCombiner != null && (domainCombiner == null || subjectAndCombiner.getCombiner() != null && subjectAndCombiner.getCombiner().equals(domainCombiner))) {
            return this.session;
        }
        if (domainCombiner instanceof SystemSubjectDomainCombiner) {
            return (SecuritySession)((SystemSubjectDomainCombiner)domainCombiner).getSession();
        }
        if (domainCombiner != null) {
            SubjectDomainCombiner subjectCombiner = (SubjectDomainCombiner)domainCombiner;
            if (this.combiner == null || domainCombiner != this.combiner.get()) {
                RunAsWeakReference reference = null;
                while ((reference = (RunAsWeakReference)this.runAsSessionQueue.poll()) != null) {
                    reference.logoutSession();
                    this.runAsHashSet.remove(reference);
                }
                this.combiner = this.runAsHashSet.contains(subjectCombiner) ? (RunAsWeakReference)this.runAsHashSet.get(subjectCombiner) : new RunAsWeakReference(subjectCombiner, this.runAsSessionQueue, this.runAsHashSet);
                this.doAsSession = this.combiner.getSession();
            }
            if (this.doAsSession != null) {
                return this.doAsSession;
            }
        }
        return this.getSessionWithoutDomainCombiner();
    }

    public boolean isAuthenticationPending() {
        if (initialValue != null && initialValue != this) {
            return initialValue.isAuthenticationPending();
        }
        if (this.session != null && this.session.isValid()) {
            return this.lazyLoginContext != null || this.lazyLoginContextReference != null;
        }
        return false;
    }

    public void delayAuthentication(LoginContext loginContext) {
        this.lazyLoginContext = loginContext;
    }

    public void delayAuthentication(LoginContextReference loginContextReference) {
        this.lazyLoginContextReference = loginContextReference;
    }

    public String toString() {
        return "Security Context : " + this.getSession();
    }

    public void setSession(com.sap.engine.interfaces.security.SecuritySession session) {
        if (session != null) {
            this.session = (SecuritySession)session;
            this.ticket = null;
            this.combiner = null;
        } else {
            this.session = null;
            this.ticket = null;
            this.combiner = null;
        }
        this.notifyListeners(3);
    }

    public void runAs(Subject subject) {
        if (!SystemProperties.getBoolean("server")) {
            throw new SecurityException("statement not allowed");
        }
        if (subject == null) {
            RunAsSubjectAndCombiner runAs = (RunAsSubjectAndCombiner)this.runAsSubjects.removeLast();
            if (runAs == null) {
                return;
            }
            this.session = runAs.getSession();
            return;
        }
        DomainCombiner currentCombiner = AccessController.getContext().getDomainCombiner();
        this.runAsSubjects.add(new RunAsSubjectAndCombiner(subject, currentCombiner, this.session));
        this.session = this.getPool().add(subject, "run_as");
    }

    public void useAsDefault() {
        byte[] initalTicket = this.ticket != null ? this.ticket : this.getTicket();
        SecuritySession initalSession = this.session != null ? this.session : (SecuritySession)this.getSession();
        initialValue = new SecurityContext();
        SecurityContext.initialValue.ticket = initalTicket;
        SecurityContext.initialValue.session = initalSession;
    }

    public void addListener(SecurityContextObjectListener listener, boolean removeOnEmpty) {
        Object object = this.listenersModificationLock;
        synchronized (object) {
            if (!removeOnEmpty) {
                if (this.persistentListeners == null) {
                    this.persistentListeners = new ArrayList();
                }
                if (!this.persistentListeners.contains(listener)) {
                    this.persistentListeners.add(listener);
                }
            } else {
                if (this.removableListeners == null) {
                    this.removableListeners = new ArrayList();
                }
                if (!this.removableListeners.contains(listener)) {
                    this.removableListeners.add(listener);
                }
            }
        }
        if (this.session != ANONYMOUS_SESSION) {
            listener.sessionChanged(this, this.session, this.session == ANONYMOUS_SESSION, 0);
        }
    }

    public void removeListener(SecurityContextObjectListener listener) {
        boolean removed = false;
        if (this.persistentListeners != null && (removed = ((AbstractCollection)this.persistentListeners).remove(listener)) && this.persistentListeners.size() == 0) {
            this.persistentListeners = null;
        }
        if (!removed && this.removableListeners != null) {
            ((AbstractCollection)this.removableListeners).remove(listener);
            if (this.removableListeners.size() == 0) {
                this.removableListeners = null;
            }
        }
    }

    public ContextAuthorizationExtension getAuthorizationExtension() {
        return ((SecuritySession)this.getSession()).getAuthorizationExtension();
    }

    protected static void setAnonymousPrincipal(String anonymous) {
        if (!(SystemProperties.getBoolean("server") || ANONYMOUS_SESSION != null && SYSTEM_PRINCIPAL.getName().equals(anonymous))) {
            Object object = anonymousLock;
            synchronized (object) {
                if (ANONYMOUS_SESSION == null || !SYSTEM_PRINCIPAL.getName().equals(anonymous)) {
                    SYSTEM_PRINCIPAL = new Principal(anonymous);
                    SYSTEM_SUBJECT = new SubjectWrapper();
                    ANONYMOUS_SESSION = new SecuritySession(SYSTEM_PRINCIPAL, SYSTEM_SUBJECT.getSubject(), null);
                }
            }
        }
    }

    public static void setAnonymousPrincipal(UserStore userStore) {
        try {
            String anonymousUser = userStore.getUserContext().getAnonymousUserName();
            SubjectWrapper subject = new SubjectWrapper();
            UserInfo info = userStore.getUserContext().getUserInfo(anonymousUser);
            userStore.getUserContext().fillSubject(info, subject.getSubject());
            SecurityContext.setAnonymousSubject(subject.getSubject());
            TicketGenerator.setAnonymousPrincipal(anonymousUser);
            anonymousPrincipalConfigured = true;
        }
        catch (Exception e) {
            throw new BaseSecurityException("security_5034", e);
        }
    }

    private static void setAnonymousSubject(Subject anonymous) {
        try {
            SYSTEM_SUBJECT = new SubjectWrapper(anonymous);
            SYSTEM_PRINCIPAL = SYSTEM_SUBJECT.getPrincipal();
            ANONYMOUS_SESSION.setPrincipalAndSubject(SYSTEM_PRINCIPAL, SYSTEM_SUBJECT.getSubject());
            if (pool != null) {
                SecuritySessionPool sessions = (SecuritySessionPool)pool.get();
                SecuritySession[] list = sessions.listSessions();
                int i = 0;
                while (i < list.length) {
                    if (list[i] != null && list[i].getAuthenticationConfiguration() == null) {
                        list[i].setPrincipalAndSubject(SYSTEM_PRINCIPAL, SYSTEM_SUBJECT.getSubject());
                    } else if (list[i] != null) {
                        list[i].setValid(false);
                    }
                    ++i;
                }
            }
            SecurityServerFrame.getLogger().log((byte)3, "Anonymous principal changed to '" + SYSTEM_PRINCIPAL + "'");
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().logThrowable((byte)5, e);
        }
    }

    private SecuritySessionPool getPool() {
        if (pool != null) {
            return (SecuritySessionPool)pool.get();
        }
        return null;
    }

    private com.sap.engine.interfaces.security.SecuritySession getSessionWithoutDomainCombiner() {
        if (this.isAuthenticationPending()) {
            Object object = this.lazyAuthenticationLock;
            synchronized (object) {
                if (this.isAuthenticationPending()) {
                    if (this.lazyLoginContextReference != null) {
                        try {
                            this.lazyLoginContext = this.lazyLoginContextReference.getLoginContext();
                            this.lazyLoginContextReference = null;
                        }
                        catch (Exception e) {
                            SecurityServerFrame.getLogger().logThrowable((byte)3, e);
                        }
                    }
                    try {
                        this.lazyLoginContext.login();
                        this.lazyLoginContext = null;
                    }
                    catch (Exception e) {
                        SecurityServerFrame.getLogger().logThrowable((byte)3, e);
                    }
                }
            }
        }
        if (initialValue != null && initialValue != this) {
            return SecurityContext.initialValue.session;
        }
        if (this.session != null && this.session.isValid()) {
            return this.session;
        }
        if (ANONYMOUS_SESSION == null || !ANONYMOUS_SESSION.isValid()) {
            ANONYMOUS_SESSION = new SecuritySession(SYSTEM_PRINCIPAL, SYSTEM_SUBJECT.getSubject(), null);
        }
        return ANONYMOUS_SESSION;
    }

    private byte[] getTicket() {
        if (initialValue != null && initialValue != this) {
            return SecurityContext.initialValue.ticket;
        }
        if (this.ticket != null) {
            return this.ticket;
        }
        return null;
    }

    private boolean equalArrays(byte[] data1, byte[] data2) {
        if (data1 == null || data2 == null) {
            return false;
        }
        if (data1.length != data2.length) {
            return false;
        }
        int i = 0;
        while (i < data1.length) {
            if (data1[i] != data2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void clearRunAsHashSet() {
        Enumeration enumeration = this.runAsHashSet.elements();
        while (enumeration.hasMoreElements()) {
            ((RunAsWeakReference)enumeration.nextElement()).logoutSession();
        }
        this.runAsHashSet.clear();
    }

    private void notifyListeners(int change) {
        int i;
        boolean isAnonymous;
        SecurityContextObjectListener l;
        if (this.persistentListeners != null) {
            l = null;
            isAnonymous = this.session == null || this.session == ANONYMOUS_SESSION;
            i = 0;
            while (i < this.persistentListeners.size()) {
                l = (SecurityContextObjectListener)this.persistentListeners.get(i);
                l.sessionChanged(this, this.session, isAnonymous, change);
                ++i;
            }
        }
        if (this.removableListeners != null) {
            l = null;
            isAnonymous = this.session == null || this.session == ANONYMOUS_SESSION;
            i = 0;
            while (i < this.removableListeners.size()) {
                l = (SecurityContextObjectListener)this.removableListeners.get(i);
                l.sessionChanged(this, this.session, isAnonymous, change);
                ++i;
            }
        }
    }
}

