/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.frame.client.ClientException;
import com.sap.engine.frame.client.ClientFactory;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.lib.security.Principal;
import com.sap.engine.services.security.exceptions.BaseLoginException;
import com.sap.engine.services.security.login.SecuritySession;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class RemoteLoginModule
implements LoginModule {
    private String namingFactory = null;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String username;
    private char[] password;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private java.security.Principal principal = null;
    private PasswordCredential passwordCredential = null;
    private boolean withAppClient = false;
    private Context context = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String appClientValue;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.namingFactory = (String)options.get("java.naming.factory.initial");
        if (this.namingFactory == null) {
            this.namingFactory = (String)sharedState.get("java.naming.factory.initial");
        }
        if (this.namingFactory == null) {
            this.namingFactory = System.getProperty("java.naming.factory.initial");
        }
        if (this.namingFactory == null) {
            this.namingFactory = "com.sap.engine.services.jndi.InitialContextFactoryImpl";
        }
        if ((appClientValue = (String)options.get("appclient")) != null) {
            this.withAppClient = appClientValue.equals("true");
        }
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new BaseLoginException("security_1015");
        }
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false)};
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (UnsupportedCallbackException uce) {
            throw new BaseLoginException("security_1016");
        }
        catch (Exception ioe) {
            throw new BaseLoginException("security_1017", ioe);
        }
        try {
            this.internalLogin(this.username, this.password);
            this.succeeded = true;
        }
        catch (Exception e) {
            throw new BaseLoginException("security_1018", e);
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.succeeded) {
            this.principal = new Principal(this.username);
            if (!this.subject.getPrincipals().contains(this.principal)) {
                this.subject.getPrincipals().add(this.principal);
            }
            this.passwordCredential = new PasswordCredential(this.username, this.password);
            this.subject.getPrivateCredentials().add(this.passwordCredential);
            this.commitSucceeded = true;
            try {
                SecurityContextObject current = (SecurityContextObject)((Object)ClientFactory.getThreadContextFactory().getThreadContext().getContextObject("security"));
                SecuritySession session = (SecuritySession)current.getSession();
                session.setPrincipalAndSubject(this.principal, this.subject);
            }
            catch (ClientException e) {
                e.printStackTrace();
            }
        }
        this.username = null;
        int i = 0;
        while (i < this.password.length) {
            this.password[i] = 32;
            ++i;
        }
        this.password = null;
        return this.commitSucceeded;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                int i = 0;
                while (i < this.password.length) {
                    this.password[i] = 32;
                    ++i;
                }
                this.password = null;
            }
            this.principal = null;
            this.passwordCredential = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.subject.getPrivateCredentials().remove(this.passwordCredential);
        try {
            this.internalLogout();
            this.succeeded = false;
            this.commitSucceeded = false;
            this.username = null;
            if (this.password != null) {
                int i = 0;
                while (i < this.password.length) {
                    this.password[i] = 32;
                    ++i;
                }
                this.password = null;
            }
            this.principal = null;
            this.passwordCredential = null;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void internalLogin(String username, char[] password) throws Exception {
        Properties properties = new Properties();
        ((Hashtable)properties).put("java.naming.factory.initial", this.namingFactory);
        ((Hashtable)properties).put("java.naming.security.principal", username);
        ((Hashtable)properties).put("java.naming.security.credentials", new String(password));
        if (this.withAppClient) {
            ((Hashtable)properties).put("appclient", "true");
        }
        this.context = new InitialContext(properties);
    }

    private void internalLogout() throws Exception {
        this.context.close();
    }
}

