/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.lib.security.LoginExceptionDetails;
import com.sap.engine.services.security.DebugSecurityLogger;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseLoginException;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.tc.logging.LogRecord;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ModulesProcessAction
implements PrivilegedExceptionAction {
    private static final String MON_COMPONENT_LOGIN = "AppServer:Security:Authentication:LOGIN:";
    private static final String MON_COMPONENT_ABORT = "AppServer:Security:Authentication:ABORT:";
    private static final String MON_COMPONENT_COMMIT = "AppServer:Security:Authentication:COMMIT:";
    private static final String MON_COMPONENT_LOGOUT = "AppServer:Security:Logout:";
    private AppConfigurationEntry[] configuration = null;
    private LoginModule[] modules = null;
    private byte type = (byte)-1;
    String authStack = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object run() throws LoginException {
        boolean processed = false;
        boolean localProcessed = false;
        Throwable exception = null;
        Throwable weakException = null;
        int i = 0;
        while (i < this.modules.length) {
            localProcessed = false;
            try {
                switch (this.type) {
                    case 0: {
                        Object var9_10;
                        IMonitor monitor = TaskMonitor.getRequestMonitor(null, (String)"AppServer:Security:Authentication");
                        String monComponentLogin = MON_COMPONENT_LOGIN + this.modules[i].getClass().getName();
                        try {
                            monitor.startComponent(monComponentLogin);
                            localProcessed = this.modules[i].login();
                            var9_10 = null;
                        }
                        catch (Throwable throwable) {
                            var9_10 = null;
                            monitor.endComponent(monComponentLogin);
                            throw throwable;
                        }
                        monitor.endComponent(monComponentLogin);
                        break;
                    }
                    case 1: {
                        Object var11_11;
                        IMonitor monitor = TaskMonitor.getRequestMonitor(null, (String)"AppServer:Security:Authentication");
                        String monComponentAbort = MON_COMPONENT_ABORT + this.modules[i].getClass().getName();
                        try {
                            monitor.startComponent(monComponentAbort);
                            localProcessed = this.modules[i].abort();
                            var11_11 = null;
                        }
                        catch (Throwable throwable) {
                            var11_11 = null;
                            monitor.endComponent(monComponentAbort);
                            throw throwable;
                        }
                        monitor.endComponent(monComponentAbort);
                        break;
                    }
                    case 2: {
                        Object var13_12;
                        IMonitor monitor = TaskMonitor.getRequestMonitor(null, (String)"AppServer:Security:Authentication");
                        String monComponentCommit = MON_COMPONENT_COMMIT + this.modules[i].getClass().getName();
                        try {
                            monitor.startComponent(monComponentCommit);
                            localProcessed = this.modules[i].commit();
                            var13_12 = null;
                        }
                        catch (Throwable throwable) {
                            var13_12 = null;
                            monitor.endComponent(monComponentCommit);
                            throw throwable;
                        }
                        monitor.endComponent(monComponentCommit);
                        break;
                    }
                    case 3: {
                        Object var15_13;
                        IMonitor monitor = TaskMonitor.getRequestMonitor(null, (String)"AppServer:Security:Logout");
                        String monComponentLogout = MON_COMPONENT_LOGOUT + this.modules[i].getClass().getName();
                        try {
                            monitor.startComponent(monComponentLogout);
                            localProcessed = this.modules[i].logout();
                            var15_13 = null;
                        }
                        catch (Throwable throwable) {
                            var15_13 = null;
                            monitor.endComponent(monComponentLogout);
                            throw throwable;
                        }
                        monitor.endComponent(monComponentLogout);
                        break;
                    }
                }
                if (localProcessed) {
                    weakException = null;
                    processed = true;
                    if (this.type == 0 && this.configuration[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
                        break;
                    }
                }
            }
            catch (LoginException e) {
                if (SecurityResourceAccessor.location.beDebug()) {
                    SecurityResourceAccessor.location.debugT("Login module {0} from authentication stack {1} does not authenticate the caller.", new Object[]{this.modules[i].getClass().getName(), this.authStack});
                }
                if (this.configuration[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                    if (this.type != 1 && this.type != 3) {
                        e.fillInStackTrace();
                        throw e;
                    }
                    if (exception == null) {
                        exception = e;
                    }
                }
                if (this.configuration[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                    if (exception == null) {
                        exception = e;
                    }
                }
                if (this.configuration[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && weakException == null) {
                    weakException = e;
                }
            }
            catch (Throwable e) {
                LogRecord record = null;
                BaseLoginException ble = new BaseLoginException("security_4046", e);
                SecurityResourceAccessor.category.infoT(SecurityResourceAccessor.location, "Login module {0} from authentication stack {1} errors while authenticating the caller. Most probably the authentication stack is not set up correctly.", new Object[]{this.modules[i].getClass().getName(), this.authStack});
                SecurityResourceAccessor.location.traceThrowableT(500, ble.getLocalizedMessage(), (Throwable)ble);
                if (((DebugSecurityLogger)SecurityServerFrame.getLogger()).isLogAvailable() && (record = SecurityResourceAccessor.location.errorT("Exception {0}", new Object[]{ble.getNestedStackTraceString()})) != null) {
                    throw new BaseSecurityException("security_4109", new Object[]{record.getId().toString()});
                }
                throw new BaseSecurityException("security_4110");
            }
            ++i;
        }
        if (exception != null) {
            exception.fillInStackTrace();
            if (exception instanceof LoginExceptionDetails) {
                throw new BaseLoginException("security_1009", exception, ((LoginExceptionDetails)((Object)exception)).getExceptionCause());
            }
            throw new BaseLoginException("security_1009", exception);
        }
        if (!processed && weakException != null) {
            weakException.fillInStackTrace();
            if (weakException instanceof LoginExceptionDetails) {
                throw new BaseLoginException("security_1010", weakException, ((LoginExceptionDetails)((Object)weakException)).getExceptionCause());
            }
            throw new BaseLoginException("security_1010", weakException);
        }
        if (processed) {
            return null;
        }
        if (SecurityResourceAccessor.location.beDebug()) {
            SecurityResourceAccessor.location.debugT("Unsuccessful login: no login module succeeded. The size of the used authentication stack {0} is {1}.", new Object[]{this.authStack, new Integer(this.modules.length)});
        }
        throw new BaseLoginException("security_1011", 17);
    }

    protected ModulesProcessAction getAction(AppConfigurationEntry[] configuration, LoginModule[] modules, byte type, String authStack) {
        this.authStack = authStack;
        this.configuration = configuration;
        this.modules = modules;
        this.type = type;
        return this;
    }
}

