/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.Util;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.engine.services.security.login.FastLoginContext;
import com.sap.engine.services.security.login.SecuritySessionPool;
import com.sap.engine.services.security.server.SecurityContextImpl;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.spi.LoginModule;

public class LoginContextFactory {
    protected static final String AUTH_NAME = "sap.security.auth.configuration.name";
    private static final String ADDITIONAL_LOADERS = "LoginModuleClassLoaders";
    private static final String MON_COMPONENT_INITIALIZE = "AppServer:Security:Authentication:INITIALIZE:";
    private static final String SID = "System-ID";
    private static final String SESSION_LOGOUT = "sap.security.auth.session.logout";
    private static final String SECURITY_CONTEXT_OBJECT = "sap.security.auth.context.object";
    private Class[] moduleClasses = null;
    private AuthenticationContext authentication = null;
    private AppConfigurationEntry[] configuration = null;
    private SecuritySessionPool sessionsPool = null;
    private String template = null;
    private boolean initialized = false;

    public LoginContextFactory(AuthenticationContext authentication, SecuritySessionPool sessionsPool, int poolLimit) {
        this.authentication = authentication;
        this.sessionsPool = sessionsPool;
    }

    public synchronized void init() {
        if (!this.initialized || this.moduleClasses == null || this.moduleClasses.length == 0) {
            this.configuration = this.authentication.getLoginModules();
            this.moduleClasses = new Class[this.configuration.length];
            ClassLoader classloader = this.getClass().getClassLoader();
            ClassLoader applicationLoader = Thread.currentThread().getContextClassLoader();
            int i = 0;
            while (i < this.moduleClasses.length) {
                try {
                    if (applicationLoader != null) {
                        try {
                            this.moduleClasses[i] = applicationLoader.loadClass(this.configuration[i].getLoginModuleName());
                        }
                        catch (ClassNotFoundException tt) {
                            this.moduleClasses[i] = null;
                        }
                    }
                    if (this.moduleClasses[i] == null) {
                        if (classloader != null) {
                            try {
                                this.moduleClasses[i] = classloader.loadClass(this.configuration[i].getLoginModuleName());
                            }
                            catch (ClassNotFoundException tt) {
                                this.moduleClasses[i] = null;
                            }
                        } else {
                            try {
                                this.moduleClasses[i] = Class.forName(this.configuration[i].getLoginModuleName());
                            }
                            catch (ClassNotFoundException tt) {
                                this.moduleClasses[i] = null;
                            }
                        }
                    }
                    if (this.moduleClasses[i] == null) {
                        this.moduleClasses[i] = Util.loadClassFromAdditionalLoaders(this.configuration[i].getLoginModuleName(), ADDITIONAL_LOADERS);
                    }
                }
                catch (ClassNotFoundException t) {
                    BaseSecurityException bse = new BaseSecurityException("security_1020", t);
                    bse.log();
                    SecurityResourceAccessor.location.errorT("Cannot load login module class {0}.", new Object[]{this.configuration[i].getLoginModuleName()});
                }
                ++i;
            }
            int length = this.moduleClasses.length;
            int i2 = 0;
            while (i2 < this.moduleClasses.length) {
                if (this.moduleClasses[i2] == null) {
                    --length;
                }
                ++i2;
            }
            Class[] compact = new Class[length];
            int i3 = 0;
            int j = 0;
            while (i3 < this.moduleClasses.length) {
                if (this.moduleClasses[i3] != null) {
                    compact[j] = this.moduleClasses[i3];
                    ++j;
                }
                ++i3;
            }
            this.moduleClasses = compact;
            this.template = this.authentication.getTemplate();
            if (this.template == null || this.template.equals("no")) {
                this.template = this.authentication.getPolicyConfigurationName();
            }
            this.initialized = true;
        }
    }

    public FastLoginContext getLoginContext(Subject subject, CallbackHandler callbackHandler) throws Exception {
        FastLoginContext result = null;
        if (!this.initialized || this.moduleClasses == null || this.moduleClasses.length == 0) {
            this.init();
        }
        if (result == null) {
            result = new FastLoginContext(this, callbackHandler != null, this.template);
        }
        result.set(subject, callbackHandler);
        return result;
    }

    public void close(FastLoginContext context) {
    }

    public void clearLoginModules() {
        this.moduleClasses = null;
        this.initialized = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Map initializeLoginContext(FastLoginContext context, boolean isSessionLogout) {
        LoginModule[] modules = null;
        HashMap<String, Object> sharedState = new HashMap<String, Object>();
        if (context.subject == null) {
            context.subject = new Subject();
        }
        modules = new LoginModule[this.moduleClasses.length];
        int i = 0;
        while (i < modules.length) {
            try {
                modules[i] = (LoginModule)this.moduleClasses[i].newInstance();
            }
            catch (Exception t) {
                SecurityResourceAccessor.location.traceThrowableT(500, "Cannot instantiate login module {0} from authentication stack {1}.", new Object[]{this.moduleClasses[i], this.template}, (Throwable)t);
                modules[i] = null;
            }
            ++i;
        }
        sharedState.put(SID, SecurityContextImpl.getSystemID());
        sharedState.put(AUTH_NAME, this.template);
        ThreadContext threadContext = SecurityServerFrame.threadContext.getThreadContext();
        if (threadContext != null) {
            sharedState.put(SECURITY_CONTEXT_OBJECT, threadContext.getContextObject("security"));
        }
        if (isSessionLogout) {
            sharedState.put(SESSION_LOGOUT, "true");
        }
        int i2 = 0;
        while (i2 < modules.length) {
            block18: {
                if (modules[i2] != null) {
                    Object var14_15;
                    IMonitor monitor = null;
                    String monComponentInit = MON_COMPONENT_INITIALIZE + modules[i2].getClass().getName();
                    try {
                        try {
                            monitor = TaskMonitor.getRequestMonitor(null, (String)"AppServer:Security:Authentication");
                            monitor.startComponent(monComponentInit);
                            modules[i2].initialize(context.subject, context.callbackHandler, sharedState, this.configuration[i2].getOptions());
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (OutOfMemoryError oome) {
                            throw oome;
                        }
                        catch (Throwable t) {
                            SecurityResourceAccessor.location.traceThrowableT(500, "Cannot initialize login module {0} from authentication stack {1}.", new Object[]{modules[i2].getClass().getName(), this.template}, t);
                            modules[i2] = null;
                            var14_15 = null;
                            monitor.endComponent(monComponentInit);
                            break block18;
                        }
                        var14_15 = null;
                    }
                    catch (Throwable throwable) {
                        var14_15 = null;
                        monitor.endComponent(monComponentInit);
                        throw throwable;
                    }
                    monitor.endComponent(monComponentInit);
                }
            }
            ++i2;
        }
        int length = modules.length;
        int i3 = 0;
        while (i3 < modules.length) {
            if (modules[i3] == null) {
                --length;
            }
            ++i3;
        }
        LoginModule[] compact = new LoginModule[length];
        int i4 = 0;
        int j = 0;
        while (i4 < modules.length) {
            if (modules[i4] != null) {
                compact[j] = modules[i4];
                ++j;
            }
            ++i4;
        }
        modules = compact;
        context.set(this.sessionsPool, context.subject, modules, this.configuration);
        return sharedState;
    }
}

