/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.engine.system.SystemLoginModule;
import java.util.Hashtable;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class LoginContextConfiguration
extends Configuration {
    public static final String EMPTY_STACK = "empty";
    public static final AppConfigurationEntry[] EMPTY_CONFIGURATION_STACK = new AppConfigurationEntry[0];
    public static final String SYSTEM_LOGIN_MODULE = (class$com$sap$engine$system$SystemLoginModule == null ? (class$com$sap$engine$system$SystemLoginModule = LoginContextConfiguration.class$("com.sap.engine.system.SystemLoginModule")) : class$com$sap$engine$system$SystemLoginModule).getName();
    private boolean initialized = false;
    private SecurityContext root = null;
    private Hashtable options = null;
    static /* synthetic */ Class class$com$sap$engine$system$SystemLoginModule;

    public LoginContextConfiguration(SecurityContext root) {
        this.root = root;
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String context) {
        if (!this.initialized) {
            this.refresh();
        }
        if (EMPTY_STACK.equals(context)) {
            return EMPTY_CONFIGURATION_STACK;
        }
        SecurityContext configuration = null;
        try {
            configuration = this.root.getPolicyConfigurationContext(context);
        }
        catch (SecurityException se) {
            configuration = null;
        }
        if (configuration == null) {
            return null;
        }
        this.options = new Hashtable(11);
        this.options.put("APP_CONFIG_ENTRIES", configuration.getAuthenticationContext());
        AppConfigurationEntry entry = new AppConfigurationEntry(SYSTEM_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.options);
        return new AppConfigurationEntry[]{entry};
    }

    public void refresh() {
        block2: {
            try {
                SystemLoginModule.setReference(this.root.getAuthenticationContext());
                this.initialized = true;
            }
            catch (Exception e) {
                if (!SecurityResourceAccessor.location.beWarning()) break block2;
                SecurityResourceAccessor.location.traceThrowableT(400, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

