/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.security.userstore.UserStoreFactory;
import com.sap.engine.interfaces.security.userstore.context.UserContext;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.lib.security.Principal;
import com.sap.engine.services.security.cluster.SecurityMessenger;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.engine.services.security.login.SecurityContext;
import com.sap.engine.services.security.login.SecuritySession;
import com.sap.engine.services.security.login.SecuritySessionPool;
import com.sap.engine.services.security.login.SubjectWrapper;
import com.sap.engine.services.security.login.TicketGenerator;
import com.sap.engine.services.security.server.SecurityContextImpl;
import java.security.PrivilegedAction;

public class CreateSessionAction
implements PrivilegedAction {
    private byte[] ticket = null;
    private SecuritySessionPool pool = null;
    private String authentication = null;
    private SubjectWrapper subject = null;

    public CreateSessionAction(byte[] ticket, String authentication, SecuritySessionPool pool) {
        this.ticket = ticket;
        this.pool = pool;
        this.authentication = authentication;
    }

    public CreateSessionAction(SubjectWrapper subject, String authentication, SecuritySessionPool pool) {
        this.subject = subject;
        this.pool = pool;
        this.authentication = authentication;
    }

    public Object run() {
        if (this.subject != null) {
            return (SecuritySession)this.createSessionFromSubject();
        }
        SecuritySession result = null;
        if (SystemProperties.getBoolean("server")) {
            result = (SecuritySession)this.createSessionFromTicketWithCommunication();
        }
        if (result == null) {
            UserStoreFactory factory = this.getUserStoreFactory();
            result = factory != null ? (SecuritySession)this.createSessionFromTicketWithUserStore(factory) : (SecuritySession)this.createSessionFromTicketWithoutUserStore();
        }
        return result;
    }

    private Object createSessionFromSubject() {
        SecuritySession session = new SecuritySession(this.subject.getPrincipal(), this.subject.getSubject(), this.authentication);
        if (this.pool != null) {
            this.pool.registerSession(this.subject.getSubject(), session);
        }
        return session;
    }

    private Object createSessionFromTicketWithCommunication() {
        SecuritySession session = null;
        try {
            long sessionNumber = TicketGenerator.getSessionNumber(this.ticket);
            if (sessionNumber != SecurityContext.ANONYMOUS_SESSION.getSessionNumber()) {
                this.subject = SecurityMessenger.requestForSubject((byte[])this.ticket);
                if (this.subject == null) {
                    return null;
                }
                session = new SecuritySession(sessionNumber, TicketGenerator.getCreationTime(this.ticket), this.subject.getPrincipal(), this.subject.getSubject(), this.authentication);
            } else {
                session = SecurityContext.ANONYMOUS_SESSION;
            }
            if (this.pool != null) {
                this.pool.registerSession(this.ticket, session);
            }
        }
        catch (Exception e) {
            BaseSecurityException bse = new BaseSecurityException("security_1023", e);
            bse.log();
        }
        catch (NoClassDefFoundError e) {
            BaseSecurityException bse = new BaseSecurityException("security_1023", e);
            bse.log();
        }
        return session;
    }

    private Object createSessionFromTicketWithUserStore(UserStoreFactory factory) {
        SecuritySession session = null;
        try {
            long sessionNumber = TicketGenerator.getSessionNumber(this.ticket);
            UserInfo userInfo = null;
            UserContext users = factory.getActiveUserStore().getUserContext();
            try {
                String principalName = TicketGenerator.getPrincipalName(this.ticket);
                userInfo = users.getUserInfo(principalName);
            }
            catch (Exception e) {
                BaseSecurityException bse = new BaseSecurityException("security_1023", e);
                bse.log();
                userInfo = null;
            }
            if (userInfo != null && sessionNumber != SecurityContext.ANONYMOUS_SESSION.getSessionNumber()) {
                this.subject = new SubjectWrapper();
                users.fillSubject(userInfo, this.subject.getSubject());
                session = new SecuritySession(sessionNumber, TicketGenerator.getCreationTime(this.ticket), userInfo.getPrincipal(), this.subject.getSubject(), this.authentication);
            } else {
                session = SecurityContext.ANONYMOUS_SESSION;
            }
            if (this.pool != null) {
                this.pool.registerSession(this.ticket, session);
            }
        }
        catch (Exception e) {
            BaseSecurityException bse = new BaseSecurityException("security_1023", e);
            bse.log();
        }
        catch (NoClassDefFoundError e) {
            BaseSecurityException bse = new BaseSecurityException("security_1023", e);
            bse.log();
        }
        return session;
    }

    private Object createSessionFromTicketWithoutUserStore() {
        SecuritySession session = null;
        try {
            long sessionNumber = TicketGenerator.getSessionNumber(this.ticket);
            Principal principal = new Principal(TicketGenerator.getPrincipalName(this.ticket));
            this.subject = new SubjectWrapper();
            this.subject.addPrincipal(principal);
            session = SecurityContext.ANONYMOUS_SESSION == null || SecurityContext.ANONYMOUS_SESSION != null && sessionNumber != SecurityContext.ANONYMOUS_SESSION.getSessionNumber() ? new SecuritySession(sessionNumber, TicketGenerator.getCreationTime(this.ticket), principal, this.subject.getSubject(), this.authentication) : SecurityContext.ANONYMOUS_SESSION;
            if (this.pool != null) {
                this.pool.registerSession(this.ticket, session);
            }
        }
        catch (Exception e) {
            BaseSecurityException bse = new BaseSecurityException("security_1023", e);
            bse.log();
        }
        catch (NoClassDefFoundError e) {
            BaseSecurityException bse = new BaseSecurityException("security_1023", e);
            bse.log();
        }
        return session;
    }

    private UserStoreFactory getUserStoreFactory() {
        try {
            return SecurityContextImpl.getRoot().getUserStoreContext();
        }
        catch (Exception exception) {
            try {
                if (SecurityResourceAccessor.location.beWarning()) {
                    SecurityResourceAccessor.location.traceThrowableT(400, exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            finally {
                return null;
            }
            {
            }
        }
        catch (NoClassDefFoundError exception) {
            try {
                if (SecurityResourceAccessor.location.beWarning()) {
                    SecurityResourceAccessor.location.traceThrowableT(400, exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            finally {
                return null;
            }
            {
            }
        }
    }
}

