/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security;

import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.lib.lang.ConvertTools;
import com.sap.engine.services.security.InputSerializator;
import com.sap.engine.services.security.OutputSerializator;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseNotSerializableException;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.engine.services.security.login.SubjectWrapper;
import com.sap.exception.IBaseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.security.Principal;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public class Util {
    private static final String COMPONENT_COMMON = "common:";
    static /* synthetic */ Class class$com$sap$engine$services$security$Util;

    public static Serializable array2object(byte[] bytes, int offset, int length) throws NotSerializableException {
        Serializable serializable;
        ByteArrayInputStream bytearrayinputstream = null;
        InputSerializator objectinputstream = null;
        String loaderName = null;
        try {
            bytearrayinputstream = new ByteArrayInputStream(bytes, offset, length);
            objectinputstream = new InputSerializator(null, bytearrayinputstream);
            objectinputstream.loaderName = loaderName = (String)objectinputstream.readObject();
            serializable = (Serializable)objectinputstream.readObject();
        }
        catch (NotSerializableException exception) {
            if (exception instanceof IBaseException) {
                throw exception;
            }
            throw new BaseNotSerializableException("security_1014", exception);
        }
        catch (Exception exception) {
            throw new BaseNotSerializableException("security_1001", exception);
        }
        try {
            if (objectinputstream != null) {
                objectinputstream.close();
            }
            if (bytearrayinputstream != null) {
                bytearrayinputstream.close();
            }
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().logThrowable((byte)3, e);
        }
        return serializable;
    }

    public static SubjectWrapper array2subject(byte[] bytes, int offset, int length) throws NotSerializableException {
        ConvertTools convert = new ConvertTools(false);
        int contentsCount = 0;
        int partSize = 0;
        int currentOffset = offset;
        try {
            Principal principal = null;
            Subject res = new Subject();
            partSize = convert.arrToInt(bytes, currentOffset);
            principal = (Principal)((Object)Util.array2object(bytes, currentOffset += 4, partSize));
            contentsCount = convert.arrToInt(bytes, currentOffset += partSize);
            currentOffset += 4;
            int i = 0;
            while (i < contentsCount) {
                partSize = convert.arrToInt(bytes, currentOffset);
                res.getPrincipals().add((Principal)((Object)Util.array2object(bytes, currentOffset += 4, partSize)));
                currentOffset += partSize;
                ++i;
            }
            contentsCount = convert.arrToInt(bytes, currentOffset);
            currentOffset += 4;
            int i2 = 0;
            while (i2 < contentsCount) {
                partSize = convert.arrToInt(bytes, currentOffset);
                res.getPrivateCredentials().add(Util.array2object(bytes, currentOffset += 4, partSize));
                currentOffset += partSize;
                ++i2;
            }
            contentsCount = convert.arrToInt(bytes, currentOffset);
            currentOffset += 4;
            int i3 = 0;
            while (i3 < contentsCount) {
                partSize = convert.arrToInt(bytes, currentOffset);
                res.getPublicCredentials().add(Util.array2object(bytes, currentOffset += 4, partSize));
                currentOffset += partSize;
                ++i3;
            }
            return new SubjectWrapper(res, principal);
        }
        catch (IOException ioe) {
            throw new BaseNotSerializableException("security_1001", ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] object2array(Serializable serializable) throws NotSerializableException {
        ByteArrayOutputStream bytearrayoutputstream = null;
        OutputSerializator objectoutputstream = null;
        ClassLoader loader = null;
        String loaderName = null;
        try {
            try {
                loader = serializable.getClass().getClassLoader();
                if (loader != null) {
                    try {
                        loaderName = (String)loader.getClass().getMethod("getName", null).invoke((Object)loader, null);
                    }
                    catch (Throwable t) {
                        SecurityServerFrame.getLogger().logThrowable((byte)3, t);
                    }
                }
                bytearrayoutputstream = new ByteArrayOutputStream();
                objectoutputstream = new OutputSerializator(loaderName, bytearrayoutputstream);
                objectoutputstream.writeObject(loaderName);
                objectoutputstream.writeObject(serializable);
                objectoutputstream.flush();
                byte[] t = bytearrayoutputstream.toByteArray();
                Object var7_8 = null;
                try {
                    if (objectoutputstream != null) {
                        objectoutputstream.close();
                    }
                    if (bytearrayoutputstream == null) return t;
                    bytearrayoutputstream.close();
                    return t;
                }
                catch (Exception e) {
                    SecurityServerFrame.getLogger().logThrowable((byte)3, e);
                }
                return t;
            }
            catch (Exception exception) {
                throw new BaseNotSerializableException("security_1002", exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {}
            catch (Exception e) {
                SecurityServerFrame.getLogger().logThrowable((byte)3, e);
                throw throwable;
            }
            if (objectoutputstream != null) {
                objectoutputstream.close();
            }
            if (bytearrayoutputstream == null) throw throwable;
            bytearrayoutputstream.close();
            throw throwable;
        }
    }

    public static Class loadClassFromAdditionalLoaders(String className, String serviceProperty) throws ClassNotFoundException {
        String propertyValue = SecurityServerFrame.getServiceProperties().getProperty(serviceProperty, "");
        StringTokenizer tokens = new StringTokenizer(propertyValue, ",");
        Class result = null;
        if (tokens.countTokens() <= 0) {
            SecurityResourceAccessor.location.errorT("Cannot load login module class {0}.", new Object[]{className});
        }
        while (tokens.hasMoreTokens()) {
            try {
                String loader = tokens.nextToken().trim();
                result = Util.loadClass(className, loader);
                if (result == null) continue;
                break;
            }
            catch (ClassNotFoundException cnfe) {
                if (tokens.hasMoreTokens()) continue;
                throw cnfe;
            }
        }
        return result;
    }

    public static Class loadClass(String className, String loaderName) throws ClassNotFoundException {
        if (loaderName == null || loaderName.length() == 0) {
            return (class$com$sap$engine$services$security$Util == null ? (class$com$sap$engine$services$security$Util = Util.class$("com.sap.engine.services.security.Util")) : class$com$sap$engine$services$security$Util).getClassLoader().loadClass(className);
        }
        ClassLoader loader = null;
        LoadContext loadContext = SecurityServerFrame.getServiceContext().getCoreContext().getLoadContext();
        loader = loadContext.getClassLoader(loaderName);
        if (loader != null) {
            return loader.loadClass(className);
        }
        if (loaderName.startsWith(COMPONENT_COMMON)) {
            StringTokenizer loaderParser = new StringTokenizer(loaderName.substring(COMPONENT_COMMON.length()), ";");
            Class<?> classInstance = null;
            while (loaderParser.hasMoreTokens() && classInstance == null) {
                try {
                    classInstance = loadContext.getClassLoader(loaderParser.nextToken()).loadClass(className);
                    if (classInstance == null) continue;
                    return classInstance;
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
        }
        return (class$com$sap$engine$services$security$Util == null ? (class$com$sap$engine$services$security$Util = Util.class$("com.sap.engine.services.security.Util")) : class$com$sap$engine$services$security$Util).getClassLoader().loadClass(className);
    }

    public static byte[] subject2array(SubjectWrapper subjectWrapper) throws NotSerializableException {
        Subject subject = subjectWrapper.getSubject();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ConvertTools convert = new ConvertTools(false);
        Object[] contents = null;
        byte[] data = null;
        try {
            data = Util.object2array((Serializable)((Object)subjectWrapper.getPrincipal()));
            baos.write(convert.intToArr(data.length));
            baos.write(data);
            contents = subject.getPrincipals().toArray();
            baos.write(convert.intToArr(contents.length));
            int i = 0;
            while (i < contents.length) {
                block17: {
                    if (contents[i] instanceof Serializable) {
                        try {
                            data = Util.object2array((Serializable)contents[i]);
                        }
                        catch (NotSerializableException e) {
                            break block17;
                        }
                        if (data != null) {
                            baos.write(convert.intToArr(data.length));
                            baos.write(data);
                        }
                    }
                }
                ++i;
            }
            contents = subject.getPrivateCredentials().toArray();
            baos.write(convert.intToArr(contents.length));
            int i2 = 0;
            while (i2 < contents.length) {
                block18: {
                    if (contents[i2] instanceof Serializable) {
                        try {
                            data = Util.object2array((Serializable)contents[i2]);
                        }
                        catch (NotSerializableException e) {
                            break block18;
                        }
                        if (data != null) {
                            baos.write(convert.intToArr(data.length));
                            baos.write(data);
                        }
                    }
                }
                ++i2;
            }
            contents = subject.getPublicCredentials().toArray();
            baos.write(convert.intToArr(contents.length));
            int i3 = 0;
            while (i3 < contents.length) {
                block19: {
                    if (contents[i3] instanceof Serializable) {
                        try {
                            data = Util.object2array((Serializable)contents[i3]);
                        }
                        catch (NotSerializableException e) {
                            break block19;
                        }
                        if (data != null) {
                            baos.write(convert.intToArr(data.length));
                            baos.write(data);
                        }
                    }
                }
                ++i3;
            }
        }
        catch (IOException ioe) {
            throw new BaseNotSerializableException("security_1002", ioe);
        }
        return baos.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

