/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security;

import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.container.registry.ObjectRegistry;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.interfaces.cross.CrossInterface;
import com.sap.engine.interfaces.security.AuthorizationContext;
import com.sap.engine.interfaces.security.ModificationContext;
import com.sap.engine.interfaces.security.ResourceContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.resource.ResourceAccessControlHandle;
import com.sap.engine.interfaces.security.resource.ResourceHandle;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerWrapper;
import com.sap.engine.services.security.DebugSecurityLogger;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.command.Commands;
import com.sap.engine.services.security.exceptions.SecurityServiceException;
import com.sap.engine.services.security.login.Signer;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remoteimpl.RemoteSecurityImpl;
import com.sap.engine.services.security.server.SecurityContextImpl;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.x509.X509Certificate;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;

public class ContainerEventListenerImpl
implements ContainerEventListener {
    private static final String INTERFACE_CROSS = "cross";
    private static final String INTERFACE_KEYSTORE = "keystore";
    private static final String INTERFACE_LOG = "log";
    private static final String INTERFACE_NAMING = "naming";
    private static final String INTERFACE_SHELL = "shell";
    private static final String INTITIAL_OBJECT_SECURITY = "security";
    private static final String JNDI_BINDING_SECURITY = "remotesecurity";
    private static final String DEFAULT_KEYSTORE_VIEW = "TicketKeystore";
    private static final String DEFAULT_KEYPAIR_ALIAS = "SAPLogonTicketKeypair";
    private static final String TICKET_ROLE = "browse_keystore_view";
    private SecurityContext root;
    private RemoteSecurity remote = null;
    private SystemMonitor systemMonitor = null;
    private SecurityServerFrame securityFrame = null;
    private Commands commands = null;
    private KeystoreManagerWrapper keystore = null;

    public ContainerEventListenerImpl(SecurityServerFrame securityFrame, SecurityContext root, ObjectRegistry registry) {
        try {
            this.securityFrame = securityFrame;
            this.systemMonitor = SecurityServerFrame.systemMonitor;
            this.root = root;
            this.remote = new RemoteSecurityImpl(root);
            Object impl = null;
            impl = registry.getProvidedInterface(INTERFACE_NAMING);
            if (impl != null) {
                this.serviceStarted(INTERFACE_NAMING, impl);
            }
            if ((impl = registry.getProvidedInterface(INTERFACE_KEYSTORE)) != null) {
                this.serviceStarted(INTERFACE_KEYSTORE, impl);
            }
            if ((impl = registry.getProvidedInterface(INTERFACE_SHELL)) != null) {
                this.interfaceAvailable(INTERFACE_SHELL, impl);
            }
            if ((impl = registry.getProvidedInterface(INTERFACE_LOG)) != null) {
                this.interfaceAvailable(INTERFACE_LOG, impl);
            }
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().logThrowable((byte)4, e);
        }
    }

    public RemoteSecurity getRemoteSecurity() {
        return this.remote;
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        ServiceMonitor serviceMonitor = this.systemMonitor.getService(serviceName);
        Hashtable securityInfo = serviceMonitor.getSecurityResources();
        if (securityInfo != null) {
            this.registerService(securityInfo);
        }
        if (serviceName.equals(INTERFACE_NAMING)) {
            try {
                new InitialContext().bind(JNDI_BINDING_SECURITY, (Object)this.remote);
            }
            catch (Exception e) {
                SecurityServerFrame.getLogger().logThrowable((byte)4, e);
            }
        } else if (serviceName.equals(INTERFACE_KEYSTORE)) {
            Signer.keystoreStarted();
            this.keystore = (KeystoreManagerWrapper)serviceInterface;
            this.setKeystore(this.keystore);
            if (this.commands != null) {
                this.commands.setKeystore(this.keystore);
            }
        }
    }

    protected void setKeystore(KeystoreManagerWrapper keystore) {
        int attempts = 0;
        boolean isSuccesfull = false;
        while (attempts++ < 180) {
            try {
                this.createTicketKeyStore(keystore);
                isSuccesfull = true;
                break;
            }
            catch (Exception e) {
                ContainerEventListenerImpl containerEventListenerImpl = this;
                synchronized (containerEventListenerImpl) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                }
            }
        }
        if (!isSuccesfull) {
            SecurityServerFrame.getLogger().log((byte)5, "System view [TicketKeystore] has not been created");
        } else {
            SecurityServerFrame.getLogger().log((byte)5, "Fully operational view [TicketKeystore] has been created, after [" + attempts + "] attempt(s)");
        }
    }

    private void createTicketKeyStore(KeystoreManagerWrapper keystore) throws Exception {
        this.lockKeystore();
        try {
            try {
                if (keystore.existKeystoreView(DEFAULT_KEYSTORE_VIEW)) {
                    Object var4_2 = null;
                    this.releaseLockKeystore();
                    return;
                }
                keystore.createKeystoreView(DEFAULT_KEYSTORE_VIEW, null);
                ContainerEventListenerImpl.createAndStoreEntries(keystore.getKeystore(DEFAULT_KEYSTORE_VIEW));
                AuthorizationContext authorization = SecurityServerFrame.getSecurityContext().getPolicyConfigurationContext("keystore-view.TicketKeystore").getAuthorizationContext();
                ContainerEventListenerImpl.createSystemRole(authorization);
            }
            catch (Exception e) {
                keystore.destroyKeystoreView(DEFAULT_KEYSTORE_VIEW);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseLockKeystore();
            throw throwable;
        }
        Object var4_3 = null;
        this.releaseLockKeystore();
    }

    private static final void createAndStoreEntries(KeyStore keystoreView) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException, KeyStoreException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("DSA");
        generator.initialize(1024);
        KeyPair myKeyPair = generator.generateKeyPair();
        X509Certificate cert = new X509Certificate();
        GregorianCalendar calendar = new GregorianCalendar();
        cert.setValidNotBefore(calendar.getTime());
        calendar.add(1, 2);
        cert.setValidNotAfter(calendar.getTime());
        Name subjectName = new Name();
        subjectName.addRDN(ObjectID.commonName, (Object)SecurityContextImpl.getSystemID());
        cert.setSubjectDN((Principal)subjectName);
        cert.setIssuerDN((Principal)subjectName);
        cert.setPublicKey(myKeyPair.getPublic());
        cert.setSerialNumber(BigInteger.ZERO);
        cert.sign(AlgorithmID.dsaWithSHA, myKeyPair.getPrivate());
        keystoreView.setKeyEntry(DEFAULT_KEYPAIR_ALIAS, myKeyPair.getPrivate(), "".toCharArray(), (Certificate[])new X509Certificate[]{cert});
        keystoreView.setCertificateEntry("SAPLogonTicketKeypair-cert", (Certificate)cert);
    }

    private static final void createSystemRole(AuthorizationContext authorization) {
        authorization.getSecurityRoleContext().addSecurityRoleReference(TICKET_ROLE, "SAP-J2EE-Engine", "all");
        ResourceAccessControlHandle views_actions = authorization.getSecurityResourceContext().getResourceAccessControlHandle("view-actions");
        views_actions.grantSecurityRole(TICKET_ROLE, "FIND_ALIAS", "ALL");
        views_actions.grantSecurityRole(TICKET_ROLE, "GET_VIEW", "ALL");
        views_actions.grantSecurityRole(TICKET_ROLE, "GET_VIEW_PROPERTIES", "ALL");
        views_actions.grantSecurityRole(TICKET_ROLE, "IS_VIEW_EXISTS", "ALL");
        views_actions.grantSecurityRole(TICKET_ROLE, "LIST_VIEW", "ALL");
        views_actions.grantSecurityRole(TICKET_ROLE, "SIZE_OF_VIEW", "ALL");
        views_actions.grantSecurityRole(TICKET_ROLE, "VIEW_ALIASES", "ALL");
        ResourceAccessControlHandle entry_actions = authorization.getSecurityResourceContext().getResourceAccessControlHandle("entry-actions");
        entry_actions.grantSecurityRole(TICKET_ROLE, "IS_ENTRY_A_KEY", "ALL");
        entry_actions.grantSecurityRole(TICKET_ROLE, "IS_ENTRY_EXISTS", "ALL");
        entry_actions.grantSecurityRole(TICKET_ROLE, "LIST_ENTRY", "ALL");
        entry_actions.grantSecurityRole(TICKET_ROLE, "READ_ENTRY", "ALL");
        ResourceAccessControlHandle property_actions = authorization.getSecurityResourceContext().getResourceAccessControlHandle("property-actions");
        property_actions.grantSecurityRole(TICKET_ROLE, "GET_PROPERTY", "ALL");
        property_actions.grantSecurityRole(TICKET_ROLE, "LIST_PROPERTY", "ALL");
    }

    private void lockKeystore() throws SecurityServiceException {
        long waitLimit = 180000L;
        long waitInterval = 1000L;
        long beginTime = System.currentTimeMillis();
        while (System.currentTimeMillis() <= beginTime + waitLimit) {
            try {
                SecurityServerFrame.internalLock.lock("$service.security", "ticket_keystore", 'X');
                return;
            }
            catch (Exception e) {
                ContainerEventListenerImpl containerEventListenerImpl = this;
                synchronized (containerEventListenerImpl) {
                    try {
                        this.wait(waitInterval);
                    }
                    catch (InterruptedException ex) {
                        throw new SecurityServiceException("security_5021", (Throwable)ex);
                    }
                }
            }
        }
        throw new SecurityServiceException("security_5021");
    }

    private void releaseLockKeystore() throws TechnicalLockException {
        SecurityServerFrame.internalLock.unlock("$service.security", "ticket_keystore", 'X');
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
        if (serviceName.equals(INTERFACE_KEYSTORE)) {
            Signer.keystoreStopped();
        }
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals(INTERFACE_SHELL)) {
            this.commands = new Commands(this.root, (ShellInterface)interfaceImpl);
            if (this.keystore != null) {
                this.commands.setKeystore(this.keystore);
            }
        } else if (interfaceName.equals(INTERFACE_CROSS)) {
            ((CrossInterface)interfaceImpl).setInitialObject(INTITIAL_OBJECT_SECURITY, this.remote);
        } else if (interfaceName.equals(INTERFACE_LOG)) {
            DebugSecurityLogger.useCategory_Location(true);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals(INTERFACE_LOG)) {
            DebugSecurityLogger.useCategory_Location(false);
        }
    }

    public void markForShutdown(long timeout) {
    }

    public boolean setServiceProperty(String key, String value) {
        Properties serviceProperties = SecurityServerFrame.getServiceProperties();
        if (serviceProperties != null) {
            serviceProperties.setProperty(key, value);
            this.securityFrame.setServiceProperties(serviceProperties);
        }
        return true;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        this.securityFrame.setServiceProperties(serviceProperties);
        return true;
    }

    private synchronized void registerService(Hashtable info) {
        SecurityContext serviceSecurity = this.root;
        ModificationContext modifications = serviceSecurity.getModificationContext();
        try {
            modifications.beginModifications();
            ResourceContext rc = serviceSecurity.getAuthorizationContext().getSecurityResourceContext();
            SecurityRoleContext src = serviceSecurity.getAuthorizationContext().getSecurityRoleContext();
            try {
                src.addSecurityRoleReference("guests", "SAP-J2EE-Engine", "guests");
                src.addSecurityRoleReference("administrators", "SAP-J2EE-Engine", "administrators");
                src.addSecurityRoleReference("all", "SAP-J2EE-Engine", "all");
            }
            catch (Exception e) {
                SecurityServerFrame.getLogger().logThrowable((byte)8, e);
            }
            Enumeration resources = info.keys();
            String resource = null;
            Hashtable actions = null;
            while (resources.hasMoreElements()) {
                try {
                    resource = (String)resources.nextElement();
                    rc.createResource(resource);
                    actions = (Hashtable)info.get(resource);
                    this.grantPermissions(resource, rc, actions);
                }
                catch (Exception ex) {
                    SecurityServerFrame.getLogger().logThrowable((byte)4, ex);
                }
            }
            modifications.commitModifications();
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().logThrowable((byte)4, e);
            modifications.rollbackModifications();
        }
    }

    private void grantPermissions(String resource, ResourceContext rc, Hashtable actions) {
        ResourceHandle resourceHandle = rc.getResourceHandle(resource);
        ResourceAccessControlHandle acl = rc.getResourceAccessControlHandle(resource);
        Enumeration actionKeys = actions.keys();
        String action = null;
        String role = null;
        while (actionKeys.hasMoreElements()) {
            try {
                action = (String)actionKeys.nextElement();
                resourceHandle.createAction(action);
                role = (String)actions.get(action);
                acl.grantSecurityRole(role, action, "ALL");
            }
            catch (Exception ex) {
                SecurityServerFrame.getLogger().logThrowable((byte)4, ex);
            }
        }
    }
}

