/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.interfaces.cross.CrossInterface;
import com.sap.engine.interfaces.log.LogInterface;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.services.rmi_p4.exception.P4ResourceAccessor;
import com.sap.engine.services.rmi_p4.log.P4Logger;
import com.sap.engine.services.rmi_p4.monitor.P4RuntimeControl;
import com.sap.engine.services.rmi_p4.server.P4ContainerEventListenerImpl;
import com.sap.engine.services.rmi_p4.server.P4Provider;
import com.sap.engine.services.rmi_p4.server.P4SessionProcessor;
import com.sap.engine.services.rmi_p4.server.command.ListCallsInfo;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Properties;

public class P4ServiceFrame
extends P4ContainerEventListenerImpl
implements ApplicationServiceFrame,
ContainerEventListener {
    public static final String USE_COMPONENT_EXECUTION_CONTEXT = "USE_ComponentExecutionContext";
    public static final String INSTANTIATE_LOCAL_STUBS = "INSTANTIATE_LOCAL_STUBS";
    public static final String GENERATE_STUBS = "generateStubs";
    public static final String BROKER_ID = "brokerId";
    public static P4ServiceFrame frame = null;
    public static Location location = null;
    public static Category category = null;
    public static boolean isP4Stopped = false;
    protected static int repeatTime = -1;
    protected static boolean instantiateLocalStubs = true;
    protected boolean generateStubs = true;
    protected static CrossInterface crossInterface = null;
    public P4SessionProcessor sessionProcessor;
    protected LogInterface logInterface = null;
    private ApplicationServiceContext asc = null;
    private P4RuntimeControl managementInterface = null;

    public void start(ApplicationServiceContext _baseContext) throws ServiceException {
        frame = this;
        this.sessionProcessor = new P4SessionProcessor(_baseContext);
        Properties properties = _baseContext.getServiceState().getProperties();
        this.initProperties(properties);
        if (P4ResourceAccessor.location == null) {
            P4ResourceAccessor.location = location = Location.getLocation((String)"com.sap.engine.services.rmi_p4");
        }
        if (P4ResourceAccessor.category == null) {
            P4ResourceAccessor.category = category = Category.getCategory((String)P4ResourceAccessor.CATEGORY);
        }
        P4Logger.setCategory(category);
        P4Logger.setLocation(location);
        if (category == null) {
            System.out.println("ERROR:P4 Service - Cannot instantiate Category and p4 service cannot log");
        }
        if (location == null) {
            System.out.println("ERROR:P4 Service - Cannot instantiate Location and p4 service cannot trace");
        }
        try {
            this.asc = _baseContext;
            int mask = 192;
            HashSet<String> names = new HashSet<String>(4);
            names.add("cross");
            names.add("appcontext");
            names.add("log");
            names.add("shell");
            _baseContext.getServiceState().registerContainerEventListener(mask, names, this);
            crossInterface = (CrossInterface)this.asc.getContainerContext().getObjectRegistry().getProvidedInterface(P4ContainerEventListenerImpl.CROSS_INTERFACE_NAME);
            this.p4Provider = new P4Provider(this.sessionProcessor, this.generateStubs);
            crossInterface.registerProtocolProvider(this.p4Provider);
            _baseContext.getClusterContext().getApplicationSessionContext().registerProcessor(this.sessionProcessor);
            this.managementInterface = new P4RuntimeControl();
            _baseContext.getServiceState().registerManagementInterface(this.managementInterface);
            _baseContext.getContainerContext().getObjectRegistry().registerInterface(this.managementInterface);
        }
        catch (Exception ex) {
            P4Logger.logErr("ID 011171: Unexpected exception. P4 service can not start!" + ex.getMessage());
            P4Logger.logThrowable(ex);
            throw new ServiceException("ID 011171: Unexpected exception.", (Throwable)ex);
        }
    }

    public void stop() {
        LogInterface logInterface;
        this.sessionProcessor.stop();
        this.asc.getServiceState().unregisterContainerEventListener();
        this.asc.getClusterContext().getApplicationSessionContext().unregisterProcessor();
        if (this.log != null && (logInterface = (LogInterface)this.asc.getContainerContext().getObjectRegistry().getProvidedInterface("log")) != null) {
            logInterface.destroyLogger("P4");
        }
        frame = null;
        crossInterface = null;
        instantiateLocalStubs = true;
        isP4Stopped = true;
    }

    private void initProperties(Properties properties) {
        String trueValue = "true";
        this.generateStubs = properties.getProperty(GENERATE_STUBS, trueValue).equalsIgnoreCase(trueValue);
        instantiateLocalStubs = properties.getProperty(INSTANTIATE_LOCAL_STUBS, trueValue).equalsIgnoreCase(trueValue);
        this.useEC = properties.getProperty(USE_COMPONENT_EXECUTION_CONTEXT, trueValue).equalsIgnoreCase(trueValue);
    }

    public boolean setServiceProperty(String key, String value) {
        String trueValue = "true";
        if (key != null && value != null) {
            if (key.equalsIgnoreCase(USE_COMPONENT_EXECUTION_CONTEXT)) {
                this.useEC = value.equalsIgnoreCase(trueValue);
            } else if (key.equalsIgnoreCase(INSTANTIATE_LOCAL_STUBS)) {
                instantiateLocalStubs = value.equalsIgnoreCase(trueValue);
            } else if (key.equals(GENERATE_STUBS)) {
                this.p4Provider.generateStubs = this.generateStubs = value.equalsIgnoreCase(trueValue);
            } else if (key.equalsIgnoreCase(BROKER_ID)) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean setServiceProperties(Properties props) {
        this.initProperties(props);
        this.p4Provider.generateStubs = this.generateStubs;
        return true;
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            Command[] cmds = new Command[]{new ListCallsInfo()};
            ((ShellInterface)interfaceImpl).registerCommands(cmds);
        }
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public void interfaceNotAvailable(String interfaceName) {
    }

    public void markForShutdown(long time) {
    }
}

