/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.server;

import com.sap.engine.interfaces.cross.ObjectReference;
import com.sap.engine.lib.lang.ConvertTools;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4RemoteObjectInfo;
import com.sap.engine.services.rmi_p4.StubBase;
import com.sap.engine.services.rmi_p4.StubBaseInfo;

public class P4ServerObjectInfo
extends P4RemoteObjectInfo
implements ObjectReference {
    static final long serialVersionUID = 1284708367544595829L;
    public static final ConvertTools ct = new ConvertTools(false);

    public Object toObject(ClassLoader loader) {
        Class<?> stubClass = null;
        P4ObjectBroker broker = P4ObjectBroker.init();
        int i = 0;
        while (i < this.stubs.length) {
            try {
                stubClass = Class.forName(this.stubs[i], true, loader);
                return broker.narrow(StubBaseInfo.makeStubBaseInfo(this), stubClass);
            }
            catch (ClassNotFoundException cnf) {
                ++i;
            }
        }
        return null;
    }

    public Object toObject(ClassLoader loader, Object properties) {
        Class<?> stubClass = null;
        P4ObjectBroker broker = P4ObjectBroker.init();
        int i = 0;
        while (i < this.stubs.length) {
            try {
                stubClass = Class.forName(this.stubs[i], true, loader);
                StubBaseInfo info = StubBaseInfo.makeStubBaseInfo(this);
                try {
                    StubBase base = (StubBase)properties;
                    String id = base.getInfo().getIncomingProfile();
                    if (id != null && info.ownerId == Integer.parseInt(id.substring(0, id.indexOf(58)))) {
                        info.setIncomingProfile(base.getInfo().getIncomingProfile());
                    }
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
                return broker.narrow(info, stubClass);
            }
            catch (ClassNotFoundException cnf) {
                ++i;
            }
        }
        return null;
    }

    public int hashCode() {
        int hash = ct.arrToInt(this.key, 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof P4ServerObjectInfo) {
            P4ServerObjectInfo p4Obj = (P4ServerObjectInfo)obj;
            if (this.server_id == p4Obj.server_id && ct.arrToInt(this.key, 0) == ct.arrToInt(p4Obj.key, 0)) {
                return true;
            }
        }
        return false;
    }
}

