/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.server;

import com.sap.engine.interfaces.cross.ObjectReference;
import com.sap.engine.interfaces.cross.ProtocolProvider;
import com.sap.engine.interfaces.cross.ProviderContainer;
import com.sap.engine.interfaces.security.ResourceContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.P4StubSkeletonGenerator;
import com.sap.engine.services.rmi_p4.RemoteObjectInfo;
import com.sap.engine.services.rmi_p4.StubBaseInfo;
import com.sap.engine.services.rmi_p4.server.P4ContainerEventListenerImpl;
import com.sap.engine.services.rmi_p4.server.P4SessionProcessor;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Vector;

public class P4Provider
implements ProtocolProvider {
    private static P4SessionProcessor sessionProcessor;
    private P4ObjectBroker broker = P4ObjectBroker.init();
    private static ResourceContext resourceCtx;
    protected boolean generateStubs = true;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$server$P4Provider;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$RemoteObjectInfo;

    public P4Provider(P4SessionProcessor _session, boolean generate) {
        sessionProcessor = _session;
        this.generateStubs = generate;
    }

    public ProviderContainer generateSupport(Class[] objects, Class[] interfaces, Hashtable access, String workDir) {
        return this.generateSupport(objects, interfaces, access, workDir, true);
    }

    public ProviderContainer generateSupport(Class[] objects, Class[] interfaces, Hashtable access, String workDir, boolean applyExecContext) {
        if (!this.generateStubs) {
            return new ProviderContainer(new String[0], new String[0], workDir);
        }
        Vector<String> vAll = new Vector<String>();
        Vector temp = null;
        Vector<String> client = new Vector<String>();
        int i = 0;
        while (i < objects.length) {
            try {
                P4StubSkeletonGenerator generator = new P4StubSkeletonGenerator(objects[i], workDir, access);
                generator.setApplyExecutionContext(applyExecContext);
                temp = generator.generate();
                int size = temp.size();
                int j = 0;
                while (j < size) {
                    String generated = (String)temp.elementAt(j);
                    vAll.addElement(generated);
                    if (generated.endsWith("_Stub")) {
                        client.addElement(generated);
                    }
                    ++j;
                }
            }
            catch (Exception ex) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4Provider == null ? P4Provider.class$("com.sap.engine.services.rmi_p4.server.P4Provider") : class$com$sap$engine$services$rmi_p4$server$P4Provider, ex, "generateSupport", 100);
            }
            ++i;
        }
        Object[] serverSupport = new String[vAll.size()];
        vAll.copyInto(serverSupport);
        Object[] clientSupport = new String[client.size()];
        client.copyInto(clientSupport);
        return new ProviderContainer((String[])serverSupport, (String[])clientSupport, workDir);
    }

    public void setInitialObject(String name, Remote initialObject) {
        sessionProcessor.setInitialObject(name, initialObject);
    }

    public void removeInitialObject(String name) {
    }

    public String getName() {
        return "p4";
    }

    public void exportObject(Remote rm, ClassLoader loader) {
    }

    public void unexportObject(Remote remote) {
        try {
            this.broker.disconnect(this.broker.loadObject(remote));
        }
        catch (Exception e) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4Provider == null ? (class$com$sap$engine$services$rmi_p4$server$P4Provider = P4Provider.class$("com.sap.engine.services.rmi_p4.server.P4Provider")) : class$com$sap$engine$services$rmi_p4$server$P4Provider, e, "011108", "unexportObject", 100);
        }
    }

    public ObjectReference getObjectReference(Object object) {
        try {
            P4RemoteObject p4Object = P4ObjectBroker.init().loadObject((Remote)object);
            RemoteObjectInfo info = p4Object.getObjectInfo();
            info.connectionProfiles = this.broker.getConnectionProfiles();
            this.broker.addLink(info.key);
            return (ObjectReference)((Object)info);
        }
        catch (Exception ex) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$P4Provider == null ? (class$com$sap$engine$services$rmi_p4$server$P4Provider = P4Provider.class$("com.sap.engine.services.rmi_p4.server.P4Provider")) : class$com$sap$engine$services$rmi_p4$server$P4Provider, ex, "getObjectReference", 100);
            return null;
        }
    }

    public Object narrow(Object obj, Class _class) throws ClassCastException {
        if (obj instanceof StubBaseInfo) {
            return this.broker.narrow(obj, _class);
        }
        if (obj instanceof RemoteObjectInfo) {
            StubBaseInfo sbi = StubBaseInfo.makeStubBaseInfo((RemoteObjectInfo)obj);
            return this.broker.narrow(sbi, _class);
        }
        return this.broker.narrow(obj, _class);
    }

    public static ResourceContext getResourceContext() {
        SecurityContext sc;
        if (resourceCtx == null && (sc = (SecurityContext)sessionProcessor.getServiceContext().getContainerContext().getObjectRegistry().getProvidedInterface(P4ContainerEventListenerImpl.SECURITY_PROVIDER_NAME)) != null) {
            resourceCtx = sc.getAuthorizationContext().getSecurityResourceContext();
        }
        return resourceCtx;
    }

    public Class getProviderClass() {
        return class$com$sap$engine$services$rmi_p4$RemoteObjectInfo == null ? (class$com$sap$engine$services$rmi_p4$RemoteObjectInfo = P4Provider.class$("com.sap.engine.services.rmi_p4.RemoteObjectInfo")) : class$com$sap$engine$services$rmi_p4$RemoteObjectInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

