/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.server;

import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.Repliable;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import com.sap.engine.services.rmi_p4.server.ClusterOrganizer;
import com.sap.engine.services.rmi_p4.server.P4SessionProcessor;

public class Messenger
implements Repliable {
    private P4SessionProcessor processor;
    private ClusterOrganizer organizer;
    private ClientThreadContext tc = null;
    private P4ObjectBroker broker = P4ObjectBroker.init();

    public Messenger(P4SessionProcessor processor, ClusterOrganizer organizer) {
        this.processor = processor;
        this.organizer = organizer;
        this.setTCT();
    }

    private void setTCT() {
        this.tc = this.broker.getCTC();
    }

    public void reply(int server_id, int client_id, byte[] reply) throws P4IOException {
        this.setTCT();
        if (!this.checkConnection(client_id)) {
            throw (P4IOException)this.broker.getException(0, P4BaseIOException.Ilegal_client_ID, null);
        }
        this.organizer.send(Math.abs(server_id), reply, 0, reply.length, this.tc != null);
    }

    public void reply(int server_id, int client_id, byte[] reply, int size) throws P4IOException {
        byte[] tosend = new byte[size - 8];
        System.arraycopy(reply, 8, tosend, 0, tosend.length);
        this.reply(server_id, client_id, tosend);
    }

    public void reply(int server_id, int sender_id, int client_id, byte[] reply, int size) throws P4IOException {
        this.setTCT();
        if (!this.checkConnection(client_id)) {
            throw (P4IOException)this.broker.getException(0, P4BaseIOException.Ilegal_client_ID, null);
        }
        this.organizer.send(Math.abs(sender_id), reply, 0, size, this.tc != null);
    }

    public void reply(Message msg, byte[] reply) throws P4IOException {
        if (!this.checkConnection(msg.client_id)) {
            throw (P4IOException)this.broker.getException(0, P4BaseIOException.Ilegal_client_ID, null);
        }
        this.reply(msg.clusterEl_id, msg.client_id, reply);
    }

    public int getTCSize() {
        return this.processor.getTCSize();
    }

    public int getTCSize(int own_broker_id) {
        return this.processor.getTCSize(own_broker_id);
    }

    public String getUnderlyingProfile() {
        return null;
    }

    public boolean checkConnection(int _connId) {
        return _connId != 0;
    }
}

