/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.cluster.ClusterContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.event.ClusterEventListener;
import com.sap.engine.frame.cluster.event.ServiceEventListener;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.cluster.message.MultipleAnswer;
import com.sap.engine.frame.cluster.message.NoListenerOnDestinationException;
import com.sap.engine.frame.cluster.message.ResponseTimedOutException;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.cross.CrossInterface;
import com.sap.engine.interfaces.cross.CrossObjectFactory;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.AppDispatchImpl;
import com.sap.engine.services.rmi_p4.Call;
import com.sap.engine.services.rmi_p4.DispatchImpl;
import com.sap.engine.services.rmi_p4.InitialCall;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.RemoteObjectInfo;
import com.sap.engine.services.rmi_p4.StubBaseInfo;
import com.sap.engine.services.rmi_p4.SystemDispatchImpl;
import com.sap.engine.services.rmi_p4.all.ConnectionProfile;
import com.sap.engine.services.rmi_p4.all.MessageConstants;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import com.sap.engine.services.rmi_p4.monitor.ConnectionObject;
import com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl;
import com.sap.engine.services.rmi_p4.server.P4SessionProcessor;
import com.sap.engine.services.rmi_p4.server.ServerDispatchImpl;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClusterOrganizer
implements MessageListener,
MessageConstants,
ClusterEventListener,
ServiceEventListener {
    public MessageContext messageContext;
    public ClusterContext clusterContext;
    public ServiceContext serviceContext;
    private P4SessionProcessor sessionProcessor;
    public Hashtable availableProfiles = new Hashtable();
    protected HashSet stubInstance = new HashSet();
    protected P4ObjectBroker broker = P4ObjectBroker.init();
    private int profileCount = 0;
    private int groupId;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer;

    protected ClusterOrganizer(MessageContext _messageContext, ApplicationServiceContext _baseContext) {
        this.messageContext = _messageContext;
        this.clusterContext = _baseContext.getClusterContext();
        this.serviceContext = _baseContext;
        try {
            this.messageContext.registerListener(this);
        }
        catch (Exception e) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, e, "011101", "ClusterOrganizer", 300);
        }
        this.sessionProcessor = P4SessionProcessor.thisProcessor;
        ClusterElement[] clusterElements = this.clusterContext.getClusterMonitor().getServiceNodes();
        this.groupId = this.clusterContext.getClusterMonitor().getCurrentParticipant().getGroupId();
        try {
            this.serviceContext.getServiceState().registerClusterEventListener(this);
            this.serviceContext.getServiceState().registerServiceEventListener(this);
        }
        catch (ListenerAlreadyRegisteredException e) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, (Exception)((Object)e), "011166: a problem with registering cluster or service event listener", "ClusterOrganizer", 100);
        }
        int i = 0;
        while (i < clusterElements.length) {
            if (clusterElements[i].getType() == 1 && this.groupId == clusterElements[i].getGroupId()) {
                try {
                    MessageAnswer answer = this.messageContext.sendAndWaitForAnswer(clusterElements[i].getClusterId(), 1, new byte[0], 0, 0, 100000L);
                    this.updateProfiles(clusterElements[i].getClusterId(), answer.getMessage(), answer.getOffset(), answer.getLength());
                }
                catch (NoListenerOnDestinationException nlode) {
                    try {
                        Thread.sleep(200L);
                        MessageAnswer answer = this.messageContext.sendAndWaitForAnswer(clusterElements[i].getClusterId(), 1, new byte[0], 0, 0, 100000L);
                        this.updateProfiles(clusterElements[i].getClusterId(), answer.getMessage(), answer.getOffset(), answer.getLength());
                    }
                    catch (Exception e) {
                        this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer") : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, e, "011102: a problem with updating profiles", "ClusterOrganizer", 100);
                    }
                }
                catch (Exception _) {
                    this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer") : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, _, "011102", "ClusterOrganizer", 100);
                }
            }
            ++i;
        }
        ((P4ObjectBrokerServerImpl)this.broker).setHttp(this.getDispatcherHosts(clusterElements));
    }

    public ConnectionProfile[] getAllProfiles() {
        return this.availableProfiles.values().toArray(new ConnectionProfile[0]);
    }

    public String[] getDispatcherHosts(ClusterElement[] clusterElements) {
        String[] full = null;
        int j = 0;
        try {
            MultipleAnswer mmsganswer = this.messageContext.sendAndWaitForAnswer(0, (byte)1, 17, new byte[0], 0, 0, 100000L);
            Enumeration enumeration = mmsganswer.answers();
            full = new String[mmsganswer.participants().length];
            while (enumeration.hasMoreElements()) {
                MessageAnswer answer = (MessageAnswer)enumeration.nextElement();
                byte[] host = new byte[answer.getLength()];
                System.arraycopy(answer.getMessage(), answer.getOffset(), host, 0, answer.getLength());
                full[j] = new String(host);
                ++j;
            }
        }
        catch (NoListenerOnDestinationException nlode) {
            try {
                Thread.sleep(20L);
                MultipleAnswer mmsganswer = this.messageContext.sendAndWaitForAnswer(0, (byte)1, 17, new byte[0], 0, 0, 100000L);
                Enumeration enumeration = mmsganswer.answers();
                full = new String[mmsganswer.participants().length];
                while (enumeration.hasMoreElements()) {
                    MessageAnswer answer = (MessageAnswer)enumeration.nextElement();
                    byte[] host = new byte[answer.getLength()];
                    System.arraycopy(answer.getMessage(), answer.getOffset(), host, 0, answer.getLength());
                    full[j] = new String(host);
                    ++j;
                }
            }
            catch (Exception e) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, e, "011167", "getDispatcherHosts", 100);
            }
        }
        catch (ClusterException _) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, (Exception)((Object)_), "011167", "getDispatcherHosts", 100);
        }
        String[] result = new String[j];
        int i = 0;
        while (i < j) {
            result[i] = full[i];
            ++i;
        }
        return result;
    }

    public void receive(int elementId, int id, byte[] message, int off, int size) {
        switch (id) {
            case 6: {
                this.updateProfiles(elementId, message, off, size);
                break;
            }
            case 13: {
                int con_id = Convert.byteArrToInt(message, off);
                Call call = null;
                RemoteObjectInfo info = null;
                try {
                    Object object;
                    Enumeration initCalls = InitialCall.getAllCalls();
                    Enumeration enumeration = Call.getAllCalls();
                    boolean goCalls = enumeration.hasMoreElements();
                    boolean goInit = initCalls.hasMoreElements();
                    while (goCalls || goInit) {
                        InitialCall iCall;
                        if (goCalls) {
                            call = (Call)enumeration.nextElement();
                            info = call.getStub().getObjectInfo();
                            if (info.client_id == con_id && Math.abs(info.local_id) == elementId) {
                                object = call;
                                synchronized (object) {
                                    call.notifyAll();
                                }
                                info.client_id = 0;
                            }
                        }
                        if (goInit && (iCall = (InitialCall)initCalls.nextElement()).getClientId() == con_id && iCall.getDispId() == elementId) {
                            object = iCall;
                            synchronized (object) {
                                iCall.notifyAll();
                            }
                            iCall.remove();
                        }
                        goCalls = enumeration.hasMoreElements();
                        goInit = initCalls.hasMoreElements();
                    }
                    object = this.stubInstance;
                    synchronized (object) {
                        Object[] arr = ((AbstractCollection)this.stubInstance).toArray();
                        int i = 0;
                        while (i < arr.length) {
                            info = (RemoteObjectInfo)arr[i];
                            if ((info.client_id == con_id || info.client_id == 0) && Math.abs(info.local_id) == elementId) {
                                info.client_id = 0;
                                this.stubInstance.remove(info);
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception ex) {
                    this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, ex, "011104", "receive", 100);
                }
                String identifer = elementId + ":" + con_id;
                this.broker.disposeConnection(identifer);
                break;
            }
            case 16: {
                Message msg = null;
                byte[] mss = new byte[size];
                System.arraycopy(message, off, mss, 0, size);
                msg = new Message(elementId, elementId, -1, mss, size);
                msg.own_id = this.broker.getId();
                SystemDispatchImpl disp = new SystemDispatchImpl(msg, this.broker, this.sessionProcessor.getMessenger());
                if (msg.type == 0) {
                    ThreadSystem threadSystem = this.serviceContext.getCoreContext().getThreadSystem();
                    threadSystem.startThread(disp, true, true);
                    break;
                }
                ((DispatchImpl)disp).run();
                break;
            }
            case 26: {
                Message msg = null;
                byte[] mss = new byte[size];
                System.arraycopy(message, off, mss, 0, size);
                msg = new Message(elementId, elementId, -1, mss, size);
                msg.own_id = this.broker.getId();
                AppDispatchImpl disp = new AppDispatchImpl(msg, this.broker, this.sessionProcessor);
                ThreadSystem threadSystem = this.serviceContext.getCoreContext().getThreadSystem();
                threadSystem.startThread(disp, false, true);
                break;
            }
            case 18: {
                Message msg = null;
                byte[] mss = new byte[size - 8];
                int dispatcherId = Convert.byteArrToInt(message, off);
                int clientId = Convert.byteArrToInt(message, off + 4);
                System.arraycopy(message, off + 8, mss, 0, size - 8);
                msg = new Message(elementId, dispatcherId, clientId, mss, size);
                ServerDispatchImpl sdisp = new ServerDispatchImpl(msg, P4ObjectBroker.init(), this.sessionProcessor, this.sessionProcessor);
                ThreadSystem threadSystem = this.serviceContext.getCoreContext().getThreadSystem();
                threadSystem.startThread(sdisp, false, true);
                break;
            }
        }
    }

    protected String getFactoryPart(String str) {
        int ind = str.indexOf(58);
        if (ind == -1) {
            return str;
        }
        return str.substring(0, ind);
    }

    public MessageAnswer receiveWait(int serverId, int _id, byte[] message, int off, int size) {
        switch (_id) {
            case 1: {
                byte[] id = new byte[4];
                Convert.writeIntToByteArr(id, 0, this.broker.brokerId);
                return new MessageAnswer(id, 0, 4);
            }
            case 14: {
                try {
                    String objName = new String(message, off, size);
                    if (this.broker.initObjects.containsKey(objName)) {
                        byte[] msg = this.broker.getInitialObject(objName);
                        return new MessageAnswer(msg, 0, msg.length);
                    }
                    return new MessageAnswer(new byte[0], 0, 0);
                }
                catch (Exception e) {
                    P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, e, "receiveAnswer", 200);
                    return new MessageAnswer(new byte[0], 0, 0);
                }
            }
            case 19: {
                String msg_ident = new String(message, off, size);
                CrossInterface cctx = (CrossInterface)this.broker.getCrossInterface();
                CrossObjectFactory cof = cctx.getObjectFactory(this.getFactoryPart(msg_ident));
                if (cof != null) {
                    return new MessageAnswer(new byte[]{1});
                }
                return new MessageAnswer(new byte[0]);
            }
        }
        return new MessageAnswer(new byte[0], 0, 0);
    }

    protected void getProfiles(int elementId) {
        try {
            MessageAnswer answer = this.messageContext.sendAndWaitForAnswer(elementId, 1, new byte[0], 0, 0, 100000L);
            this.updateProfiles(elementId, answer.getMessage(), answer.getOffset(), answer.getLength());
        }
        catch (NoListenerOnDestinationException nlode) {
            try {
                Thread.sleep(1000L);
                MessageAnswer answer = this.messageContext.sendAndWaitForAnswer(elementId, 1, new byte[0], 0, 0, 100000L);
                this.updateProfiles(elementId, answer.getMessage(), answer.getOffset(), answer.getLength());
            }
            catch (Exception e) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, e, "getProfiles", 500);
            }
        }
        catch (Exception ex) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, ex, "getProfiles", 500);
        }
    }

    protected void updateProfiles(int id, byte[] answer, int off, int length) {
        Hashtable hashtable = this.availableProfiles;
        synchronized (hashtable) {
            String transportProfile = Convert.byteArrToUString(answer, off, length / 2);
            StringTokenizer tokenizer = new StringTokenizer(transportProfile, ":");
            String hosts = tokenizer.nextToken();
            StringTokenizer hostsTokens = new StringTokenizer(hosts, "@");
            String[] nameHosts = new String[hostsTokens.countTokens()];
            int i = 0;
            while (hostsTokens.hasMoreTokens()) {
                nameHosts[i] = hostsTokens.nextToken();
                ++i;
            }
            while (tokenizer.hasMoreTokens()) {
                String type = tokenizer.nextToken();
                int port = Integer.parseInt(tokenizer.nextToken());
                ConnectionProfile[] newProfile = new ConnectionProfile[nameHosts.length];
                int ii = 0;
                while (ii < nameHosts.length) {
                    newProfile[ii] = new ConnectionProfile(type, nameHosts[ii], port);
                    Enumeration it = this.availableProfiles.elements();
                    boolean contains = false;
                    while (it.hasMoreElements()) {
                        Object o = it.nextElement();
                        if (!o.equals(newProfile[ii])) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(id);
                        buf.append(this.profileCount++);
                        this.availableProfiles.put(buf.toString(), newProfile[ii]);
                    }
                    ++ii;
                }
            }
        }
    }

    protected void prepareConnection(String connType, String host, int port, StubBaseInfo info) throws P4IOException {
        int[] conData = this.getConnection(connType, host, port);
        info.local_id = -1 * conData[0];
        info.client_id = conData[1];
        HashSet hashSet = this.stubInstance;
        synchronized (hashSet) {
            if (!this.stubInstance.contains(info)) {
                this.stubInstance.add(info);
            }
        }
    }

    protected int[] getConnection(String connType, String host, int port) throws P4IOException {
        ClusterElement[] clusterElements = this.clusterContext.getClusterMonitor().getServiceNodes();
        int hostLength = 2 * host.length();
        byte[] request = new byte[8 + hostLength + 2 * connType.length()];
        Convert.writeIntToByteArr(request, 0, port);
        Convert.writeIntToByteArr(request, 4, hostLength);
        Convert.writeUStringToByteArr(request, 8, host);
        Convert.writeUStringToByteArr(request, 8 + hostLength, connType);
        MessageAnswer answer = null;
        int i = 0;
        while (i < clusterElements.length) {
            block10: {
                if (clusterElements[i].getType() == 1 && clusterElements[i].getGroupId() == this.groupId) {
                    try {
                        answer = this.messageContext.sendAndWaitForAnswer(clusterElements[i].getClusterId(), 2, request, 0, request.length, 100000L);
                    }
                    catch (NoListenerOnDestinationException nlode) {
                        try {
                            Thread.sleep(20L);
                            answer = this.messageContext.sendAndWaitForAnswer(clusterElements[i].getClusterId(), 2, request, 0, request.length, 100000L);
                        }
                        catch (Exception e) {
                            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, e, "011106", "getConnection", 100);
                        }
                    }
                    catch (ResponseTimedOutException timeout) {
                        break block10;
                    }
                    catch (Exception ex) {
                        this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, ex, "011106", "getConnection", 100);
                        throw (P4IOException)this.broker.getException(0, P4BaseIOException.Unable_to_Open_Connection, ex);
                    }
                    int[] res = new int[2];
                    res[0] = clusterElements[i].getClusterId();
                    if (answer.getLength() != 4) {
                        if (answer.getLength() > 4) {
                            String exMessage = new String(answer.getMessage(), answer.getOffset(), answer.getLength());
                            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, exMessage, "getConnection", 100);
                            throw (P4IOException)this.broker.getException(0, P4BaseIOException.Unable_to_Open_Connection, null);
                        }
                        throw (P4IOException)this.broker.getException(0, P4BaseIOException.Unable_to_Open_Connection, null);
                    }
                    res[1] = Convert.byteArrToInt(answer.getMessage(), answer.getOffset());
                    return res;
                }
            }
            ++i;
        }
        throw (P4IOException)this.broker.getException(0, P4BaseIOException.Unable_to_Open_Connection, null);
    }

    public void send(int serverId, byte[] toSend, int off, int length) throws P4IOException {
        try {
            this.messageContext.send(serverId, 16, toSend, off, length);
        }
        catch (NoListenerOnDestinationException nlode) {
            try {
                Thread.sleep(20L);
                this.messageContext.send(serverId, 16, toSend, off, length);
            }
            catch (Exception e) {
                throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Couldnt_send_message, e);
            }
        }
        catch (Exception ex) {
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Couldnt_send_message, ex);
        }
    }

    public void send(int serverId, byte[] toSend, int off, int length, boolean isAppThread) throws P4IOException {
        if (!isAppThread) {
            this.send(serverId, toSend, off, length);
        } else {
            try {
                this.messageContext.send(serverId, 26, toSend, off, length);
            }
            catch (NoListenerOnDestinationException nlode) {
                try {
                    Thread.sleep(20L);
                    this.messageContext.send(serverId, 26, toSend, off, length);
                }
                catch (Exception e) {
                    throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Couldnt_send_message, e);
                }
            }
            catch (Exception ex) {
                throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Couldnt_send_message, ex);
            }
        }
    }

    public void elementJoin(ClusterElement element) {
    }

    public void elementStateChanged(ClusterElement element, byte id) {
    }

    public void elementLoss(ClusterElement element) {
        Object object;
        int _elementId = element.getClusterId();
        Call call = null;
        RemoteObjectInfo info = null;
        try {
            Enumeration enumeration = Call.getAllCalls();
            while (enumeration.hasMoreElements()) {
                call = (Call)enumeration.nextElement();
                info = call.getStub().getObjectInfo();
                if (Math.abs(info.local_id) != _elementId) continue;
                object = call;
                synchronized (object) {
                    call.setException(true);
                    call.notifyAll();
                }
                info.client_id = 0;
            }
            object = this.stubInstance;
            synchronized (object) {
                Object[] arr = ((AbstractCollection)this.stubInstance).toArray();
                int i = 0;
                while (i < arr.length) {
                    info = (RemoteObjectInfo)arr[i];
                    if (Math.abs(info.local_id) == _elementId) {
                        info.client_id = 0;
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, ex, "elementLoss", 100);
        }
        object = this.availableProfiles;
        synchronized (object) {
            Enumeration enumeration = this.availableProfiles.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.startsWith(String.valueOf(_elementId))) continue;
                this.availableProfiles.remove(key);
            }
        }
    }

    public void unregister() {
        this.messageContext.unregisterListener();
        this.serviceContext.getServiceState().unregisterClusterEventListener();
    }

    public ConnectionObject[] listConnections() {
        StringTokenizer tok;
        Vector<String> tempData = new Vector<String>();
        ClusterElement[] clusterElements = this.clusterContext.getClusterMonitor().getServiceNodes();
        byte[] request = new byte[]{};
        MessageAnswer answer = null;
        int i = 0;
        while (i < clusterElements.length) {
            if (clusterElements[i].getType() == 1 && clusterElements[i].getAddress().equals(this.clusterContext.getClusterMonitor().getCurrentParticipant().getAddress())) {
                try {
                    answer = this.messageContext.sendAndWaitForAnswer(clusterElements[i].getClusterId(), 4, request, 0, request.length, 100000L);
                    String connections = new String(answer.getMessage(), answer.getOffset(), answer.getLength());
                    StringTokenizer tok2 = new StringTokenizer(connections, "~");
                    while (tok2.hasMoreTokens()) {
                        tempData.add(tok2.nextToken() + ":" + clusterElements[i].getClusterId());
                    }
                }
                catch (NoListenerOnDestinationException nlode) {
                    try {
                        Thread.sleep(20L);
                        answer = this.messageContext.sendAndWaitForAnswer(clusterElements[i].getClusterId(), 4, request, 0, request.length, 100000L);
                        String connections = new String(answer.getMessage(), answer.getOffset(), answer.getLength());
                        tok = new StringTokenizer(connections, "~");
                        while (tok.hasMoreTokens()) {
                            tempData.add(tok.nextToken() + ":" + clusterElements[i].getClusterId());
                        }
                    }
                    catch (Exception e) {
                        this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, e, "listConnections", 100);
                    }
                }
                catch (Exception ex) {
                    this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, ex, "listConnections", 100);
                }
                break;
            }
            ++i;
        }
        ConnectionObject[] result = new ConnectionObject[tempData.size()];
        int ri = 0;
        while (ri < result.length) {
            tok = new StringTokenizer((String)tempData.elementAt(ri), ":");
            String type = tok.nextToken();
            String host = tok.nextToken();
            int port = Integer.parseInt(tok.nextToken());
            int conId = Integer.parseInt(tok.nextToken());
            int dispId = Integer.parseInt(tok.nextToken());
            result[ri] = new ConnectionObject(true, type, host, port, conId, dispId);
            ++ri;
        }
        return result;
    }

    public void serviceStarted(ClusterElement element) {
        if (element.getType() == 1 && this.groupId == element.getGroupId()) {
            try {
                MessageAnswer answer = this.messageContext.sendAndWaitForAnswer(element.getClusterId(), 1, new byte[0], 0, 0, 100000L);
                this.updateProfiles(element.getClusterId(), answer.getMessage(), answer.getOffset(), answer.getLength());
            }
            catch (NoListenerOnDestinationException nlode) {
                try {
                    Thread.sleep(200L);
                    MessageAnswer answer = this.messageContext.sendAndWaitForAnswer(element.getClusterId(), 1, new byte[0], 0, 0, 100000L);
                    this.updateProfiles(element.getClusterId(), answer.getMessage(), answer.getOffset(), answer.getLength());
                }
                catch (Exception e) {
                    this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, e, "011102", "serviceStarted", 500);
                }
            }
            catch (Exception _) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer == null ? (class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer = ClusterOrganizer.class$("com.sap.engine.services.rmi_p4.server.ClusterOrganizer")) : class$com$sap$engine$services$rmi_p4$server$ClusterOrganizer, _, "011102", "serviceStarted", 200);
            }
        }
        ((P4ObjectBrokerServerImpl)this.broker).setHttp(this.getDispatcherHosts(this.clusterContext.getClusterMonitor().getServiceNodes()));
    }

    public void serviceStopped(ClusterElement element) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

