/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.monitor;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.ObjectEntry;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.monitor.ConnectionObject;
import com.sap.engine.services.rmi_p4.monitor.MonitorObject;
import com.sap.engine.services.rmi_p4.monitor.P4Monitor;
import com.sap.engine.services.rmi_p4.monitor.PingCall;
import com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.util.StringTokenizer;

public class P4MonitorServer
extends P4Monitor {
    private byte[] ping_request = new byte[]{0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0};
    P4ObjectBrokerServerImpl homeBroker;

    public P4MonitorServer(P4ObjectBroker broker) {
        this.homeBroker = (P4ObjectBrokerServerImpl)broker;
    }

    public boolean isClient() {
        return this.homeBroker instanceof P4ObjectBrokerServerImpl;
    }

    public boolean isClient2() {
        return P4ObjectBrokerServerImpl.getImplName().startsWith("CLIENT");
    }

    public MonitorObject[] listRemoteObjects() {
        ObjectEntry[] objects = this.homeBroker.objManager.getEntries();
        MonitorObject[] result = new MonitorObject[objects.length];
        int valid = 0;
        int i = 0;
        while (i < objects.length) {
            if (objects[i].isValid()) {
                result[valid] = new MonitorObject();
                P4RemoteObject p4Obj = (P4RemoteObject)((WeakReference)objects[i].reference).get();
                Remote remote = p4Obj.getDelegate();
                Class<?> remoteClass = remote.getClass();
                result[valid].setLinks(objects[i].links);
                result[valid].setNumber(i);
                result[valid].setRemote(remoteClass.toString());
                result[valid].setInterfaces(p4Obj.getObjectInfo().stubs);
                result[valid].setStats(objects[i].connectionStatistics.keySet().toArray());
                ++valid;
            }
            ++i;
        }
        if (valid < objects.length) {
            MonitorObject[] temp = new MonitorObject[valid];
            System.arraycopy(result, 0, temp, 0, temp.length);
            result = temp;
        }
        return result;
    }

    public ConnectionObject[] listConnections() {
        return this.homeBroker.listConnections();
    }

    public String getORBHost() {
        try {
            return this.homeBroker.getHost();
        }
        catch (Exception e) {
            return "localhost";
        }
    }

    public int getORBPort() {
        try {
            return this.homeBroker.getPort();
        }
        catch (Exception e) {
            return 3011;
        }
    }

    public boolean pingConnection(Object obj) {
        ConnectionObject[] cons = this.listConnections();
        StringTokenizer stk = new StringTokenizer((String)obj, ":");
        String type = stk.nextToken();
        String host = stk.nextToken();
        int port = Integer.parseInt(stk.nextToken());
        int conId = Integer.parseInt(stk.nextToken());
        int dispId = Integer.parseInt(stk.nextToken());
        int ic = 0;
        while (ic < cons.length) {
            if (conId == cons[ic].getConId() && dispId == cons[ic].getDispId()) {
                PingCall pingCall = PingCall.getPingCall();
                Convert.writeLongToByteArr(this.ping_request, 6, this.homeBroker.sessionProcessor.getServerId());
                pingCall.writeId(this.ping_request, 14);
                try {
                    this.homeBroker.sessionProcessor.reply(0, dispId, conId, this.ping_request, this.ping_request.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    pingCall.getResult(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            ++ic;
        }
        return false;
    }

    public boolean pingObject(Object obj) {
        return true;
    }
}

