/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.monitor;

import com.sap.engine.services.rmi_p4.Connection;
import com.sap.engine.services.rmi_p4.ObjectEntry;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4ObjectBrokerClientImpl;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.monitor.ConnectionObject;
import com.sap.engine.services.rmi_p4.monitor.MonitorObject;
import com.sap.engine.services.rmi_p4.monitor.P4Monitor;
import com.sap.engine.services.rmi_p4.monitor.PingCall;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.util.StringTokenizer;

public class P4MonitorClient
extends P4Monitor {
    P4ObjectBrokerClientImpl homeBroker;

    public P4MonitorClient(P4ObjectBroker broker) {
        this.homeBroker = (P4ObjectBrokerClientImpl)broker;
    }

    public boolean isClient() {
        return this.homeBroker instanceof P4ObjectBrokerClientImpl;
    }

    public boolean isClient2() {
        return P4ObjectBroker.getImplName().startsWith("CLIENT");
    }

    public MonitorObject[] listRemoteObjects() {
        ObjectEntry[] objects = this.homeBroker.objManager.getEntries();
        MonitorObject[] result = new MonitorObject[objects.length];
        int valid = 0;
        int i = 0;
        while (i < objects.length) {
            if (objects[i].isValid()) {
                result[valid] = new MonitorObject();
                P4RemoteObject p4Obj = (P4RemoteObject)((WeakReference)objects[i].reference).get();
                Remote remote = p4Obj.getDelegate();
                Class<?> remoteClass = remote.getClass();
                result[valid].setLinks(objects[i].links);
                result[valid].setNumber(i);
                result[valid].setRemote(remoteClass.toString());
                result[valid].setInterfaces(p4Obj.getObjectInfo().stubs);
                result[valid].setStats(objects[i].connectionStatistics.keySet().toArray());
                ++valid;
            }
            ++i;
        }
        if (valid < objects.length) {
            MonitorObject[] temp = new MonitorObject[valid];
            System.arraycopy(result, 0, temp, 0, temp.length);
            result = temp;
        }
        return result;
    }

    public ConnectionObject[] listConnections() {
        return this.homeBroker.listConnections();
    }

    public String getORBHost() {
        try {
            return this.homeBroker.getHost();
        }
        catch (Exception e) {
            return "localhost";
        }
    }

    public int getORBPort() {
        try {
            return this.homeBroker.getPort();
        }
        catch (Exception e) {
            return 3011;
        }
    }

    public boolean pingConnection(Object obj) {
        Connection con;
        StringTokenizer stk = new StringTokenizer((String)obj, ":");
        String type = stk.nextToken();
        String host = stk.nextToken();
        int port = Integer.parseInt(stk.nextToken());
        try {
            con = this.homeBroker.manager.takeConnection(type, host, port);
            con.isAlive();
        }
        catch (Exception e) {
            return false;
        }
        PingCall pingCall = PingCall.getPingCall();
        byte[] message = new byte[25];
        pingCall.writeId(message, 14);
        message[22] = 4;
        try {
            con.reply(1111, 1111, message, message.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        try {
            pingCall.getResult(con);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean pingObject(Object obj) {
        return true;
    }
}

