/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.gui;

import com.sap.engine.services.rmi_p4.gui.BrokerView;
import com.sap.engine.services.rmi_p4.monitor.P4MonitorInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PingPanel
extends JPanel
implements Runnable {
    Graphics g;
    int xb;
    int yb;
    int xsb;
    boolean init = false;
    boolean pingFailed = false;
    int failCnt;
    boolean end = false;
    boolean allOk = false;
    boolean ping = false;
    BrokerView visual;

    public PingPanel(BrokerView visual) {
        this.visual = visual;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (!this.ping) {
            return;
        }
        this.g = g;
        g.setColor(Color.white);
        int xl = (int)this.getSize().getWidth();
        int yl = (int)this.getSize().getHeight();
        this.drawPC(20, yl - 50, true);
        this.drawPC(xl - 40, yl - 50, !this.pingFailed);
        g.setColor(Color.darkGray);
        g.drawLine(53, yl - 18, xl - 50, yl - 18);
        this.yb = yl - 20;
        if (!this.init) {
            this.xb = 60;
            this.xsb = 10;
            this.init = true;
        } else if (this.xb < 58) {
            this.xb = 58;
            this.xsb = Math.abs(10);
        } else if (this.xb > xl - 58) {
            this.xb = xl - 58;
            this.xsb = -Math.abs(10);
        }
        if (this.allOk) {
            g.setColor(new Color(0, 200, 0));
            int xt = this.xb;
            if (xt < 58) {
                xt = 58;
            }
            if (xt > xl - 50 - 15) {
                xt = xl - 50 - 15;
            }
            g.drawString("OK !", xt, 20);
            ++this.failCnt;
            if (this.failCnt == 30) {
                this.end = true;
            }
            this.xb += this.xsb;
        } else if (!this.pingFailed) {
            g.setColor(Color.white);
            int xt = this.xb;
            if (xt < 50) {
                xt = 50;
            }
            if (xt > xl - 58 - 35) {
                xt = xl - 58 - 35;
            }
            g.drawString("Checking", xt, 20);
            this.xb += this.xsb;
        } else {
            g.setColor(Color.red);
            int xt = this.xb;
            if (xt < 50) {
                xt = 50;
            }
            if (xt > xl - 58 - 40) {
                xt = xl - 58 - 40;
            }
            g.drawString("Failed ...", xt, 20);
            ++this.failCnt;
            if (this.failCnt == 30) {
                this.end = true;
            }
        }
        g.fillOval(this.xb, this.yb, 5, 5);
    }

    public void ping(P4MonitorInterface monitor, String str) {
        this.ping = true;
        this.init = false;
        this.pingFailed = false;
        this.end = false;
        this.allOk = false;
        try {
            new Thread(this).start();
            new Thread(new Invoker(this, monitor, str)).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void problem() {
        this.pingFailed = true;
        this.failCnt = 0;
    }

    public void success() {
        this.allOk = true;
        this.failCnt = 0;
    }

    private void drawPC(int x, int y, boolean ok) {
        this.g.setColor(Color.black);
        int xm = 25;
        int ym = 23;
        int b = 2;
        this.g.drawRect(x, y, xm, ym);
        this.g.drawRect(x + b, y + b, xm - 2 * b, ym - 2 * b);
        this.g.setColor(Color.darkGray);
        this.g.drawLine(x, y, x + b, y + b);
        this.g.drawLine(x + xm, y, x + xm - b, y + b);
        this.g.drawLine(x + xm, y + ym, x + xm - b, y + ym - b);
        this.g.drawLine(x, y + ym, x + b, y + ym - b);
        this.g.setColor(Color.darkGray);
        this.g.fillRect(x - xm / 3, y + ym + 2, xm + xm / 3 * 2, ym / 2);
        this.g.setColor(Color.white);
        this.g.drawRect(x - xm / 3, y + ym + 2, xm + xm / 3 * 2, ym / 2);
        this.g.setColor(Color.lightGray);
        this.g.fillRect(x - xm / 3 + 5, y + ym + 11, xm + xm / 3 * 2 - 10, 2);
        this.g.drawRect(x - 5, y + ym + 5, 10, 4);
        this.g.drawRect(x + 15, y + ym + 5, 15, 4);
        if (ok) {
            long time = System.currentTimeMillis();
            int it = 1;
            while (it < 300) {
                int xp = x + b + 2 + new Random(time / (long)it).nextInt(xm - 2 * b - 4);
                int yp = y + b + 2 + new Random(time / (long)it).nextInt(ym - 2 * b - 3);
                this.g.setColor(new Color(new Random(it).nextInt(255), new Random(it * 2).nextInt(255), new Random(it * 3).nextInt(255)));
                this.g.drawLine(xp, yp, xp + 1, yp);
                ++it;
            }
        } else {
            this.g.setColor(Color.blue);
            this.g.fillRect(x + b + 1, y + b + 1, xm - 2 * b - 1, ym - 2 * b - 1);
            this.g.setColor(Color.white);
            int li = 0;
            while (li < 7) {
                this.g.drawLine(x + b + 2, y + b + 4 + 2 * li, x + xm - 2 * b, y + b + 4 + 2 * li);
                ++li;
            }
        }
    }

    public void run() {
        while (!this.end) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                continue;
            }
            this.repaint();
        }
        this.ping = false;
        this.repaint();
        this.visual.pingConnectionDone();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        PingPanel pp = new PingPanel(null);
        frame.getContentPane().add(pp);
        ((Component)frame).setSize(260, 100);
        ((Component)frame).setVisible(true);
        pp.ping(null, null);
    }

    protected class Invoker
    implements Runnable {
        P4MonitorInterface monitor;
        PingPanel pp;
        String str;

        public Invoker(PingPanel pp, P4MonitorInterface monitor, String str) {
            this.monitor = monitor;
            this.pp = pp;
            this.str = str;
        }

        public void run() {
            if (this.monitor.pingConnection(this.str)) {
                this.pp.success();
            } else {
                this.pp.problem();
            }
        }
    }
}

