/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.gui;

import com.sap.engine.services.rmi_p4.gui.ConnectionTable;
import com.sap.engine.services.rmi_p4.gui.ObjectTable;
import com.sap.engine.services.rmi_p4.gui.PingPanel;
import com.sap.engine.services.rmi_p4.monitor.ConnectionObject;
import com.sap.engine.services.rmi_p4.monitor.MonitorObject;
import com.sap.engine.services.rmi_p4.monitor.P4MonitorInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BrokerView
extends JPanel
implements ListSelectionListener {
    private P4MonitorInterface monitor;
    private JTable cTable;
    private JTable oTable;
    private JButton pingCon = new JButton("PING");
    private JButton refreshCon = new JButton("REFRESH");
    private JScrollPane conScroll;
    private JScrollPane objScroll;
    private JButton pingObj = new JButton("PING");
    private JButton refreshObj = new JButton("REFRESH");
    private JTextArea objTextArea = new JTextArea("Object info");
    private PingPanel graphPanel;

    public BrokerView(String name, P4MonitorInterface monitor) {
        try {
            this.monitor = monitor;
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), name));
            JTabbedPane jTab = new JTabbedPane();
            JPanel orbInfo = new JPanel();
            orbInfo.setLayout(new BorderLayout());
            orbInfo.add((Component)new JLabel("Host : " + monitor.getORBHost() + "    Port : " + monitor.getORBPort()), "North");
            this.conScroll = new JScrollPane();
            orbInfo.add((Component)this.conScroll, "Center");
            this.refreshConnection();
            JPanel pingConPanel = new JPanel();
            pingConPanel.setLayout(new GridBagLayout());
            this.graphPanel = new PingPanel(this);
            pingConPanel.add((Component)this.graphPanel, new GridBagConstraints(0, 0, 1, 2, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            pingConPanel.add((Component)this.pingCon, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
            pingConPanel.add((Component)this.refreshCon, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.pingCon.addActionListener(new ConPingListener(this));
            this.refreshCon.addActionListener(new ConRefreshListener(this));
            orbInfo.add((Component)pingConPanel, "South");
            this.pingCon.setEnabled(false);
            JPanel objects = new JPanel();
            objects.setLayout(new BorderLayout());
            objects.add((Component)new JLabel("Remote objects"), "North");
            this.objScroll = new JScrollPane();
            objects.add((Component)this.objScroll, "Center");
            this.refreshObject();
            JPanel pingObjPanel = new JPanel();
            pingObjPanel.setPreferredSize(new Dimension(500, 100));
            pingObjPanel.setLayout(new GridBagLayout());
            this.pingObj.addActionListener(new ObjPingListener(this));
            this.pingObj.setEnabled(false);
            this.refreshObj.addActionListener(new ObjRefreshListener(this));
            this.refreshObj.setEnabled(true);
            objects.add((Component)pingObjPanel, "South");
            JScrollPane textScroll = new JScrollPane();
            textScroll.getViewport().add((Component)this.objTextArea, "Center");
            pingObjPanel.add((Component)textScroll, new GridBagConstraints(0, 0, 1, 2, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            pingObjPanel.add((Component)this.pingObj, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
            pingObjPanel.add((Component)this.refreshObj, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.objTextArea.setEditable(false);
            this.objTextArea.setEnabled(false);
            jTab.add("Info", orbInfo);
            jTab.add("Objects", objects);
            this.add((Component)jTab, "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void pingConnection() {
        this.pingCon.setEnabled(false);
        this.refreshCon.setEnabled(false);
        this.graphPanel.ping(this.monitor, ((ConnectionTable)this.cTable.getModel()).getWholeRow(this.cTable.getSelectedRow()));
    }

    protected void pingConnectionDone() {
        this.pingCon.setEnabled(true);
        this.refreshCon.setEnabled(true);
    }

    protected void pingObject() {
    }

    protected void refreshConnection() {
        ConnectionObject[] cons = new ConnectionObject[]{};
        try {
            cons = this.monitor.listConnections();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cons == null) {
            cons = new ConnectionObject[]{};
        }
        ConnectionTable conTable = new ConnectionTable(cons.length);
        int i = 0;
        while (i < cons.length) {
            conTable.addConnection(cons[i].isAlive(), cons[i].getType(), cons[i].getHost(), cons[i].getPort(), cons[i].getConId(), cons[i].getDispId());
            ++i;
        }
        this.cTable = new JTable();
        this.cTable.setModel(conTable);
        this.cTable.getSelectionModel().addListSelectionListener(this);
        this.cTable.getSelectionModel().setSelectionMode(0);
        this.conScroll.getViewport().add(this.cTable);
        this.valueChanged(null);
    }

    protected void refreshObject() {
        MonitorObject[] remotes = new MonitorObject[]{};
        try {
            remotes = this.monitor.listRemoteObjects();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        ObjectTable objTable = new ObjectTable(remotes.length);
        int i = 0;
        while (i < remotes.length) {
            objTable.addConnection(remotes[i].getNumber(), remotes[i].getRemote(), remotes[i].getLinks(), remotes[i].getInterfaces(), remotes[i].getStats());
            ++i;
        }
        this.oTable = new JTable();
        this.oTable.setModel(objTable);
        this.objScroll.getViewport().add(this.oTable);
        this.oTable.getSelectionModel().addListSelectionListener(this);
        this.oTable.getSelectionModel().setSelectionMode(0);
        this.valueChanged(null);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.cTable.getSelectedRow() != -1) {
            this.pingCon.setEnabled(true);
        } else {
            this.pingCon.setEnabled(false);
        }
        if (this.oTable == null) {
            return;
        }
        if (this.oTable.getSelectedRow() != -1) {
            this.pingObj.setEnabled(true);
            this.objTextArea.setEnabled(true);
            ObjectTable myTable = (ObjectTable)this.oTable.getModel();
            String text = "Package : " + myTable.getObjPackage(this.oTable.getSelectedRow()) + "\n";
            text = text + "Interfaces: \n";
            String[] ins = myTable.getObjInterfaces(this.oTable.getSelectedRow());
            int ii = 0;
            while (ii < ins.length) {
                text = text + "  " + ins[ii] + ";\n";
                ++ii;
            }
            text = text + "Stats: \n";
            Object[] sts = myTable.getObjStats(this.oTable.getSelectedRow());
            int si = 0;
            while (si < sts.length) {
                text = text + "  " + sts[si] + ";\n";
                ++si;
            }
            this.objTextArea.setText(text);
        } else {
            this.pingObj.setEnabled(false);
            this.objTextArea.setEnabled(false);
            this.objTextArea.setText("Object info");
        }
    }

    public class ConRefreshListener
    implements ActionListener {
        BrokerView main;

        public ConRefreshListener(BrokerView main) {
            this.main = main;
        }

        public void actionPerformed(ActionEvent e) {
            BrokerView.this.graphPanel.problem();
            BrokerView.this.refreshConnection();
        }
    }

    public class ObjRefreshListener
    implements ActionListener {
        BrokerView main;

        public ObjRefreshListener(BrokerView main) {
            this.main = main;
        }

        public void actionPerformed(ActionEvent e) {
            BrokerView.this.refreshObject();
        }
    }

    public class ObjPingListener
    implements ActionListener {
        BrokerView main;

        public ObjPingListener(BrokerView main) {
            this.main = main;
        }

        public void actionPerformed(ActionEvent e) {
            BrokerView.this.pingObject();
        }
    }

    public class ConPingListener
    implements ActionListener {
        BrokerView main;

        public ConPingListener(BrokerView main) {
            this.main = main;
        }

        public void actionPerformed(ActionEvent e) {
            BrokerView.this.pingConnection();
        }
    }
}

