/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.dispatcher;

import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.ClusterContext;
import com.sap.engine.frame.cluster.session.CommunicationSessionContext;
import com.sap.engine.frame.cluster.transport.TransportEventListener;
import com.sap.engine.frame.container.CommunicationContainerContext;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.all.ConnectionProfile;
import com.sap.engine.services.rmi_p4.dispatcher.P4ServiceFrame;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class TransportMonitor
implements TransportEventListener {
    public static final int DEFAULT_PORT = 3011;
    public static final String PORT_PROPERTY = "port";
    public static final String NI_PORT_PROPERTY = "ni";
    public static final String NI_COMMUNICATION_LAYER = "SAPRouter";
    public static final String DEFAULT_PROPERTY_DELIMITERS = ":";
    public static final String DEFAULT_PROFILE_DELIMITER = "@";
    public static final String DEFAULT_COMMUNICATION_LAYER = "None";
    public static final String ALL_TRANSPORTS_PROPERTY = "allTransports";
    public static final String HOST_TO_BIND_PROPERTY = "bindHost";
    public static final String MAX_REQUEST_SIZE = "MaxRequestSize";
    public static final String GENERAL_FOR_ALLHOST = "0.0.0.0";
    public static final String INITIALIZE_CONNECTION_TIMEOUT = "InitializeConnectionTimeout";
    public static final String SEND_IN_QUEUE_TIMEOUT = "sendInQueueTimeout";
    private int sendInQueueTimeout = 1000;
    private int initializationTimeout = 1000;
    private int defaultReqSize;
    private int maxRequestSize = this.defaultReqSize = 0x1000000;
    private String host = "";
    private String nameHost = "";
    protected int listenerPort;
    protected int ni_listener_port;
    private int groupId;
    private CommunicationContainerContext ccc = null;
    private CommunicationSessionContext sessionContext;
    private ClusterContext clusterContext;
    private Hashtable suppliers = null;
    private Hashtable availableTransports = new Hashtable();
    private StringBuffer transportProfiles;
    private Properties sp = null;
    private boolean isGenHost = false;
    private P4ServiceFrame frame = null;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor;

    public TransportMonitor(P4ServiceFrame frame, Hashtable suppliers) {
        this.frame = frame;
        this.ccc = frame.serviceContext.getContainerContext();
        this.suppliers = suppliers;
        this.sessionContext = frame.serviceContext.getClusterContext().getCommunicationSessionContext();
        this.clusterContext = frame.serviceContext.getClusterContext();
        this.groupId = this.clusterContext.getClusterMonitor().getCurrentParticipant().getGroupId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransportMonitor(P4ServiceFrame frame, Properties sp) throws ServiceException {
        this(frame, new Hashtable());
        this.sp = sp;
        String bindHost = sp.getProperty(HOST_TO_BIND_PROPERTY);
        if (bindHost != null && bindHost.indexOf(GENERAL_FOR_ALLHOST) != -1) {
            this.isGenHost = true;
        }
        if (bindHost == null || bindHost.trim().length() == 0 || this.isGenHost) {
            InetAddress[] multi = null;
            try {
                bindHost = this.host = InetAddress.getLocalHost().getHostAddress();
                this.nameHost = InetAddress.getByName(this.host).getHostName();
                multi = InetAddress.getAllByName(this.nameHost);
            }
            catch (UnknownHostException unknownHost) {
                try {
                    bindHost = this.host = InetAddress.getByName("127.0.0.1").getHostAddress();
                    this.nameHost = InetAddress.getByName(this.host).getHostName();
                    multi = InetAddress.getAllByName(this.nameHost);
                }
                catch (UnknownHostException unHost) {
                    P4ServiceFrame.logErr("ID 011061: P4 service: Error in geting local host address.");
                }
            }
            String host0 = "";
            int i = 0;
            while (i < multi.length) {
                host0 = host0 + multi[i].getHostAddress() + DEFAULT_PROFILE_DELIMITER;
                ++i;
            }
            this.transportProfiles = new StringBuffer(host0);
        }
        String port = sp.getProperty(PORT_PROPERTY, Integer.toString(3011));
        try {
            this.ni_listener_port = this.listenerPort = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            Class clazz;
            P4ServiceFrame.logErr((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor : Incorect port value: \"port\" in property file.");
            StringBuffer stringBuffer = new StringBuffer().append(nfe.getMessage()).append("\n");
            if (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null) {
                clazz = class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor");
                throw new ServiceException(stringBuffer.append(clazz.getName()).append(" constructor : Incorect port value: \"port\" in property file").toString());
            }
            clazz = class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor;
            throw new ServiceException(stringBuffer.append(clazz.getName()).append(" constructor : Incorect port value: \"port\" in property file").toString());
        }
        try {
            this.initializationTimeout = Integer.parseInt(sp.getProperty(INITIALIZE_CONNECTION_TIMEOUT, "1000"));
            if (this.initializationTimeout < 0) {
                P4ServiceFrame.logWarning((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor : Incorect timeout value: \"InitializeConnectionTimeout\"=" + this.initializationTimeout + " in property file. Using default 1000");
                this.initializationTimeout = 1000;
            }
        }
        catch (Exception e) {
            P4ServiceFrame.logWarning((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor : Incorect timeout value: \"InitializeConnectionTimeout\" in property file. Using default 1000");
            this.initializationTimeout = 1000;
        }
        try {
            this.sendInQueueTimeout = Integer.parseInt(sp.getProperty(SEND_IN_QUEUE_TIMEOUT, "1000"));
            if (this.sendInQueueTimeout < 0) {
                P4ServiceFrame.logWarning((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor : Incorect timeout value: \"sendInQueueTimeout\"=" + this.sendInQueueTimeout + " in property file");
                this.sendInQueueTimeout = 1000;
            }
        }
        catch (Exception e) {
            P4ServiceFrame.logWarning((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor : Incorect timeout value: \"sendInQueueTimeout\" in property file. Using default 1000");
            this.sendInQueueTimeout = 1000;
        }
        String maxS = sp.getProperty(MAX_REQUEST_SIZE);
        int power = 0;
        if (maxS != null) {
            int n = maxS.toUpperCase().endsWith("M") ? 20 : (power = maxS.toUpperCase().endsWith("K") ? 10 : 0);
            if (power != 0) {
                try {
                    int p = Integer.parseInt(maxS.substring(0, maxS.length() - 1));
                    this.maxRequestSize = p * (int)Math.pow(2.0, power);
                }
                catch (Exception nfe) {
                    System.out.println((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor :  Cannot parse MaxRequestSize property correctly -> maxRequestSize is set : " + maxS);
                }
            } else {
                System.out.println((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor :  Cannot parse MaxRequestSize property correctly -> maxRequestSize is set : " + maxS + ". Set M for Mb or K for Kb.");
            }
        }
        this.listenerPort = this.listenerPort == 0 ? 3011 : this.listenerPort;
        try {
            StringTokenizer st = null;
            st = bindHost == null || bindHost.trim().length() == 0 || this.isGenHost ? new StringTokenizer(this.transportProfiles.toString(), DEFAULT_PROFILE_DELIMITER) : new StringTokenizer(bindHost, DEFAULT_PROPERTY_DELIMITERS);
            String host1 = "";
            if (this.isGenHost) {
                this.sessionContext.openServerSocket(GENERAL_FOR_ALLHOST, this.listenerPort, "", 512, 1);
            }
            while (true) {
                if (!st.hasMoreTokens()) {
                    this.transportProfiles = new StringBuffer(host1);
                    break;
                }
                String tempHost = st.nextToken();
                if (!this.isGenHost) {
                    this.sessionContext.openServerSocket(tempHost, this.listenerPort, "", 512, 1);
                }
                frame.putLogonInfo(this.listenerPort, true);
                host1 = host1 + tempHost + DEFAULT_PROFILE_DELIMITER;
            }
        }
        catch (Exception io) {
            Class clazz;
            P4ServiceFrame.logInfo((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor :  can't open  server socket");
            StringBuffer stringBuffer = new StringBuffer().append(io.getMessage()).append("\n");
            if (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null) {
                clazz = class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor");
                throw new ServiceException(stringBuffer.append(clazz.getName()).append(" constructor : can't open  server socket.").toString());
            }
            clazz = class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor;
            throw new ServiceException(stringBuffer.append(clazz.getName()).append(" constructor : can't open  server socket.").toString());
        }
        this.availableTransports.put(new Integer(this.listenerPort), DEFAULT_COMMUNICATION_LAYER);
        this.transportProfiles.append(DEFAULT_PROPERTY_DELIMITERS);
        this.transportProfiles.append(DEFAULT_COMMUNICATION_LAYER);
        this.transportProfiles.append(DEFAULT_PROPERTY_DELIMITERS);
        this.transportProfiles.append(this.listenerPort);
        this.transportProfiles.append(DEFAULT_PROPERTY_DELIMITERS);
        this.transportProfiles.append(NI_COMMUNICATION_LAYER);
        this.transportProfiles.append(DEFAULT_PROPERTY_DELIMITERS);
        this.transportProfiles.append(this.ni_listener_port);
        HashSet<ConnectionProfile> tempSet = new HashSet<ConnectionProfile>();
        tempSet.add(new ConnectionProfile(DEFAULT_COMMUNICATION_LAYER, this.host, this.listenerPort));
        tempSet.add(new ConnectionProfile(NI_COMMUNICATION_LAYER, this.host, this.ni_listener_port));
        port = null;
        String transports = sp.getProperty(ALL_TRANSPORTS_PROPERTY);
        if (transports == null) return;
        StringTokenizer tokenizer = new StringTokenizer(transports, DEFAULT_PROPERTY_DELIMITERS);
        int _port = 0;
        TransportMonitor transportMonitor = this;
        synchronized (transportMonitor) {
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken();
                port = sp.getProperty(nextToken);
                try {
                    _port = Integer.parseInt(port);
                }
                catch (NumberFormatException nfe) {
                    P4ServiceFrame.logInfo((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor") : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor :  Incorect port value: \"" + nextToken + "\" in property file.");
                    continue;
                }
                this.suppliers.put(nextToken, port);
                TransportMonitor transportMonitor2 = this;
                synchronized (transportMonitor2) {
                    int state = -1;
                    try {
                        int i = 0;
                        i = nextToken.indexOf("/");
                        if (i > 0) {
                            String ss = nextToken.substring(0, i);
                            state = this.ccc.getSystemMonitor().getService(ss).getStartupState();
                        } else {
                            state = this.ccc.getSystemMonitor().getService(nextToken).getStartupState();
                        }
                    }
                    catch (Exception _) {
                        continue;
                    }
                    if (state == 11) {
                        try {
                            this.sessionContext.openServerSocket(_port, nextToken);
                            tempSet.add(new ConnectionProfile(nextToken, this.host, _port));
                            this.availableTransports.put(new Integer(_port), nextToken);
                            this.transportProfiles.append(DEFAULT_PROPERTY_DELIMITERS);
                            this.transportProfiles.append(nextToken);
                            this.transportProfiles.append(DEFAULT_PROPERTY_DELIMITERS);
                            this.transportProfiles.append(port);
                            P4ServiceFrame.logInfo((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor") : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor : Service " + nextToken + " opened server socket on " + port);
                        }
                        catch (Exception e) {
                            P4ServiceFrame.logErr((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor") : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + " constructor : Service " + nextToken + " cannot open server socket on " + port);
                        }
                    }
                }
            }
            return;
        }
    }

    public String getHost() {
        return this.host;
    }

    public Hashtable getRefereceToAvailableTransports() {
        return this.availableTransports;
    }

    public String getAllProfiles() {
        return this.transportProfiles.toString();
    }

    public synchronized void transportSupplierAdded(String supplierName) {
        if (this.suppliers.containsKey(supplierName)) {
            int port = 0;
            try {
                port = Integer.parseInt((String)this.suppliers.get(supplierName));
            }
            catch (Exception ex) {
                P4ServiceFrame.logInfo(ex.getMessage() + "\nID 011016: <Rmi_P4 Service>: Incorect port value: \"" + supplierName + "\" in property file.");
                return;
            }
            int bothPort = 0;
            String httpsPort = null;
            int sslState = -1;
            int tunnelState = -1;
            tunnelState = this.ccc.getSystemMonitor().getService("httptunneling").getStartupState();
            sslState = this.ccc.getSystemMonitor().getService("ssl").getStartupState();
            if (this.sp != null && tunnelState == 11 && sslState == 11) {
                block16: {
                    try {
                        httpsPort = this.sp.getProperty("https");
                        bothPort = Integer.parseInt(httpsPort);
                    }
                    catch (NumberFormatException ex) {
                        bothPort = Integer.parseInt(this.sp.getProperty(httpsPort));
                    }
                    bothPort = bothPort > 0 ? bothPort : 3093;
                    try {
                        if (supplierName.equalsIgnoreCase("httptunneling")) {
                            this.sessionContext.openServerSocket(port, "httptunneling");
                            break block16;
                        }
                        try {
                            httpsPort = this.sp.getProperty("https");
                            bothPort = Integer.parseInt(httpsPort);
                        }
                        catch (NumberFormatException ex) {
                            bothPort = Integer.parseInt(this.sp.getProperty(httpsPort));
                        }
                        bothPort = bothPort > 0 ? bothPort : 3093;
                        this.sessionContext.openServerSocket(bothPort, "https");
                    }
                    catch (IOException e) {
                        P4ServiceFrame.logErr(e.getMessage() + "\nID 011021: <Rmi_P4 Service>: Can't open: \"ssl/httptunneling\" port:" + bothPort);
                    }
                }
                this.transportProfiles.append(":https:" + bothPort);
                this.sendProfileAvailable(this.host + ":https:" + bothPort);
                P4ServiceFrame.logInfo("Service https opened server socket on " + bothPort);
            }
            if (port != 0) {
                try {
                    this.sessionContext.openServerSocket(port, supplierName);
                    StringBuffer transport = new StringBuffer();
                    transport.append(DEFAULT_PROPERTY_DELIMITERS);
                    transport.append(supplierName);
                    transport.append(DEFAULT_PROPERTY_DELIMITERS);
                    transport.append(port);
                    this.transportProfiles.append(transport.toString());
                    this.sendProfileAvailable(transport.insert(0, this.host).toString());
                    P4ServiceFrame.logInfo("Service " + supplierName + " opened server socket on " + port);
                }
                catch (Exception ioex) {
                    P4ServiceFrame.logErr(ioex.getMessage() + "\nID 011017: <Rmi_P4 Service>: Can't open: \"" + supplierName + "\" port:" + port);
                }
            }
        } else if (P4ServiceFrame.location != null) {
            P4ServiceFrame.location.debugT((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + ".transportSupplierAdded(String supplierName) just for info : " + supplierName + " -> isn't contained in the p4 supports.");
        }
    }

    public void transportSupplierRemoved(String supplierName) {
        int bothPort = 0;
        if (supplierName.equals("ssl") || supplierName.equals("httptunneling")) {
            try {
                bothPort = Integer.parseInt((String)this.suppliers.get("https"));
                this.sessionContext.closeServerSocket(bothPort);
                P4ServiceFrame.logInfo((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + ".transportSupplierRemoved(String supplierName) https closed server socker on " + bothPort);
            }
            catch (NumberFormatException e) {
                P4ServiceFrame.logInfo((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + ".transportSupplierRemoved(String supplierName) https can't closed server socker on " + bothPort);
            }
        }
        int port = 0;
        try {
            port = Integer.parseInt((String)this.suppliers.get(supplierName));
        }
        catch (Exception ex) {
            P4ServiceFrame.logInfo(ex.getMessage() + "\n" + (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + ".transportSupplierRemoved(String supplierName) Incorect port value: \"" + supplierName + "\" in property file.");
            return;
        }
        if (port != 0) {
            try {
                this.sessionContext.closeServerSocket(port);
                P4ServiceFrame.logInfo((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + ".transportSupplierRemoved(String supplierName)Service " + supplierName + " closed server socket on " + port);
            }
            catch (Exception e) {
                P4ServiceFrame.logInfo((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + ".transportSupplierRemoved(String supplierName)Service " + supplierName + " cannot close server socket on " + port);
            }
        }
    }

    public void transportLayerDamaged(String queueDescription) {
    }

    public void transportLayerRecovered(String queueDescription) {
    }

    protected void sendProfileAvailable(String profile) {
        int len = 2 * profile.length();
        byte[] arr = new byte[len];
        Convert.writeUStringToByteArr(arr, 0, profile);
        byte nodeType = -1;
        try {
            this.clusterContext.getMessageContext().send(-1, nodeType, 6, arr, 0, len);
        }
        catch (Exception ex) {
            P4ServiceFrame.logInfo((class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor == null ? (class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor = TransportMonitor.class$("com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor")) : class$com$sap$engine$services$rmi_p4$dispatcher$TransportMonitor).getName() + ".sendProfileAvailable(String profile) " + ex.getMessage());
        }
    }

    public synchronized boolean checkForLockal(String type, String host, int port) {
        if (this.host.equals("") || this.host.equals(GENERAL_FOR_ALLHOST)) {
            try {
                this.host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        if (type.equals("") || type.equals(NI_COMMUNICATION_LAYER)) {
            type = DEFAULT_COMMUNICATION_LAYER;
        }
        try {
            host = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (host.equals(this.host)) {
            String suppType = (String)this.availableTransports.get(new Integer(port));
            return suppType != null ? suppType.equals(type) : false;
        }
        return false;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public int getInitializationTimeout() {
        return this.initializationTimeout;
    }

    public int getSendInQueueTimeout() {
        return this.sendInQueueTimeout;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

