/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.dispatcher;

import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.CommunicationClusterContext;
import com.sap.engine.frame.cluster.balance.ApplicationDestination;
import com.sap.engine.frame.cluster.balance.Destination;
import com.sap.engine.frame.cluster.balance.Loadbalance;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.cluster.session.ApplicationConnection;
import com.sap.engine.frame.cluster.session.ClientConnection;
import com.sap.engine.frame.cluster.session.CommunicationSessionContext;
import com.sap.engine.frame.cluster.session.CommunicationSessionProcessor;
import com.sap.engine.frame.cluster.session.Connection;
import com.sap.engine.frame.cluster.session.ConnectionMonitor;
import com.sap.engine.frame.cluster.session.Data;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.dispatcher.CallIdentificator;
import com.sap.engine.services.rmi_p4.dispatcher.P4ConnectionMetaData;
import com.sap.engine.services.rmi_p4.dispatcher.P4ServiceFrame;
import com.sap.engine.services.rmi_p4.exception.P4ResourceAccessor;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.WeakHashMap;

public class P4SessionProcessor
implements CommunicationSessionProcessor {
    public static final String DEFAULT_SEPARATOR = ":";
    int sendInQueueTimeout = 0;
    private MessageContext messageContext;
    private CommunicationSessionContext sessionContext;
    private CommunicationClusterContext clusterContext;
    private Loadbalance loadBalanceContext;
    private ClientConnection clientConnection = null;
    private ClusterMonitor clusterMonitor;
    protected static byte[] MAGIC = new byte[]{35, 112, 35, 52};
    protected static byte[] VERSION = new byte[]{118, 49};
    private Hashtable listenerPorts;
    protected Hashtable connections = new Hashtable();
    private WeakHashMap storedConnections = new WeakHashMap();
    private int consumerID = -1;
    private int maxRequestSize = 0x1000000;
    private int initializationTimeout = 1000;
    private byte[] release_reply = new byte[]{0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0};
    private byte[] ping_reply = new byte[]{0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0};

    public P4SessionProcessor(CommunicationServiceContext _baseContext) {
        this.clusterMonitor = _baseContext.getClusterContext().getClusterMonitor();
        this.clusterContext = _baseContext.getClusterContext();
        this.sessionContext = this.clusterContext.getCommunicationSessionContext();
        this.messageContext = this.clusterContext.getMessageContext();
        this.loadBalanceContext = this.clusterContext.getLoadbalanceContext();
        this.consumerID = this.loadBalanceContext.registerConsumer("p4", this.initializeDestination(), "p4");
    }

    protected void postInit(String _host, Hashtable _listenerPorts) {
        this.listenerPorts = _listenerPorts;
    }

    private Destination initializeDestination() {
        ClusterElement[] elements = this.clusterMonitor.getServiceNodes();
        int[] ids = new int[elements.length];
        int ii = 0;
        while (ii < elements.length) {
            ids[ii] = elements[ii].getClusterId();
            ++ii;
        }
        return new ApplicationDestination(ids);
    }

    protected void stopProcessor() {
        this.loadBalanceContext.unregisterConsumer(this.consumerID);
    }

    public synchronized int getConnection(String type, String host, int port) throws IOException {
        int conId = this.getExistentConnection(type, host, port, DEFAULT_SEPARATOR);
        conId = conId < 0 ? this.getExistentConnection(type, host, port, "") : conId;
        type = type.equals("None") ? "" : type;
        return conId < 0 ? this.sessionContext.openSocket(host, port, type) : conId;
    }

    private int getExistentConnection(String type, String host, int port, String separator) {
        StringBuffer _id = new StringBuffer(type);
        _id.append(separator);
        _id.append(host);
        _id.append(separator);
        _id.append(port);
        String id = _id.toString();
        Integer conID = (Integer)this.connections.get(id);
        if (conID != null) {
            return conID;
        }
        return -1;
    }

    public void putConnection() {
    }

    public void initialize(Connection c, ConnectionMonitor monitor) {
        P4ConnectionMetaData metaData = new P4ConnectionMetaData();
        P4SessionProcessor p4SessionProcessor = this;
        synchronized (p4SessionProcessor) {
            if (!((AbstractMap)this.storedConnections).containsValue(c)) {
                this.storedConnections.put(metaData, c);
            }
        }
        int port = monitor.getSocket().getLocalPort();
        String host = monitor.getSocket().getLocalAddress().getHostAddress();
        String type = (String)this.listenerPorts.get(new Integer(port));
        if (type == null || type.equals("")) {
            type = "None";
        }
        StringBuffer _id = new StringBuffer(type);
        _id.append(DEFAULT_SEPARATOR);
        _id.append(host);
        _id.append(DEFAULT_SEPARATOR);
        _id.append(port);
        String id = _id.toString();
        OutputStream out = monitor.getOutputStream();
        InputStream in = monitor.getInputStream();
        try {
            int defaultTimeout = monitor.getSocket().getSoTimeout();
            monitor.getSocket().setSoTimeout(this.initializationTimeout);
            out.write(VERSION);
            out.write((byte)id.length() + 4);
            out.write(MAGIC);
            out.write(id.getBytes());
            int b = 2;
            byte[] body = null;
            int i = 0;
            while (i < 2) {
                int count = 0;
                body = new byte[b];
                int read = 0;
                while (count != b) {
                    read = in.read(body, count, b - count);
                    if (read == -1) {
                        c.closeConnection();
                        return;
                    }
                    count += read;
                }
                switch (i) {
                    case 0: {
                        if (body[0] != VERSION[0] || body[1] != VERSION[1]) {
                            c.closeConnection();
                            return;
                        }
                        b = (byte)in.read();
                        if (b != -1) break;
                        c.closeConnection();
                        break;
                    }
                    case 1: {
                        if (body[0] == 35 && body[1] == 112 && body[2] == 35 && body[3] == 52) break;
                        c.closeConnection();
                        return;
                    }
                }
                ++i;
            }
            monitor.getSocket().setSoTimeout(defaultTimeout);
            this.connections.put(new String(body, 4, body.length - 4), new Integer(c.getConnectionId()));
        }
        catch (Exception ex) {
            P4ServiceFrame.logThrowable(ex);
            try {
                c.closeConnection();
                return;
            }
            catch (Exception e) {
                P4ServiceFrame.logErr("ID 011007: " + e.getMessage());
            }
        }
        c.setPrivateData(metaData);
        c.setPackSize(14);
    }

    protected void releaseCalls(int clusterId) {
        Iterator iter = ((AbstractMap)this.storedConnections).values().iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            P4ConnectionMetaData metaData = (P4ConnectionMetaData)con.getPrivateData();
            Enumeration enumCall = metaData.callIds.keys();
            while (enumCall.hasMoreElements()) {
                CallIdentificator callId = (CallIdentificator)enumCall.nextElement();
                if (metaData.callIds.get(callId) != clusterId) continue;
                Convert.writeLongToByteArr(this.release_reply, 14, callId.getCallId());
                Convert.writeIntToByteArr(this.release_reply, 6, callId.getClusterId());
                this.clientConnection.send(con, this.release_reply, 0, 30);
                metaData.callIds.remove(callId);
            }
        }
    }

    public boolean memoryWarning(Connection cc, ApplicationConnection application, ClientConnection client, boolean forced) {
        return false;
    }

    public void parseRequest(Connection c, ApplicationConnection app, ClientConnection client) {
        block24: {
            if (this.clientConnection == null) {
                this.clientConnection = client;
            }
            P4ConnectionMetaData info = (P4ConnectionMetaData)c.getPrivateData();
            Data d = c.getRequestData();
            if (!info.newSession) {
                try {
                    int msgTypePos = 22;
                    switch (d.getBytes()[msgTypePos]) {
                        case 4: {
                            long callIdp = Convert.byteArrToLong(d.getBytes(), 14);
                            Convert.writeLongToByteArr(this.ping_reply, 14, callIdp);
                            client.send(c, this.ping_reply, 0, this.ping_reply.length);
                            c.nullData();
                            c.setPackSize(14);
                            info.newSession = true;
                            info.header.server_id = -1;
                            Object var15_11 = null;
                            c.setPackSize(14);
                            info.newSession = true;
                            info.header.server_id = -1;
                            return;
                        }
                        case 0: 
                        case 10: {
                            long callId = Convert.byteArrToLong(d.getBytes(), 14);
                            int senderId = Convert.byteArrToInt(d.getBytes(), 10);
                            CallIdentificator callIdent = new CallIdentificator(callId, senderId);
                            try {
                                this.sendRequestToServer(app, c, callIdent);
                            }
                            catch (ClusterException clEx) {
                                P4ServiceFrame.logInfo("Cannot send request to the server and try to find other element to redirect request");
                                this.redirectRequest(app, c, callIdent);
                            }
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 11: 
                        case 31: {
                            try {
                                app.sendInQueue(c, this.sendInQueueTimeout);
                            }
                            catch (ClusterException cex) {
                                P4ServiceFrame.logThrowable((Throwable)((Object)cex));
                                P4ServiceFrame.logWarning("Error while sending replay with type=" + d.getBytes()[msgTypePos] + ". Can be caused by a broken communication with the server.");
                                c.nullData();
                            }
                            break;
                        }
                        default: {
                            try {
                                app.send(c);
                                break;
                            }
                            catch (Exception ee) {
                                c.nullData();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var15_13 = null;
                    c.setPackSize(14);
                    info.newSession = true;
                    info.header.server_id = -1;
                    throw throwable;
                }
                Object var15_12 = null;
                c.setPackSize(14);
                info.newSession = true;
                info.header.server_id = -1;
                {
                    break block24;
                }
            }
            info.header.loadFromByteArray(c.getRequestData().getBytes());
            if (info.header.size < 0 || info.header.size > this.maxRequestSize) {
                try {
                    ((ConnectionMonitor)((Object)c)).getOutputStream().write(-1);
                }
                catch (IOException e) {
                    Location location = P4ResourceAccessor.location;
                    location.logT(300, "There is a problem with writing a message to client when tha max Request Size is out of range!!!");
                }
                c.closeConnection();
            }
            try {
                if (info.header.size == 0) {
                    c.closeConnection();
                    return;
                }
                if (info.header.server_id < 0) {
                    c.setDestinationId(this.loadBalanceContext.getLessBusyElement(this.consumerID));
                    if (c.getDestinationId() == -1) {
                        c.closeConnection();
                    }
                } else {
                    c.setDestinationId(info.header.server_id);
                }
                c.setPackSize(info.header.size);
            }
            catch (Exception oomer) {
                P4ServiceFrame.logErr("ID 011008: " + oomer.getMessage());
                c.closeConnection();
            }
            info.newSession = false;
        }
    }

    public void sendRequestToServer(ApplicationConnection app, Connection c, CallIdentificator callIdent) throws ClusterException {
        P4ConnectionMetaData info = (P4ConnectionMetaData)c.getPrivateData();
        info.callIds.put(callIdent, c.getDestinationId());
        try {
            app.send(c);
        }
        catch (ClusterException e) {
            P4ServiceFrame.logInfo("Cannot send request to specified cluster element");
            info.callIds.remove(callIdent);
            throw e;
        }
    }

    public void redirectRequest(ApplicationConnection app, Connection c, CallIdentificator callIdent) {
        P4ConnectionMetaData info = (P4ConnectionMetaData)c.getPrivateData();
        if (info.redirectTo == -1) {
            this.findFreeServer(app, c, callIdent, info);
            return;
        }
        c.setDestinationId(info.redirectTo);
        callIdent.setClusterId(info.redirectTo);
        try {
            this.sendRequestToServer(app, c, callIdent);
        }
        catch (ClusterException cl) {
            P4ServiceFrame.logInfo(" Cannot send request to this server that set as redirect element. Try to find working cluster element for redirect");
            this.findFreeServer(app, c, callIdent, info);
        }
    }

    public void findFreeServer(ApplicationConnection app, Connection c, CallIdentificator callIdent, P4ConnectionMetaData info) {
        int redirectId = this.loadBalanceContext.getLessBusyElement(this.consumerID);
        while (redirectId != -1) {
            c.setDestinationId(redirectId);
            info.redirectTo = redirectId;
            callIdent.setClusterId(redirectId);
            try {
                this.sendRequestToServer(app, c, callIdent);
                return;
            }
            catch (ClusterException e) {
                P4ServiceFrame.logInfo("Cannot send request to server with Id : " + redirectId + ".");
                int oldId = redirectId;
                redirectId = this.loadBalanceContext.getLessBusyElement(this.consumerID);
                if (redirectId == oldId) break;
            }
        }
        P4ServiceFrame.logErr("Cannot find a working cluster element");
        c.closeConnection();
    }

    public void parseReply(Connection c, ApplicationConnection app, ClientConnection client) {
        byte[] toSend = null;
        Data data = null;
        while ((data = c.getReplyData()) != null) {
            try {
                toSend = data.getBytes();
                int size = data.getLength() - 14;
                Convert.writeIntToByteArr(toSend, data.getOffset() + 2, size);
                client.send(c, toSend, data.getOffset(), data.getLength());
                P4ConnectionMetaData info = (P4ConnectionMetaData)c.getPrivateData();
                long callId = Convert.byteArrToLong(data.getBytes(), data.getOffset() + 14);
                int serverId = Convert.byteArrToInt(data.getBytes(), data.getOffset() + 14 - 8);
                CallIdentificator callIdent = new CallIdentificator(callId, serverId);
                try {
                    info.callIds.remove(callIdent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    P4ServiceFrame.logErr("ID 011009:Error removing callId - " + e.toString());
                }
            }
            catch (Exception _) {
                _.printStackTrace();
                P4ServiceFrame.logErr("ID 011010: " + _.getMessage());
            }
        }
    }

    public void fail(Connection c, ConnectionMonitor conMon) {
        block3: {
            this.storedConnections.remove(c.getPrivateData());
            Enumeration enumeration = this.connections.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Integer conId = (Integer)this.connections.get(key);
                if (conId.intValue() != c.getConnectionId()) continue;
                this.connections.remove(key);
            }
            byte[] update_connection = new byte[4];
            Convert.writeIntToByteArr(update_connection, 0, c.getConnectionId());
            try {
                this.messageContext.send(0, (byte)2, 13, update_connection, 0, update_connection.length);
            }
            catch (Exception ex) {
                if (!P4ServiceFrame.hasLogger) break block3;
                P4ServiceFrame.logErr("ID 011011: " + ex.getMessage());
            }
        }
    }

    public void setMaxRequestSize(int size) {
        this.maxRequestSize = size;
    }

    public void setInitializationTimeout(int initializationTimeout) {
        this.initializationTimeout = initializationTimeout;
    }
}

