/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4.dispatcher;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.CommunicationClusterContext;
import com.sap.engine.frame.cluster.event.ClusterEventListener;
import com.sap.engine.frame.cluster.event.ServiceEventListener;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.dispatcher.P4ServiceFrame;
import com.sap.engine.services.rmi_p4.dispatcher.P4SessionProcessor;
import com.sap.engine.services.rmi_p4.dispatcher.TransportMonitor;

public class P4EventListener
implements ServiceEventListener,
ClusterEventListener {
    TransportMonitor transportMonitor;
    private CommunicationClusterContext clusterContext;
    private P4SessionProcessor processor;
    private int groupId;

    public P4EventListener(TransportMonitor transportMonitor, CommunicationClusterContext clusterContext, P4SessionProcessor processor) {
        this.transportMonitor = transportMonitor;
        this.clusterContext = clusterContext;
        this.processor = processor;
        this.groupId = clusterContext.getClusterMonitor().getCurrentParticipant().getGroupId();
    }

    public synchronized void serviceStarted(ClusterElement element) {
        try {
            if (element.getGroupId() == this.groupId) {
                String profiles = this.transportMonitor.getAllProfiles();
                int len = 2 * profiles.length();
                byte[] arr = new byte[len];
                Convert.writeUStringToByteArr(arr, 0, profiles);
                this.clusterContext.getMessageContext().send(element.getClusterId(), 6, arr, 0, len);
            }
        }
        catch (Exception ex) {
            P4ServiceFrame.logErr("ID 011001: <Rmi_P4 Service>: .");
        }
    }

    public void serviceStopped(ClusterElement element) {
        this.processor.releaseCalls(element.getClusterId());
        P4ServiceFrame.logInfo("P4EventListener: ServiceStopped - release Connection for " + element.getClusterId());
    }

    public void elementJoin(ClusterElement element) {
        this.actualizeServerInfo(element);
    }

    public void elementLoss(ClusterElement element) {
        this.actualizeServerInfo(element);
    }

    private void actualizeServerInfo(ClusterElement element) {
        int servers = 0;
        int curGroupId = this.clusterContext.getClusterMonitor().getCurrentParticipant().getGroupId();
        if (element.getType() == 2 && curGroupId == element.getGroupId()) {
            ClusterElement[] all = this.clusterContext.getClusterMonitor().getParticipants();
            if (all != null && all.length > 0) {
                int i = 0;
                while (i < all.length) {
                    if (all[i].getType() == 2 && all[i].getGroupId() == curGroupId && (all[i].getModifiers() & 1) == 0) {
                        ++servers;
                    }
                    ++i;
                }
            }
            try {
                this.clusterContext.getCommunicationSessionContext().putLogonInfo(3, this.transportMonitor.listenerPort, servers);
            }
            catch (ClusterException e) {
                P4ServiceFrame.logErr("Cannot update p4 logon information for the message server !\n" + (Object)((Object)e));
            }
        }
        this.processor.releaseCalls(element.getClusterId());
        P4ServiceFrame.logInfo("P4EventListener: Element Lost - release Connection for " + element.getClusterId());
    }

    public void elementStateChanged(ClusterElement element, byte oldState) {
        this.actualizeServerInfo(element);
    }
}

