/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.services.rmi_p4.ExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class P4StubSkeletonGenerator {
    private static String tab1 = "\t";
    private static String tab2 = "\t\t";
    private static String tab3 = "\t\t\t";
    private static String tab4 = "\t\t\t\t";
    private static String tab5 = "\t\t\t\t\t";
    private static String tab6 = "\t\t\t\t\t\t";
    private Class remote_class = null;
    private String destDir = null;
    private String p4 = "";
    private Class[] remoteInterfaces = new Class[0];
    private Hashtable remoteMethods = new Hashtable();
    private Hashtable access = new Hashtable();
    private boolean onlyStub = false;
    private boolean applyExecutionContext = true;
    private Vector files = new Vector();
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$P4RemoteObject;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$lang$String;

    public P4StubSkeletonGenerator(Class _class, String _destDir, Hashtable access) throws IOException {
        this.remote_class = _class;
        this.access = access;
        if (access == null) {
            this.access = new Hashtable();
        }
        if (!(class$com$sap$engine$services$rmi_p4$P4RemoteObject == null ? (class$com$sap$engine$services$rmi_p4$P4RemoteObject = P4StubSkeletonGenerator.class$("com.sap.engine.services.rmi_p4.P4RemoteObject")) : class$com$sap$engine$services$rmi_p4$P4RemoteObject).isAssignableFrom(this.remote_class)) {
            this.p4 = "p4";
        }
        this.destDir = _destDir;
        if (_class.isInterface()) {
            this.onlyStub = true;
        }
        Vector temp_interfaces = new Vector();
        this.getRemoteInterfaces(this.remote_class, temp_interfaces);
        this.getRemoteMethods(temp_interfaces, this.remoteMethods);
        if (temp_interfaces.size() > 0) {
            this.remoteInterfaces = new Class[temp_interfaces.size()];
            temp_interfaces.copyInto(this.remoteInterfaces);
        }
    }

    public void setApplyExecutionContext(boolean applyExecutionContext) {
        this.applyExecutionContext = applyExecutionContext;
    }

    private void getRemoteInterfaces(Class _target, Vector interfaceBuffer) {
        if (_target != null) {
            this.getRemoteInterfaces(_target.getSuperclass(), interfaceBuffer);
            Class<?>[] temp_interfaces = _target.getInterfaces();
            int k = 0;
            while (k < temp_interfaces.length) {
                this.update(temp_interfaces[k], interfaceBuffer);
                ++k;
            }
        }
    }

    public void getRemoteMethods(Vector _target, Hashtable methodBuffer) {
        int k = 0;
        while (k < _target.size()) {
            Method[] methods = ((Class)_target.elementAt(k)).getMethods();
            String methodName = "";
            int i = 0;
            while (i < methods.length) {
                if (!methods[i].getName().startsWith("<clinit>")) {
                    methodName = methods[i].toString();
                    methodName = methodName.substring(methodName.indexOf(40), methodName.lastIndexOf(41) + 1);
                    methodName = methods[i].getName() + methodName;
                    if (!methodBuffer.contains(methodName)) {
                        methodBuffer.put(methodName, methods[i]);
                    }
                }
                ++i;
            }
            ++k;
        }
    }

    public boolean update(Class _interface, Vector buffer) {
        if (!(class$java$rmi$Remote == null ? (class$java$rmi$Remote = P4StubSkeletonGenerator.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(_interface)) {
            return false;
        }
        int i = 0;
        while (i < buffer.size()) {
            if (_interface.isAssignableFrom((Class)buffer.elementAt(i))) {
                return false;
            }
            if (((Class)buffer.elementAt(i)).isAssignableFrom(_interface)) {
                buffer.removeElementAt(i--);
            }
            ++i;
        }
        buffer.addElement(_interface);
        return true;
    }

    public Vector generate() throws IOException {
        if (!this.onlyStub) {
            this.generateSkeleton();
            int i = 0;
            while (i < this.remoteInterfaces.length) {
                this.generateStub(this.remoteInterfaces[i]);
                ++i;
            }
        } else {
            this.generateStub(this.remote_class);
        }
        return this.files;
    }

    public void generateStub(Class remote_interface) throws IOException {
        Method[] methods1 = remote_interface.getMethods();
        String stubName = this.makeStubName(remote_interface.getName());
        PrintWriter file = this.makeFile(stubName, remote_interface);
        file.println("\n");
        file.println("import com.sap.engine.services.rmi_p4.*;");
        file.println("\n");
        file.println("/**");
        file.println("*");
        file.println("* @author  RMIC Generator");
        file.println("* @version 6.30");
        file.println("*/");
        file.print("public class " + stubName);
        file.println(" extends com.sap.engine.services.rmi_p4.StubImpl ");
        file.print(tab2 + "implements " + remote_interface.getName() + " {");
        file.println("\n");
        file.print(tab1 + "private static final String[] operations = {");
        Vector<String> vec1 = new Vector<String>();
        Vector<Method> vec2 = new Vector<Method>();
        int i = 0;
        while (i < methods1.length) {
            if (!methods1[i].getName().startsWith("<clinit>")) {
                String methodName = "";
                methodName = methods1[i].toString();
                methodName = methodName.substring(methodName.indexOf(40), methodName.lastIndexOf(41) + 1);
                methodName = methods1[i].getName() + methodName;
                if (!vec1.contains(methodName)) {
                    vec1.add(methodName);
                    vec2.add(methods1[i]);
                    file.print("\n" + tab3 + "\"" + methodName + "\"" + (i == methods1.length - 1 ? "" : ","));
                }
            }
            ++i;
        }
        file.println("};\n");
        Method[] methods = vec2.toArray(new Method[0]);
        file.println(tab1 + "public String[] p4_getOperations() {");
        file.println(tab2 + "return operations;");
        file.println(tab1 + "}\n");
        int p = 0;
        while (p < methods.length) {
            Class<?> returnType = methods[p].getReturnType();
            Class[] exceptions = methods[p].getExceptionTypes();
            boolean declaredRemoteException = false;
            if (exceptions.length != 0) {
                exceptions = new ExceptionHandler().handler(exceptions);
            }
            int i2 = 0;
            while (i2 < exceptions.length) {
                if ((class$java$rmi$RemoteException == null ? P4StubSkeletonGenerator.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).equals(exceptions[i2])) {
                    declaredRemoteException = true;
                    break;
                }
                ++i2;
            }
            Class[] parameters = methods[p].getParameterTypes();
            int modifier = methods[p].getModifiers();
            if (Modifier.isPublic(modifier)) {
                file.print(tab1 + "public ");
            } else if (Modifier.isPrivate(modifier)) {
                file.print(tab1 + "private ");
            } else if (Modifier.isProtected(modifier)) {
                file.print(tab1 + "protected ");
            }
            file.print(this.nameToType(returnType) + " ");
            file.print(methods[p].getName() + "(");
            int i3 = 0;
            while (i3 < parameters.length) {
                file.print(this.nameToType(parameters[i3]) + " _param" + i3);
                file.print(i3 == parameters.length - 1 ? ")" : ", ");
                ++i3;
            }
            file.print(parameters.length == 0 ? ") " : " ");
            file.print(exceptions.length == 0 ? " {\n" : "throws ");
            int i4 = 0;
            while (i4 < exceptions.length) {
                file.print(exceptions[i4].getName().replace('$', '.'));
                file.print(i4 == exceptions.length - 1 ? " {\n" : ", ");
                ++i4;
            }
            String mName = "";
            mName = methods[p].toString();
            mName = mName.substring(mName.indexOf(40), mName.lastIndexOf(41) + 1);
            mName = methods[p].getName() + mName;
            file.print("\n");
            if (this.applyExecutionContext) {
                file.println(tab2 + "Object state = null;");
            }
            file.println(tab2 + "if (isLocal) {");
            file.println(tab3 + "java.rmi.Remote remote;");
            file.println(tab3 + "if (p4remote == null) {");
            if (declaredRemoteException) {
                file.println(tab4 + "throw new java.rmi.NoSuchObjectException(\"\");");
            } else {
                file.println(tab4 + "throw (com.sap.engine.services.rmi_p4.P4RuntimeException) broker.getException(P4ObjectBroker.P4_RuntimeException, com.sap.engine.services.rmi_p4.exception.P4BaseRuntimeException.Object_is_Disconnected, null);");
            }
            file.println(tab3 + "} else {");
            String tab = tab4;
            if (!declaredRemoteException) {
                file.println(tab4 + "try {");
                tab = tab5;
            }
            file.println(tab + "remote = p4remote.delegate();");
            if (!declaredRemoteException) {
                file.println(tab4 + "} catch (java.rmi.NoSuchObjectException nso) { ");
                file.println(tab5 + "// $JL-EXC$");
                file.println(tab5 + "throw (com.sap.engine.services.rmi_p4.P4RuntimeException) broker.getException(P4ObjectBroker.P4_RuntimeException, com.sap.engine.services.rmi_p4.exception.P4BaseRuntimeException.Object_is_Disconnected, nso);");
                file.println(tab4 + "}");
            }
            file.println(tab3 + "}");
            file.println(tab3 + "try {");
            if (this.applyExecutionContext) {
                file.println(tab4 + "state = broker.applyExecContextState(remote);");
            }
            file.print(tab4 + remote_interface.getName() + " remoteInterface = ");
            file.println("(" + remote_interface.getName() + ") remote;");
            boolean useStreamss = false;
            int i5 = 0;
            while (i5 < parameters.length) {
                if (!this.checkElementType(parameters[i5])) {
                    useStreamss = true;
                }
                ++i5;
            }
            if (useStreamss) {
                file.println(tab4 + "ReplicateOutputStream out1 = p4_getReplicateOutput();");
                file.println(tab4 + "ReplicateInputStream inn1 = p4_getReplicateInput(out1);");
            }
            if (returnType.getName().equals("void")) {
                file.print(tab4 + "remoteInterface." + methods[p].getName() + "(");
                file.print(this.replicateMethodParameters(parameters));
                file.println(");");
                file.println(tab4 + "return;");
            } else {
                String cast = "";
                if (!this.checkElementType(returnType)) {
                    cast = "(" + this.nameToType(returnType) + ") broker.narrow(p4_replicate(";
                    file.print(tab4 + "return " + cast + "remoteInterface." + methods[p].getName() + "(");
                    file.print(this.replicateMethodParameters(parameters));
                    file.println(")), " + this.nameToType(returnType) + ".class);");
                } else {
                    file.print(tab4 + "return remoteInterface." + methods[p].getName() + "(");
                    file.print(this.replicateMethodParameters(parameters));
                    file.println(");");
                }
            }
            file.println(tab3 + "} catch (java.lang.ClassCastException rex) {");
            file.println(tab4 + "// $JL-EXC$");
            boolean useStreamsss = false;
            int i6 = 0;
            while (i6 < parameters.length) {
                if (!this.checkElementType(parameters[i6])) {
                    useStreamsss = true;
                }
                ++i6;
            }
            if (useStreamsss) {
                file.println(tab4 + "ReplicateOutputStream outt = p4_getReplicateOutput();");
                file.println(tab4 + "ReplicateInputStream inn = p4_getReplicateInput(outt);");
            }
            file.print(tab4 + "Object[] params = new Object[]{");
            int i7 = 0;
            while (i7 < parameters.length) {
                if (parameters[i7].isPrimitive() || parameters[i7].isArray()) {
                    if (this.ioType(parameters[i7]).equals("Int")) {
                        file.print("new Integer(_param" + new Integer(i7).toString() + ")");
                    } else if (this.ioType(parameters[i7]).equals("Char")) {
                        file.print("new Character(_param" + new Integer(i7).toString() + ")");
                    } else if (parameters[i7].isArray() && this.checkElementType(parameters[i7])) {
                        file.print("_param" + new Integer(i7).toString());
                    } else if (parameters[i7].isArray() && !this.checkElementType(parameters[i7])) {
                        file.print("p4_replicateWithStreams(inn,outt,_param" + new Integer(i7).toString() + ")");
                    } else {
                        file.print("new " + this.ioType(parameters[i7]) + "(" + " _param" + new Integer(i7).toString() + ")");
                    }
                } else if (!this.nameToType(parameters[i7]).equalsIgnoreCase("java.lang.String")) {
                    file.print("p4_replicateWithStreams(inn,outt,");
                    file.print("_param" + new Integer(i7).toString());
                    file.print(")");
                } else {
                    file.print("_param" + new Integer(i7).toString());
                }
                if (i7 < parameters.length - 1) {
                    file.print(",");
                }
                ++i7;
            }
            file.println("};");
            file.print(tab4 + "Class[] p = new Class[]{");
            int i8 = 0;
            while (i8 < parameters.length) {
                if (parameters[i8].isPrimitive() || parameters[i8].isArray() && this.checkElementType(parameters[i8])) {
                    file.print(this.nameToType(parameters[i8]) + ".class");
                } else if (!this.nameToType(parameters[i8]).equalsIgnoreCase("java.lang.String")) {
                    file.print("(Class) p4_replicateWithStreams(inn,outt," + this.nameToType(parameters[i8]) + ".class)");
                } else {
                    file.print(this.nameToType(parameters[i8]) + ".class");
                }
                if (i8 < parameters.length - 1) {
                    file.print(",");
                }
                ++i8;
            }
            file.println("};");
            file.println(tab4 + "try { ");
            if (!returnType.getName().equalsIgnoreCase("void")) {
                file.print(tab5 + "return ");
                if (!returnType.isPrimitive() && !returnType.equals(class$java$lang$String == null ? P4StubSkeletonGenerator.class$("java.lang.String") : class$java$lang$String)) {
                    file.println("(" + this.nameToType(returnType) + ")broker.narrow(p4_replicate(p4_invokeReflect(remote,\"" + methods[p].getName() + "\",params,p))," + this.nameToType(returnType) + ".class);");
                } else if (this.ioType(returnType).equals("Int")) {
                    file.println("((Integer) p4_invokeReflect(remote,\"" + methods[p].getName() + "\",params,p)).intValue();");
                } else if (this.ioType(returnType).equals("Char")) {
                    file.println("((Character) p4_invokeReflect(remote,\"" + methods[p].getName() + "\",params, p)).charValue();");
                } else if (returnType.equals(class$java$lang$String == null ? P4StubSkeletonGenerator.class$("java.lang.String") : class$java$lang$String)) {
                    file.println("((String) p4_invokeReflect(remote,\"" + methods[p].getName() + "\",params,p));");
                } else {
                    file.println("((" + this.ioType(returnType) + ") p4_invokeReflect(remote,\"" + methods[p].getName() + "\",params,p))." + returnType + "Value();");
                }
            } else {
                file.println(tab5 + "p4_invokeReflect(remote,\"" + methods[p].getName() + "\",params,p);");
                file.println(tab5 + "return ;");
            }
            file.println(tab4 + "} catch (java.lang.NoSuchMethodException nsme) {");
            file.println(tab5 + "// $JL-EXC$");
            file.println(tab5 + "throw (com.sap.engine.services.rmi_p4.P4RuntimeException)P4ObjectBroker.init().getException(P4ObjectBroker.P4_RuntimeException,com.sap.engine.services.rmi_p4.exception.P4BaseRuntimeException.No_Such_Method,nsme);");
            file.println(tab4 + "} catch (java.lang.IllegalAccessException iae) {");
            file.println(tab5 + "// $JL-EXC$");
            file.println(tab5 + "throw (com.sap.engine.services.rmi_p4.P4RuntimeException)P4ObjectBroker.init().getException(P4ObjectBroker.P4_RuntimeException,com.sap.engine.services.rmi_p4.exception.P4BaseRuntimeException.Illegal_Access,iae);");
            file.println(tab4 + "} catch (java.lang.reflect.InvocationTargetException ite) {");
            file.println(tab5 + "// $JL-EXC$");
            file.println(tab5 + "java.lang.Throwable target = (java.lang.Throwable) p4_replicate(ite.getTargetException());");
            file.print(tab5);
            int ii = 0;
            while (ii < exceptions.length) {
                file.println("if (target instanceof " + this.nameToType(exceptions[ii]) + ") {");
                file.println(tab5 + " throw (" + this.nameToType(exceptions[ii]).replace('$', '.') + ")target;");
                file.print(tab5 + "} else ");
                ++ii;
            }
            file.println("{ ");
            file.println(tab5 + " throw (com.sap.engine.services.rmi_p4.P4RuntimeException)P4ObjectBroker.init().getException(P4ObjectBroker.P4_RuntimeException,com.sap.engine.services.rmi_p4.exception.P4BaseRuntimeException.InvocationTarget, target);");
            file.println(tab5 + "}");
            file.println(tab4 + "} ");
            file.println(tab3 + "} catch (java.lang.RuntimeException rex) {");
            file.println(tab5 + "// $JL-EXC$");
            file.println(tab4 + "broker.log(\"P4 Call exception: Exception in execute <" + methods[p].getName() + ">\", broker.debug);");
            file.println(tab4 + "broker.log(rex, broker.debug);");
            file.println(tab5 + "throw rex;");
            int k = 0;
            while (k < exceptions.length) {
                file.println(tab3 + "} catch (" + exceptions[k].getName().replace('$', '.') + " ex) {");
                file.println(tab5 + "// $JL-EXC$");
                file.println(tab4 + "broker.log(\"P4 Call exception: Exception in execute <" + methods[p].getName() + ">\", broker.debug);");
                file.println(tab4 + "broker.log(ex, broker.debug);");
                file.println(tab4 + "throw (" + exceptions[k].getName().replace('$', '.') + ") p4_replicate(ex);");
                ++k;
            }
            if (this.applyExecutionContext) {
                file.println(tab3 + "} finally {");
                file.println(tab4 + "broker.setExecContextState(state);");
            }
            file.println(tab3 + "} ");
            file.println(tab2 + "}");
            file.println(tab3 + "com.sap.engine.services.rmi_p4.Call call = null;");
            file.println(tab3 + "try {");
            file.println(tab4 + "call = p4_newCall(" + p + ");");
            file.println(tab4 + "P4ObjectOutput out = call.getOutputStream();");
            int i9 = 0;
            while (i9 < parameters.length) {
                file.print(tab4 + "out.write" + this.ioType(parameters[i9]));
                file.println("( _param" + i9 + ");");
                ++i9;
            }
            file.println(tab4 + "p4_invoke(call);");
            file.println(tab4 + "P4ObjectInput in = call.getResultStream();");
            if (!returnType.getName().equals("void")) {
                String type = this.nameToType(returnType);
                if (returnType.isPrimitive()) {
                    file.print(tab4 + type + " _result = ");
                    file.println("in.read" + this.ioType(returnType) + "();");
                } else {
                    file.println(tab5 + "Object obj;");
                    if (!returnType.getName().equals("java.lang.Class")) {
                        file.println(tab5 + type + " _result;");
                    }
                    if (returnType.getName().equals("java.lang.Class")) {
                        file.println(tab5 + "obj = in.readObject" + "();");
                    } else {
                        file.println(tab5 + "obj = in.read" + this.ioType(returnType) + "();");
                    }
                    if (!returnType.getName().equals("java.lang.Class")) {
                        file.println(tab5 + "try {");
                        file.print(tab6 + " _result = ");
                        file.println("(" + type + ")obj;");
                        file.println(tab5 + "} catch (java.lang.ClassCastException ex) {");
                        file.println(tab5 + "// $JL-EXC$");
                        file.print(tab6 + " _result = ");
                        file.println("(" + type + ") broker.narrow(obj," + type + ".class);");
                        file.println(tab5 + "}");
                    }
                }
            }
            if (!returnType.getName().equals("void")) {
                if (returnType.getName().equals("java.lang.Class")) {
                    file.println(tab4 + "return (obj == null? null: ((com.sap.engine.services.rmi_p4.P4ClassWrapper)obj).getCarriedClass());");
                } else {
                    file.println(tab4 + "return _result;");
                }
            }
            exceptions = new ExceptionHandler().handler(exceptions);
            int k2 = 0;
            while (k2 < exceptions.length) {
                if (!exceptions[k2].getName().equals("java.lang.Exception")) {
                    file.println(tab3 + "} catch (" + exceptions[k2].getName().replace('$', '.') + " ex) {");
                    file.println(tab5 + "// $JL-EXC$");
                    file.println(tab4 + "throw ex;");
                }
                ++k2;
            }
            file.println(tab3 + "} catch (java.lang.Exception tr) {");
            file.println(tab5 + "// $JL-EXC$");
            file.println(tab4 + " // ex.printStackTrace();");
            file.println(tab4 + "if ( java.lang.RuntimeException.class.isAssignableFrom(tr.getClass()) ) {");
            file.println(tab5 + "throw (java.lang.RuntimeException)tr;");
            file.println(tab4 + "} else {");
            file.println(tab5 + "throw (com.sap.engine.services.rmi_p4.P4RuntimeException)P4ObjectBroker.init().getException(P4ObjectBroker.P4_RuntimeException, com.sap.engine.services.rmi_p4.exception.P4BaseRuntimeException.Unexpexted_exception, tr);");
            file.println(tab4 + "}");
            file.println(tab3 + "} finally {");
            file.println(tab4 + "p4_done(call);");
            file.println(tab4 + "call.releaseInputStream();");
            file.println(tab3 + "}");
            file.println(tab1 + "}");
            file.println("\n");
            ++p;
        }
        file.println("}");
        file.close();
    }

    public void generateSkeleton() throws IOException {
        String resourceId = (String)this.access.get(this.remote_class);
        boolean useSecurity = false;
        if (resourceId != null) {
            useSecurity = true;
        }
        String skelName = this.makeSkeletonName(this.remote_class.getName());
        PrintWriter file = this.makeFile(skelName, this.remote_class);
        file.println("import java.rmi.server.Operation;");
        file.println();
        file.println("import com.sap.engine.services.rmi_p4.*;");
        if (useSecurity) {
            file.println("import com.sap.engine.services.rmi_p4.server.P4Provider;");
            file.println("import com.sap.engine.interfaces.security.ResourceContext;");
            file.println("import com.sap.engine.interfaces.security.resource.ResourceHandle;");
        }
        file.println();
        file.println("/**");
        file.println(" *");
        file.println(" * @author RMIC Generator ");
        file.println(" * @version 6.30");
        file.println(" */");
        file.print("public class " + skelName);
        if (!(class$com$sap$engine$services$rmi_p4$P4RemoteObject == null ? (class$com$sap$engine$services$rmi_p4$P4RemoteObject = P4StubSkeletonGenerator.class$("com.sap.engine.services.rmi_p4.P4RemoteObject")) : class$com$sap$engine$services$rmi_p4$P4RemoteObject).isAssignableFrom(this.remote_class)) {
            file.print(" extends P4RemoteObject ");
            file.println(" implements com.sap.engine.services.rmi_p4.Skeleton, java.rmi.Remote {");
        } else {
            file.println(" implements com.sap.engine.services.rmi_p4.Skeleton {");
        }
        file.println();
        file.print(tab1 + "public P4ObjectBroker broker = P4ObjectBroker.init();\n");
        if (useSecurity) {
            if (resourceId != null) {
                file.print(tab1 + "private static String resourceId = \"" + resourceId + "\";\n");
            } else {
                file.print(tab1 + "private static String resourceId  = null; \n");
            }
            file.println(tab1 + "private ResourceContext resourceCtx = null;");
        }
        file.print(tab1 + "private static final Operation[] operations = {");
        Enumeration enumeration = this.remoteMethods.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            file.print("\n" + tab3 + "new Operation(\"" + key + "\")" + (enumeration.hasMoreElements() ? "," : ""));
        }
        file.println("};\n");
        file.println(tab1 + "public " + skelName + " () {");
        if (useSecurity) {
            file.println(tab2 + "resourceCtx = P4Provider.getResourceContext();");
        }
        file.println(tab1 + "}\n");
        file.println(tab1 + "public Operation[] getOperations() {");
        file.println(tab2 + "return operations;");
        file.println(tab1 + "}\n");
        file.print(tab1 + "private static final String[] _implements = {");
        int i = 0;
        while (i < this.remoteInterfaces.length) {
            file.print("\n" + tab3 + "\"" + this.remoteInterfaces[i].getName() + "\"" + (i != this.remoteInterfaces.length - 1 ? "," : ""));
            ++i;
        }
        file.println("};\n");
        file.println(tab1 + "public String[] getImplemntsObjects() {");
        file.println(tab2 + "return _implements;");
        file.println(tab1 + "}\n");
        file.println(tab1 + "public void dispatch(java.rmi.Remote remote, Dispatch call, int opnum) throws java.lang.Exception {");
        file.println();
        if (this.applyExecutionContext) {
            file.println(tab2 + "Object state = null;");
            file.println(tab2 + "try {");
            file.println(tab2 + "state = broker.applyExecContextState(delegate());");
        }
        if (useSecurity) {
            file.print(tab2 + "resourceCtx.checkPermission(");
            file.print("operations[opnum].getOperation()");
            file.println(", resourceId, ResourceHandle.ALL);\n");
        }
        if (!(class$com$sap$engine$services$rmi_p4$P4RemoteObject == null ? (class$com$sap$engine$services$rmi_p4$P4RemoteObject = P4StubSkeletonGenerator.class$("com.sap.engine.services.rmi_p4.P4RemoteObject")) : class$com$sap$engine$services$rmi_p4$P4RemoteObject).isAssignableFrom(this.remote_class)) {
            file.println(tab2 + this.remote_class.getName() + " impl = (" + this.remote_class.getName() + ") delegate();");
        } else {
            file.println(tab2 + this.remote_class.getName() + " impl = (" + this.remote_class.getName() + ") remote;");
        }
        file.println(tab2 + "P4ObjectInput in = call.getInputStream();");
        file.println();
        file.println(tab2 + "switch (opnum) {\n");
        enumeration = this.remoteMethods.keys();
        int opnum = 0;
        while (enumeration.hasMoreElements()) {
            int i2;
            String key = (String)enumeration.nextElement();
            Method mm = (Method)this.remoteMethods.get(key);
            Class<?> returnType = mm.getReturnType();
            Class<?>[] parameters = mm.getParameterTypes();
            file.println(tab3 + "case " + opnum + " : {" + "  //method " + mm);
            file.println(tab4 + "try {");
            int i3 = 0;
            while (i3 < parameters.length) {
                String type = this.nameToType(parameters[i3]);
                if (parameters[i3].isPrimitive()) {
                    file.print(tab5 + type + " param" + i3 + " = ");
                    file.println("in.read" + this.ioType(parameters[i3]) + "();");
                } else {
                    file.println(tab5 + "Object obj" + i3 + ";");
                    file.println(tab5 + type + " param" + i3 + ";");
                    file.println(tab5 + "obj" + i3 + " = in.read" + this.ioType(parameters[i3]) + "();");
                    file.println(tab5 + "try {");
                    file.print(tab6 + " param" + i3 + " = ");
                    file.println("(" + type + ")obj" + i3 + ";");
                    file.println(tab5 + "} catch (java.lang.ClassCastException ex) {");
                    file.println(tab5 + "// $JL-EXC$");
                    file.print(tab6 + " param" + i3 + " = ");
                    file.println("(" + type + ") broker.narrow(obj" + i3 + "," + type + ".class);");
                    file.println(tab5 + "}");
                }
                ++i3;
            }
            if (!returnType.getName().equals("void")) {
                file.print(tab5 + this.nameToType(returnType) + " _result = impl." + mm.getName() + "(");
                i2 = 0;
                while (i2 < parameters.length) {
                    file.print("param" + i2 + (i2 == parameters.length - 1 ? "" : ", "));
                    ++i2;
                }
                file.println(");");
                file.println(tab5 + "P4ObjectOutput out = call.getOutputStream();");
                if (returnType.getName().equals("java.lang.Class")) {
                    file.println(tab5 + "if(_result != null){");
                    file.print(tab6 + "out.writeObject");
                    file.println("(new com.sap.engine.services.rmi_p4.P4ClassWrapper((java.lang.Class)_result));");
                    file.println(tab5 + "} else {");
                    file.println(tab6 + "out.writeObject(null);");
                    file.println(tab5 + "}");
                } else {
                    file.print(tab5 + "out.write" + this.ioType(returnType));
                    file.println("( _result);");
                }
                file.println(tab5 + "out.flush();");
            } else {
                file.print(tab5 + "impl." + mm.getName() + "(");
                i2 = 0;
                while (i2 < parameters.length) {
                    file.print("param" + i2 + (i2 == parameters.length - 1 ? "" : ", "));
                    ++i2;
                }
                file.println(");");
                file.println(tab5 + "P4ObjectOutput out = call.getOutputStream();");
            }
            file.println(tab4 + "} catch (java.lang.Exception ex) {");
            file.println(tab5 + "// $JL-EXC$");
            file.println(tab5 + "throw ex;");
            file.println(tab4 + "}");
            file.println(tab4 + "break;");
            file.println(tab3 + "}");
            ++opnum;
        }
        file.println(tab2 + "}");
        if (this.applyExecutionContext) {
            file.println(tab2 + "} finally {");
            file.println(tab3 + "broker.setExecContextState(state);");
            file.println(tab2 + "}");
        }
        file.println(tab1 + "}\n");
        if (useSecurity) {
            file.println(tab1 + "public void checkPermission(String operationName) throws SecurityException {");
            file.println(tab2 + "if (resourceId != null) {");
            file.println(tab3 + "resourceCtx.checkPermission(operationName, resourceId, ResourceHandle.ALL);");
            file.println(tab2 + "}");
            file.println(tab1 + "}");
        }
        file.println("}");
        file.close();
    }

    private String makeStubName(String className) {
        String stubName = className.substring(className.lastIndexOf(46) + 1);
        stubName = stubName + "_Stub";
        return stubName;
    }

    private String makeSkeletonName(String className) {
        String skeletonName = className.substring(className.lastIndexOf(46) + 1);
        skeletonName = skeletonName + this.p4 + "_" + "Skel";
        return skeletonName;
    }

    private String ioType(Class _toRW) {
        if (_toRW.getName().equals("int")) {
            return "Int";
        }
        if (_toRW.getName().equals("long")) {
            return "Long";
        }
        if (_toRW.getName().equals("short")) {
            return "Short";
        }
        if (_toRW.getName().equals("boolean")) {
            return "Boolean";
        }
        if (_toRW.getName().equals("byte")) {
            return "Byte";
        }
        if (_toRW.getName().equals("char")) {
            return "Char";
        }
        if (_toRW.getName().equals("double")) {
            return "Double";
        }
        if (_toRW.getName().equals("float")) {
            return "Float";
        }
        return "Object";
    }

    private String nameToType(Class _class) {
        String type = _class.getName().replace('$', '.');
        int last = type.lastIndexOf(91);
        if (last < 0) {
            return type;
        }
        char descriptor = type.charAt(last + 1);
        type = type.substring(last + 1);
        String arrDimension = "[]";
        int i = 0;
        while (i < last) {
            arrDimension = arrDimension + "[]";
            ++i;
        }
        switch (descriptor) {
            case 'B': {
                type = "byte" + arrDimension;
                break;
            }
            case 'C': {
                type = "char" + arrDimension;
                break;
            }
            case 'D': {
                type = "double" + arrDimension;
                break;
            }
            case 'F': {
                type = "float" + arrDimension;
                break;
            }
            case 'I': {
                type = "int" + arrDimension;
                break;
            }
            case 'J': {
                type = "long" + arrDimension;
                break;
            }
            case 'L': {
                type = type.substring(1, type.length() - 1) + arrDimension;
                break;
            }
            case 'S': {
                type = "short" + arrDimension;
                break;
            }
            case 'Z': {
                type = "boolean" + arrDimension;
            }
        }
        return type;
    }

    private PrintWriter makeFile(String _fileName, Class _forClass) throws IOException {
        String fileName = "";
        String package_ = "";
        package_ = P4StubSkeletonGenerator.getPackageName(_forClass.getName());
        fileName = package_.replace('.', File.separatorChar);
        File __file = new File(this.destDir + File.separatorChar + fileName);
        __file.mkdirs();
        File _file = new File(__file, _fileName + ".java");
        fileName = fileName.length() > 0 ? fileName + File.separatorChar + _fileName : _fileName;
        this.files.addElement(fileName);
        fileName = fileName + ".java";
        FileOutputStream fos = new FileOutputStream(_file.getCanonicalPath(), false);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        PrintWriter file = new PrintWriter((Writer)osw, true);
        file.println("// Class generated by SAP Labs Bulgaria Generator");
        file.println("// Don't change it !!");
        file.println();
        file.println();
        if (package_ != null && !package_.equals("")) {
            file.println("/**");
            file.println(" * Copyright (c) 2000 by SAP AG, Walldorf.,");
            file.println(" * url: http:////www.sap.com");
            file.println(" * All rights reserved.");
            file.println(" *");
            file.println(" * This software is the confidential and proprietary information");
            file.println(" * of SAP AG, Walldorf.. You shall not disclose such Confidential");
            file.println(" * Information and shall use it only in accordance with the terms");
            file.println(" * of the license agreement you entered into with SAP.");
            file.println(" */");
            file.println("package " + package_ + ";");
            file.println();
        }
        return file;
    }

    private static String getPackageName(String fullClassName) {
        if (fullClassName.indexOf(".") == -1) {
            return "";
        }
        return fullClassName.substring(0, fullClassName.lastIndexOf("."));
    }

    private String replicateMethodParameters(Class[] parameters) {
        String result = "";
        int i = 0;
        while (i < parameters.length) {
            result = parameters[i].isPrimitive() || parameters[i].getName().startsWith("java.lang.String") || parameters[i].isArray() && this.checkElementType(parameters[i]) ? result + " _param" + new Integer(i).toString() : result + "(" + this.nameToType(parameters[i]) + ") broker.narrow(p4_replicateWithStreams(inn1,out1,_param" + new Integer(i).toString() + ")," + this.nameToType(parameters[i]) + ".class)";
            result = result + (i == parameters.length - 1 ? "" : ", ");
            ++i;
        }
        return result;
    }

    private boolean checkElementType(Class _class) {
        if (_class.isArray()) {
            return this.checkElementType(_class.getComponentType());
        }
        return _class.isPrimitive() || _class.getName().startsWith("java.lang.String");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

