/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.frame.client.ClientException;
import com.sap.engine.frame.client.ClientFactory;
import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.TransferableExt;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.Connection;
import com.sap.engine.services.rmi_p4.ConnectionManager;
import com.sap.engine.services.rmi_p4.InitialCall;
import com.sap.engine.services.rmi_p4.InitializingException;
import com.sap.engine.services.rmi_p4.MarshalException;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.P4ConnectionException;
import com.sap.engine.services.rmi_p4.P4DynamicSkeleton;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4ParseRequestException;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.P4RemoteObjectInfo;
import com.sap.engine.services.rmi_p4.P4RuntimeException;
import com.sap.engine.services.rmi_p4.P4URLLoader;
import com.sap.engine.services.rmi_p4.Parser;
import com.sap.engine.services.rmi_p4.Repliable;
import com.sap.engine.services.rmi_p4.StubBaseInfo;
import com.sap.engine.services.rmi_p4.StubImpl;
import com.sap.engine.services.rmi_p4.all.ConnectionProfile;
import com.sap.engine.services.rmi_p4.classload.ClassLoaderContext;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import com.sap.engine.services.rmi_p4.garbagecollector.GarbageCollector;
import com.sap.engine.services.rmi_p4.monitor.ConnectionObject;
import com.sap.engine.services.rmi_p4.server.P4ServerObjectInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class P4ObjectBrokerClientImpl
extends P4ObjectBroker {
    public static final String TICKET = "?ticket=";
    public ConnectionManager manager;
    private Thread garbageCollector;
    private boolean isClose = false;
    private ResourceBundle rb = null;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$P4ObjectBrokerClientImpl;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$P4URLLoader;

    protected P4ObjectBrokerClientImpl() {
        this.weaks = new WeakHashMap();
    }

    public void inform(Object _identifer, Message _message) {
        this.objManager.inform(_identifer, _message.getUnmarshaledRequest());
    }

    public void disposeConnection(Object _connection) {
        try {
            this.objManager.disposeConnection(_connection);
            this.manager.removeConnection((Connection)_connection);
        }
        catch (Exception ex) {
            this.log(ex);
        }
    }

    public P4RemoteObjectInfo getObjectInfo() {
        P4ServerObjectInfo info = new P4ServerObjectInfo();
        info.connectionProfiles = this.getConnectionProfiles();
        return info;
    }

    public Object resolveInitialReference(String name, String host, int port) throws Exception {
        return this.resolveInitialReference("None", name, host, port);
    }

    public Object resolveInitialReference(String connectionType, String name, String host, int port) throws Exception {
        return this.resolveInitialReference(connectionType, name, host, port, -1);
    }

    public Object resolveInitialReference(String connectionType, String name, String host, int port, int destServerId) throws Exception {
        int headerSize = 14;
        int nameLength = name.length();
        InitialCall call = InitialCall.getInitialCall();
        byte[] message = new byte[headerSize + 8 + 1 + 2 * nameLength];
        Convert.writeIntToByteArr(message, 6, destServerId);
        call.writeId(message, headerSize);
        message[headerSize + 8] = 10;
        Convert.writeUStringToByteArr(message, headerSize + 8 + 1, name);
        if (host.equals("localhost")) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHost) {
                try {
                    host = InetAddress.getByName("127.0.0.1").getHostAddress();
                }
                catch (UnknownHostException unHost) {
                    System.out.println("P4ObjectBrokerClient Impl: Error in geting local host address.");
                    this.log("P4ObjectBrokerClient Impl: Error in geting local host address.");
                }
            }
        } else {
            host = InetAddress.getByName(host).getHostAddress();
        }
        connectionType = connectionType.equals("") ? "None" : connectionType;
        Connection con = this.manager.getConnection(connectionType, host, port);
        con.reply(destServerId, 0, message, message.length);
        con.host = host;
        con.port = port;
        byte[] res = call.getResult(con);
        StubBaseInfo stubInfo = this.byteArrayToObject(res);
        if (destServerId != -1 && stubInfo.server_id != destServerId) {
            throw new RemoteException("Server with id " + destServerId + " doesn't exsist !");
        }
        if (!con.connectionId.equalsIgnoreCase(con.destinationId)) {
            String id;
            StringBuffer _id = new StringBuffer(String.valueOf(stubInfo.ownerId));
            _id.append(':');
            _id.append(con.connectionId);
            con.underlyingProfile = id = _id.toString();
            stubInfo.setIncomingProfile(id);
        }
        this.initialProfiles = stubInfo.connectionProfiles;
        return stubInfo;
    }

    public synchronized void close() {
        if (this.isClose) {
            return;
        }
        try {
            this.isClose = true;
            this.manager.close();
            this.impls.clear();
            this.initObjects.clear();
            Parser.close();
            this.garbageCollector.stop();
            this.garbageCollector.interrupt();
        }
        catch (Exception e) {
            this.log(e);
        }
        this.garbageCollector = null;
        this.manager = null;
        P4ObjectBroker.broker = null;
    }

    public Repliable getRepliable(String _connectionType, ConnectionProfile[] _profiles, StubBaseInfo _info) throws P4IOException {
        Connection repl = null;
        if (_info.getIncomingProfile() != null) {
            StringTokenizer tokenizer = new StringTokenizer(_info.getIncomingProfile(), ":");
            try {
                tokenizer.nextToken();
                repl = this.manager.getConnection(tokenizer.nextToken(), tokenizer.nextToken(), Integer.parseInt(tokenizer.nextToken()));
                return repl;
            }
            catch (NoSuchElementException nsee) {
                _info.setIncomingProfile(null);
            }
            catch (NumberFormatException nfe) {
                _info.setIncomingProfile(null);
            }
            catch (P4IOException p4ioe) {
                // empty catch block
            }
        }
        if (_profiles == null || _profiles.length == 0) {
            _profiles = this.initialProfiles;
        }
        int ii = 0;
        while (ii < _profiles.length) {
            repl = this.manager.takeConnection(_connectionType, _profiles[ii].getHost(), _profiles[ii].getPort());
            if (repl != null) {
                return repl;
            }
            ++ii;
        }
        int i = 0;
        while (i < _profiles.length) {
            try {
                if (_profiles[i].supplyType(_connectionType)) {
                    repl = this.manager.getConnection(_connectionType, _profiles[i].getHost(), _profiles[i].getPort());
                    return repl;
                }
            }
            catch (Exception _) {
                this.log("WARNING: Can't make connection:" + _profiles[i]);
            }
            ++i;
        }
        this.log("WARNING: Reload Connection profiles.");
        _profiles = this.initialProfiles;
        int i2 = 0;
        while (i2 < _profiles.length) {
            try {
                if (_profiles[i2].supplyType(_connectionType)) {
                    repl = this.manager.getConnection(_connectionType, _profiles[i2].getHost(), _profiles[i2].getPort());
                    return repl;
                }
            }
            catch (Exception _) {
                this.log("WARNING: Can't make connection:" + _profiles[i2]);
            }
            ++i2;
        }
        throw (P4IOException)P4ObjectBroker.broker.getException(0, P4BaseIOException.Cannot_Make_Connection, null);
    }

    public synchronized void postInit() {
        this.manager = ConnectionManager.getManager(this);
    }

    public void postInit(int sPort) {
        this.manager = ConnectionManager.getManager(this, sPort);
    }

    public void postInit(Properties prop) {
    }

    public int getId() {
        return -1;
    }

    public int getPort() throws IOException {
        return this.manager.port;
    }

    public String getHost() throws IOException {
        return this.manager.hostNameIP;
    }

    public ConnectionProfile[] getConnectionProfiles() {
        try {
            ConnectionProfile[] toReturn = new ConnectionProfile[]{new ConnectionProfile(P4ObjectBroker.transportType, this.getHost(), this.getPort())};
            return toReturn;
        }
        catch (Exception ex) {
            this.log(ex, "011721");
            this.log("ERROR: Unexpected exception:" + ex.getMessage());
            return null;
        }
    }

    public void runGarbageCollector() {
        this.garbageCollector = new Thread(new GarbageCollector(this.objManager));
        this.garbageCollector.setDaemon(true);
        this.garbageCollector.start();
    }

    public Object getCrossInterface() {
        return null;
    }

    public P4RemoteObject loadObject(Remote obj) throws ClassNotFoundException {
        if (obj instanceof P4RemoteObject) {
            return (P4RemoteObject)((Object)obj);
        }
        P4RemoteObject retObj = null;
        Class<?> remoteClass = obj.getClass();
        String remoteClassName = remoteClass.getName();
        remoteClassName = remoteClassName + "p4_Skel";
        Class skeletonClass = null;
        try {
            skeletonClass = Class.forName(remoteClassName, true, remoteClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                skeletonClass = this.getParentSkel(remoteClass, "p4_Skel");
            }
            catch (Exception ex) {
                this.log("Skeleton class not found for:" + remoteClassName);
            }
        }
        try {
            try {
                retObj = (P4RemoteObject)skeletonClass.newInstance();
            }
            catch (Exception ex) {
                this.log("Skeleton class not found and try to instantiate Dynamic Skeleton");
                retObj = new P4DynamicSkeleton(obj);
            }
            retObj.setDelegate(obj);
            return retObj;
        }
        catch (Exception ie) {
            throw new ClassNotFoundException(remoteClass.getName() + " : InstantiationException: " + ie.getMessage());
        }
    }

    public String getTicket(StubBaseInfo info) {
        try {
            ContextObject co = this.getCTC().getContextObject("security");
            if (co == null || !(co instanceof TransferableExt)) {
                return null;
            }
            TransferableExt trans = (TransferableExt)((Object)co);
            if (trans != null) {
                byte[] result = null;
                result = new byte[trans.size(new Integer(info.ownerId))];
                trans.store(new Integer(info.ownerId), result, 0);
                BigInteger big = new BigInteger(1, result);
                return big.toString(16);
            }
        }
        catch (Exception e) {
            this.trace(class$com$sap$engine$services$rmi_p4$P4ObjectBrokerClientImpl == null ? (class$com$sap$engine$services$rmi_p4$P4ObjectBrokerClientImpl = P4ObjectBrokerClientImpl.class$("com.sap.engine.services.rmi_p4.P4ObjectBrokerClientImpl")) : class$com$sap$engine$services$rmi_p4$P4ObjectBrokerClientImpl, e, "getTicket", 100);
        }
        return null;
    }

    public ClassLoader getClassLoader(Object obj, Class cl) {
        if (!P4ObjectBroker.USE_P4_REMOTE_CLASSLOADING) {
            P4ObjectBroker.broker.trace(class$com$sap$engine$services$rmi_p4$P4ObjectBrokerClientImpl == null ? (class$com$sap$engine$services$rmi_p4$P4ObjectBrokerClientImpl = P4ObjectBrokerClientImpl.class$("com.sap.engine.services.rmi_p4.P4ObjectBrokerClientImpl")) : class$com$sap$engine$services$rmi_p4$P4ObjectBrokerClientImpl, "unset using remote classloading", "getClassLoader(object,class)", 100);
            return super.getClassLoader(obj, cl);
        }
        P4URLLoader urlLoader = (P4URLLoader)this.weaks.get(cl);
        if (urlLoader != null) {
            return urlLoader;
        }
        StubBaseInfo info = null;
        if (obj instanceof StubImpl) {
            info = ((StubImpl)obj).p4_getInfo();
        } else if (obj instanceof StubBaseInfo) {
            info = (StubBaseInfo)obj;
        }
        String[] urlList = info.urls;
        String[] hostss = info.hosts;
        if (urlList != null && hostss != null) {
            String ticket = "";
            if (urlList[0].indexOf("@download@") > 0) {
                ticket = this.getTicket(info);
                if (ticket == null || ticket == "") {
                    return cl.getClassLoader();
                }
                ticket = TICKET + ticket;
            }
            URL[] urls = new URL[urlList.length * hostss.length];
            int y = 0;
            int i = 0;
            while (i < urlList.length) {
                int k = 0;
                while (k < hostss.length) {
                    try {
                        urls[y++] = new URL(hostss[k] + urlList[i] + ticket);
                    }
                    catch (MalformedURLException muf) {
                        this.trace((Exception)muf, "0117261");
                    }
                    ++k;
                }
                ++i;
            }
            urlLoader = new P4URLLoader(urls, cl.getClassLoader());
            this.weaks.put(cl, urlLoader);
            return urlLoader;
        }
        return cl.getClassLoader();
    }

    public ClassLoader getClassLoader(Object obj, Class cl, ClassLoader cLoader) {
        if (!P4ObjectBroker.USE_P4_REMOTE_CLASSLOADING) {
            P4ObjectBroker.broker.trace(class$com$sap$engine$services$rmi_p4$P4ObjectBrokerClientImpl == null ? (class$com$sap$engine$services$rmi_p4$P4ObjectBrokerClientImpl = P4ObjectBrokerClientImpl.class$("com.sap.engine.services.rmi_p4.P4ObjectBrokerClientImpl")) : class$com$sap$engine$services$rmi_p4$P4ObjectBrokerClientImpl, "unset using remote classloading", "getClassLoader(object,class,classloader)", 100);
            return super.getClassLoader(obj, cl, cLoader);
        }
        StubBaseInfo info = null;
        if (obj instanceof StubImpl) {
            info = ((StubImpl)obj).p4_getInfo();
        } else if (obj instanceof StubBaseInfo) {
            info = (StubBaseInfo)obj;
        }
        if (System.getProperty("P4ClassLoad", "").equals("P4Connection")) {
            return ClassLoaderContext.getDynamicLoader(info.ownerId);
        }
        P4URLLoader urlLoader = (P4URLLoader)this.weaks.get(cl);
        if (urlLoader != null) {
            return urlLoader;
        }
        String[] urlList = info.urls;
        String[] hostss = info.hosts;
        if (urlList != null && hostss != null && urlList.length > 0) {
            String ticket = "";
            if (urlList[0].indexOf("@download@") > 0) {
                ticket = this.getTicket(info);
                if (ticket == null || ticket == "") {
                    return cl.getClassLoader();
                }
                ticket = TICKET + ticket;
            }
            URL[] urls = new URL[urlList.length * hostss.length];
            int y = 0;
            int i = 0;
            while (i < urlList.length) {
                int k = 0;
                while (k < hostss.length) {
                    try {
                        urls[y++] = new URL(hostss[k] + urlList[i] + ticket);
                    }
                    catch (MalformedURLException muf) {
                        this.log((Exception)muf, "0117261");
                    }
                    ++k;
                }
                ++i;
            }
            if ((class$com$sap$engine$services$rmi_p4$P4URLLoader == null ? (class$com$sap$engine$services$rmi_p4$P4URLLoader = P4ObjectBrokerClientImpl.class$("com.sap.engine.services.rmi_p4.P4URLLoader")) : class$com$sap$engine$services$rmi_p4$P4URLLoader).isAssignableFrom(cLoader.getClass())) {
                ((P4URLLoader)cLoader).addMissedURLs(urls);
                return cLoader;
            }
            urlLoader = new P4URLLoader(urls, cLoader);
            this.weaks.put(cl, urlLoader);
            return urlLoader;
        }
        return cLoader;
    }

    public ClientThreadContext getCTC() {
        try {
            return ClientFactory.getThreadContextFactory().getThreadContext();
        }
        catch (ClientException e) {
            return null;
        }
    }

    public void log(Exception ex) {
        if (P4ObjectBroker.debug) {
            ex.printStackTrace();
        }
    }

    public void log(String message) {
        if (P4ObjectBroker.debug) {
            System.out.println("P4:" + Thread.currentThread() + ": \n" + message);
        }
    }

    public void trace(String message) {
        if (P4ObjectBroker.debug) {
            System.out.println("P4:" + Thread.currentThread() + ": \n" + message);
        }
    }

    public void trace(Throwable er) {
        if (P4ObjectBroker.debug) {
            er.printStackTrace();
        }
    }

    public void log(Exception ex, String id) {
        if (P4ObjectBroker.debug) {
            System.out.println("P4:" + Thread.currentThread() + ": Error log: ");
            ex.printStackTrace(System.err);
        }
    }

    public void trace(Exception ex, String id) {
        if (P4ObjectBroker.debug) {
            System.out.println("P4:" + Thread.currentThread() + ": Error log: ");
            ex.printStackTrace(System.err);
        }
    }

    public void trace(Exception ex) {
        if (P4ObjectBroker.debug) {
            System.out.println("P4:" + Thread.currentThread() + ": Error log: ");
            ex.printStackTrace(System.err);
        }
    }

    public void log(Class cl, String message, String methodName, int idSev) {
        this.log(message);
    }

    public void log(Class cl, Exception ex, String id, String methodName, int idSev) {
        this.log(ex, id);
    }

    public void log(Class cl, Exception ex, String methodName, int idSev) {
        this.log(ex);
    }

    public void log(Exception ex, boolean d) {
        this.log(ex);
    }

    public void log(String message, boolean d) {
        this.log(message);
    }

    public void log(Exception ex, boolean d, String id) {
        this.log(ex, id);
    }

    public void trace(Exception ex, boolean d, String id) {
        this.trace(ex, id);
    }

    public void trace(Exception ex, boolean d) {
        this.trace(ex);
    }

    public void log(Class cl, String message, boolean d, String methodName, int idSev) {
        this.log(message);
    }

    public void log(Class cl, Exception ex, boolean d, String id, String methodName, int idSev) {
        this.log(ex, id);
    }

    public void log(Class cl, Exception ex, boolean d, String methodName, int idSev) {
        this.log(ex);
    }

    public void trace(Class cl, String message, String methodName, int IdSer) {
        if (P4ObjectBroker.debug) {
            System.out.println("P4:" + Thread.currentThread() + ": \n" + " ID:" + this.id + " CLASS : " + cl + " : method : " + methodName + " : message : " + message);
        }
    }

    public void trace(Class cl, Throwable er, String methodName, int IdSer) {
        if (P4ObjectBroker.debug) {
            System.out.println("P4:" + Thread.currentThread() + ": \n" + "CLASS : " + cl + " : method : " + methodName + " : message : " + er.getMessage());
            er.printStackTrace();
        }
    }

    public void trace(Class cl, Exception ex, String methodName, int IdSer) {
        if (P4ObjectBroker.debug) {
            System.out.println("P4:" + Thread.currentThread() + ": \n" + "CLASS : " + cl + " : method : " + methodName + " : message : " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void trace(Class cl, Exception ex, String id, String methodName, int IdSer) {
        if (P4ObjectBroker.debug) {
            System.out.println("P4:" + Thread.currentThread() + ": \n" + " ID:" + id + " CLASS : " + cl + " : method : " + methodName + " : message : " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void setExecContextState(Object o) {
    }

    public Object applyExecContextState(Object pro) {
        return null;
    }

    public void setExecContext(Object o) {
    }

    public void setResourceBundle(String bundlename, Locale l) {
        this.rb = ResourceBundle.getBundle(bundlename, l, this.getClass().getClassLoader());
    }

    public String getBundleMessage(String key) {
        String msg = "";
        if (this.rb == null) {
            this.setResourceBundle("com.sap.engine.services.rmi_p4.exception.P4ResourceBundle", Locale.getDefault());
        }
        if (this.rb != null) {
            msg = this.rb.getString(key);
        }
        return msg;
    }

    public Exception getException(int type, String msgText, Throwable th) {
        return this.getException(type, msgText, th, null);
    }

    public Exception getException(int type, String msgText, Throwable th, Object[] args) {
        if (msgText.startsWith("p4_")) {
            msgText = this.getBundleMessage(msgText);
        }
        switch (type) {
            case 0: {
                return new P4IOException(msgText, th, args);
            }
            case 2: {
                return new P4ConnectionException(msgText, th, args);
            }
            case 3: {
                return new InitializingException(msgText, th, args);
            }
            case 4: {
                return new MarshalException(msgText, th, args);
            }
            case 5: {
                return new P4ParseRequestException(msgText);
            }
        }
        return new P4RuntimeException(msgText, th, args);
    }

    public ConnectionObject[] listConnections() {
        ConnectionObject[] result = null;
        Hashtable allCons = this.manager.connections;
        result = new ConnectionObject[allCons.size()];
        Enumeration cons = allCons.elements();
        int index = 0;
        while (cons.hasMoreElements()) {
            Connection c = (Connection)cons.nextElement();
            int ind = 0;
            boolean ok = false;
            while (!ok) {
                try {
                    Integer.parseInt("" + c.connectionId.charAt(ind));
                    ok = true;
                }
                catch (Exception e) {
                    ++ind;
                }
            }
            result[index] = ind < 3 ? new ConnectionObject(c.isAlive(), "None", c.host, c.port, -1, -1) : new ConnectionObject(c.isAlive(), c.connectionId.substring(0, ind - 1), c.host, c.port, -1, -1);
            ++index;
        }
        return result;
    }

    public boolean isServerBroker() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

