/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.Call;
import com.sap.engine.services.rmi_p4.Connection;
import com.sap.engine.services.rmi_p4.InitializingException;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.NoSuchObjectException;
import com.sap.engine.services.rmi_p4.ObjectManager;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.P4RemoteObjectInfo;
import com.sap.engine.services.rmi_p4.P4RuntimeException;
import com.sap.engine.services.rmi_p4.RemoteObjectInfo;
import com.sap.engine.services.rmi_p4.RemoteRef;
import com.sap.engine.services.rmi_p4.Repliable;
import com.sap.engine.services.rmi_p4.Skeleton;
import com.sap.engine.services.rmi_p4.StubBaseImpl;
import com.sap.engine.services.rmi_p4.StubBaseInfo;
import com.sap.engine.services.rmi_p4.StubImpl;
import com.sap.engine.services.rmi_p4.all.ConnectionProfile;
import com.sap.engine.services.rmi_p4.classload.DynamicClassLoader;
import com.sap.engine.services.rmi_p4.exception.P4ExceptionConstants;
import com.sap.engine.services.rmi_p4.monitor.ConnectionObject;
import com.sap.engine.services.rmi_p4.monitor.P4MonitorClient;
import com.sap.engine.services.rmi_p4.monitor.P4MonitorInterface;
import com.sap.engine.services.rmi_p4.monitor.P4MonitorServer;
import com.sap.engine.services.rmi_p4.reflect.P4InvocationHandler;
import com.sap.engine.services.rmi_p4.server.P4ServerObjectInfo;
import com.sap.engine.services.rmi_p4.server.P4ServiceFrame;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public abstract class P4ObjectBroker
implements P4ExceptionConstants {
    public static boolean debug = SystemProperties.getBoolean("debug");
    public static final String CALL_TIMEOUT = "CallTimeout";
    public static final String TRANSPORT_TYPE = "TransportLayerQueue";
    public static final String SERVER_SOCKET_PORT = "SocketPort";
    public static final String CLIENT_BROKER_CLASS = "com.sap.engine.services.rmi_p4.P4ObjectBrokerClientImpl";
    public static final String SERVER_BROKER_CLASS = "com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl";
    private static final String PORTABLE_REMOTE_OBJECT_CLASS = "javax.rmi.CORBA.PortableRemoteObjectClass";
    private static final String IDENTITY = "com.sap.engine.system.";
    public static final String P4_CLASSLOADING = "sap.p4.remote_classloading";
    public static boolean USE_P4_REMOTE_CLASSLOADING = true;
    public static final String SECURITY_CO = "security";
    public static final String SERVICE_ALIAS = "@download@";
    public static final String EMPTY_STRING = "";
    protected static final byte[] PROTOCOL_VERSION = new byte[]{118, 49};
    public static final String INITIALIZE_CONNECTION_TIMEOUT = "InitializeConnectionTimeout";
    public static final String RUNTIME_CONNECTION_TIMEOUT = "RuntimeConnectionTimeout";
    public static final String ENABLE_NAT = "EnableNAT";
    public static final String DEFAULT_COMMUNICATION_LAYER = "None";
    public static String transportType = "None";
    public static Properties props = null;
    protected static P4ObjectBroker broker;
    public Hashtable impls = new Hashtable();
    public Hashtable initObjects = new Hashtable();
    protected Hashtable redirectableObjects = new Hashtable();
    public ObjectManager objManager = new ObjectManager(128);
    public int brokerId;
    public int id;
    public boolean useReiterationOfGC = false;
    public ConnectionProfile[] initialProfiles = null;
    protected WeakHashMap weaks = new WeakHashMap();
    public static P4MonitorInterface p4Monitor;
    public static boolean enableNAT;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$P4ObjectBroker;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$RemoteRef;

    public static P4ObjectBroker getBroker() {
        return broker;
    }

    public static P4ObjectBroker init() {
        return P4ObjectBroker.init(null);
    }

    public static P4ObjectBroker init(Properties env) throws InitializingException {
        if (P4ServiceFrame.isP4Stopped) {
            throw new InitializingException("P4 Service is stopped and cannot make broker.init() ");
        }
        if (broker != null) {
            return broker;
        }
        P4ObjectBroker br = P4ObjectBroker.loadInstance(env);
        p4Monitor = P4ObjectBroker.getImplName().equals(CLIENT_BROKER_CLASS) ? new P4MonitorClient(br) : new P4MonitorServer(br);
        return broker;
    }

    public P4MonitorInterface getMonitor() {
        return p4Monitor;
    }

    private static synchronized P4ObjectBroker loadInstance(Properties env) {
        if (broker != null) {
            return broker;
        }
        String serverPort = null;
        if (env != null) {
            props = env;
            String callTimeOut = env.getProperty(CALL_TIMEOUT);
            String transport = env.getProperty(TRANSPORT_TYPE);
            serverPort = env.getProperty(SERVER_SOCKET_PORT);
            String use_p4_remoteCL = env.getProperty(P4_CLASSLOADING);
            String connTimeOut = env.getProperty(INITIALIZE_CONNECTION_TIMEOUT);
            String runtimeTimeOut = env.getProperty(RUNTIME_CONNECTION_TIMEOUT);
            String natEnabled = env.getProperty(ENABLE_NAT);
            try {
                if (callTimeOut != null) {
                    Call.TIMEOUT = Integer.parseInt(callTimeOut);
                }
                if (connTimeOut != null) {
                    Connection.INITIALIZE_CONNECTION_TIMEOUT = Integer.parseInt(connTimeOut);
                }
                if (runtimeTimeOut != null) {
                    Connection.RUNTIME_CONNECTION_TIMEOUT = Integer.parseInt(runtimeTimeOut);
                }
                if (use_p4_remoteCL != null) {
                    USE_P4_REMOTE_CLASSLOADING = Boolean.getBoolean(use_p4_remoteCL);
                }
                if (natEnabled != null && natEnabled.equals("false")) {
                    enableNAT = false;
                }
            }
            catch (Exception ex) {
                throw new InitializingException(ex.getMessage() + "\nID 011710 : IllegalValue in Properties", ex);
            }
            transportType = transport != null && !transport.trim().equals(EMPTY_STRING) ? transport : DEFAULT_COMMUNICATION_LAYER;
        }
        Class<?> _class = null;
        try {
            _class = Class.forName(P4ObjectBroker.getImplName());
        }
        catch (Exception e1) {
            throw new InitializingException(e1.getMessage() + "\nID 011711 : Implementation of ObjectBroker NotFound!:", e1);
        }
        try {
            broker = (P4ObjectBroker)_class.newInstance();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new InitializingException(e2.getMessage() + "\nID 011712 : Can't instantiate P4ObjectBroker!:", e2);
        }
        P4ObjectBroker.broker.id = broker.getId();
        try {
            broker.postInit(serverPort != null && serverPort.length() != 0 ? Integer.parseInt(serverPort) : 0);
        }
        catch (Exception e3) {
            throw new InitializingException(e3.getMessage() + "\nID 011713 : IllegalValue in Properties", e3);
        }
        return broker;
    }

    public static String getImplName() {
        String name = System.getProperty(PORTABLE_REMOTE_OBJECT_CLASS);
        if (name != null && name.startsWith(IDENTITY)) {
            return SERVER_BROKER_CLASS;
        }
        return CLIENT_BROKER_CLASS;
    }

    protected P4ObjectBroker() {
        this.brokerId = (int)System.currentTimeMillis();
        this.postInit();
        this.objManager = new ObjectManager(128);
        this.runGarbageCollector();
    }

    protected Class getParentSkel(Class c, String suff) throws Exception {
        Class parent = c;
        Class<?> skel = null;
        while (skel == null) {
            if (!(class$java$rmi$Remote == null ? P4ObjectBroker.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(parent)) {
                throw new Exception(parent.getName() + " didn't implement or inherit java.rmi.Remote");
            }
            try {
                skel = parent.getClassLoader().loadClass(parent.getName() + suff);
            }
            catch (ClassNotFoundException e) {
                parent = parent.getSuperclass();
            }
        }
        return skel;
    }

    public void connect(P4RemoteObject obj) {
        P4RemoteObjectInfo info = (P4RemoteObjectInfo)obj.getObjectInfo();
        if (info != null) {
            return;
        }
        info = this.getObjectInfo();
        info.protocol_id = PROTOCOL_VERSION;
        info.server_id = this.id;
        info.local_id = this.id;
        info.ownerId = this.brokerId;
        obj.setInfo(info);
        info.key = this.objManager.storeObject(obj);
        Skeleton skel = null;
        if (obj instanceof Skeleton) {
            skel = (Skeleton)((Object)obj);
        } else {
            Class _class = obj.getClass();
            try {
                _class = this.getParentSkel(obj.getClass(), "_Skel");
            }
            catch (Exception cnfex) {
                this.trace(class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : class$com$sap$engine$services$rmi_p4$P4ObjectBroker, cnfex, "connect", 100);
                this.trace(class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : class$com$sap$engine$services$rmi_p4$P4ObjectBroker, "Error loading Skeleton clags for " + obj + " in P4ObjectBroker.connect().\n Object is not accessible through rmi_p4.", "connect", 100);
                return;
            }
            try {
                skel = (Skeleton)_class.newInstance();
            }
            catch (Exception ex) {
                this.trace(class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : class$com$sap$engine$services$rmi_p4$P4ObjectBroker, ex, "connect", 100);
                this.trace(class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : class$com$sap$engine$services$rmi_p4$P4ObjectBroker, "Error instantiate skeleton: " + _class + " in P4ObjectBroker.connect().\n Object is not accessible through rmi_p4.", "connect", 100);
                return;
            }
        }
        info.skeleton = skel;
        info.stubs = info.skeleton.getImplemntsObjects();
        obj.setConnected();
    }

    public void disconnect(P4RemoteObject object) {
        object.setDisconnected();
        if (this.objManager != null) {
            this.objManager.deleteObject(object);
        }
    }

    public void setInitialObject(String name, P4RemoteObject initObject) throws Exception {
        this.initObjects.put(name, initObject);
    }

    public byte[] getInitialObject(String name) throws RemoteException {
        if (this.initObjects.containsKey(name)) {
            P4RemoteObject initObject = (P4RemoteObject)this.initObjects.get(name);
            RemoteObjectInfo info = initObject.getObjectInfo();
            info.connectionProfiles = this.getConnectionProfiles();
            byte[] r = this.makeObjectRef(info.connectionProfiles, info.server_id, info.key);
            return r;
        }
        throw new NoSuchObjectException("ID:011781: Object:<" + name + ">");
    }

    public byte[] objectToByteArr(P4RemoteObject _obj) {
        RemoteObjectInfo info = _obj.getObjectInfo();
        info.connectionProfiles = this.getConnectionProfiles();
        return this.makeObjectRef(info.connectionProfiles, info.server_id, info.key);
    }

    public StubBaseInfo byteArrayToObject(byte[] objectRef) {
        StubBaseInfo info = new StubBaseInfo();
        byte[] _objectRef = objectRef;
        info.server_id = this.serverIdFromRef(_objectRef);
        info.local_id = this.id;
        info.ownerId = this.ownerIdFromRef(_objectRef);
        info.key = this.objectKeyFromRef(_objectRef);
        info.connectionProfiles = this.connectionProfileFromRef(_objectRef);
        info.client_id = -1;
        return info;
    }

    /*
     * WARNING - void declaration
     */
    public StubBaseInfo stringToObject(String objectRef) {
        if (objectRef.startsWith("clusteraloc")) {
            throw (P4RuntimeException)broker.getException(1, "p4_0018", null);
        }
        StringReader reader = new StringReader(objectRef);
        StringBuffer buffer = new StringBuffer(4);
        int k = 0;
        try {
            int value;
            int ch;
            reader.skip(4L);
            while ((ch = reader.read()) != -1) {
                void var4_5;
                if ((char)var4_5 != ' ') continue;
                ++k;
            }
            reader.reset();
            reader.skip(5L);
            byte[] ref = new byte[k];
            k = 0;
            while ((ch = reader.read()) != -1 && k < ref.length) {
                if ((char)ch != ' ') {
                    buffer.append((char)ch);
                    continue;
                }
                value = Integer.parseInt(buffer.toString());
                ref[k] = (byte)value;
                ++k;
                buffer.delete(0, 4);
            }
            value = Integer.parseInt(buffer.toString());
            ref[k] = (byte)value;
            buffer.delete(0, 4);
            return this.byteArrayToObject(ref);
        }
        catch (IOException ioe) {
            this.trace(class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : class$com$sap$engine$services$rmi_p4$P4ObjectBroker, ioe, "stringToObject", 100);
            return null;
        }
    }

    public String objectToString(P4RemoteObject obj) {
        RemoteObjectInfo info = obj.getObjectInfo();
        info.connectionProfiles = this.getConnectionProfiles();
        byte[] ref = this.makeObjectRef(info.connectionProfiles, info.server_id, info.key);
        return this.makeStringIOR(ref);
    }

    public String makeStringIOR(byte[] _ref) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IOR:");
        int i = 0;
        while (i < _ref.length) {
            stringBuffer.append(" ");
            stringBuffer.append(_ref[i]);
            ++i;
        }
        return stringBuffer.toString();
    }

    public Object narrow(Object info, Class stubClass) {
        return this.narrow(info, stubClass, transportType);
    }

    public Object narrow(Object info, Class stubClass, String _connectionType) {
        return this.narrow(info, stubClass, _connectionType, stubClass.getClassLoader());
    }

    /*
     * Unable to fully structure code
     */
    public Object narrow(Object info, Class stubClass, String _connectionType, ClassLoader cLoader) {
        _info = null;
        if (info instanceof StubImpl) {
            _info = ((StubImpl)info).p4_getInfo();
        } else if (info instanceof StubBaseInfo) {
            _info = (StubBaseInfo)info;
        } else if (info instanceof P4ServerObjectInfo) {
            _info = StubBaseInfo.makeStubBaseInfo((RemoteObjectInfo)info);
        }
        if (stubClass.isAssignableFrom(info.getClass())) {
            if (_info != null && !_info.connected) {
                try {
                    this.makeConnection(_connectionType, (StubImpl)info);
                    ((StubImpl)info).p4_setClassLoader(this.getClassLoader(info, stubClass, cLoader));
                }
                catch (Exception ex) {
                    this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, ex, "narrow", 100);
                    this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, "Error making connection in P4ObjectBroker.narrow().\n Stub instance <" + info + "> is not connected.", "narrow", 100);
                }
            }
            return info;
        }
        if (_info == null) {
            this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, "P4ObjectBroker can't narrow <" + info + "> to <" + stubClass + ".", "narrow", 100);
            return info;
        }
        if (_info.stubs == null) {
            _info.stubs = new String[1];
            _info.stubs[0] = stubClass.getName();
        }
        _info.local_id = this.id;
        ret = null;
        _class = null;
        if (stubClass.isInterface()) {
            block27: {
                name = stubClass.getName();
                urlcl = this.getClassLoader(info, stubClass, cLoader);
                if (urlcl instanceof DynamicClassLoader && !((DynamicClassLoader)urlcl).isPrepared()) {
                    dynStub = new StubBaseImpl();
                    dynStub.p4_setInfo(_info);
                    dynStub.setClassLoader(urlcl);
                    dynStub.setConnectionType(_connectionType);
                    try {
                        dynStub.setRepliaror(this.getRepliable(_connectionType, dynStub.p4_getInfo().connectionProfiles, dynStub.p4_getInfo()));
                    }
                    catch (P4IOException io) {
                        this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, io, "narrow", 100);
                        this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, "Error loadin stub class: " + name + " in P4ObjectBroker.narrow().\n ClassNotFoundException.", "narrow", 100);
                    }
                    ((DynamicClassLoader)urlcl).setStubContext(dynStub);
                }
                try {
                    _class = urlcl == null ? Class.forName(name + "_Stub") : urlcl.loadClass(name + "_Stub");
                    break block27;
                }
                catch (ClassNotFoundException cnfex) {
                    this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, cnfex, "narrow", 100);
                    base = new StubBaseImpl();
                    base.p4_setInfo(_info);
                    base.p4_setClassLoader(urlcl);
                    base.p4_setConnectionType(_connectionType);
                    try {
                        base.p4_setRepliaror(this.getRepliable(_connectionType, base.p4_getInfo().connectionProfiles, base.p4_getInfo()));
                    }
                    catch (P4IOException io) {
                        this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, io, "narrow", 100);
                        this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, "Error loading stub class: " + name + " in P4ObjectBroker.narrow().\n ClassNotFoundException.", "narrow", 100);
                        return ret;
                    }
                    p4Handler = new P4InvocationHandler();
                    p4Handler.setInfo(base);
                    cl = new Class[_info.stubs.length + 1];
                    failedLoad = 0;
                    i = 0;
                    ** while (i < _info.stubs.length)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        cl[failedLoad] = urlcl.loadClass(_info.stubs[i]);
                        ++failedLoad;
                    }
                    catch (ClassNotFoundException notFound) {
                        // empty catch block
                    }
                    ++i;
                    continue;
                }
lbl74:
                // 1 sources

                if (_info.stubs.length > failedLoad) {
                    temp = cl;
                    cl = new Class[failedLoad + 1];
                    System.arraycopy(temp, 0, cl, 0, failedLoad);
                }
                cl[cl.length - 1] = P4ObjectBroker.class$com$sap$engine$services$rmi_p4$RemoteRef == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$RemoteRef = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.RemoteRef")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$RemoteRef;
                proxy = Proxy.newProxyInstance(urlcl, cl, (InvocationHandler)p4Handler);
                return proxy;
            }
            try {
                ret = (StubImpl)_class.newInstance();
            }
            catch (Exception ex) {
                this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, ex, "narrow", 100);
                this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, "Error instantiate stub: " + _class + " in P4ObjectBroker.narrow().\n Stub instance is not accessible.", "narrow", 100);
            }
            ret.p4_setInfo(_info);
            ret.p4_setConnectionType(_connectionType);
            ret.p4_setClassLoader(urlcl);
            try {
                this.makeConnection(_connectionType, ret);
            }
            catch (Exception ex) {
                this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, ex, "narrow", 100);
                this.trace(P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker == null ? (P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker = P4ObjectBroker.class$("com.sap.engine.services.rmi_p4.P4ObjectBroker")) : P4ObjectBroker.class$com$sap$engine$services$rmi_p4$P4ObjectBroker, "Error making connection in P4ObjectBroker.narrow().\n Stub instance <" + ret + "> is not connected.", "narrow", 100);
            }
        }
        return ret;
    }

    public void makeConnection(String _connType, StubImpl _stub) throws P4IOException {
        Repliable repl = this.getRepliable(_connType, _stub.p4_getInfo().connectionProfiles, _stub.p4_getInfo());
        _stub.p4_setRepliaror(repl);
    }

    public P4RemoteObject getObject(byte[] obj_key) {
        return this.objManager.getObject(obj_key);
    }

    public void addLink(byte[] _key) {
        this.objManager.addLink(_key);
    }

    protected byte[] makeObjectRef(ConnectionProfile[] profiles, int _server_id, byte[] _key) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < profiles.length) {
            buffer.append(profiles[i].toString());
            if (i < profiles.length - 1) {
                buffer.append(":");
            }
            ++i;
        }
        int buffLength = buffer.length();
        char[] charArr = new char[buffLength];
        buffer.getChars(0, buffLength, charArr, 0);
        int index = 0;
        byte[] ref = new byte[8 + _key.length + 2 * buffLength];
        Convert.writeIntToByteArr(ref, 0, _server_id);
        Convert.writeIntToByteArr(ref, 4, this.brokerId);
        System.arraycopy(_key, 0, ref, index += 8, _key.length);
        Convert.charArrToByteArr(ref, index += _key.length, charArr, 0, buffLength);
        return ref;
    }

    public int serverIdFromRef(byte[] ref) {
        return Convert.byteArrToInt(ref, 0);
    }

    public int ownerIdFromRef(byte[] ref) {
        return Convert.byteArrToInt(ref, 4);
    }

    public byte[] objectKeyFromRef(byte[] ref) {
        byte[] _key = new byte[12];
        System.arraycopy(ref, 8, _key, 0, _key.length);
        return _key;
    }

    protected synchronized ConnectionProfile[] connectionProfileFromRef(byte[] _ref) {
        int length = _ref.length - 20;
        char[] temp = Convert.byteArrToCharArr(_ref, 20, length / 2);
        StringTokenizer tokenizer = new StringTokenizer(new String(temp), ":");
        int count = tokenizer.countTokens() / 3;
        ConnectionProfile[] result = new ConnectionProfile[count];
        int i = 0;
        while (i < count) {
            result[i] = new ConnectionProfile(tokenizer.nextToken(), tokenizer.nextToken(), Integer.parseInt(tokenizer.nextToken()));
            ++i;
        }
        return result;
    }

    public ClassLoader getClassLoader(Object obj, Class s) {
        return s.getClassLoader();
    }

    public ClassLoader getClassLoader(Object obj, Class s, ClassLoader cl) {
        return cl;
    }

    public void redirectObject(Object target, Object supplier) {
        RemoteObjectInfo targetInf;
        RemoteObjectInfo suppInf;
        if (supplier instanceof RemoteRef) {
            suppInf = ((RemoteRef)supplier).getObjectInfo();
        } else if (supplier instanceof RemoteObjectInfo) {
            suppInf = (RemoteObjectInfo)supplier;
        } else {
            return;
        }
        if (target instanceof RemoteRef) {
            targetInf = ((RemoteRef)supplier).getObjectInfo();
        } else if (target instanceof RemoteObjectInfo) {
            targetInf = (RemoteObjectInfo)supplier;
        } else {
            return;
        }
        targetInf.connectionProfiles = suppInf.connectionProfiles;
    }

    public boolean NATEnabled() {
        return enableNAT;
    }

    public void setURLList(P4RemoteObject obj) {
    }

    public abstract ConnectionObject[] listConnections();

    public abstract String getHost() throws IOException;

    public abstract int getPort() throws IOException;

    public abstract Exception getException(int var1, String var2, Throwable var3);

    public abstract Exception getException(int var1, String var2, Throwable var3, Object[] var4);

    public abstract int getId();

    public abstract void postInit(Properties var1) throws InitializingException;

    public abstract void postInit();

    public abstract void postInit(int var1);

    public abstract void close();

    public abstract void runGarbageCollector();

    public abstract void disposeConnection(Object var1);

    public abstract void inform(Object var1, Message var2);

    public abstract ConnectionProfile[] getConnectionProfiles();

    public abstract P4RemoteObjectInfo getObjectInfo();

    public abstract P4RemoteObject loadObject(Remote var1) throws ClassNotFoundException;

    public abstract Object resolveInitialReference(String var1, String var2, int var3) throws Exception;

    public abstract Object resolveInitialReference(String var1, String var2, String var3, int var4) throws Exception;

    public abstract Object resolveInitialReference(String var1, String var2, String var3, int var4, int var5) throws Exception;

    public abstract Repliable getRepliable(String var1, ConnectionProfile[] var2, StubBaseInfo var3) throws P4IOException;

    public abstract Object getCrossInterface();

    public abstract void log(String var1, boolean var2);

    public abstract void log(Exception var1, boolean var2, String var3);

    public abstract void log(Exception var1, boolean var2);

    public abstract void log(Class var1, String var2, boolean var3, String var4, int var5);

    public abstract void log(Class var1, Exception var2, boolean var3, String var4, String var5, int var6);

    public abstract void log(Class var1, Exception var2, boolean var3, String var4, int var5);

    public abstract void log(String var1);

    public abstract void log(Exception var1, String var2);

    public abstract void trace(Class var1, String var2, String var3, int var4);

    public abstract void trace(Class var1, Throwable var2, String var3, int var4);

    public abstract void trace(Class var1, Exception var2, String var3, int var4);

    public abstract void trace(Class var1, Exception var2, String var3, String var4, int var5);

    public abstract void log(Exception var1);

    public abstract void log(Class var1, String var2, String var3, int var4);

    public abstract void log(Class var1, Exception var2, String var3, String var4, int var5);

    public abstract void log(Class var1, Exception var2, String var3, int var4);

    public abstract ClientThreadContext getCTC();

    public abstract void setExecContextState(Object var1);

    public abstract Object applyExecContextState(Object var1);

    public abstract void setExecContext(Object var1);

    public abstract boolean isServerBroker();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        p4Monitor = null;
        enableNAT = true;
    }
}

