/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.services.rmi_p4.Dispatch;
import com.sap.engine.services.rmi_p4.MarshalInputStream;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4ObjectInput;
import com.sap.engine.services.rmi_p4.P4ObjectOutput;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.Skeleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.server.Operation;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class P4DynamicSkeleton
extends P4RemoteObject
implements Skeleton,
Remote {
    private Operation[] operations = null;
    private String[] _implements = null;
    private Class[] remoteInterfaces = new Class[0];
    private Hashtable remoteMethods = new Hashtable();
    private Class remote_class = null;
    private Object impl;
    public P4ObjectBroker broker = P4ObjectBroker.init();
    static /* synthetic */ Class class$java$rmi$Remote;

    public P4DynamicSkeleton() {
    }

    public P4DynamicSkeleton(Object impl) {
        this.impl = impl;
        this.remote_class = impl.getClass();
        Vector temp_interfaces = new Vector();
        this.getRemoteInterfaces(this.remote_class, temp_interfaces);
        this.getRemoteMethods(temp_interfaces, this.remoteMethods);
        if (temp_interfaces.size() > 0) {
            this.remoteInterfaces = new Class[temp_interfaces.size()];
            temp_interfaces.copyInto(this.remoteInterfaces);
        }
        this._implements = new String[this.remoteInterfaces.length];
        int i = 0;
        while (i < this.remoteInterfaces.length) {
            this._implements[i] = this.remoteInterfaces[i].getName();
            ++i;
        }
        this.getObjectInfo().stubs = this._implements;
        Enumeration enumeration = this.remoteMethods.keys();
        this.operations = new Operation[this.remoteMethods.size()];
        int l = 0;
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.operations[l] = new Operation(key);
            ++l;
        }
    }

    public Operation[] getOperations() {
        return this.operations;
    }

    public String[] getImplemntsObjects() {
        if (this._implements == null) {
            return new String[0];
        }
        return this._implements;
    }

    private void getRemoteInterfaces(Class _target, Vector interfaceBuffer) {
        if (_target != null) {
            this.getRemoteInterfaces(_target.getSuperclass(), interfaceBuffer);
            Class<?>[] temp_interfaces = _target.getInterfaces();
            int k = 0;
            while (k < temp_interfaces.length) {
                this.update(temp_interfaces[k], interfaceBuffer);
                ++k;
            }
        }
    }

    public boolean update(Class _interface, Vector buffer) {
        if (!(class$java$rmi$Remote == null ? (class$java$rmi$Remote = P4DynamicSkeleton.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(_interface)) {
            return false;
        }
        int i = 0;
        while (i < buffer.size()) {
            if (_interface.isAssignableFrom((Class)buffer.elementAt(i))) {
                return false;
            }
            if (((Class)buffer.elementAt(i)).isAssignableFrom(_interface)) {
                buffer.removeElementAt(i--);
            }
            ++i;
        }
        buffer.addElement(_interface);
        return true;
    }

    public void getRemoteMethods(Vector _target, Hashtable methodBuffer) {
        int k = 0;
        while (k < _target.size()) {
            Method[] methods = ((Class)_target.elementAt(k)).getMethods();
            String methodName = "";
            int i = 0;
            while (i < methods.length) {
                if (!methods[i].getName().startsWith("<clinit>")) {
                    methodName = methods[i].toString();
                    methodName = methodName.substring(methodName.indexOf(40), methodName.lastIndexOf(41) + 1);
                    methodName = methods[i].getName() + methodName;
                    if (!methodBuffer.contains(methodName)) {
                        methodBuffer.put(methodName, methods[i]);
                    }
                }
                ++i;
            }
            ++k;
        }
    }

    public void dispatch(Remote remote, Dispatch call, int opnum) throws Exception {
        Object result;
        P4ObjectInput in = call.getInputStream();
        ((MarshalInputStream)in).setClassLoader(this.impl.getClass().getClassLoader());
        String methodName = this.operations[opnum].getOperation();
        Method method = null;
        method = (Method)this.remoteMethods.get(methodName);
        Class<?>[] mArgs = method.getParameterTypes();
        Object[] params = null;
        if (mArgs != null && mArgs.length > 0) {
            params = new Object[mArgs.length];
            int i = 0;
            while (i < mArgs.length) {
                if (mArgs[i].equals(Boolean.TYPE)) {
                    params[i] = new Boolean(in.readBoolean());
                } else if (mArgs[i].equals(Byte.TYPE)) {
                    params[i] = new Byte(in.readByte());
                } else if (mArgs[i].equals(Short.TYPE)) {
                    params[i] = new Short(in.readShort());
                } else if (mArgs[i].equals(Character.TYPE)) {
                    params[i] = new Character(in.readChar());
                } else if (mArgs[i].equals(Float.TYPE)) {
                    params[i] = new Float(in.readFloat());
                } else if (mArgs[i].equals(Integer.TYPE)) {
                    params[i] = new Integer(in.readInt());
                } else if (mArgs[i].equals(Double.TYPE)) {
                    params[i] = new Double(in.readDouble());
                } else if (mArgs[i].equals(Long.TYPE)) {
                    params[i] = new Long(in.readLong());
                } else {
                    params[i] = in.readObject();
                    if (params[i] != null && (class$java$rmi$Remote == null ? P4DynamicSkeleton.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(params[i].getClass())) {
                        params[i] = this.broker.narrow(params[i], mArgs[i]);
                    }
                }
                ++i;
            }
        }
        Class<?> returnType = method.getReturnType();
        try {
            result = method.invoke(this.impl, params);
        }
        catch (InvocationTargetException invEx) {
            if (invEx.getTargetException() instanceof Exception) {
                throw (Exception)invEx.getTargetException();
            }
            throw invEx;
        }
        P4ObjectOutput out = call.getOutputStream();
        if (returnType.getName().equals("void")) {
            return;
        }
        if (returnType.isPrimitive()) {
            if (returnType.equals(Boolean.TYPE)) {
                out.writeBoolean((Boolean)result);
            } else if (returnType.equals(Byte.TYPE)) {
                out.writeByte(((Byte)result).byteValue());
            } else if (returnType.equals(Short.TYPE)) {
                out.writeShort(((Short)result).shortValue());
            } else if (returnType.equals(Character.TYPE)) {
                out.writeChar(((Character)result).charValue());
            } else if (returnType.equals(Float.TYPE)) {
                out.writeFloat(((Float)result).floatValue());
            } else if (returnType.equals(Integer.TYPE)) {
                out.writeInt((Integer)result);
            } else if (returnType.equals(Double.TYPE)) {
                out.writeDouble((Double)result);
            } else if (returnType.equals(Long.TYPE)) {
                out.writeLong((Long)result);
            }
        } else {
            out.writeObject(result);
        }
        out.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

