/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.client.ClientException;
import com.sap.engine.frame.client.ClientFactory;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.TransferableExt;
import com.sap.engine.services.rmi_p4.MarshalInputStream;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4URLLoader;
import com.sap.engine.services.rmi_p4.classload.DynamicClassLoader;
import com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Hashtable;

public class P4ClassWrapper
implements Serializable {
    static final long serialVersionUID = -7663094581799919698L;
    public static final String EJBLOADER = "com.sap.engine.services.ejb.deploy.EJBLoader";
    public static final String APPLOADER = "com.sap.engine.services.deploy.server.ApplicationLoader";
    public static final String COMPONENTLOADER = "com.sap.engine.core.service630.container.ComponentClassLoader";
    public static final String FRAMELOADER = "com.sap.engine.boot.FrameClassLoader";
    public static final String P4_CLASSLOADING = "P4ClassLoad";
    public static final String P4_CONNECTION = "P4Connection";
    public static final String ALIAS = "@download@";
    public static final String DOWNLOAD_SERVICE_DIRS = "Bin Directory";
    public static final String DOWNLOAD_APPS_DIRS = "Applications Directory";
    public static final String HTTP_PREFIX = "http://";
    public static final String TICKET = "?ticket=";
    public static final String EMPTY_STRING = "";
    public static final String APPDIR = "apps";
    public static final String BINDIR = "bin";
    public static final String SECURITY_CO = "security";
    public static final String APP_DIR_SEP = File.separator + "apps" + File.separator;
    public static final String BIN_DIR_SEP = File.separator + "bin" + File.separator;
    public static final String APP_ALIAS_SEP = "@download@" + File.separator + "apps".toUpperCase() + File.separator;
    public static final String BIN_ALIAS_SEP = "@download@" + File.separator + "bin".toUpperCase() + File.separator;
    public static Hashtable hastLoader = new Hashtable();
    private String className = null;
    private transient Class cl = null;
    private String classLoaderName = null;
    private String[] urlList = null;
    private String[] hosts = null;
    private transient URL[] urls = null;
    private transient ClassLoader loader = null;
    private transient URLClassLoader urlLoader = null;
    private boolean isServer = false;
    private boolean isPrepared = false;
    transient P4ObjectBroker broker = null;
    private transient int remote_brokerId = -1;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$P4ClassWrapper;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$P4URLLoader;

    public P4ClassWrapper(Class cl) {
        if (cl != null) {
            this.cl = cl;
            this.className = cl.getName();
        }
    }

    private boolean isServer() {
        if (this.broker == null) {
            this.broker = P4ObjectBroker.init();
        }
        if ((class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl == null ? (class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl = P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.server.P4ObjectBrokerServerImpl")) : class$com$sap$engine$services$rmi_p4$server$P4ObjectBrokerServerImpl).isAssignableFrom(this.broker.getClass())) {
            this.isServer = true;
            this.hosts = ((P4ObjectBrokerServerImpl)this.broker).getHttp();
        } else {
            this.isServer = false;
        }
        return this.isServer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare() {
        block18: {
            block19: {
                try {
                    if (this.className == null || this.isPrepared || this.cl == null) break block18;
                    this.broker = P4ObjectBroker.init();
                    this.isServer();
                    this.loader = this.cl.getClassLoader();
                    if (this.loader == null) {
                        Object var10_1 = null;
                        this.isPrepared = true;
                        this.cl = null;
                        return;
                    }
                    String alias = EMPTY_STRING;
                    if (!this.isServer) break block18;
                    LoadContext lc = ((P4ObjectBrokerServerImpl)this.broker).sessionProcessor.serviceContext.getCoreContext().getLoadContext();
                    String[] allLoaders = null;
                    HashSet<String> allRes = new HashSet<String>();
                    String currentDir = EMPTY_STRING;
                    if (this.loader.getClass().getName().equals(EJBLOADER)) {
                        this.urlList = ((ReferencedLoader)this.loader.getParent()).getResourceNames();
                        allLoaders = lc.getReferences(((ReferencedLoader)this.loader.getParent()).getName());
                        alias = APP_ALIAS_SEP;
                        currentDir = SystemProperties.getProperty(DOWNLOAD_APPS_DIRS);
                    } else if (this.loader.getClass().getName().equals(APPLOADER)) {
                        this.urlList = ((ReferencedLoader)this.loader).getResourceNames();
                        allLoaders = lc.getReferences(((ReferencedLoader)this.loader).getName());
                        alias = APP_ALIAS_SEP;
                        currentDir = SystemProperties.getProperty(DOWNLOAD_APPS_DIRS);
                    } else if (this.loader.getClass().getName().equals(COMPONENTLOADER)) {
                        this.urlList = ((ReferencedLoader)this.loader).getResourceNames();
                        allLoaders = lc.getReferences(((ReferencedLoader)this.loader).getName());
                        alias = BIN_ALIAS_SEP;
                        currentDir = SystemProperties.getProperty(DOWNLOAD_SERVICE_DIRS);
                    } else if (this.loader.getClass().getName().equals(FRAMELOADER)) {
                        this.urlList = null;
                        break block19;
                    }
                    if (this.urlList != null) {
                        int i = 0;
                        while (i < this.urlList.length) {
                            if (this.urlList[i] != null) {
                                allRes.add(this.urlList[i]);
                            }
                            ++i;
                        }
                    }
                    if (allLoaders != null) {
                        this.addURLs(allRes, allLoaders, lc);
                    }
                    if (allRes == null) break block18;
                    String[] temp = ((AbstractCollection)allRes).toArray(new String[0]);
                    int i = 0;
                    while (true) {
                        if (i >= temp.length) {
                            this.urlList = ((AbstractCollection)allRes).toArray(new String[0]);
                            break block18;
                        }
                        if (temp[i] != null) {
                            String s = this.getLastUrl(temp[i], alias, currentDir);
                            if (s != null) {
                                allRes.add(s);
                            }
                            allRes.remove(temp[i]);
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_4 = null;
                    this.isPrepared = true;
                    this.cl = null;
                    throw throwable;
                }
            }
            Object var10_2 = null;
            this.isPrepared = true;
            this.cl = null;
            return;
        }
        Object var10_3 = null;
        this.isPrepared = true;
        this.cl = null;
    }

    private void addURLs(HashSet allRes, String[] allLoaders, LoadContext lc) {
        String[] tempRes = null;
        int j = 0;
        while (j < allLoaders.length) {
            tempRes = ((ReferencedLoader)lc.getClassLoader(allLoaders[j])).getResourceNames();
            if (tempRes != null) {
                int k = 0;
                while (k < tempRes.length) {
                    allRes.add(tempRes[k]);
                    ++k;
                }
            }
            ++j;
        }
    }

    public void setClassLoaderName(String loaderName) {
        this.classLoaderName = loaderName;
    }

    private String getLastUrl(String name, String alias, String dirs) {
        int ii;
        if (dirs == null || dirs.indexOf(".") != -1) {
            String string = name.indexOf(APPDIR) != -1 ? APP_DIR_SEP : (dirs = name.indexOf(BINDIR) != -1 ? BIN_DIR_SEP : null);
        }
        if (dirs != null && (ii = name.lastIndexOf(dirs)) != -1) {
            return "/" + alias + new String(name.substring(ii + dirs.length()));
        }
        return null;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (ois instanceof MarshalInputStream) {
            this.loader = ((MarshalInputStream)ois).getClassLoader();
        }
        this.loadClass();
    }

    private void loadClass() throws ClassNotFoundException {
        if (this.isServer() && this.classLoaderName != null && this.className != null) {
            try {
                this.cl = ((P4ObjectBrokerServerImpl)this.broker).sessionProcessor.serviceContext.getCoreContext().getLoadContext().getClassLoader(this.classLoaderName).loadClass(this.className);
                return;
            }
            catch (Throwable e) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$P4ClassWrapper == null ? (class$com$sap$engine$services$rmi_p4$P4ClassWrapper = P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.P4ClassWrapper")) : class$com$sap$engine$services$rmi_p4$P4ClassWrapper, "Try to load Class : " + this.className + " <> " + e.getMessage(), "loadClass", 100);
                this.broker.trace(class$com$sap$engine$services$rmi_p4$P4ClassWrapper == null ? (class$com$sap$engine$services$rmi_p4$P4ClassWrapper = P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.P4ClassWrapper")) : class$com$sap$engine$services$rmi_p4$P4ClassWrapper, e, "loadClass", 100);
            }
        }
        try {
            this.cl = this.loader == null ? Class.forName(this.className) : this.loader.loadClass(this.className);
        }
        catch (Throwable e) {
            this.broker.trace(class$com$sap$engine$services$rmi_p4$P4ClassWrapper == null ? (class$com$sap$engine$services$rmi_p4$P4ClassWrapper = P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.P4ClassWrapper")) : class$com$sap$engine$services$rmi_p4$P4ClassWrapper, "Try to load Class : " + this.className + " <> " + e.getMessage(), "loadClass", 100);
            this.broker.trace(class$com$sap$engine$services$rmi_p4$P4ClassWrapper == null ? (class$com$sap$engine$services$rmi_p4$P4ClassWrapper = P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.P4ClassWrapper")) : class$com$sap$engine$services$rmi_p4$P4ClassWrapper, e, "loadClass", 100);
        }
    }

    public String getTicket() {
        block5: {
            try {
                ContextObject co = ClientFactory.getThreadContextFactory().getThreadContext().getContextObject(SECURITY_CO);
                if (co == null || !(co instanceof TransferableExt)) {
                    return null;
                }
                TransferableExt trans = (TransferableExt)((Object)co);
                if (trans == null) break block5;
                byte[] result = null;
                try {
                    result = new byte[trans.size(new Integer(this.remote_brokerId))];
                    trans.store(new Integer(this.remote_brokerId), result, 0);
                }
                catch (Exception e) {
                    this.broker.trace(class$com$sap$engine$services$rmi_p4$P4ClassWrapper == null ? (class$com$sap$engine$services$rmi_p4$P4ClassWrapper = P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.P4ClassWrapper")) : class$com$sap$engine$services$rmi_p4$P4ClassWrapper, "cannot get security context object", "getTicket", 100);
                    this.broker.trace(class$com$sap$engine$services$rmi_p4$P4ClassWrapper == null ? (class$com$sap$engine$services$rmi_p4$P4ClassWrapper = P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.P4ClassWrapper")) : class$com$sap$engine$services$rmi_p4$P4ClassWrapper, e, "getTicket", 100);
                }
                BigInteger big = new BigInteger(1, result);
                return big.toString(16);
            }
            catch (ClientException e) {
                this.broker.trace(class$com$sap$engine$services$rmi_p4$P4ClassWrapper == null ? (class$com$sap$engine$services$rmi_p4$P4ClassWrapper = P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.P4ClassWrapper")) : class$com$sap$engine$services$rmi_p4$P4ClassWrapper, "cannot get ticket", "getTicket", 100);
                this.broker.trace(class$com$sap$engine$services$rmi_p4$P4ClassWrapper == null ? (class$com$sap$engine$services$rmi_p4$P4ClassWrapper = P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.P4ClassWrapper")) : class$com$sap$engine$services$rmi_p4$P4ClassWrapper, (Exception)((Object)e), "getTicket", 100);
                return null;
            }
        }
        return null;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Class getCarriedClass() throws ClassNotFoundException {
        if (this.className == null) {
            return null;
        }
        if (SystemProperties.getProperty(P4_CLASSLOADING, EMPTY_STRING).equals(P4_CONNECTION) && this.loader != null && this.loader instanceof DynamicClassLoader) {
            Class<?> c = this.loader.loadClass(this.className);
            return c;
        }
        if (this.urlList != null && this.hosts != null && this.urlList.length > 0) {
            String ticket = EMPTY_STRING;
            this.urls = new URL[this.urlList.length * this.hosts.length];
            if (this.urlList[0] != null && this.urlList[0].indexOf(ALIAS) > 0) {
                ticket = this.getTicket();
                ticket = ticket != null && !ticket.equals(EMPTY_STRING) ? TICKET + ticket : EMPTY_STRING;
            }
            int i = 0;
            while (i < this.urlList.length) {
                int j = 0;
                while (j < this.hosts.length) {
                    try {
                        if (this.urlList[i] != null) {
                            this.urls[i + j] = new URL(HTTP_PREFIX + this.hosts[j] + this.urlList[i] + ticket);
                        }
                    }
                    catch (MalformedURLException e) {
                        this.broker.trace(class$com$sap$engine$services$rmi_p4$P4ClassWrapper == null ? P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.P4ClassWrapper") : class$com$sap$engine$services$rmi_p4$P4ClassWrapper, e, "getCarriedClass", 100);
                    }
                    ++j;
                }
                ++i;
            }
            if ((class$com$sap$engine$services$rmi_p4$P4URLLoader == null ? (class$com$sap$engine$services$rmi_p4$P4URLLoader = P4ClassWrapper.class$("com.sap.engine.services.rmi_p4.P4URLLoader")) : class$com$sap$engine$services$rmi_p4$P4URLLoader).isAssignableFrom(this.loader.getClass())) {
                ((P4URLLoader)this.loader).addMissedURLs(this.urls);
            } else {
                this.urlLoader = new URLClassLoader(this.urls, this.loader);
            }
        }
        return this.loader != null ? this.loader.loadClass(this.className) : this.urlLoader.loadClass(this.className);
    }

    public void setURLList(String[] urlList) {
        this.urlList = urlList;
    }

    public ClassLoader getLoader() {
        return this.urlLoader;
    }

    public String[] getURLList() {
        return this.urlList;
    }

    public String getURL(int index) {
        return this.urlList[index];
    }

    public void setRemoteBrokerId(int remote_brokerId) {
        this.remote_brokerId = remote_brokerId;
    }

    public int getRemoteBrokerId() {
        return this.remote_brokerId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

