/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.Transferable;
import com.sap.engine.frame.core.thread.TransferableExt;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.Connection;
import com.sap.engine.services.rmi_p4.ContextObjectClassReceiver;
import com.sap.engine.services.rmi_p4.ObjectInfo;
import com.sap.engine.services.rmi_p4.P4ContextObject;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.StubBaseInfo;
import java.io.ByteArrayInputStream;

public class Message {
    private int offBody = 0;
    private boolean parsed = false;
    private int size;
    protected int lenTC;
    ByteArrayInputStream bais = null;
    private static boolean wait;
    public static final int CALL_REQUEST = 0;
    public static final int DISPATCH_REPLY = 1;
    public static final int DISPATCH_ERROR_REPLY = 2;
    public static final int SPECIAL_ERROR_MESSAGE = 3;
    public static final int PING_CONNECTION_MESSAGE = 4;
    public static final int PING_CONNECTION_MESSAGE_SERVER = 5;
    public static final int RESOLVE_INITIAL_REFERENCE = 10;
    public static final int RESOLVE_INITIAL_REFERENCE_REPLY = 11;
    public static final int INFORM_MESSAGE = 20;
    public static final int GET_CONTEXT_OBJECT = 30;
    public static final int GET_CONTEXT_OBJECT_REPLY = 31;
    public static final int OBJECT_KEY_SIZE = 12;
    public long ssid;
    public int clusterEl_id;
    public int sender_id;
    public int client_id;
    public byte[] unmarshaledRequest;
    public byte[] request;
    public int type;
    public int nextPos = 0;
    public byte[] call_id;
    public int own_id = -1;
    public String opName;
    public boolean isRedir = false;
    public String ident = "";
    public byte[] objectKey;
    public String name = null;
    public static ObjectInfo obj;
    private Connection con = null;
    protected P4ContextObject p4co = null;
    private StubBaseInfo info = null;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$ContextObjectClassReceiver;

    public Message() {
    }

    public Message(int clusterEl_id, int client_id, byte[] request, Connection c) {
        this(clusterEl_id, client_id, request);
        this.con = c;
    }

    public Message(int clusterEl_id, int client_id, byte[] request) {
        this.request = request;
        this.clusterEl_id = clusterEl_id;
        this.client_id = client_id;
        this.sender_id = clusterEl_id;
        this.call_id = new byte[8];
        System.arraycopy(request, this.offBody, this.call_id, 0, 8);
        this.type = request[this.offBody + 8];
        this.size = request.length;
    }

    public Message(int sender_id, int clusterEl_id, int client_id, byte[] request) {
        this(clusterEl_id, client_id, request);
        this.sender_id = sender_id;
    }

    public Message(int sender_id, int clusterEl_id, int client_id, byte[] request, int size) {
        this.offBody = 14;
        this.sender_id = sender_id;
        this.size = size;
        this.own_id = Convert.byteArrToInt(request, 6);
        this.request = request;
        this.clusterEl_id = clusterEl_id;
        this.client_id = client_id;
        this.call_id = new byte[8];
        System.arraycopy(request, this.offBody, this.call_id, 0, 8);
        this.type = request[this.offBody + 8];
        size = request.length;
    }

    public byte[] getUnmarshaledRequest() {
        if (!this.parsed) {
            this.parseMessage();
        }
        return this.unmarshaledRequest;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offBody;
    }

    public long getCallId() {
        return Convert.byteArrToLong(this.request, this.offBody);
    }

    public void parseMessage() {
        this.lenTC = Convert.byteArrToInt(this.request, this.offBody + 9);
        this.nextPos = this.offBody + 9 + 4;
        if (this.type != 10 && this.type != 11 && this.type != 20 && this.type != 4 && this.lenTC > 0) {
            int co_name_size = 0;
            int coCounts = 0;
            int byteArrSize = 0;
            int currentCO = 0;
            coCounts = this.request[this.nextPos] & 0xFF | this.request[this.nextPos + 1] << 8;
            this.nextPos += 2;
            while (currentCO < coCounts) {
                co_name_size = this.request[this.nextPos] & 0xFF | this.request[this.nextPos + 1] << 8;
                this.nextPos += 2;
                this.name = this.readString(this.request, this.nextPos, co_name_size);
                this.nextPos += co_name_size;
                byteArrSize = this.request[this.nextPos] & 0xFF | this.request[this.nextPos + 1] << 8;
                this.nextPos += 2;
                this.loadContextObject(this.request, this.nextPos, byteArrSize);
                ++currentCO;
            }
        }
        switch (this.type) {
            case 0: {
                if (this.request[this.nextPos++] == 1) {
                    this.isRedir = true;
                    byte nameSize = this.request[this.nextPos++];
                    this.ident = Convert.byteArrToUString(this.request, this.nextPos, nameSize);
                    this.nextPos += 2 * nameSize;
                }
                int opNameSize = this.request[this.nextPos++] & 0xFF | this.request[this.nextPos++] << 8;
                this.opName = Convert.byteArrToUString(this.request, this.nextPos, opNameSize);
                this.nextPos += 2 * opNameSize;
                this.objectKey = new byte[12];
                System.arraycopy(this.request, this.nextPos, this.objectKey, 0, this.objectKey.length);
                this.nextPos += 12;
                this.bais = new ByteArrayInputStream(this.request, this.nextPos, this.size - this.nextPos);
                break;
            }
            case 1: {
                this.bais = new ByteArrayInputStream(this.request, this.nextPos, this.size - this.nextPos);
                break;
            }
            case 2: {
                this.bais = new ByteArrayInputStream(this.request, this.nextPos, this.size - this.nextPos);
                break;
            }
            case 10: 
            case 11: {
                this.unmarshaledRequest = new byte[this.size - 9 - this.offBody];
                System.arraycopy(this.request, 9 + this.offBody, this.unmarshaledRequest, 0, this.unmarshaledRequest.length);
                break;
            }
            case 20: {
                this.unmarshaledRequest = new byte[this.size - 9 - this.offBody];
                System.arraycopy(this.request, 9 + this.offBody, this.unmarshaledRequest, 0, this.unmarshaledRequest.length);
                break;
            }
            case 30: {
                byte[] req = this.request;
                P4ObjectBroker p4 = P4ObjectBroker.getBroker();
                String name_CO = Convert.byteArrToAString(req, 23, req.length - 14 - 9);
                ContextObject contextObj = p4.getCTC().getContextObject(name_CO);
                byte[] rep = null;
                String name = Convert.byteArrToUString(this.getUnmarshaledRequest());
                rep = new byte[contextObj.getClass().getName().getBytes().length + 9];
                System.arraycopy(this.call_id, 0, rep, 0, 8);
                rep[8] = 31;
                System.arraycopy(contextObj.getClass().getName().getBytes(), 0, rep, 9, contextObj.getClass().getName().getBytes().length);
                break;
            }
            case 31: {
                obj.setInfo(this.request);
                obj.notify();
            }
        }
        this.parsed = true;
    }

    public ByteArrayInputStream getByteArrayInputStream() {
        if (!this.parsed) {
            this.parseMessage();
        }
        return this.bais;
    }

    public int readShortToInt(byte[] buf, int off) {
        return buf[off] & 0xFF | buf[off++] << 8;
    }

    public String readString(byte[] buf, int off, int len) {
        String s = null;
        try {
            s = Convert.byteArrToAString(buf, off, len);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return s;
    }

    public void loadContextObject(byte[] buf, int off, int skip) {
        block15: {
            P4ObjectBroker broker = P4ObjectBroker.init();
            ClientThreadContext ctc = broker.getCTC();
            if (ctc != null) {
                ContextObject co = ctc.getContextObject(this.name);
                if (co != null) {
                    if (skip > 0) {
                        if (this.name.equals("security") && (this.type == 1 || this.type == 11 || this.type == 2) && co instanceof TransferableExt) {
                            ((TransferableExt)((Object)co)).load(new Integer(this.info.ownerId), buf, off);
                        } else {
                            ((Transferable)((Object)co)).load(buf, off);
                        }
                        this.nextPos += skip;
                    }
                } else {
                    try {
                        if (!this.name.equalsIgnoreCase("P4")) {
                            String type = P4ObjectBroker.transportType;
                            if (P4ObjectBroker.props != null) {
                                type = P4ObjectBroker.props.getProperty("TransportLayerQueue");
                            }
                            if (type == null) {
                                type = P4ObjectBroker.transportType;
                            }
                            Message.setContextObject(type, this.name, this.con.host, this.con.port);
                            co = broker.getCTC().getContextObject(this.name);
                            if (co != null) {
                                if (this.name.equals("security") && (this.type == 1 || this.type == 11 || this.type == 2) && co instanceof TransferableExt) {
                                    ((TransferableExt)((Object)co)).load(new Integer(this.info.ownerId), buf, off);
                                } else {
                                    ((Transferable)((Object)co)).load(buf, off);
                                }
                            }
                            this.nextPos += skip;
                            break block15;
                        }
                        this.p4co = new P4ContextObject();
                        this.p4co.load(buf, off);
                        this.nextPos += skip;
                    }
                    catch (Exception _) {
                        _.printStackTrace();
                        this.nextPos += skip;
                    }
                }
            } else {
                this.nextPos += skip;
            }
        }
    }

    public static String toString(byte[] bytes, int begin, int length) {
        String hex = "0123456789ABCDEF";
        if (bytes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        length = Math.min(length, bytes.length);
        int end = begin + length;
        int c = begin;
        while (c < end) {
            int count = 16;
            StringBuffer text = new StringBuffer();
            int j = c;
            while (--count >= 0 && j < end) {
                int charAsInt = bytes[j] & 0xFF;
                sb.append(" " + hex.charAt(charAsInt >> 4) + hex.charAt(charAsInt & 0xF));
                int ch = charAsInt > 31 ? (int)charAsInt : 46;
                text.append((char)ch);
                ++j;
            }
            while (--count >= -2) {
                sb.append("   ");
            }
            sb.append((Object)text);
            if (c < end - 16) {
                sb.append("\r\n");
            }
            c += 16;
        }
        return sb.toString();
    }

    private static synchronized void setContextObject(String _type, String name, String host, int port) {
        if (wait) {
            return;
        }
        wait = true;
        try {
            ContextObject co = P4ObjectBroker.init().getCTC().getContextObject(name);
            if (co == null) {
                Class c;
                ContextObjectClassReceiver oo = (ContextObjectClassReceiver)P4ObjectBroker.getBroker().narrow(P4ObjectBroker.init().resolveInitialReference(_type, "cocr", host, port), class$com$sap$engine$services$rmi_p4$ContextObjectClassReceiver == null ? (class$com$sap$engine$services$rmi_p4$ContextObjectClassReceiver = Message.class$("com.sap.engine.services.rmi_p4.ContextObjectClassReceiver")) : class$com$sap$engine$services$rmi_p4$ContextObjectClassReceiver);
                if (name.length() > 1 && (c = oo.getClassByName(name)) != null) {
                    co = ((ContextObject)c.newInstance()).getInitialValue();
                    P4ObjectBroker.init().getCTC().setContextObject(name, co);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        wait = false;
    }

    public void setInfo(StubBaseInfo info) {
        this.info = info;
    }

    public StubBaseInfo getInfo() {
        return this.info;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        obj = null;
    }
}

