/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.ContextObjectNameIterator;
import com.sap.engine.frame.core.thread.Transferable;
import com.sap.engine.frame.core.thread.TransferableExt;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.rmi_p4.Call;
import com.sap.engine.services.rmi_p4.LocalDispatchImpl;
import com.sap.engine.services.rmi_p4.MarshalInputStream;
import com.sap.engine.services.rmi_p4.MarshalOutputStream;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import com.sap.engine.services.rmi_p4.Repliable;
import com.sap.engine.services.rmi_p4.Skeleton;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.rmi.Remote;
import java.rmi.server.Operation;

public class LocalDispatch
implements Repliable {
    P4RemoteObject p4Object;
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$LocalDispatch;

    public LocalDispatch(P4RemoteObject target) {
        this.p4Object = target;
    }

    public void reply(int server_id, int client_id, byte[] reply) throws P4IOException {
        Message msg = new Message(server_id, client_id, reply);
        if (msg.type == 20) {
            P4ObjectBroker.init().inform(this, msg);
        }
    }

    public void reply(int server_id, int client_id, byte[] reply, int size) throws P4IOException {
    }

    public void reply(int server_id, int sender, int client_id, byte[] reply, int size) throws P4IOException {
        Message msg = new Message(0, server_id, client_id, reply, size);
        if (msg.type == 20) {
            P4ObjectBroker.init().inform(this, msg);
        }
    }

    public void reply(int server_id, int client_id, byte[] reply, int size, Call call) throws P4IOException {
        try {
            MarshalOutputStream out = new MarshalOutputStream(new ByteArrayOutputStream());
            Skeleton skel = this.p4Object.getInfo().skeleton;
            int opNameSize = reply[0] & 0xFF | reply[1] << 8;
            String op = Convert.byteArrToUString(reply, 2, opNameSize);
            MarshalInputStream in = new MarshalInputStream(new ByteArrayInputStream(reply, 2 * opNameSize + 2, size - 2 * opNameSize - 2));
            in.setClassLoader(skel.getClass().getClassLoader());
            Operation[] operations = skel.getOperations();
            int opnum = 0;
            boolean flag = false;
            while (opnum < operations.length) {
                if (op.equals(operations[opnum].getOperation())) {
                    flag = true;
                    break;
                }
                ++opnum;
            }
            if (flag) {
                LocalDispatchImpl dispatchContext = new LocalDispatchImpl(out, in, this);
                try {
                    skel.dispatch((Remote)((Object)this.p4Object), dispatchContext, opnum);
                }
                catch (Exception ex) {
                    P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$LocalDispatch == null ? (class$com$sap$engine$services$rmi_p4$LocalDispatch = LocalDispatch.class$("com.sap.engine.services.rmi_p4.LocalDispatch")) : class$com$sap$engine$services$rmi_p4$LocalDispatch, ex, "reply", 300);
                    call.setException(true);
                    dispatchContext.throwException(ex, call);
                }
            } else {
                throw new Exception("Incorect Operation");
            }
            byte[] marshaledReply = out.toByteArray();
            this.send(marshaledReply, call);
        }
        catch (Exception ex) {
            P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$LocalDispatch == null ? (class$com$sap$engine$services$rmi_p4$LocalDispatch = LocalDispatch.class$("com.sap.engine.services.rmi_p4.LocalDispatch")) : class$com$sap$engine$services$rmi_p4$LocalDispatch, ex, "reply", 100);
            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Could_not_make_reply, ex);
        }
    }

    public void reply(Message msg, byte[] reply) throws P4IOException {
        this.reply(msg.clusterEl_id, msg.client_id, reply);
    }

    public void send(byte[] reply, Call call) {
        call.setReply(reply);
    }

    public int getTCSize() {
        int tcSize = 0;
        int coCounts = 0;
        boolean stringLen = false;
        int byteArrLen = 0;
        P4ObjectBroker p4 = P4ObjectBroker.getBroker();
        ClientThreadContext ctc = p4.getCTC();
        ContextObjectNameIterator coIt = ctc.getTransferableContextObjectNames();
        try {
            while (coIt.hasNext()) {
                ++coCounts;
                String n = coIt.nextName();
            }
            tcSize += 2;
            int i = 0;
            while (i < coCounts) {
                if (coIt.hasNext()) {
                    tcSize += 2;
                    String name = coIt.nextName();
                    tcSize += name.length();
                    tcSize += 2;
                    ContextObject co = ctc.getContextObject(name);
                    byteArrLen = ((Transferable)((Object)co)).size();
                    tcSize += byteArrLen;
                }
                ++i;
            }
        }
        catch (Exception e) {
            P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$LocalDispatch == null ? (class$com$sap$engine$services$rmi_p4$LocalDispatch = LocalDispatch.class$("com.sap.engine.services.rmi_p4.LocalDispatch")) : class$com$sap$engine$services$rmi_p4$LocalDispatch, e, "getTCSize", 100);
            return tcSize;
        }
        return tcSize;
    }

    public int getTCSize(int own_broker_Id) {
        int tcSize = 9;
        int byteArrLen = 0;
        P4ObjectBroker p4 = P4ObjectBroker.init();
        ClientThreadContext ctc = p4.getCTC();
        try {
            ContextObjectNameIterator coIt = ctc.getTransferableContextObjectNames();
            while (coIt.hasNext()) {
                String n = coIt.nextName();
                ContextObject co = ctc.getContextObject(n);
                byteArrLen = n.equals("security") && co instanceof TransferableExt ? ((TransferableExt)((Object)co)).size(new Integer(own_broker_Id)) : ((Transferable)((Object)co)).size();
                tcSize = tcSize + 2 + n.length();
                tcSize = tcSize + 2 + byteArrLen;
            }
        }
        catch (Exception ex) {
            return tcSize;
        }
        return tcSize += 2;
    }

    public String getUnderlyingProfile() {
        return null;
    }

    protected void finalize() {
        P4ObjectBroker.init().disposeConnection("LocalDispatch@" + this.hashCode());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

