/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rmi_p4;

import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.ContextObjectNameIterator;
import com.sap.engine.frame.core.thread.Transferable;
import com.sap.engine.frame.core.thread.TransferableExt;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.util.ConcurrentHashMapLongObject;
import com.sap.engine.services.rmi_p4.ByteArrayOutput;
import com.sap.engine.services.rmi_p4.LocalDispatch;
import com.sap.engine.services.rmi_p4.MarshalException;
import com.sap.engine.services.rmi_p4.MarshalInputStream;
import com.sap.engine.services.rmi_p4.MarshalOutputStream;
import com.sap.engine.services.rmi_p4.Message;
import com.sap.engine.services.rmi_p4.P4ContextObject;
import com.sap.engine.services.rmi_p4.P4IOException;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4ObjectInput;
import com.sap.engine.services.rmi_p4.P4ObjectOutput;
import com.sap.engine.services.rmi_p4.StubBase;
import com.sap.engine.services.rmi_p4.StubImpl;
import com.sap.engine.services.rmi_p4.exception.P4BaseIOException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;

public class Call {
    static long id = 0L;
    public static long TIMEOUT = 0L;
    private MarshalOutputStream out;
    private MarshalInputStream in;
    private long timeout;
    protected long call_id;
    private byte[] reply;
    private String opname;
    private int offset;
    private Message replyMessage = null;
    public StubImpl stub;
    private int tcsize = 0;
    public boolean exception = false;
    private Exception ex;
    protected static ConcurrentHashMapLongObject calls = new ConcurrentHashMapLongObject(101);
    static /* synthetic */ Class class$com$sap$engine$services$rmi_p4$Call;

    public Call(StubImpl stub, int opnum) throws IOException {
        this.stub = stub;
        this.opname = stub.p4_getOperations()[opnum];
        this.offset = 2 + 2 * this.opname.length();
        this.out = new MarshalOutputStream(new ByteArrayOutput(this.offset));
    }

    public Call(StubBase stub, int opnum) throws IOException {
        this.stub = stub;
        this.opname = stub.getOperations()[opnum].getOperation();
        this.offset = 2 + 2 * this.opname.length();
        this.out = new MarshalOutputStream(new ByteArrayOutput(this.offset));
    }

    public Call(StubImpl stub, String opname) throws IOException {
        this.stub = stub;
        this.opname = opname;
        this.offset = 2 + 2 * opname.length();
        this.out = new MarshalOutputStream(new ByteArrayOutput(this.offset));
    }

    public Call(StubImpl stub, String opname, long call_id, long timeout) throws IOException {
        this.stub = stub;
        this.opname = opname;
        this.call_id = call_id;
        this.timeout = timeout;
        if (stub.info.isRedirectable) {
            this.offset += 2 * stub.info.redirIdent.length() + 1;
        }
        this.tcsize = stub.repliable.getTCSize(stub.p4_getInfo().ownerId) & 0xFF;
        this.offset += 30 + stub.p4_getInfo().key.length + this.tcsize + 2 * opname.length();
        this.out = new MarshalOutputStream(new ByteArrayOutput(this.offset));
        this.reply = null;
    }

    public Call(StubImpl stub, int opnum, long call_id, long timeout) throws IOException {
        this.timeout = timeout;
        this.stub = stub;
        this.opname = stub.p4_getOperations()[opnum];
        this.call_id = call_id;
        if (stub.info.isRedirectable) {
            this.offset += 2 * stub.info.redirIdent.length() + 1;
        }
        this.tcsize = stub.repliable.getTCSize(stub.p4_getInfo().ownerId) & 0xFF;
        this.offset += 30 + stub.p4_getInfo().key.length + this.tcsize + 2 * this.opname.length();
        this.out = new MarshalOutputStream(new ByteArrayOutput(this.offset));
        this.reply = null;
    }

    public Call(StubBase stub, int opnum, long call_id, long timeout) throws IOException {
        this.timeout = timeout;
        this.stub = stub;
        this.opname = stub.getOperations()[opnum].getOperation();
        this.call_id = call_id;
        if (stub.info.isRedirectable) {
            this.offset += 2 * stub.info.redirIdent.length() + 1;
        }
        this.tcsize = stub.repliable.getTCSize(stub.p4_getInfo().ownerId) & 0xFF;
        this.offset += 30 + stub.p4_getInfo().key.length + this.tcsize + 2 * this.opname.length();
        this.out = new MarshalOutputStream(new ByteArrayOutput(this.offset));
        this.reply = null;
    }

    public long getCall_id() {
        return this.call_id;
    }

    public P4ObjectOutput getOutputStream() {
        return this.out;
    }

    public synchronized void setException(Message replyMsg) {
        this.exception = true;
        this.replyMessage = replyMsg;
        this.notify();
    }

    public synchronized void setException(boolean ex) {
        this.exception = ex;
    }

    public synchronized void setException(Exception ex) {
        this.ex = ex;
        this.exception = true;
        this.notify();
    }

    public P4ObjectInput getResultStream() throws IOException, Exception {
        Object object;
        try {
            if (this.stub.isLocal) {
                this.in = new MarshalInputStream(new ByteArrayInputStream(this.reply));
            } else {
                object = this;
                synchronized (object) {
                    if (this.replyMessage == null && !this.exception) {
                        try {
                            this.wait(TIMEOUT);
                            if (this.replyMessage == null) {
                                if (this.ex != null) {
                                    this.stub.broker.trace(class$com$sap$engine$services$rmi_p4$Call == null ? (class$com$sap$engine$services$rmi_p4$Call = Call.class$("com.sap.engine.services.rmi_p4.Call")) : class$com$sap$engine$services$rmi_p4$Call, this.ex, "Call ID: " + this.call_id + ": opname:" + this.opname, "getResultStream", 100);
                                    throw this.ex;
                                }
                                this.stub.broker.log(class$com$sap$engine$services$rmi_p4$Call == null ? (class$com$sap$engine$services$rmi_p4$Call = Call.class$("com.sap.engine.services.rmi_p4.Call")) : class$com$sap$engine$services$rmi_p4$Call, "Call ID: " + this.call_id + ": opname:" + this.opname + ". Request timeout, replyMessage did not arrived", "getResultStream", 100);
                                throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.ReplyMessage_Didnot_arrived, null);
                            }
                        }
                        catch (InterruptedException iex) {
                            this.stub.broker.trace(class$com$sap$engine$services$rmi_p4$Call == null ? (class$com$sap$engine$services$rmi_p4$Call = Call.class$("com.sap.engine.services.rmi_p4.Call")) : class$com$sap$engine$services$rmi_p4$Call, iex, "Call ID: " + this.call_id + ": opname:" + this.opname + ". InterruptedException while waiting Message", "getResultStream", 100);
                            throw (P4IOException)P4ObjectBroker.init().getException(0, P4BaseIOException.Interrupted_While_Wait_Message, iex);
                        }
                    }
                }
                if (this.replyMessage != null) {
                    this.replyMessage.setInfo(this.stub.p4_getInfo());
                    this.in = new MarshalInputStream(this.replyMessage.getByteArrayInputStream());
                    this.in.setUnderlyingProfile(this.stub.repliable.getUnderlyingProfile());
                    P4ContextObject co = this.replyMessage.p4co;
                    if (co != null) {
                        byte[] temp = new byte[((Transferable)co).size()];
                        ((Transferable)co).store(temp, 0);
                        int cluster_id = Convert.byteArrToInt(temp, temp.length - 4);
                        byte[] oKey = new byte[temp.length - 4];
                        System.arraycopy(temp, 0, oKey, 0, temp.length - 4);
                        this.stub.p4_setNewServerInfo(oKey, cluster_id);
                    }
                } else if (this.reply != null) {
                    this.in = new MarshalInputStream(new ByteArrayInputStream(this.reply));
                }
            }
            this.in.setConnectionType(this.stub.p4_getConnectionType());
            this.in.setClassLoader(this.stub.p4_getClassLoader());
            if (this.exception) {
                Exception ex = null;
                try {
                    ex = (Exception)this.in.readObject();
                }
                catch (Exception exe) {
                    this.stub.broker.trace(class$com$sap$engine$services$rmi_p4$Call == null ? (class$com$sap$engine$services$rmi_p4$Call = Call.class$("com.sap.engine.services.rmi_p4.Call")) : class$com$sap$engine$services$rmi_p4$Call, exe, "Call ID: " + this.call_id + ": opname:" + this.opname + ". Exception is thrown in execution process.Exception occur when try to read original Exception", "getResultStream", 100);
                    throw (MarshalException)P4ObjectBroker.init().getException(4, "p4_0017", exe);
                }
                throw ex;
            }
            this.in.setRemoteBrokerId(this.stub.info.ownerId);
            object = this.in;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            Call.removeCall(this.call_id);
            throw throwable;
        }
        Call.removeCall(this.call_id);
        return object;
    }

    public StubImpl getStub() {
        return this.stub;
    }

    public void remove() {
        if (calls.containsKey(this.call_id)) {
            calls.remove(this.call_id);
        }
    }

    public static Call getCall(long call_id) {
        Call call = (Call)calls.get(call_id);
        if (call != null) {
            calls.remove(call_id);
        }
        return call;
    }

    public static Enumeration getAllCalls() {
        return calls.elements();
    }

    public static void removeCall(long call_id) {
        if (calls.containsKey(call_id)) {
            calls.remove(call_id);
        }
    }

    public static Call newCall(StubImpl stubImpl, String opname) throws IOException {
        Call call = null;
        if (stubImpl.isLocal) {
            if (stubImpl.repliable == null) {
                stubImpl.p4_setRepliaror(new LocalDispatch(stubImpl.broker.getObject(stubImpl.info.key)));
            }
            call = new Call(stubImpl, opname);
        } else {
            call = new Call(stubImpl, opname, Call.getNewId(), 0L);
            calls.put(call.call_id, call);
        }
        return call;
    }

    public static Call newCall(StubBase stubBase, String opname) throws IOException {
        Call call = null;
        try {
            if (stubBase.isLocal) {
                if (stubBase.repliable == null) {
                    stubBase.setRepliaror(new LocalDispatch(stubBase.broker.getObject(stubBase.info.key)));
                }
                call = new Call((StubImpl)stubBase, opname);
            } else {
                call = new Call((StubImpl)stubBase, opname, Call.getNewId(), 0L);
                calls.put(call.call_id, call);
            }
        }
        catch (Exception e) {
            P4ObjectBroker.init().trace(class$com$sap$engine$services$rmi_p4$Call == null ? (class$com$sap$engine$services$rmi_p4$Call = Call.class$("com.sap.engine.services.rmi_p4.Call")) : class$com$sap$engine$services$rmi_p4$Call, e, "newCall", 100);
            throw new IOException(e.getMessage());
        }
        return call;
    }

    public static Call newCall(StubImpl stubImpl, int opnum) throws IOException {
        Call call;
        if (stubImpl.isLocal) {
            if (stubImpl.repliable == null) {
                stubImpl.p4_setRepliaror(new LocalDispatch(stubImpl.broker.getObject(stubImpl.info.key)));
            }
            call = new Call(stubImpl, opnum);
        } else {
            call = new Call(stubImpl, opnum, Call.getNewId(), 0L);
            calls.put(call.call_id, call);
        }
        return call;
    }

    public static Call newCall(StubBase stubBase, int opnum) throws IOException {
        Call call;
        if (stubBase.isLocal) {
            if (stubBase.repliable == null) {
                stubBase.setRepliaror(new LocalDispatch(stubBase.broker.getObject(stubBase.info.key)));
            }
            call = new Call(stubBase, opnum);
        } else {
            call = new Call(stubBase, opnum, Call.getNewId(), 0L);
            calls.put(call.call_id, call);
        }
        return call;
    }

    public static boolean callsEmpty() {
        return calls.isEmpty();
    }

    public void sendRequest() throws P4IOException {
        byte[] _key;
        int opnameLength;
        int operationLength;
        int client_id;
        int local_id;
        int server_id;
        block10: {
            server_id = this.stub.p4_getInfo().server_id;
            local_id = this.stub.p4_getInfo().local_id;
            client_id = this.stub.p4_getInfo().client_id;
            operationLength = this.opname.length();
            opnameLength = 2 * operationLength;
            _key = this.stub.p4_getInfo().key;
            try {
                this.out.flush();
            }
            catch (IOException ioex) {
                if (this.stub == null) break block10;
                this.stub.broker.trace(class$com$sap$engine$services$rmi_p4$Call == null ? (class$com$sap$engine$services$rmi_p4$Call = Call.class$("com.sap.engine.services.rmi_p4.Call")) : class$com$sap$engine$services$rmi_p4$Call, ioex, "Call ID: " + this.call_id + ": opname:" + this.opname, "sendRequest", 100);
            }
        }
        int lenTC = this.stub.repliable.getTCSize(this.stub.p4_getInfo().ownerId) & 0xFF;
        byte[] request = this.out.getBuffer();
        int nextPos = 27;
        Convert.writeLongToByteArr(request, 14, this.call_id);
        request[22] = 0;
        Convert.writeIntToByteArr(request, 23, lenTC);
        int coCounts = 0;
        int byteArrLen = 0;
        P4ObjectBroker broker = P4ObjectBroker.getBroker();
        ClientThreadContext ctc = broker.getCTC();
        ContextObjectNameIterator coIt = null;
        int position_for_co_counts = nextPos;
        if (lenTC != 0) {
            coIt = ctc.getTransferableContextObjectNames();
            nextPos += 2;
            while (coIt.hasNext()) {
                String co_name = null;
                int position_for_co_name_length = -1;
                int position_for_co_name = -1;
                int tempNextPos = nextPos;
                int position_for_co_size = -1;
                int position_for_co = -1;
                try {
                    co_name = coIt.nextName();
                    ContextObject co = ctc.getContextObject(co_name);
                    position_for_co_name_length = tempNextPos;
                    position_for_co_name = tempNextPos += 2;
                    position_for_co_size = tempNextPos += co_name.length();
                    position_for_co = tempNextPos += 2;
                    byteArrLen = co_name.equals("security") && co instanceof TransferableExt ? ((TransferableExt)((Object)co)).size(new Integer(this.stub.p4_getInfo().ownerId)) : ((Transferable)((Object)co)).size();
                    if (co_name.equals("security") && co instanceof TransferableExt) {
                        ((TransferableExt)((Object)co)).store(new Integer(this.stub.p4_getInfo().ownerId), request, position_for_co);
                    } else {
                        ((Transferable)((Object)co)).store(request, position_for_co);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                ++coCounts;
                nextPos = tempNextPos += byteArrLen;
                this.writeIntToShort(request, position_for_co_name_length, co_name.length());
                this.writeString(request, position_for_co_name, co_name);
                this.writeIntToShort(request, position_for_co_size, byteArrLen);
            }
            this.writeIntToShort(request, position_for_co_counts, coCounts);
        }
        if (this.stub.info.isRedirectable) {
            request[nextPos++] = 1;
            request[nextPos++] = (byte)this.stub.info.redirIdent.length();
            Convert.writeUStringToByteArr(request, nextPos, this.stub.info.redirIdent);
            nextPos += 2 * this.stub.info.redirIdent.length();
        } else {
            request[nextPos++] = 0;
        }
        request[nextPos++] = (byte)operationLength;
        request[nextPos++] = (byte)(operationLength >> 8);
        Convert.writeUStringToByteArr(request, nextPos, this.opname);
        System.arraycopy(_key, 0, request, nextPos += opnameLength, _key.length);
        nextPos += _key.length;
        this.stub.repliable.reply(server_id, local_id, client_id, request, this.out.getSize());
    }

    public void sendLocalRequest() throws P4IOException {
        try {
            this.out.flush();
        }
        catch (IOException ioex) {
            this.stub.broker.trace(class$com$sap$engine$services$rmi_p4$Call == null ? (class$com$sap$engine$services$rmi_p4$Call = Call.class$("com.sap.engine.services.rmi_p4.Call")) : class$com$sap$engine$services$rmi_p4$Call, ioex, "Call ID: " + this.call_id + ": opname:" + this.opname, "sendLocalRequest", 100);
        }
        byte[] request = this.out.getBuffer();
        int operationLength = this.opname.length();
        request[0] = (byte)operationLength;
        request[1] = (byte)(operationLength >> 8);
        Convert.writeUStringToByteArr(request, 2, this.opname);
        ((LocalDispatch)this.stub.repliable).reply(0, 0, request, this.out.getSize(), this);
    }

    public void releaseInputStream() {
    }

    public void setReply(byte[] reply) {
        this.reply = reply;
        Call call = this;
        synchronized (call) {
            this.notify();
        }
    }

    public void setReply(Message reply) {
        this.replyMessage = reply;
        Call call = this;
        synchronized (call) {
            this.notify();
        }
    }

    public static synchronized long getNewId() {
        return id++;
    }

    public void writeIntToShort(byte[] buf, int off, int d) {
        Convert.writeShortToByteArr(buf, off, (short)d);
    }

    public void writeString(byte[] buf, int off, String str) {
        Convert.writeAStringToByteArr(buf, off, str);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

