/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rfcengine.gui;

import com.sap.engine.services.rfcengine.BundleConfiguration;
import com.sap.engine.services.rfcengine.RFCRuntimeInterface;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class BundleListRenderer
extends JLabel
implements ListCellRenderer {
    protected RFCRuntimeInterface rfcRuntimeInterface;
    protected ImageIcon startedIcon;
    protected ImageIcon stoppedIcon;

    public BundleListRenderer() {
        this.setOpaque(true);
        this.initImages();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String name = value.toString();
        boolean isRunning = false;
        if (this.rfcRuntimeInterface != null) {
            try {
                BundleConfiguration config = this.rfcRuntimeInterface.getConfiguration(name);
                if (config != null) {
                    isRunning = config.isRunning();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error", 0);
            }
        }
        if (isRunning) {
            this.setIcon(this.startedIcon);
        } else {
            this.setIcon(this.stoppedIcon);
        }
        this.setText(name);
        this.setToolTipText(name + " - " + (isRunning ? "started" : "not started"));
        this.setBackground(isSelected ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(isSelected ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    public void setRFCRuntimeInterface(RFCRuntimeInterface rfcRuntimeInterface) {
        this.rfcRuntimeInterface = rfcRuntimeInterface;
    }

    private void initImages() {
        try {
            this.startedIcon = new ImageIcon(this.getClass().getResource("images/started.gif"));
            this.stoppedIcon = new ImageIcon(this.getClass().getResource("images/stopped.gif"));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Images not found", "Warning", 2);
        }
    }
}

