/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rfcengine.gui;

import com.sap.engine.services.rfcengine.gui.BundleListRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class BundleEditorView
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener,
ItemListener {
    protected static String EXPORT_BUNDLE_CMD = "Export";
    protected static String IMPORT_BUNDLE_CMD = "Import";
    protected static String REMOVE_BUNDLE_CMD = "Remove";
    protected static String SET_BUNDLE_PROPS_CMD = "Set";
    protected static String START_BUNDLE_CMD = "Start";
    protected static String STOP_BUNDLE_CMD = "Stop";
    protected static String OPEN_PROFILE_CMD = "Open";
    protected static String SELECT_SNCLIB_CMD = "Select SNCLIB";
    protected static String USE_SNC_CMD = "Use SNC";
    protected static String AUTHENTICATION_ONLY = "Authentication Only";
    protected static String INTEGRITY_PROTECTION = "Integrity Protection";
    protected static String PRIVACY_PROTECTION = "Privacy Protection";
    protected static String DEFAULT_PROTECTION = "Default Protection";
    protected static String MAXIMUM_PROTECTION = "Maximum Protection";
    protected JTextField applicationServerHostField;
    protected JLabel applicationServerHostLabel;
    protected JList bundleList;
    protected JPanel bundlePanel;
    protected JPanel buttonBundlePanel;
    protected JPanel buttonPropertiesPanel;
    protected JButton exportButton;
    protected JTextField gateWayHostField;
    protected JLabel gateWayHostLabel;
    protected JTextField gateWayServerField;
    protected JLabel gateWayServerLabel;
    protected JButton importButton;
    protected JCheckBox localFlag;
    protected JCheckBox unicodeFlag;
    protected JTextField logonClientField;
    protected JLabel logonClientLabel;
    protected JTextField logonLanguageField;
    protected JLabel logonLanguageLabel;
    protected JPasswordField logonPasswordField;
    protected JLabel logonPasswordLabel;
    protected JTextField logonUserField;
    protected JLabel logonUserLabel;
    protected JTextField processNumberField;
    protected JLabel processNumberLabel;
    protected JTextField programIdField;
    protected JLabel programIdLabel;
    protected JPanel propertiesPanel;
    protected JButton removeButton;
    protected BundleListRenderer renderer;
    protected JPanel repositoryPanel;
    protected JPanel rfcDestinationPanel;
    protected JScrollPane scrollBundlePane1;
    protected JButton setButton;
    protected JPanel settingsPanel;
    protected JButton startButton;
    protected JButton stopButton;
    protected JTextField systemNumberField;
    protected JLabel systemNumberLabel;
    protected JButton profileNameButton;
    protected boolean middlewareState = false;
    protected JPanel setButtonPanel;
    protected JTabbedPane tabs = null;
    protected JPanel sncSettingsPanel;
    protected JPanel sncPanel;
    protected JPanel bundleSettingsPanel;
    protected JTextField authPartnerField;
    protected JLabel authPartnerLabel;
    protected JTextField sncNameField;
    protected JLabel sncNameLabel;
    protected JComboBox sncQOPList;
    protected JLabel sncQOPLabel;
    protected JTextField sncLibField;
    protected JLabel sncLibLabel;
    protected JButton setButton1;
    protected JButton browseButton;
    protected JCheckBox useSNCCheckButton;

    public BundleEditorView() {
        this.initView();
    }

    public void initView() {
        this.initBundlePanel();
        this.initBundleSettingsPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)new JSplitPane(1, true, this.bundlePanel, this.bundleSettingsPanel), "Center");
    }

    protected void initBundleSettingsPanel() {
        this.initSettingsPanel();
        this.initSNCPanel();
        this.tabs = new JTabbedPane();
        this.tabs.add("Bundles", this.settingsPanel);
        this.tabs.add("SNC Settings", this.sncSettingsPanel);
        this.bundleSettingsPanel = new JPanel();
        this.bundleSettingsPanel.setLayout(new BorderLayout());
        this.bundleSettingsPanel.add((Component)this.tabs, "Center");
    }

    protected void initSNCPanel() {
        this.useSNCCheckButton = new JCheckBox("Use SNC", false);
        this.useSNCCheckButton.addItemListener(this);
        this.useSNCCheckButton.setSelected(false);
        this.browseButton = new JButton(". . .");
        this.browseButton.setPreferredSize(new Dimension(21, 21));
        this.browseButton.setActionCommand(SELECT_SNCLIB_CMD);
        this.browseButton.addActionListener(this);
        this.sncNameField = new JTextField();
        this.sncLibField = new JTextField();
        this.authPartnerField = new JTextField();
        this.sncNameLabel = new JLabel("SNC Name ");
        this.sncQOPLabel = new JLabel("SNC Quality of Service ");
        this.sncLibLabel = new JLabel("SNC Library Path ");
        this.authPartnerLabel = new JLabel("Authorization Partner ");
        this.sncQOPList = new JComboBox<String>(new String[]{AUTHENTICATION_ONLY, INTEGRITY_PROTECTION, PRIVACY_PROTECTION, DEFAULT_PROTECTION, MAXIMUM_PROTECTION});
        this.authPartnerField.setEditable(false);
        this.sncNameField.setEditable(false);
        this.sncQOPList.setEnabled(false);
        this.sncLibField.setEditable(false);
        this.browseButton.setEnabled(false);
        this.sncPanel = new JPanel();
        this.sncPanel.setLayout(new GridBagLayout());
        this.sncPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "SNC Settings"));
        this.sncPanel.add((Component)this.sncNameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.sncPanel.add((Component)this.sncNameField, new GridBagConstraints(1, 0, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.sncPanel.add((Component)this.sncQOPLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.sncPanel.add((Component)this.sncQOPList, new GridBagConstraints(1, 1, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.sncPanel.add((Component)this.sncLibLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.sncPanel.add((Component)this.sncLibField, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.sncPanel.add((Component)this.browseButton, new GridBagConstraints(2, 2, 1, 1, 0.1, 1.0, 10, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.sncPanel.add((Component)this.authPartnerLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.sncPanel.add((Component)this.authPartnerField, new GridBagConstraints(1, 3, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.sncSettingsPanel = new JPanel();
        this.sncSettingsPanel.setLayout(new GridBagLayout());
        this.sncSettingsPanel.add((Component)this.useSNCCheckButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.sncSettingsPanel.add((Component)this.sncPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 2, 2));
        this.sncSettingsPanel.add((Component)new JPanel(), new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 2, 2));
    }

    protected void initBundlePanel() {
        this.startButton = new JButton("Start");
        this.startButton.setMinimumSize(new Dimension(80, 28));
        this.startButton.setPreferredSize(new Dimension(65, 28));
        this.startButton.setEnabled(false);
        this.startButton.setActionCommand(START_BUNDLE_CMD);
        this.startButton.addActionListener(this);
        this.stopButton = new JButton("Stop");
        this.stopButton.setMinimumSize(new Dimension(70, 28));
        this.stopButton.setPreferredSize(new Dimension(65, 28));
        this.stopButton.setEnabled(false);
        this.stopButton.setActionCommand(STOP_BUNDLE_CMD);
        this.stopButton.addActionListener(this);
        this.removeButton = new JButton("Remove");
        this.removeButton.setMinimumSize(new Dimension(70, 28));
        this.removeButton.setPreferredSize(new Dimension(80, 28));
        this.removeButton.setEnabled(false);
        this.removeButton.setActionCommand(REMOVE_BUNDLE_CMD);
        this.removeButton.addActionListener(this);
        this.buttonBundlePanel = new JPanel();
        this.buttonBundlePanel.add((Component)this.startButton, null);
        this.buttonBundlePanel.add((Component)this.stopButton, null);
        this.buttonBundlePanel.add((Component)this.removeButton, null);
        this.bundleList = new JList();
        this.bundleList.getSelectionModel().setSelectionMode(0);
        this.bundleList.addListSelectionListener(this);
        this.renderer = new BundleListRenderer();
        this.bundleList.setCellRenderer(this.renderer);
        ToolTipManager.sharedInstance().registerComponent(this.bundleList);
        this.scrollBundlePane1 = new JScrollPane();
        this.scrollBundlePane1.getViewport().add((Component)this.bundleList, null);
        this.bundlePanel = new JPanel();
        this.bundlePanel.setLayout(new BorderLayout());
        this.bundlePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Available RFC destinations"));
        this.bundlePanel.add((Component)this.scrollBundlePane1, "Center");
        this.bundlePanel.add((Component)this.buttonBundlePanel, "South");
        this.exportButton = new JButton();
        this.exportButton.setToolTipText("Export bundle to file");
        this.exportButton.setActionCommand(EXPORT_BUNDLE_CMD);
        this.exportButton.setPreferredSize(new Dimension(30, 30));
        this.exportButton.addActionListener(this);
        this.importButton = new JButton();
        this.importButton.setToolTipText("Import bundle from file");
        this.importButton.setActionCommand(IMPORT_BUNDLE_CMD);
        this.importButton.setPreferredSize(new Dimension(24, 24));
        this.importButton.addActionListener(this);
        try {
            this.exportButton.setIcon(new ImageIcon(this.getClass().getResource("images/set.gif")));
            this.importButton.setIcon(new ImageIcon(this.getClass().getResource("images/open.gif")));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Images not found", "Warning", 2);
        }
    }

    protected void initSettingsPanel() {
        this.setButton = new JButton("Set");
        this.setButton.setMinimumSize(new Dimension(80, 28));
        this.setButton.setPreferredSize(new Dimension(80, 28));
        this.setButton.setEnabled(true);
        this.setButton.setActionCommand(SET_BUNDLE_PROPS_CMD);
        this.setButton.addActionListener(this);
        this.logonClientLabel = new JLabel("Client");
        this.logonClientField = new JTextField(15);
        this.logonClientField.setToolTipText("The client used to connect the repository");
        this.logonClientField.setMinimumSize(new Dimension(170, 20));
        this.logonClientLabel.setLabelFor(this.logonClientField);
        this.logonUserLabel = new JLabel("User");
        this.logonUserField = new JTextField(15);
        this.logonUserField.setToolTipText("The user name for the client connection for the repository");
        this.logonUserField.setMinimumSize(new Dimension(170, 20));
        this.logonUserLabel.setLabelFor(this.logonUserField);
        this.logonPasswordLabel = new JLabel("Password");
        this.logonPasswordField = new JPasswordField(15);
        this.logonPasswordField.setToolTipText("The user password for the client connection for the repository");
        this.logonPasswordField.setAutoscrolls(true);
        this.logonPasswordField.setMinimumSize(new Dimension(170, 20));
        this.logonPasswordLabel.setLabelFor(this.logonPasswordField);
        this.logonLanguageLabel = new JLabel("Language");
        this.logonLanguageField = new JTextField(15);
        this.logonLanguageField.setToolTipText("The language for the specific connection");
        this.logonLanguageField.setMinimumSize(new Dimension(170, 20));
        this.logonLanguageLabel.setLabelFor(this.logonLanguageField);
        this.applicationServerHostLabel = new JLabel("Application server host");
        this.applicationServerHostField = new JTextField(15);
        this.applicationServerHostField.setToolTipText("The host of the R/3 application server for the repository");
        this.applicationServerHostField.setMinimumSize(new Dimension(170, 20));
        this.applicationServerHostLabel.setLabelFor(this.applicationServerHostField);
        this.systemNumberLabel = new JLabel("System number");
        this.systemNumberField = new JTextField(15);
        this.systemNumberField.setToolTipText("The system number for the connection for the repository");
        this.systemNumberField.setMinimumSize(new Dimension(170, 20));
        this.systemNumberLabel.setLabelFor(this.systemNumberField);
        this.gateWayHostLabel = new JLabel("Gateway host");
        this.gateWayHostField = new JTextField(15);
        this.gateWayHostField.setToolTipText("The host of the gateway trough which the requests will be passed");
        this.gateWayHostField.setMinimumSize(new Dimension(170, 20));
        this.gateWayHostLabel.setLabelFor(this.gateWayHostField);
        this.gateWayServerLabel = new JLabel("Gateway service");
        this.gateWayServerField = new JTextField(15);
        this.gateWayServerField.setToolTipText("The gateway server which will be connected to receive request for handling JCO.Function-s");
        this.gateWayServerField.setMinimumSize(new Dimension(170, 20));
        this.gateWayServerLabel.setLabelFor(this.gateWayServerField);
        this.programIdLabel = new JLabel("Program ID");
        this.programIdField = new JTextField(15);
        this.programIdField.setToolTipText("The program id of the JCO.Server which is configured at the gateway service");
        this.programIdField.setMinimumSize(new Dimension(170, 20));
        this.programIdLabel.setLabelFor(this.programIdField);
        this.processNumberLabel = new JLabel("Number of processes");
        this.processNumberField = new JTextField(15);
        this.processNumberField.setToolTipText("Number of servers simultaneously running with the same Program ID");
        this.processNumberField.setMinimumSize(new Dimension(170, 20));
        this.processNumberLabel.setLabelFor(this.processNumberField);
        this.localFlag = new JCheckBox("Local bundle", false);
        this.localFlag.setToolTipText("If checked, the bundle will run only at this cluster element");
        this.localFlag.setMinimumSize(new Dimension(175, 20));
        this.unicodeFlag = new JCheckBox("Unicode", false);
        this.unicodeFlag.setToolTipText("If checked, the JCO Server will run in unicode");
        this.unicodeFlag.setMinimumSize(new Dimension(175, 20));
        this.unicodeFlag.setEnabled(true);
        this.profileNameButton = new JButton(". . .");
        this.profileNameButton.setPreferredSize(new Dimension(21, 21));
        this.profileNameButton.setActionCommand(OPEN_PROFILE_CMD);
        this.profileNameButton.addActionListener(this);
        this.putOnDestinationPanel();
        this.putOnRepositoryPanel();
        this.putOnPropertiesPanel();
        this.putOnSettingsPanel();
    }

    protected void putOnDestinationPanel() {
        this.rfcDestinationPanel = new JPanel();
        this.rfcDestinationPanel.setLayout(new GridBagLayout());
        this.rfcDestinationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "RFC destination"));
        this.rfcDestinationPanel.add((Component)this.programIdLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcDestinationPanel.add((Component)this.programIdField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcDestinationPanel.add((Component)this.profileNameButton, new GridBagConstraints(2, 0, 1, 1, 0.1, 1.0, 10, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcDestinationPanel.add((Component)this.gateWayHostLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcDestinationPanel.add((Component)this.gateWayHostField, new GridBagConstraints(1, 1, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcDestinationPanel.add((Component)this.gateWayServerLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcDestinationPanel.add((Component)this.gateWayServerField, new GridBagConstraints(1, 2, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcDestinationPanel.add((Component)this.processNumberLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.rfcDestinationPanel.add((Component)this.processNumberField, new GridBagConstraints(1, 3, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
    }

    protected void putOnRepositoryPanel() {
        this.repositoryPanel = new JPanel();
        this.repositoryPanel.setLayout(new GridBagLayout());
        this.repositoryPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Repository"));
        this.repositoryPanel.add((Component)this.applicationServerHostLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.applicationServerHostField, new GridBagConstraints(1, 0, 0, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.systemNumberField, new GridBagConstraints(1, 1, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.systemNumberLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.logonClientLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.logonClientField, new GridBagConstraints(1, 2, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.logonLanguageLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.logonLanguageField, new GridBagConstraints(1, 3, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.logonUserLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.logonUserField, new GridBagConstraints(1, 4, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.logonPasswordLabel, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1), 2, 2));
        this.repositoryPanel.add((Component)this.logonPasswordField, new GridBagConstraints(1, 5, 0, 1, 1.0, 1.0, 10, 2, new Insets(1, 1, 1, 1), 2, 2));
    }

    protected void putOnPropertiesPanel() {
        this.buttonPropertiesPanel = new JPanel();
        this.setButtonPanel = new JPanel();
        this.setButtonPanel.setLayout(new BorderLayout());
        this.setButtonPanel.add((Component)this.setButton, "Center");
        this.buttonPropertiesPanel.setLayout(new GridBagLayout());
        this.buttonPropertiesPanel.add((Component)this.localFlag, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 1, 1), 2, 2));
        this.buttonPropertiesPanel.add((Component)this.unicodeFlag, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 1, 1), 2, 2));
        this.buttonPropertiesPanel.add((Component)this.setButtonPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 5, 5), 1, 1));
        this.propertiesPanel = new JPanel();
        this.propertiesPanel.addMouseListener(this);
        this.propertiesPanel.setLayout(new GridBagLayout());
        this.propertiesPanel.add((Component)this.rfcDestinationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 2, 2));
        this.propertiesPanel.add((Component)this.repositoryPanel, new GridBagConstraints(0, 1, 1, 2, 1.0, 2.0, 10, 1, new Insets(1, 1, 1, 1), 2, 2));
    }

    public void putOnSettingsPanel() {
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new BorderLayout());
        this.settingsPanel.add((Component)this.buttonPropertiesPanel, "South");
        this.settingsPanel.add((Component)this.propertiesPanel, "Center");
    }

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void valueChanged(ListSelectionEvent var1);

    public abstract void mouseExited(MouseEvent var1);

    public abstract void mouseEntered(MouseEvent var1);

    public abstract void mouseReleased(MouseEvent var1);

    public abstract void mousePressed(MouseEvent var1);

    public abstract void mouseClicked(MouseEvent var1);

    public abstract void itemStateChanged(ItemEvent var1);
}

