/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rfcengine.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.gui.UserNode;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.services.rfcengine.BundleConfiguration;
import com.sap.engine.services.rfcengine.RFCRuntimeInterface;
import com.sap.engine.services.rfcengine.gui.BundleEditorView;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;

public class BundleEditorLogical
extends BundleEditorView
implements VisualRuntimeControl {
    protected String errorMessage = null;
    protected boolean isGlobalRuntime = false;
    protected Frame mainFrame;
    protected RFCRuntimeInterface rfcRuntimeInterface;
    protected JButton[] runtimeButtons = new JButton[]{this.exportButton, this.importButton};
    protected EditorViewManager taskManager;
    private int maxProcessesProperty = -1;
    private boolean internalCall = false;

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        try {
            if (command.equals(BundleEditorView.SET_BUNDLE_PROPS_CMD)) {
                this.setBundleAction();
            } else if (command.equals(BundleEditorView.REMOVE_BUNDLE_CMD)) {
                this.removeBundleAction();
            } else if (command.equals(BundleEditorView.START_BUNDLE_CMD)) {
                this.startBundleAction();
            } else if (command.equals(BundleEditorView.STOP_BUNDLE_CMD)) {
                this.stopBundleAction();
            } else if (command.equals(BundleEditorView.EXPORT_BUNDLE_CMD)) {
                this.exportBundleAction();
            } else if (command.equals(BundleEditorView.IMPORT_BUNDLE_CMD)) {
                this.importBundleAction();
            } else if (command.equals(BundleEditorView.OPEN_PROFILE_CMD)) {
                this.openProfileAction();
            } else if (command.equals(BundleEditorView.SELECT_SNCLIB_CMD)) {
                this.selectSncLibAction();
            }
        }
        catch (RemoteException re) {
            this.handleException(re);
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        this.enableSNCSettings();
    }

    public void freeResources() {
    }

    public JButton[] getRuntimeButtons() {
        if (this.rfcRuntimeInterface != null) {
            this.maxProcessesProperty = this.rfcRuntimeInterface.getMaxProcesses();
            this.processNumberLabel.setText("Number of processes(1.." + this.maxProcessesProperty + ")");
            this.processNumberLabel.repaint();
            if (!this.bundleList.getSelectionModel().isSelectionEmpty()) {
                try {
                    String programID = (String)this.bundleList.getSelectedValue();
                    this.updateView();
                    this.bundleList.setSelectedValue(programID, true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.runtimeButtons;
    }

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            try {
                this.updateView();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void setEnvironment(String editorToolName, Object environment) throws UnsupportedEditorException {
        if (!editorToolName.equals("SAPJ2EEEngineVisualAdministrator")) {
            throw new UnsupportedEditorException("admin_0");
        }
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public void setGlobalRuntime(ManagementInterface serviceRuntimeInterface) {
        this.isGlobalRuntime = true;
        this.setRuntime(serviceRuntimeInterface);
    }

    public void setRuntime(ManagementInterface serviceRuntimeInterface) {
        if (serviceRuntimeInterface != null) {
            this.rfcRuntimeInterface = (RFCRuntimeInterface)serviceRuntimeInterface;
            this.renderer.setRFCRuntimeInterface(this.rfcRuntimeInterface);
            this.maxProcessesProperty = this.rfcRuntimeInterface.getMaxProcesses();
            this.processNumberLabel.setText("Number of processes(1.." + this.maxProcessesProperty + ")");
            this.processNumberLabel.repaint();
            this.updateView();
        }
    }

    public void setTaskManager(EditorViewManager manager) {
        this.taskManager = manager;
    }

    public void setUserTree(UserNode root) {
    }

    public void show(ManagementInterface serviceRuntimeInterface) {
        this.setRuntime(serviceRuntimeInterface);
    }

    public void updateBundleList() throws RemoteException {
        this.bundleList.setListData(this.getAllBundleProgramID());
    }

    public void updateButtons() throws RemoteException {
        if (this.bundleList.getSelectionModel().isSelectionEmpty()) {
            this.startButton.setEnabled(false);
            this.stopButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.exportButton.setEnabled(false);
        } else {
            String programId = (String)this.bundleList.getSelectedValue();
            BundleConfiguration config = this.rfcRuntimeInterface.getConfiguration(programId);
            if (config != null) {
                boolean started = config.isRunning();
                if (started) {
                    this.startButton.setEnabled(false);
                    this.stopButton.setEnabled(true);
                } else {
                    this.startButton.setEnabled(true);
                    this.stopButton.setEnabled(false);
                }
                this.removeButton.setEnabled(true);
                this.exportButton.setEnabled(true);
            } else {
                String message = programId + " does't exist any more!\nRemoved by another application!";
                JOptionPane.showMessageDialog(this, message, "Error", 0);
                this.updateView();
            }
        }
    }

    public void updateProperties() throws RemoteException {
        if (!this.bundleList.getSelectionModel().isSelectionEmpty()) {
            String programId = (String)this.bundleList.getSelectedValue();
            BundleConfiguration config = this.rfcRuntimeInterface.getConfiguration(programId);
            if (config != null) {
                this.internalCall = true;
                this.logonClientField.setText(config.getLogonClient());
                this.logonUserField.setText(config.getLogonUser());
                ((JTextComponent)this.logonPasswordField).setText(config.getLogonPassword());
                this.logonLanguageField.setText(config.getLogonLanguage());
                this.applicationServerHostField.setText(config.getApplicationServerHost());
                this.systemNumberField.setText(config.getSystemNumber());
                this.gateWayHostField.setText(config.getGatewayHost());
                this.gateWayServerField.setText(config.getGatewayServer());
                this.programIdField.setText(config.getProgramId());
                this.localFlag.setSelected(config.isLocal());
                this.unicodeFlag.setSelected(config.isUnicode());
                this.processNumberField.setText(new Integer(config.getProcessesNumber()).toString());
                this.updateSNCProperties(config);
            } else {
                String message = programId + " does't exist any more!\nRemoved by another application!";
                JOptionPane.showMessageDialog(this, message, "Error", 0);
                this.updateView();
            }
        } else {
            this.setMiddlewareControls(this.middlewareState);
        }
    }

    protected void updateSNCProperties(BundleConfiguration config) {
        this.authPartnerField.setText(config.getAuthPartner());
        this.sncNameField.setText(config.getSncName());
        switch (config.getSncQop()) {
            case 1: {
                this.sncQOPList.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.sncQOPList.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.sncQOPList.setSelectedIndex(2);
                break;
            }
            case 8: {
                this.sncQOPList.setSelectedIndex(3);
                break;
            }
            case 9: {
                this.sncQOPList.setSelectedIndex(4);
            }
        }
        this.sncLibField.setText(config.getSncLib());
        this.useSNCCheckButton.setSelected(config.getUseSnc());
    }

    public void setMiddlewareControls(boolean mw) {
        if (mw) {
            this.programIdLabel.setText("Profile name");
            this.programIdField.setToolTipText("The name of the profile for the specific connection");
        } else {
            this.programIdLabel.setText("Program ID");
            this.programIdField.setToolTipText("The program id of the JCO.Server which is configured at the gateway service");
        }
        this.logonClientField.setText("");
        this.logonUserField.setText("");
        ((JTextComponent)this.logonPasswordField).setText("");
        this.logonLanguageField.setText("");
        this.applicationServerHostField.setText("");
        this.systemNumberField.setText("");
        this.gateWayHostField.setText("");
        this.gateWayServerField.setText("");
        this.programIdField.setText("");
        this.processNumberField.setText("");
        this.localFlag.setSelected(false);
        this.unicodeFlag.setSelected(false);
        this.programIdField.setEditable(true);
        this.profileNameButton.setVisible(mw);
        this.logonClientField.setEditable(!mw);
        this.logonUserField.setEditable(!mw);
        this.logonPasswordField.setEditable(!mw);
        this.logonLanguageField.setEditable(!mw);
        this.logonPasswordField.setBackground(this.logonClientField.getBackground());
        this.logonPasswordField.setBorder(this.logonClientField.getBorder());
        this.applicationServerHostField.setEditable(!mw);
        this.systemNumberField.setEditable(!mw);
        this.gateWayHostField.setEditable(!mw);
        this.gateWayServerField.setEditable(!mw);
        this.authPartnerField.setText("");
        this.sncNameField.setText("");
        this.sncQOPList.setSelectedIndex(0);
        this.sncLibField.setText("");
        this.useSNCCheckButton.setSelected(false);
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        if (evt == null) {
            this.updateView();
            return;
        }
        try {
            this.updateButtons();
            this.updateProperties();
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
    }

    protected void addBundleAction() throws RemoteException {
        BundleConfiguration config = new BundleConfiguration();
        if (this.parseProperties(config)) {
            if (!this.rfcRuntimeInterface.addBundle(config)) {
                config.setRunningState(false);
                this.errorMessage = "Error adding bundle, see LOG for details !";
                JOptionPane.showMessageDialog(this, this.errorMessage, "Error", 0);
            } else {
                config.setRunningState(true);
            }
            this.updateView();
        } else {
            JOptionPane.showMessageDialog(this, this.errorMessage, "Error", 0);
        }
    }

    protected void changeBundleAction() throws RemoteException {
        String programID = (String)this.bundleList.getSelectedValue();
        BundleConfiguration config = new BundleConfiguration();
        if (this.middlewareState) {
            config.setProgramId((String)this.bundleList.getSelectedValue());
        }
        if (this.parseProperties(config)) {
            if (!this.rfcRuntimeInterface.changeBundleConfiguration(config)) {
                this.errorMessage = "Error changing bundle's properties, see LOG for details !";
                JOptionPane.showMessageDialog(this, this.errorMessage, "Error", 0);
            }
            this.updateView();
            this.bundleList.setSelectedValue(programID, true);
        } else {
            JOptionPane.showMessageDialog(this, this.errorMessage, "Error", 0);
        }
    }

    protected void exportBundleAction() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Export to file in serialized form");
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                String programId = (String)this.bundleList.getSelectedValue();
                BundleConfiguration config = this.rfcRuntimeInterface.getConfiguration(programId);
                config.setLogonPassword("");
                ObjectOutputStream outFile = new ObjectOutputStream(new FileOutputStream(file));
                outFile.writeObject(config);
                outFile.close();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected void importBundleAction() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Import from file with serialized RFC destination");
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                ObjectInputStream inFile = new ObjectInputStream(new FileInputStream(file));
                Object obj = null;
                try {
                    obj = inFile.readObject();
                    if (!(obj instanceof BundleConfiguration)) {
                        throw new InvalidClassException("");
                    }
                }
                catch (InvalidClassException e) {
                    this.errorMessage = "The serial version of the class does not match (maybe an older version)";
                    JOptionPane.showMessageDialog(this, this.errorMessage, "Error", 0);
                    this.updateView();
                    return;
                }
                BundleConfiguration config = (BundleConfiguration)obj;
                inFile.close();
                if (!this.rfcRuntimeInterface.addBundle(config)) {
                    this.errorMessage = "Error importing bundle, see LOG for details !";
                    JOptionPane.showMessageDialog(this, this.errorMessage, "Error", 0);
                }
                this.updateView();
            }
            catch (Exception e) {
                this.handleException(e);
                this.updateView();
            }
        }
    }

    public void openProfileAction() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("The profile file for a specific connection");
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                this.programIdField.setText(file.getAbsolutePath());
            }
            catch (Exception e) {
                this.handleException(e);
                this.updateView();
            }
        }
    }

    public void selectSncLibAction() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Please select snc library path");
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                this.sncLibField.setText(file.getAbsolutePath());
            }
            catch (Exception e) {
                this.handleException(e);
                this.updateView();
            }
        }
    }

    protected boolean parseProperties(BundleConfiguration config) {
        if (this.middlewareState) {
            String profileName = this.programIdField.getText().trim();
            if (profileName.equals("")) {
                this.errorMessage = "You must provide profile name !";
                return false;
            }
            File profile = new File(profileName);
            if (!profile.exists()) {
                this.errorMessage = "You must provide a proper profile name !";
                return false;
            }
            if (profile.isDirectory()) {
                this.errorMessage = "You must provide a proper profile name !";
                return false;
            }
            int processNumber = -1;
            try {
                processNumber = Integer.parseInt(this.processNumberField.getText().trim());
            }
            catch (Exception e) {
                this.errorMessage = "You must provide valid value for the number of processes (between 1 and " + this.maxProcessesProperty + ")!";
            }
            if (processNumber < 1 || processNumber > this.maxProcessesProperty) {
                this.errorMessage = "You must provide valid value for the number of processes (between 1 and " + this.maxProcessesProperty + ") !";
                return false;
            }
            config.setProfileName(profileName);
            config.setLocal(this.localFlag.isSelected());
            config.setProcessesNumber(processNumber);
            return true;
        }
        String applicationServerHost = this.applicationServerHostField.getText().trim();
        String gateWayHost = this.gateWayHostField.getText().trim();
        String gateWayServer = this.gateWayServerField.getText().trim();
        String logonClient = this.logonClientField.getText().trim();
        String logonLanguage = this.logonLanguageField.getText().trim();
        String logonPassword = new String(this.logonPasswordField.getPassword());
        String logonUser = this.logonUserField.getText().trim();
        String programId = this.programIdField.getText().trim();
        String systemNumber = this.systemNumberField.getText().trim();
        boolean localState = this.localFlag.isSelected();
        boolean unicodeState = this.unicodeFlag.isSelected();
        int processNumber = -1;
        try {
            processNumber = Integer.parseInt(this.processNumberField.getText().trim());
        }
        catch (Exception e) {
            this.errorMessage = "You must provide valid value for the number of processes (between 1 and " + this.maxProcessesProperty + ")!";
        }
        if (programId.equals("")) {
            this.errorMessage = "You must provide program ID !";
            return false;
        }
        if (gateWayHost.equals("")) {
            this.errorMessage = "You must provide gateway host !";
            return false;
        }
        if (gateWayServer.equals("")) {
            this.errorMessage = "You must provide gateway service !";
            return false;
        }
        if (processNumber < 1 || processNumber > this.maxProcessesProperty) {
            this.errorMessage = "You must provide valid value for the number of processes (between 1 and " + this.maxProcessesProperty + ") !";
            return false;
        }
        if (applicationServerHost.equals("")) {
            this.errorMessage = "You must provide application server host !";
            return false;
        }
        if (systemNumber.equals("")) {
            this.errorMessage = "You must provide system number !";
            return false;
        }
        if (logonClient.equals("")) {
            this.errorMessage = "You must provide client !";
            return false;
        }
        if (logonLanguage.equals("")) {
            this.errorMessage = "You must provide language !";
            return false;
        }
        if (logonUser.equals("")) {
            this.errorMessage = "You must provide user !";
            return false;
        }
        if (logonPassword.equals("")) {
            this.errorMessage = "You must provide password !";
            return false;
        }
        config.setApplicationServerHost(applicationServerHost);
        config.setGatewayHost(gateWayHost);
        config.setGatewayServer(gateWayServer);
        config.setLogonClient(logonClient);
        config.setLogonLanguage(logonLanguage);
        config.setLogonPassword(logonPassword);
        config.setLogonUser(logonUser);
        config.setProgramId(programId);
        config.setSystemNumber(systemNumber);
        config.setLocal(localState);
        config.setUnicodeState(unicodeState);
        config.setProcessesNumber(processNumber);
        if (this.useSNCCheckButton.isSelected()) {
            config.setUseSnc(true);
            if (this.sncNameField.getText().trim().equals("")) {
                this.errorMessage = "You must provide SNC name !";
                return false;
            }
            if (this.sncLibField.getText().trim().equals("")) {
                this.errorMessage = "You must provide SNC library !";
                return false;
            }
            if (this.authPartnerField.getText().trim().equals("")) {
                this.errorMessage = "You must provide SNC authorization partner !";
                return false;
            }
            config.setSncLib(this.sncLibField.getText().trim());
            config.setSncName(this.sncNameField.getText().trim());
            config.setAuthPartner(this.authPartnerField.getText().trim());
            switch (this.sncQOPList.getSelectedIndex()) {
                case 0: {
                    config.setSncQop(1);
                    break;
                }
                case 1: {
                    config.setSncQop(2);
                    break;
                }
                case 2: {
                    config.setSncQop(3);
                    break;
                }
                case 3: {
                    config.setSncQop(8);
                    break;
                }
                case 4: {
                    config.setSncQop(9);
                }
            }
        }
        return true;
    }

    protected void removeBundleAction() throws RemoteException {
        int index = this.bundleList.getSelectedIndex();
        int last = 0;
        if (!this.rfcRuntimeInterface.removeBundle((String)this.bundleList.getSelectedValue())) {
            this.errorMessage = "Error removing bundle, see LOG for details !";
            JOptionPane.showMessageDialog(this, this.errorMessage, "Error", 0);
        }
        this.updateView();
        last = this.bundleList.getModel().getSize() - 1;
        if (index > last) {
            index = last;
        }
        this.bundleList.setSelectedIndex(index);
    }

    protected void setBundleAction() throws RemoteException {
        if (this.middlewareState) {
            if (!this.bundleList.getSelectionModel().isSelectionEmpty()) {
                this.changeBundleAction();
            } else {
                this.addBundleAction();
            }
        } else if (this.rfcRuntimeInterface.getConfiguration(this.programIdField.getText().trim()) == null) {
            this.addBundleAction();
        } else {
            this.changeBundleAction();
        }
    }

    protected void startBundleAction() throws RemoteException {
        String programID = (String)this.bundleList.getSelectedValue();
        if (!this.rfcRuntimeInterface.startBundle(programID)) {
            this.errorMessage = "Error starting bundle, see LOG for details !";
            JOptionPane.showMessageDialog(this, this.errorMessage, "Error", 0);
        }
        this.updateView();
        this.bundleList.setSelectedValue(programID, true);
    }

    protected void stopBundleAction() throws RemoteException {
        String programID = (String)this.bundleList.getSelectedValue();
        if (!this.rfcRuntimeInterface.stopBundle(programID)) {
            this.errorMessage = "Error stoping bundle, see LOG for details !";
            JOptionPane.showMessageDialog(this, this.errorMessage, "Error", 0);
        }
        this.updateView();
        this.bundleList.setSelectedValue(programID, true);
    }

    protected void updateView() {
        try {
            this.updateBundleList();
            this.updateButtons();
            this.updateProperties();
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
        this.repaint();
    }

    protected String[] getAllBundleProgramID() throws RemoteException {
        BundleConfiguration[] configurations;
        String[] result = null;
        if (this.rfcRuntimeInterface != null && (configurations = this.rfcRuntimeInterface.getConfigurations()) != null) {
            result = new String[configurations.length];
            int i = 0;
            while (i < configurations.length) {
                result[i] = configurations[i].getProgramId();
                ++i;
            }
        }
        Arrays.sort(result);
        return result;
    }

    protected void handleException(Exception e) {
        String show = e.getClass().getName();
        int begin = show.lastIndexOf(".") + 1;
        String buffer = show.substring(begin) + "\n" + e.getMessage();
        JOptionPane.showMessageDialog(this, buffer, "Exception occured", 0);
    }

    protected void enableSNCSettings() {
        this.authPartnerField.setEditable(this.useSNCCheckButton.isSelected());
        this.sncNameField.setEditable(this.useSNCCheckButton.isSelected());
        this.sncQOPList.setEnabled(this.useSNCCheckButton.isSelected());
        this.sncLibField.setEditable(this.useSNCCheckButton.isSelected());
        this.browseButton.setEnabled(this.useSNCCheckButton.isSelected());
        if (!this.useSNCCheckButton.isSelected()) {
            this.authPartnerField.setText("");
            this.sncNameField.setText("");
            this.sncQOPList.setSelectedIndex(0);
            this.sncLibField.setText("");
        }
    }
}

