/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rfcengine;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.security.CryptographyContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.rfcengine.Bundle;
import com.sap.engine.services.rfcengine.BundleConfiguration;
import com.sap.engine.services.rfcengine.RFCApplicationFrame;
import com.sap.engine.services.rfcengine.RFCResourceAccessor;
import com.sap.engine.services.rfcengine.RFCRuntimeInterface;
import com.sap.mw.jco.JCO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.rmi.PortableRemoteObject;

public class RFCRuntimeInterfaceImpl
extends PortableRemoteObject
implements RFCRuntimeInterface,
MessageListener,
ConfigurationChangedListener {
    public static final String RFCENGINE_CFG_GLOBAL = " rfcengine_global";
    public static final String RFCENGINE_CFG_LOCAL = " rfcengine_local";
    private boolean remoteCall = false;
    private Hashtable bundles = new Hashtable();
    private int maxProcesses = 20;
    private int maxConnections = 20;
    private ClusterContext cluster = null;
    private ApplicationServiceContext serviceContext = null;
    private CryptographyContext crypt = null;
    private Hashtable functionTable = new Hashtable();
    ConfigurationHandlerFactory cfgfactory;
    ClusterElement element = null;
    private String method = "RFCRuntimeInterfaceImpl.RFCRuntimeInterfaceImpl<init>";

    public RFCRuntimeInterfaceImpl(ApplicationServiceContext srvCtx, int maxPrcs, int maxConn, boolean defaultDestination, boolean rfc_unicode) throws RemoteException {
        this.maxProcesses = maxPrcs;
        this.maxConnections = maxConn;
        this.serviceContext = srvCtx;
        this.cluster = srvCtx.getClusterContext();
        this.crypt = ((SecurityContext)srvCtx.getContainerContext().getObjectRegistry().getProvidedInterface("security")).getCryptographyContext();
        this.cfgfactory = srvCtx.getCoreContext().getConfigurationHandlerFactory();
        try {
            srvCtx.getClusterContext().getMessageContext().registerListener(this);
        }
        catch (Exception e) {
            RFCApplicationFrame.traceError("Can't register MessageListener :" + e.toString());
        }
    }

    void init() throws RemoteException {
        ConfigurationHandler handler = null;
        Configuration rfcconfig = null;
        this.method = "RFCRuntimeInterfaceImpl.init()";
        try {
            handler = this.cfgfactory.getConfigurationHandler();
            try {
                rfcconfig = handler.openConfiguration(RFCENGINE_CFG_GLOBAL, 0);
            }
            catch (ConfigurationException e) {
                rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_GLOBAL);
            }
            Map cfgmap = rfcconfig.getAllSubConfigurations();
            Iterator i = cfgmap.values().iterator();
            while (i.hasNext()) {
                Configuration next = (Configuration)i.next();
                PropertySheet propssheet = next.getPropertySheetInterface();
                BundleConfiguration bundlecfg = new BundleConfiguration();
                this.readFromPropertySheet(propssheet, bundlecfg);
                Bundle bundle = new Bundle();
                boolean flag = bundle.initBundle(bundlecfg, this.maxProcesses, this.maxConnections, false, this.serviceContext, this);
                this.bundles.put(bundlecfg.getProgramId(), bundle);
            }
            try {
                rfcconfig = handler.openConfiguration(RFCENGINE_CFG_LOCAL, 0);
            }
            catch (ConfigurationException e) {
                rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_LOCAL);
            }
            ClusterElement element = this.cluster.getClusterMonitor().getCurrentParticipant();
            String clusterId = new Integer(element.getClusterId()).toString();
            try {
                Configuration serverConf = rfcconfig.getSubConfiguration(clusterId);
                Map maps = serverConf.getAllSubConfigurations();
                Iterator i2 = maps.values().iterator();
                while (i2.hasNext()) {
                    Configuration next = (Configuration)i2.next();
                    PropertySheet propssheet = next.getPropertySheetInterface();
                    BundleConfiguration bundlecfg = new BundleConfiguration();
                    this.readFromPropertySheet(propssheet, bundlecfg);
                    Bundle bundle = new Bundle();
                    boolean flag = bundle.initBundle(bundlecfg, this.maxProcesses, this.maxConnections, false, this.serviceContext, this);
                    this.bundles.put(bundlecfg.getProgramId(), bundle);
                }
            }
            catch (ConfigurationException ee) {
                RFCApplicationFrame.logInfo(this.method, "There are no local bundles regstered for the cluster node ", new String[]{clusterId});
            }
            handler.commit();
        }
        catch (ConfigurationException e) {
            try {
                handler.rollback();
            }
            catch (ConfigurationException cfg) {
                RFCApplicationFrame.traceError("Rollback of the database transaction failed");
                LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)cfg));
            }
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)e));
        }
    }

    void cleanup() throws RemoteException {
        if (this.bundles != null) {
            this.bundles.clear();
        } else {
            this.bundles = new Hashtable();
        }
    }

    public synchronized boolean startBundle(String prgId) throws RemoteException {
        this.method = "RFCRuntimeInterfaceImpl.startBundle(String prgId)";
        boolean flag = true;
        Bundle bndl = (Bundle)this.bundles.get(prgId);
        BundleConfiguration config = bndl.getConfiguration();
        if (bndl != null && !config.isRunning() && (flag = bndl.startAll())) {
            config.setRunningState(true);
            this.changeRunningStateInConfig(config);
        }
        if (flag) {
            RFCApplicationFrame.logInfo(this.method, "Bundle started !", new Object[]{prgId});
        } else {
            RFCApplicationFrame.logError(this.method, "Bundle failed to start!", new Object[]{prgId});
        }
        return flag;
    }

    public synchronized boolean stopBundle(String prgId) throws RemoteException {
        this.method = "RFCRuntimeInterfaceImpl.stopBundle(String prgId)";
        if (!this.bundles.containsKey(prgId)) {
            RFCApplicationFrame.logError(this.method, "Bundle not found !", new Object[]{prgId});
            return false;
        }
        boolean flag = true;
        Bundle bndl = (Bundle)this.bundles.get(prgId);
        BundleConfiguration config = bndl.getConfiguration();
        if (bndl != null && config.isRunning() && (flag = bndl.stopAll())) {
            config.setRunningState(false);
            this.changeRunningStateInConfig(config);
        }
        if (flag) {
            RFCApplicationFrame.logInfo(this.method, "Bundle was stopped !", new Object[]{prgId});
        } else {
            RFCApplicationFrame.logError(this.method, "Bundle failed to stop !", new Object[]{prgId});
        }
        return flag;
    }

    public synchronized boolean addBundle(BundleConfiguration conf) throws RemoteException {
        this.method = "RFCRuntimeInterfaceImpl.addBundle(BundleConfiguration conf)";
        boolean flag = true;
        Bundle bndl = new Bundle();
        flag = bndl.initBundle(conf, this.maxProcesses, this.maxConnections, conf.isRunning(), this.serviceContext, this);
        this.bundles.put(conf.getProgramId(), bndl);
        if (!conf.isRunning() && flag) {
            flag = bndl.startAll();
        }
        if (flag) {
            conf.setRunningState(true);
            RFCApplicationFrame.logInfo(this.method, "Bundle added !", new Object[]{conf.getProgramId()});
        } else {
            conf.setRunningState(false);
            RFCApplicationFrame.logError(this.method, "Bundle can not be added !", new Object[]{conf.getProgramId()});
        }
        ConfigurationHandler handler = null;
        Configuration rfcconfig = null;
        try {
            handler = this.cfgfactory.getConfigurationHandler();
            if (conf.isLocal()) {
                ClusterElement element = this.cluster.getClusterMonitor().getCurrentParticipant();
                String clusterId = new Integer(element.getClusterId()).toString();
                try {
                    rfcconfig = handler.openConfiguration(RFCENGINE_CFG_LOCAL, 1);
                }
                catch (ConfigurationException e) {
                    rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_LOCAL);
                }
                Configuration cfg = null;
                cfg = !rfcconfig.existsSubConfiguration(clusterId) ? rfcconfig.createSubConfiguration(clusterId) : rfcconfig.getSubConfiguration(clusterId);
                if (cfg.existsSubConfiguration(conf.getProgramId())) {
                    cfg.deleteSubConfigurations(new String[]{conf.getProgramId()});
                }
                Configuration bundleConf = cfg.createSubConfiguration(conf.getProgramId(), 1);
                handler.addConfigurationChangedListener(this, RFCENGINE_CFG_LOCAL + clusterId + conf.getProgramId());
                PropertySheet propssheet = bundleConf.getPropertySheetInterface();
                this.writeInPropertySheet(propssheet, conf);
            } else {
                try {
                    rfcconfig = handler.openConfiguration(RFCENGINE_CFG_GLOBAL, 1);
                }
                catch (ConfigurationException e) {
                    rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_GLOBAL);
                }
                if (rfcconfig.existsSubConfiguration(conf.getProgramId())) {
                    rfcconfig.deleteSubConfigurations(new String[]{conf.getProgramId()});
                }
                Configuration cfg = rfcconfig.createSubConfiguration(conf.getProgramId(), 1);
                handler.addConfigurationChangedListener(this, RFCENGINE_CFG_GLOBAL + conf.getProgramId());
                PropertySheet prsheet = cfg.getPropertySheetInterface();
                this.writeInPropertySheet(prsheet, conf);
            }
            handler.commit();
            handler.closeConfiguration(rfcconfig);
        }
        catch (ConfigurationException e) {
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)e));
            try {
                handler.rollback();
            }
            catch (ConfigurationException cfg) {
                RFCApplicationFrame.traceError("Rollback of the database transaction failed");
                LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)cfg));
            }
            RFCApplicationFrame.traceError("Transaction to the database failed");
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)e));
        }
        return flag;
    }

    public synchronized boolean removeBundle(String prgId) throws RemoteException {
        this.method = "RFCRuntimeInterfaceImpl.removeBundle(String prgId)";
        if (!this.bundles.containsKey(prgId)) {
            return false;
        }
        boolean flag = true;
        Bundle bndl = (Bundle)this.bundles.get(prgId);
        BundleConfiguration conf = bndl.getConfiguration();
        if (bndl != null) {
            flag = bndl.stopAll();
            if (flag) {
                this.bundles.remove(prgId);
            }
        } else {
            RFCApplicationFrame.logError(this.method, "Bundle cannot be removed !", new Object[]{conf.getProgramId()});
            return false;
        }
        ConfigurationHandler handler = null;
        try {
            handler = this.cfgfactory.getConfigurationHandler();
            if (conf.isLocal()) {
                this.deleteConfFromLocal(handler, conf);
            } else {
                this.deleteConfFromGlobal(handler, conf);
            }
        }
        catch (ConfigurationException e) {
            try {
                handler.rollback();
            }
            catch (ConfigurationException cfg) {
                LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)cfg));
            }
        }
        if (flag) {
            RFCApplicationFrame.logInfo(this.method, "Bundle removed !", new Object[]{conf.getProgramId()});
        } else {
            RFCApplicationFrame.logError(this.method, "Bundle can not be removed !", new Object[]{conf.getProgramId()});
        }
        return flag;
    }

    private synchronized boolean changeNumberOfProcesses(String prgId, int prcsNumber) throws RemoteException {
        Bundle bndl = (Bundle)this.bundles.get(prgId);
        if (bndl != null) {
            int nm = bndl.getProcessesNumber();
            if (nm == prcsNumber) {
                return false;
            }
            if (nm > prcsNumber) {
                int i = nm;
                while (i > prcsNumber) {
                    bndl.remove(-1);
                    --i;
                }
                return true;
            }
            int i = nm;
            while (i < prcsNumber) {
                bndl.add(-1);
                ++i;
            }
            return true;
        }
        return false;
    }

    public synchronized boolean changeBundleConfiguration(BundleConfiguration config) throws RemoteException {
        String prgId;
        boolean flag;
        block19: {
            this.method = "RFCRuntimeInterfaceImpl.changeBundleConfiguration(BundleConfiguration config)";
            flag = false;
            prgId = config.getProgramId();
            if (!this.bundles.containsKey(prgId)) {
                return false;
            }
            Bundle bndl = (Bundle)this.bundles.get(prgId);
            if (bndl.getConfiguration().equals(config)) {
                RFCApplicationFrame.logInfo(this.method, "Configuration of bundle does not need change !", new Object[]{prgId});
                return true;
            }
            boolean status = bndl.getConfiguration().isLocal();
            boolean previousState = bndl.getConfiguration().isRunning();
            Bundle bundle = new Bundle();
            JCO.removeClientPool((String)(prgId + "Bundle"));
            flag = bundle.initBundle(config, this.maxProcesses, this.maxConnections, true, this.serviceContext, this);
            if (previousState && flag) {
                flag = bundle.startAll();
                bundle.getConfiguration().setRunningState(flag);
            }
            this.bundles.put(prgId, bundle);
            if (!bndl.stopAll() && flag) {
                flag = false;
            }
            ConfigurationHandler handler = null;
            Configuration rfcconfig = null;
            try {
                handler = this.cfgfactory.getConfigurationHandler();
                this.element = this.cluster.getClusterMonitor().getCurrentParticipant();
                String clusterId = new Integer(this.element.getClusterId()).toString();
                if (config.isLocal()) {
                    Configuration programId;
                    if (!status) {
                        this.deleteConfFromGlobal(handler, config);
                        this.setLocalConfiguration(handler, config);
                        break block19;
                    }
                    try {
                        rfcconfig = handler.openConfiguration(RFCENGINE_CFG_LOCAL, 1);
                    }
                    catch (ConfigurationException e) {
                        LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)e));
                        rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_LOCAL);
                    }
                    Configuration clusterConf = rfcconfig.getSubConfiguration(clusterId);
                    if (clusterConf != null && (programId = clusterConf.getSubConfiguration(config.getProgramId())) != null) {
                        this.changePropertyEntries(programId, config);
                    }
                    handler.commit();
                    handler.closeConfiguration(rfcconfig);
                    break block19;
                }
                if (status) {
                    this.deleteConfFromLocal(handler, config);
                    this.setGlobalConfiguration(handler, config);
                    break block19;
                }
                try {
                    rfcconfig = handler.openConfiguration(RFCENGINE_CFG_GLOBAL, 1);
                }
                catch (ConfigurationException e) {
                    rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_GLOBAL);
                }
                Configuration programId = rfcconfig.getSubConfiguration(config.getProgramId());
                if (programId != null) {
                    this.changePropertyEntries(programId, config);
                }
                handler.commit();
                handler.closeConfiguration(rfcconfig);
            }
            catch (ConfigurationException e) {
                LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)e));
                try {
                    handler.rollback();
                }
                catch (ConfigurationException cfg) {
                    LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)cfg));
                }
            }
        }
        if (flag) {
            RFCApplicationFrame.logInfo(this.method, "Bundle changed !", new Object[]{prgId});
        } else {
            RFCApplicationFrame.logError(this.method, "Error changing bundle !", new Object[]{prgId});
        }
        return flag;
    }

    public synchronized BundleConfiguration getConfiguration(String programId) throws RemoteException {
        Bundle bndl = (Bundle)this.bundles.get(programId);
        if (bndl != null) {
            return bndl.getConfiguration();
        }
        return null;
    }

    public synchronized BundleConfiguration[] getConfigurations() throws RemoteException {
        Enumeration enumeration = this.bundles.elements();
        BundleConfiguration[] result = new BundleConfiguration[this.bundles.size()];
        int i = 0;
        while (enumeration.hasMoreElements()) {
            result[i++] = ((Bundle)enumeration.nextElement()).getConfiguration();
        }
        return result;
    }

    synchronized Hashtable getBundles() {
        return this.bundles;
    }

    public synchronized int getMaxProcesses() {
        return this.maxProcesses;
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    synchronized void newProperties(int prcs, int conn) {
        this.method = "RFCRuntimeInterfaceImpl.newProperties(int prcs, int conn)";
        boolean flag = false;
        this.maxProcesses = prcs;
        this.maxConnections = conn;
        Enumeration configs = this.bundles.elements();
        while (configs.hasMoreElements()) {
            BundleConfiguration cfg = ((Bundle)configs.nextElement()).getConfiguration();
            if (cfg.getProcessesNumber() > this.maxProcesses) {
                cfg.setProcessesNumber(this.maxProcesses);
                flag = true;
            }
            if (cfg.getMaxConnections() > this.maxConnections) {
                cfg.setMaxConnections(this.maxConnections);
                flag = true;
            }
            if (!flag) continue;
            flag = false;
            try {
                this.changeBundleConfiguration(cfg);
            }
            catch (RemoteException e) {
                RFCApplicationFrame.logError(this.method, "Can not change configuration of bundle !", new Object[]{cfg.getProgramId()});
                LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, e);
            }
        }
    }

    public void receive(int clusterId, int messageId, byte[] message, int offset, int length) {
        this.method = "RFCRuntimeInterfaceImpl.receive(int clusterId, int messageId, byte[] message, int offset, int length)";
        try {
            this.cleanup();
            this.init();
        }
        catch (RemoteException re) {
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, re);
            this.remoteCall = false;
            return;
        }
        this.remoteCall = false;
    }

    public MessageAnswer receiveWait(int clusterId, int messageId, byte[] message, int offset, int length) {
        return new MessageAnswer(null, 0, 0);
    }

    private synchronized void send(BundleConfiguration cfg, byte msgId) {
        this.method = "RFCRuntimeInterfaceImpl.send(BundleConfiguration cfg, byte msgId)";
        if (this.remoteCall) {
            this.remoteCall = false;
            return;
        }
        ClusterElement[] elements = this.cluster.getClusterMonitor().getParticipants();
        int i = 0;
        while (i < elements.length) {
            int id = elements[i].getClusterId();
            if (elements[i].getType() == 2) {
                byte[] arr = null;
                try {
                    arr = RFCRuntimeInterfaceImpl.getByteArray(cfg);
                }
                catch (Exception e) {
                    RFCApplicationFrame.logError(this.method, "Message could not be sent due to serialization problems !", new Object[]{new Integer(msgId)});
                    return;
                }
                try {
                    this.cluster.getMessageContext().send(id, msgId, arr, 0, arr.length);
                }
                catch (ClusterException e) {
                    LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)e));
                }
            }
            ++i;
        }
    }

    private static byte[] getByteArray(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(obj);
            oos.close();
        }
        catch (Exception ex) {
            oos.close();
            throw ex;
        }
        return baos.toByteArray();
    }

    private static Object getObject(byte[] obj) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(obj);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object object = null;
        try {
            object = ois.readObject();
            ois.close();
        }
        catch (Exception ex) {
            ois.close();
            throw ex;
        }
        return object;
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public void configurationChanged(ChangeEvent e) {
        this.method = "RFCRuntimeInterfaceImpl.configurationChanged(com.sap.engine.frame.core.configuration.ChangeEvent e)";
        String bundle = null;
        ConfigurationHandler handler = null;
        BundleConfiguration newBundle = null;
        Configuration rfcconfig = null;
        String clusterId = new Integer(this.element.getClusterId()).toString();
        String path = e.getPath();
        try {
            if (path.startsWith(RFCENGINE_CFG_GLOBAL)) {
                bundle = path.substring(20);
                newBundle = new BundleConfiguration();
                handler = this.cfgfactory.getConfigurationHandler();
                try {
                    rfcconfig = handler.openConfiguration(RFCENGINE_CFG_GLOBAL, 0);
                }
                catch (ConfigurationException ex) {
                    rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_GLOBAL);
                }
                Configuration programId = rfcconfig.getSubConfiguration(bundle);
                if (programId != null) {
                    PropertySheet propssheet = programId.getPropertySheetInterface();
                    this.readFromPropertySheet(propssheet, newBundle);
                }
            } else if (path.startsWith(RFCENGINE_CFG_LOCAL)) {
                Configuration programId;
                bundle = path.substring(19 + clusterId.length());
                newBundle = new BundleConfiguration();
                try {
                    rfcconfig = handler.openConfiguration(RFCENGINE_CFG_LOCAL, 0);
                }
                catch (ConfigurationException ex) {
                    rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_LOCAL);
                }
                Configuration serverConf = rfcconfig.getSubConfiguration(clusterId);
                if (serverConf != null && (programId = serverConf.getSubConfiguration(bundle)) != null) {
                    PropertySheet propssheet = programId.getPropertySheetInterface();
                    this.readFromPropertySheet(propssheet, newBundle);
                }
            }
            switch (e.getAction()) {
                case 0: {
                    this.bundles.remove(bundle);
                    this.bundles.put(bundle, newBundle);
                    break;
                }
                case 1: {
                    this.bundles.put(bundle, newBundle);
                    break;
                }
                case 2: {
                    this.bundles.remove(bundle);
                }
            }
        }
        catch (ConfigurationException exept) {
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)exept));
        }
    }

    private void writeInPropertySheet(PropertySheet propssheet, BundleConfiguration conf) throws ConfigurationException {
        propssheet.createPropertyEntry("application.server.host", conf.getApplicationServerHost(), "Application_server_host");
        propssheet.createPropertyEntry("gateway.host", conf.getGatewayHost(), "Gateaway_host");
        propssheet.createPropertyEntry("gateway.server", conf.getGatewayServer(), "Gateaway_server");
        propssheet.createPropertyEntry("local", new Boolean(conf.isLocal()).toString(), "Is_local");
        propssheet.createPropertyEntry("logon.client", conf.getLogonClient(), "Logon_client");
        propssheet.createPropertyEntry("logon.language", conf.getLogonLanguage(), "Logon_language");
        propssheet.createSecurePropertyEntry("logon.password", conf.getLogonPassword(), "Logon_password");
        propssheet.createPropertyEntry("logon.user", conf.getLogonUser(), "Logon_user");
        propssheet.createPropertyEntry("max.connections.", new Integer(conf.getMaxConnections()).toString(), "Maximum_connections");
        propssheet.createPropertyEntry("processes.number", new Integer(conf.getProcessesNumber()).toString(), "Process_number");
        propssheet.createPropertyEntry("prifile.name", conf.getProfileName(), "Profile_name");
        propssheet.createPropertyEntry("program.id", conf.getProgramId(), "Program_ID");
        propssheet.createPropertyEntry("running.state", new Boolean(conf.isRunning()).toString(), "Running_state");
        propssheet.createPropertyEntry("syste.number", conf.getSystemNumber(), "System_number");
        propssheet.createPropertyEntry("unicode", new Boolean(conf.isUnicode()).toString(), "Unicode_state");
        if (conf.getUseSnc()) {
            propssheet.createPropertyEntry("use.snc", new Boolean(true).toString(), "Use_Snc");
            propssheet.createPropertyEntry("jco.server.snc_lib", conf.getSncLib(), "Snc_Lib");
            propssheet.createPropertyEntry("jco.server.snc_myname", conf.getSncName(), "Snc_Name");
            propssheet.createPropertyEntry("jco.server.snc_qop", new Integer(conf.getSncQop()).toString(), "Snc_Qop");
            propssheet.createPropertyEntry("jco.server.auth_partner", conf.getAuthPartner(), "Snc_Auth_Partner");
        }
    }

    private void readFromPropertySheet(PropertySheet propssheet, BundleConfiguration bundlecfg) throws ConfigurationException {
        bundlecfg.setApplicationServerHost((String)propssheet.getPropertyEntry("application.server.host").getValue());
        bundlecfg.setGatewayHost((String)propssheet.getPropertyEntry("gateway.host").getValue());
        bundlecfg.setGatewayServer((String)propssheet.getPropertyEntry("gateway.server").getValue());
        boolean local = new Boolean((String)propssheet.getPropertyEntry("local").getValue());
        bundlecfg.setLocal(local);
        bundlecfg.setLogonClient((String)propssheet.getPropertyEntry("logon.client").getValue());
        bundlecfg.setLogonLanguage((String)propssheet.getPropertyEntry("logon.language").getValue());
        bundlecfg.setLogonPassword((String)propssheet.getPropertyEntry("logon.password").getValue());
        bundlecfg.setLogonUser((String)propssheet.getPropertyEntry("logon.user").getValue());
        int mc = Integer.parseInt((String)propssheet.getPropertyEntry("max.connections.").getValue());
        bundlecfg.setMaxConnections(mc);
        int pn = Integer.parseInt((String)propssheet.getPropertyEntry("processes.number").getValue());
        bundlecfg.setProcessesNumber(pn);
        bundlecfg.setProfileName((String)propssheet.getPropertyEntry("prifile.name").getValue());
        bundlecfg.setProgramId((String)propssheet.getPropertyEntry("program.id").getValue());
        boolean rs = new Boolean((String)propssheet.getPropertyEntry("running.state").getValue());
        bundlecfg.setRunningState(rs);
        bundlecfg.setSystemNumber((String)propssheet.getPropertyEntry("syste.number").getValue());
        boolean us = new Boolean((String)propssheet.getPropertyEntry("unicode").getValue());
        bundlecfg.setUnicodeState(us);
        try {
            propssheet.getPropertyEntry("use.snc");
            bundlecfg.setUseSnc(true);
            bundlecfg.setSncLib((String)propssheet.getPropertyEntry("jco.server.snc_lib").getValue());
            bundlecfg.setSncName((String)propssheet.getPropertyEntry("jco.server.snc_myname").getValue());
            int qop = Integer.parseInt((String)propssheet.getPropertyEntry("jco.server.snc_qop").getValue());
            bundlecfg.setSncQop(qop);
            bundlecfg.setAuthPartner((String)propssheet.getPropertyEntry("jco.server.auth_partner").getValue());
        }
        catch (NameNotFoundException ex) {
            LoggingHelper.traceThrowable(100, RFCResourceAccessor.location, "RFCRuntimeInterfaceImpl.readFromPropertySheet()", (Throwable)((Object)ex));
        }
    }

    private void setLocalConfiguration(ConfigurationHandler handler, BundleConfiguration config) throws ConfigurationException {
        Configuration rfcconfig = null;
        String clusterId = new Integer(this.element.getClusterId()).toString();
        try {
            rfcconfig = handler.openConfiguration(RFCENGINE_CFG_LOCAL, 1);
        }
        catch (ConfigurationException e) {
            rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_LOCAL);
        }
        if (!rfcconfig.existsSubConfiguration(clusterId)) {
            Configuration cfg = rfcconfig.createSubConfiguration(clusterId);
            Configuration bundleConf = cfg.createSubConfiguration(config.getProgramId(), 1);
            PropertySheet propssheet = bundleConf.getPropertySheetInterface();
            this.writeInPropertySheet(propssheet, config);
        } else {
            Configuration cfg = rfcconfig.getSubConfiguration(clusterId);
            Configuration bundleConf = cfg.createSubConfiguration(config.getProgramId(), 1);
            PropertySheet propssheet = bundleConf.getPropertySheetInterface();
            this.writeInPropertySheet(propssheet, config);
        }
        handler.commit();
        handler.closeConfiguration(rfcconfig);
    }

    private void setGlobalConfiguration(ConfigurationHandler handler, BundleConfiguration config) throws ConfigurationException {
        Configuration rfcconfig = null;
        try {
            rfcconfig = handler.openConfiguration(RFCENGINE_CFG_GLOBAL, 1);
        }
        catch (ConfigurationException e) {
            rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_GLOBAL);
        }
        if (!rfcconfig.existsSubConfiguration(config.getProgramId())) {
            Configuration cfg = rfcconfig.createSubConfiguration(config.getProgramId(), 1);
            PropertySheet prsheet = cfg.getPropertySheetInterface();
            this.writeInPropertySheet(prsheet, config);
        }
        handler.commit();
        handler.closeConfiguration(rfcconfig);
    }

    private void changePropertyEntries(Configuration config, BundleConfiguration bundlecfg) throws ConfigurationException {
        PropertySheet propssheet = config.getPropertySheetInterface();
        propssheet.getPropertyEntry("application.server.host").setValue(bundlecfg.getApplicationServerHost());
        propssheet.getPropertyEntry("gateway.host").setValue(bundlecfg.getGatewayHost());
        propssheet.getPropertyEntry("gateway.server").setValue(bundlecfg.getGatewayServer());
        propssheet.getPropertyEntry("local").setValue(new Boolean(bundlecfg.isLocal()).toString());
        propssheet.getPropertyEntry("logon.client").setValue(bundlecfg.getLogonClient());
        propssheet.getPropertyEntry("logon.language").setValue(bundlecfg.getLogonLanguage());
        propssheet.getPropertyEntry("logon.password").setValue(bundlecfg.getLogonPassword());
        propssheet.getPropertyEntry("logon.password").setSecure(true);
        propssheet.getPropertyEntry("logon.user").setValue(bundlecfg.getLogonUser());
        propssheet.getPropertyEntry("max.connections.").setValue(new Integer(bundlecfg.getMaxConnections()).toString());
        propssheet.getPropertyEntry("processes.number").setValue(new Integer(bundlecfg.getProcessesNumber()).toString());
        propssheet.getPropertyEntry("prifile.name").setValue(bundlecfg.getProfileName());
        propssheet.getPropertyEntry("program.id").setValue(bundlecfg.getProgramId());
        propssheet.getPropertyEntry("running.state").setValue(new Boolean(bundlecfg.isRunning()).toString());
        propssheet.getPropertyEntry("syste.number").setValue(bundlecfg.getSystemNumber());
        propssheet.getPropertyEntry("unicode").setValue(new Boolean(bundlecfg.isUnicode()).toString());
        if (bundlecfg.getUseSnc()) {
            try {
                PropertyEntry p = propssheet.getPropertyEntry("use.snc");
                p.setValue("true");
                propssheet.getPropertyEntry("jco.server.snc_lib").setValue(bundlecfg.getSncLib());
                propssheet.getPropertyEntry("jco.server.snc_myname").setValue(bundlecfg.getSncName());
                propssheet.getPropertyEntry("jco.server.snc_qop").setValue(new Integer(bundlecfg.getSncQop()).toString());
                propssheet.getPropertyEntry("jco.server.auth_partner").setValue(bundlecfg.getAuthPartner());
            }
            catch (NameNotFoundException ex) {
                propssheet.createPropertyEntry("use.snc", "true", "Use_Snc");
                propssheet.createPropertyEntry("jco.server.snc_lib", bundlecfg.getSncLib(), "Snc_Lib");
                propssheet.createPropertyEntry("jco.server.snc_myname", bundlecfg.getSncName(), "Snc_Name");
                propssheet.createPropertyEntry("jco.server.snc_qop", new Integer(bundlecfg.getSncQop()).toString(), "Snc_Qop");
                propssheet.createPropertyEntry("jco.server.auth_partner", bundlecfg.getAuthPartner(), "Snc_Auth_Partner");
            }
        } else {
            try {
                propssheet.deletePropertyEntry("use.snc");
                propssheet.deletePropertyEntry("jco.server.snc_lib");
                propssheet.deletePropertyEntry("jco.server.snc_myname");
                propssheet.deletePropertyEntry("jco.server.snc_qop");
                propssheet.deletePropertyEntry("jco.server.auth_partner");
            }
            catch (NameNotFoundException ex) {
                LoggingHelper.traceThrowable(100, RFCResourceAccessor.location, "RFCRuntimeInterfaceImpl.changePropertyEntries(Configuration config, BundleConfiguration bundlecfg)", (Throwable)((Object)ex));
            }
        }
    }

    private void deleteConfFromLocal(ConfigurationHandler handler, BundleConfiguration config) throws ConfigurationException {
        this.element = this.cluster.getClusterMonitor().getCurrentParticipant();
        String clusterId = new Integer(this.element.getClusterId()).toString();
        Configuration rfcconfig = null;
        try {
            rfcconfig = handler.openConfiguration(RFCENGINE_CFG_LOCAL, 1);
        }
        catch (ConfigurationException e) {
            rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_LOCAL);
        }
        Configuration clusterConf = rfcconfig.getSubConfiguration(clusterId);
        if (clusterConf != null && clusterConf.existsSubConfiguration(config.getProgramId())) {
            clusterConf.deleteConfiguration(config.getProgramId());
        }
        handler.commit();
        handler.closeConfiguration(rfcconfig);
    }

    private void deleteConfFromGlobal(ConfigurationHandler handler, BundleConfiguration config) throws ConfigurationException {
        Configuration rfcconfig = null;
        try {
            rfcconfig = handler.openConfiguration(RFCENGINE_CFG_GLOBAL, 1);
        }
        catch (ConfigurationException e) {
            rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_GLOBAL);
        }
        if (rfcconfig.existsSubConfiguration(config.getProgramId())) {
            rfcconfig.deleteConfiguration(config.getProgramId());
        }
        handler.commit();
        handler.closeConfiguration(rfcconfig);
    }

    private void changeRunningStateInConfig(BundleConfiguration config) {
        this.method = "RFCRuntimeInterfaceImpl.changeRunningStateInConfig(BundleConfiguration config)";
        this.element = this.cluster.getClusterMonitor().getCurrentParticipant();
        String clusterId = new Integer(this.element.getClusterId()).toString();
        Configuration rfcconfig = null;
        ConfigurationHandler handler = null;
        try {
            handler = this.cfgfactory.getConfigurationHandler();
            if (config.isLocal()) {
                Configuration programId;
                try {
                    rfcconfig = handler.openConfiguration(RFCENGINE_CFG_LOCAL, 1);
                }
                catch (ConfigurationException e) {
                    rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_LOCAL);
                }
                Configuration clusterConf = rfcconfig.getSubConfiguration(clusterId);
                if (clusterConf != null && (programId = clusterConf.getSubConfiguration(config.getProgramId())) != null) {
                    PropertySheet propssheet = programId.getPropertySheetInterface();
                    propssheet.getPropertyEntry("running.state").setValue(new Boolean(config.isRunning()).toString());
                }
            } else {
                try {
                    rfcconfig = handler.openConfiguration(RFCENGINE_CFG_GLOBAL, 1);
                }
                catch (ConfigurationException e) {
                    rfcconfig = handler.createRootConfiguration(RFCENGINE_CFG_GLOBAL);
                }
                Configuration programId = rfcconfig.getSubConfiguration(config.getProgramId());
                if (programId != null) {
                    PropertySheet propssheet = programId.getPropertySheetInterface();
                    propssheet.getPropertyEntry("running.state").setValue(new Boolean(config.isRunning()).toString());
                }
            }
            handler.commit();
            handler.closeConfiguration(rfcconfig);
        }
        catch (ConfigurationException e) {
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, (Throwable)((Object)e));
        }
    }

    public void registerFunction(String functionName, String ejbName) {
        this.functionTable.put(functionName, ejbName);
    }

    public void unregisterFunction(String functionName) {
        this.functionTable.remove(functionName);
    }

    public Hashtable getFunctionNamesTable() {
        return this.functionTable;
    }
}

