/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rfcengine;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.rfcengine.RFCApplicationFrame;
import com.sap.engine.services.rfcengine.RFCRequestHandler;
import com.sap.engine.services.rfcengine.RFCResourceAccessor;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.util.Properties;

public class RFCJCOServer
extends JCO.Server {
    static final long WAIT_INTERVAL = 10000L;
    static final int RETRIES = 10;
    private String authParner;
    private RFCRequestHandler handler = null;
    private String programId = null;

    public RFCJCOServer(String gatewayHost, String gatewayServer, String programId, IRepository repository) {
        super(gatewayHost, gatewayServer, programId, repository);
        this.programId = programId;
    }

    public RFCJCOServer(Properties prop, String prgId, IRepository repository) {
        super(prop, repository);
        this.programId = prgId;
    }

    public void handleRequest(JCO.Function function) throws JCO.J2EEAbapException, JCO.AbapException {
        boolean finished = false;
        Object abaperr = null;
        Object scheduler = new Object();
        ApplicationRunnable r = new ApplicationRunnable(function, scheduler);
        Object object = scheduler;
        synchronized (object) {
            RFCApplicationFrame.globalServiceContext.getCoreContext().getThreadSystem().startThread(r, false);
            while (!finished) {
                try {
                    scheduler.wait();
                    if (!r.finished()) continue;
                    finished = true;
                    break;
                }
                catch (InterruptedException ie) {
                    LoggingHelper.traceThrowable(100, RFCResourceAccessor.location, "RFCJCOServer.handleRequest(JCO.Function function)", ie);
                }
            }
        }
        if (!finished) {
            throw new RuntimeException(" Timeout processing JCO.Function " + function);
        }
        r.forwardMethodException();
    }

    public void handleRequestInternal(JCO.Function function) throws Throwable {
        if (this.handler != null) {
            this.handler.setTicket(this.getAttributes().getSSOTicket());
            this.handler.handleRequest(function);
        } else {
            System.out.println("No handler found for incomming request: " + function.getName());
        }
    }

    public synchronized void registerHandler(RFCRequestHandler handler) {
        this.handler = handler;
    }

    public synchronized RFCRequestHandler unregisterHandler() {
        RFCRequestHandler result = this.handler;
        this.handler = null;
        return result;
    }

    protected boolean checkAuthorization(String function_name, int authorization_mode, String authorization_partner, byte[] authorization_key) {
        RFCApplicationFrame.logInfo("checkAuthorization", "Function name:    ", new String[]{function_name});
        RFCApplicationFrame.logInfo("checkAuthorization", "Authorization Parner:   ", new String[]{authorization_partner});
        RFCApplicationFrame.logInfo("checkAuthorization", "Authorization Parner set by user:   ", new String[]{this.authParner});
        if (this.authParner != null) {
            return authorization_partner.equals(this.authParner);
        }
        return false;
    }

    public void setAuthorizationPartner(String partner) {
        this.authParner = partner;
    }

    class ApplicationRunnable
    implements Runnable {
        JCO.Function function;
        Object scheduler;
        boolean finished = false;
        RuntimeException anyerr = null;
        JCO.AbapException abaperr = null;
        JCO.J2EEAbapException j2eeabaperr = null;

        ApplicationRunnable(JCO.Function function0, Object scheduler0) {
            this.function = function0;
            this.scheduler = scheduler0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            try {
                try {
                    RFCJCOServer.this.handleRequestInternal(this.function);
                }
                catch (JCO.AbapException jae) {
                    this.abaperr = jae;
                    Object var8_2 = null;
                    Object object3 = this.scheduler;
                    synchronized (object3) {
                        this.finished = true;
                        this.scheduler.notify();
                        return;
                    }
                }
                catch (JCO.J2EEAbapException jjae) {
                    JCO.AbapException a = jjae.getAbapException();
                    if (a != null) {
                        this.abaperr = a;
                    } else {
                        this.j2eeabaperr = jjae;
                    }
                    Object var8_3 = null;
                    Object object4 = this.scheduler;
                    synchronized (object4) {
                        this.finished = true;
                        this.scheduler.notify();
                        return;
                    }
                }
                catch (RuntimeException r) {
                    this.anyerr = r;
                    Object var8_4 = null;
                    Object object5 = this.scheduler;
                    synchronized (object5) {
                        this.finished = true;
                        this.scheduler.notify();
                        return;
                    }
                }
                catch (ThreadDeath death) {
                    throw death;
                }
                catch (OutOfMemoryError outofmem) {
                    throw outofmem;
                }
                catch (Throwable t) {
                    this.anyerr = new RuntimeException(t.toString());
                    Object var8_5 = null;
                    Object object6 = this.scheduler;
                    synchronized (object6) {
                        this.finished = true;
                        this.scheduler.notify();
                        return;
                    }
                }
                Object var8_1 = null;
                object = this.scheduler;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                Object object2 = this.scheduler;
                synchronized (object2) {
                    this.finished = true;
                    this.scheduler.notify();
                    throw throwable;
                }
            }
            synchronized (object) {
                this.finished = true;
                this.scheduler.notify();
                return;
            }
        }

        void forwardMethodException() throws JCO.AbapException, JCO.J2EEAbapException {
            if (this.abaperr != null) {
                LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, "RFCJCOServer.handleRequestInternal()", this.abaperr);
                throw this.abaperr;
            }
            if (this.j2eeabaperr != null) {
                LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, "RFCJCOServer.handleRequestInternal()", this.j2eeabaperr);
                throw this.j2eeabaperr;
            }
            if (this.anyerr != null) {
                LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, "RFCJCOServer.handleRequestInternal()", this.anyerr);
                throw this.anyerr;
            }
        }

        boolean finished() {
            return this.finished;
        }
    }
}

