/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rfcengine;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.rfcengine.RFCApplicationFrame;
import com.sap.engine.services.rfcengine.RFCException;
import com.sap.engine.services.rfcengine.RFCRequestHandler;
import com.sap.engine.services.rfcengine.RFCResourceAccessor;
import com.sap.engine.services.rfcengine.RFCRuntimeInterfaceImpl;
import com.sap.engine.services.rfcengine.security.impl.RFCCallbackHandlerImpl;
import com.sap.mw.jco.JCO;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class RFCDefaultRequestHandler
implements RFCRequestHandler {
    private ApplicationServiceContext serviceContext = null;
    private Class[] sessionBeanParameterClasses = null;
    private RFCRuntimeInterfaceImpl runtimeInterface = null;
    private InitialContext ctx = null;
    private String ticket = null;
    static /* synthetic */ Class class$com$sap$mw$jco$JCO$Function;

    public RFCDefaultRequestHandler(ApplicationServiceContext serviceContext, RFCRuntimeInterfaceImpl rintf) {
        this.runtimeInterface = rintf;
        this.serviceContext = serviceContext;
        this.sessionBeanParameterClasses = new Class[]{class$com$sap$mw$jco$JCO$Function == null ? (class$com$sap$mw$jco$JCO$Function = RFCDefaultRequestHandler.class$("com.sap.mw.jco.JCO$Function")) : class$com$sap$mw$jco$JCO$Function};
    }

    public void handleRequest(JCO.Function function) throws Throwable {
        if (this.ticket != null) {
            RFCApplicationFrame.logInfo("handleRequest", "SSO Ticket received from an R/3 side!", new String[0]);
            RFCCallbackHandlerImpl handler = new RFCCallbackHandlerImpl(this.ticket);
            try {
                new LoginContext("evaluate_assertion_ticket", handler).login();
            }
            catch (LoginException le) {
                LoggingHelper.traceThrowable(100, RFCResourceAccessor.location, "handleRequest", le);
                throw new RFCException("rfc_0006", le);
            }
            RFCApplicationFrame.logInfo("handleRequest", "R/3 call authorized!", new String[0]);
        }
        String functionName = function.getName();
        String beanName = (String)this.runtimeInterface.getFunctionNamesTable().get(functionName);
        if (beanName == null) {
            beanName = functionName;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextLoader = currentThread.getContextClassLoader();
        ClassLoader rfcLoader = this.getClass().getClassLoader();
        currentThread.setContextClassLoader(rfcLoader);
        try {
            try {
                Object ejbobject;
                if (this.ctx == null) {
                    this.ctx = new InitialContext();
                }
                Object home = this.ctx.lookup("rfcaccessejb/" + beanName);
                Method createMethod = null;
                Method processFunctionMethod = null;
                if (home != null) {
                    ClassLoader moduleLoader = home.getClass().getClassLoader();
                    currentThread.setContextClassLoader(moduleLoader);
                    ejbobject = null;
                    try {
                        createMethod = home.getClass().getMethod("create", null);
                        ejbobject = createMethod.invoke(home, null);
                    }
                    catch (NoSuchMethodException nme) {
                        throw new RFCException("rfc_0005", new String[]{home.getClass().toString()}, nme);
                    }
                } else {
                    throw new RFCException("rfc_0000", new String[]{beanName});
                }
                processFunctionMethod = ejbobject.getClass().getMethod("processFunction", this.sessionBeanParameterClasses);
                Object[] parameters = new Object[]{function};
                processFunctionMethod.invoke(ejbobject, parameters);
                Object var14_18 = null;
                currentThread.setContextClassLoader(contextLoader);
            }
            catch (NamingException ne) {
                throw new RFCException("rfc_0000", new String[]{beanName}, ne);
            }
            catch (InvocationTargetException ite) {
                LoggingHelper.traceThrowable(100, RFCResourceAccessor.location, "RFCDefaultRequestHandler.handleRequest()", ite);
                throw ite.getTargetException();
            }
            catch (NoSuchMethodException nme) {
                throw new RFCException("rfc_0001", nme);
            }
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            currentThread.setContextClassLoader(contextLoader);
            throw throwable;
        }
    }

    public void setTicket(String _ticket) {
        this.ticket = _ticket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

