/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rfcengine;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.ApplicationContainerContext;
import com.sap.engine.interfaces.log.Logger;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.deploy.DeployCallbackImpl;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.rfcengine.Bundle;
import com.sap.engine.services.rfcengine.DeployListenerImpl;
import com.sap.engine.services.rfcengine.RFCContainerEventListener;
import com.sap.engine.services.rfcengine.RFCResourceAccessor;
import com.sap.engine.services.rfcengine.RFCRuntimeInterfaceImpl;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RFCApplicationFrame
implements ApplicationServiceFrame {
    static ApplicationServiceContext globalServiceContext;
    private RFCRuntimeInterfaceImpl interfaceImpl = null;
    private int maxProcesses = 20;
    private int maxConnections = 20;
    protected static ApplicationContainerContext containerContext;
    public static Logger logger;
    private RFCContainerEventListener containerEventListener = null;
    private boolean destinationFlag = true;
    private boolean frfc_unicode = false;
    private String method = null;
    private ApplicationServiceContext serviceContext = null;
    private DeployCallbackImpl callback;
    private DeployListenerImpl dListener;
    private DeployService dService;
    private InitialContext ctx;

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        this.method = "RFCApplicationFrame.start(ApplicationServiceContext serviceContext)";
        this.serviceContext = serviceContext;
        globalServiceContext = serviceContext;
        this.changeProperties(serviceContext.getServiceState().getProperties());
        Location location = Location.getLocation((String)"com.sap.engine.services.rfcengine");
        Category category = Category.getCategory((String)RFCResourceAccessor.CATEGORY);
        new RFCResourceAccessor().init(category, location);
        Object rfcRequestHandler = null;
        try {
            this.containerEventListener = new RFCContainerEventListener();
        }
        catch (Throwable t) {
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, t);
        }
        containerContext = serviceContext.getContainerContext();
        int mask = 192;
        HashSet<String> names = new HashSet<String>(1);
        names.add("log");
        serviceContext.getServiceState().registerContainerEventListener(mask, names, this.containerEventListener);
        try {
            this.interfaceImpl = new RFCRuntimeInterfaceImpl(serviceContext, this.maxProcesses, this.maxConnections, this.destinationFlag, this.frfc_unicode);
        }
        catch (RemoteException re) {
            RFCApplicationFrame.traceError("Unable to prepare the service's interface !");
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, re);
        }
        if (this.interfaceImpl != null) {
            try {
                this.interfaceImpl.init();
            }
            catch (RemoteException re) {
                RFCApplicationFrame.traceError("Unable to initialize the service's interface !");
                LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, re);
            }
        } else {
            RFCApplicationFrame.traceError("Could not register runtime interface !");
            throw new ServiceException("Could not register runtime interface !");
        }
        serviceContext.getContainerContext().getObjectRegistry().registerInterface(this.interfaceImpl);
        serviceContext.getServiceState().registerManagementInterface(this.interfaceImpl);
        this.registerDeployListener();
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        String rfcUnicode;
        try {
            this.maxProcesses = Integer.parseInt(properties.getProperty("MaxProcesses", "20"));
            if (this.maxProcesses > 100) {
                this.maxProcesses = 100;
            }
        }
        catch (NumberFormatException nfe) {
            this.maxProcesses = 20;
        }
        try {
            this.maxConnections = Integer.parseInt(properties.getProperty("MaxConnections", "20"));
            if (this.maxConnections > 100) {
                this.maxConnections = 100;
            }
        }
        catch (NumberFormatException nfe) {
            this.maxConnections = 20;
        }
        String rfcDest = properties.getProperty("RFC_Default_Destination");
        if (rfcDest != null && rfcDest.equals("false")) {
            this.destinationFlag = false;
        }
        if ((rfcUnicode = properties.getProperty("default_unicode")) != null && rfcUnicode.equals("true")) {
            this.frfc_unicode = true;
        }
        if (this.interfaceImpl != null) {
            this.interfaceImpl.newProperties(this.maxProcesses, this.maxConnections);
        }
        return true;
    }

    public void stop() {
        this.method = "RFCApplicationFrame.stop()";
        Enumeration cycle = this.interfaceImpl.getBundles().elements();
        while (cycle.hasMoreElements()) {
            ((Bundle)cycle.nextElement()).stopAll();
        }
        try {
            this.interfaceImpl.cleanup();
        }
        catch (RemoteException re) {
            RFCApplicationFrame.traceError("Unable to cleanup ! Reason : " + re.getMessage());
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, re);
        }
        this.containerEventListener.destroyLogger();
        this.serviceContext.getClusterContext().getMessageContext().unregisterListener();
        this.serviceContext.getServiceState().unregisterManagementInterface();
        this.callback.removeDeployListener(this.dListener);
    }

    private void registerDeployListener() {
        try {
            if (this.ctx == null) {
                this.ctx = new InitialContext();
                this.dService = (DeployService)this.ctx.lookup("deploy");
            }
        }
        catch (NamingException ne) {
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, "RFCApplicationFrame.registerDeployListener()", ne);
        }
        if (this.callback == null) {
            this.callback = new DeployCallbackImpl();
            this.dListener = new DeployListenerImpl(this.interfaceImpl.getBundles());
            this.callback.addDeployListener(this.dListener);
        }
        try {
            this.dService.registerDeployCallback(this.callback, null);
        }
        catch (RemoteException re) {
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, "RFCApplicationFrame.registerDeployListener()", re);
        }
    }

    public Object getServiceInterface() {
        return this.interfaceImpl;
    }

    public static void logError(String message) {
        if (RFCResourceAccessor.category != null) {
            RFCResourceAccessor.category.errorT(RFCResourceAccessor.location, message);
        }
    }

    public static void logError(String method, String message, Object[] obj) {
        if (RFCResourceAccessor.category != null) {
            RFCResourceAccessor.category.errorT(RFCResourceAccessor.location, method, message, obj);
        }
    }

    public static void logInfo(String method, String message, Object[] obj) {
        if (RFCResourceAccessor.category != null) {
            RFCResourceAccessor.category.infoT(RFCResourceAccessor.location, method, message, obj);
        }
    }

    public static void traceError(String message) {
        if (RFCResourceAccessor.location != null) {
            RFCResourceAccessor.location.errorT(RFCResourceAccessor.category, message);
        }
    }

    public static void traceError(String method, String message, Object[] obj) {
        if (RFCResourceAccessor.location != null) {
            RFCResourceAccessor.location.errorT(RFCResourceAccessor.category, method, message, obj);
        }
    }

    static {
        containerContext = null;
        logger = null;
    }
}

