/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rfcengine;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.rfcengine.BundleConfiguration;
import com.sap.engine.services.rfcengine.RFCApplicationFrame;
import com.sap.engine.services.rfcengine.RFCDefaultRequestHandler;
import com.sap.engine.services.rfcengine.RFCJCOServer;
import com.sap.engine.services.rfcengine.RFCRequestHandler;
import com.sap.engine.services.rfcengine.RFCResourceAccessor;
import com.sap.engine.services.rfcengine.RFCRuntimeInterfaceImpl;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.util.Properties;

public class JCOParadigm
implements JCO.ServerExceptionListener,
JCO.ServerErrorListener {
    private RFCJCOServer server = null;
    private RFCRequestHandler handler = null;
    private int maxConnections = -1;
    private String programId = null;
    private ApplicationServiceContext serviceContext = null;
    private RFCRuntimeInterfaceImpl runtimeInterface = null;

    public JCOParadigm(ApplicationServiceContext serviceContext, RFCRuntimeInterfaceImpl _runtimeInterface) {
        this.runtimeInterface = _runtimeInterface;
        this.serviceContext = serviceContext;
        try {
            this.handler = new RFCDefaultRequestHandler(serviceContext, this.runtimeInterface);
        }
        catch (Exception e) {
            RFCApplicationFrame.logError("Could not construct RFCRequestHandle!");
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, "JCOParadigm.<init>", e);
            return;
        }
    }

    synchronized void createServer(BundleConfiguration config, IRepository repository) {
        this.programId = config.getProgramId();
        try {
            Properties p = new Properties();
            p.setProperty("jco.server.gwhost", config.getGatewayHost());
            p.setProperty("jco.server.gwserv", config.getGatewayServer());
            p.setProperty("jco.server.progid", this.programId);
            if (config.isUnicode()) {
                p.setProperty("jco.server.unicode", "1");
            } else {
                p.setProperty("jco.server.unicode", "0");
            }
            if (config.getUseSnc()) {
                p.setProperty("jco.server.snc_myname", config.getSncName());
                p.setProperty("jco.server.snc_qop", new Integer(config.getSncQop()).toString());
                p.setProperty("jco.server.snc_lib", config.getSncLib());
            }
            this.server = new RFCJCOServer(p, this.programId, repository);
            if (config.getUseSnc()) {
                this.server.setAuthorizationPartner(config.getAuthPartner());
            }
            JCO.addServerErrorListener((JCO.ServerErrorListener)this);
            JCO.addServerExceptionListener((JCO.ServerExceptionListener)this);
        }
        catch (Error er) {
            this.handleThrowable(er);
        }
        catch (Exception ex) {
            this.handleThrowable(ex);
        }
        if (this.server != null) {
            this.server.registerHandler(this.handler);
        }
    }

    public boolean startServer(BundleConfiguration config, IRepository repository) {
        boolean flag = false;
        try {
            if (this.server == null) {
                this.createServer(config, repository);
            }
            if (this.server != null) {
                this.server.start();
                flag = true;
            }
        }
        catch (Exception e) {
            flag = false;
            this.handleThrowable(e);
        }
        return flag;
    }

    public boolean stopServer() {
        boolean flag;
        block5: {
            flag = true;
            try {
                if (this.server == null) break block5;
                RFCRequestHandler rFCRequestHandler = this.handler;
                synchronized (rFCRequestHandler) {
                    this.server.stop();
                }
                JCO.removeServerErrorListener((JCO.ServerErrorListener)this);
                JCO.removeServerExceptionListener((JCO.ServerExceptionListener)this);
                this.server.unregisterHandler();
                this.server = null;
            }
            catch (Exception e) {
                flag = false;
                this.handleThrowable(e);
            }
        }
        return flag;
    }

    public void serverExceptionOccurred(JCO.Server srv, Exception ex) {
        if (srv != this.server) {
            return;
        }
        this.handleThrowable(ex);
    }

    public void serverErrorOccurred(JCO.Server srv, Error err) {
        if (srv != this.server) {
            return;
        }
        this.handleThrowable(err);
    }

    private void handleThrowable(Throwable t) {
        String method = "handleThrowable(Throwable t)";
        if (t instanceof JCO.Exception && ((JCO.Exception)t).getGroup() == 129) {
            RFCApplicationFrame.logError("handleThrowable(Throwable t)", "RFCEngine: Server startup error, stopping \"" + this.programId + "\" :\n", new Object[]{this.programId});
            return;
        }
        if (this.server != null) {
            RFCApplicationFrame.logError("handleThrowable(Throwable t)", "Error in Server \"" + this.programId + "\" :\n", new Object[]{this.programId});
        } else {
            RFCApplicationFrame.logError("handleThrowable(Throwable t)", "Connection with \"" + this.programId + "\" could not be established !\n", new Object[]{this.programId});
        }
        LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, "handleThrowable(Throwable t)", t);
    }

    public void setLogConfiguration() {
    }
}

