/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rfcengine;

import java.io.Serializable;
import java.util.Properties;

public class BundleConfiguration
implements Serializable {
    public static final String APPLICATION_SERVER_HOST = "application.server.host";
    public static final String GATEWAY_HOST = "gateway.host";
    public static final String GATEWAY_SERVER = "gateway.server";
    public static final String LOCAL = "local";
    public static final String LOGON_CLIENT = "logon.client";
    public static final String LOGON_LANGUAGE = "logon.language";
    public static final String LOGON_PASSWORD = "logon.password";
    public static final String LOGON_USER = "logon.user";
    public static final String MAX_CONNECTIONS = "max.connections.";
    public static final String PROCESSES_NUMBER = "processes.number";
    public static final String PROFILE_NAME = "prifile.name";
    public static final String PROGRAM_ID = "program.id";
    public static final String RUNNING_STATE = "running.state";
    public static final String SYSTEM_NUMBER = "syste.number";
    public static final String UNICODE = "unicode";
    public static final String SNC_NAME = "jco.server.snc_myname";
    public static final String SNC_QOP = "jco.server.snc_qop";
    public static final String SNC_LIB = "jco.server.snc_lib";
    public static final String SNC_AUTH_PARTNER = "jco.server.auth_partner";
    public static final String USE_SNC = "use.snc";
    private int maxConnections = 20;
    public String[] configuration = new String[10];
    private boolean local = true;
    private int processes = 1;
    private boolean running = false;
    private boolean middleware = false;
    private boolean unicode = false;
    private Properties props = null;
    private String sncName = "";
    private int sncQop;
    private String sncLib = "";
    private boolean useSnc = false;
    private String authPartner = "";

    public BundleConfiguration() {
        int i = 0;
        while (i < 10) {
            this.configuration[i] = new String();
            ++i;
        }
    }

    public BundleConfiguration(BundleConfiguration bundleConfiguration) {
        this.setApplicationServerHost(bundleConfiguration.getApplicationServerHost());
        this.setGatewayHost(bundleConfiguration.getGatewayHost());
        this.setGatewayServer(bundleConfiguration.getGatewayServer());
        this.setLocal(bundleConfiguration.isLocal());
        this.setLogonClient(bundleConfiguration.getLogonClient());
        this.setLogonLanguage(bundleConfiguration.getLogonLanguage());
        this.setLogonPassword(bundleConfiguration.getLogonPassword());
        this.setLogonUser(bundleConfiguration.getLogonUser());
        this.setMaxConnections(bundleConfiguration.getMaxConnections());
        this.setProcessesNumber(bundleConfiguration.getProcessesNumber());
        this.setProfileName(bundleConfiguration.getProfileName());
        this.setProgramId(bundleConfiguration.getProgramId());
        this.setRunningState(bundleConfiguration.isRunning());
        this.setSystemNumber(bundleConfiguration.getSystemNumber());
        this.setUnicodeState(bundleConfiguration.isUnicode());
        this.setAuthPartner(bundleConfiguration.getAuthPartner());
        this.setSncLib(bundleConfiguration.getSncLib());
        this.setSncName(bundleConfiguration.getSncName());
        this.setSncQop(bundleConfiguration.getSncQop());
        this.setUseSnc(bundleConfiguration.getUseSnc());
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public synchronized String getLogonClient() {
        return this.configuration[0];
    }

    public synchronized void setLogonClient(String logonClient) {
        this.configuration[0] = logonClient;
    }

    public synchronized String getLogonUser() {
        return this.configuration[1];
    }

    public synchronized void setLogonUser(String logonUser) {
        this.configuration[1] = logonUser;
    }

    public synchronized String getLogonPassword() {
        return this.configuration[2];
    }

    public synchronized void setLogonPassword(String logonPassword) {
        this.configuration[2] = logonPassword;
    }

    public synchronized String getLogonLanguage() {
        return this.configuration[3];
    }

    public synchronized void setLogonLanguage(String logonLanguage) {
        this.configuration[3] = logonLanguage;
    }

    public synchronized String getApplicationServerHost() {
        return this.configuration[4];
    }

    public synchronized void setApplicationServerHost(String applicationServerHost) {
        this.configuration[4] = applicationServerHost;
    }

    public synchronized String getSystemNumber() {
        return this.configuration[5];
    }

    public synchronized void setSystemNumber(String systemNumber) {
        this.configuration[5] = systemNumber;
    }

    public synchronized String getGatewayHost() {
        return this.configuration[6];
    }

    public synchronized void setGatewayHost(String gatewayHost) {
        this.configuration[6] = gatewayHost;
    }

    public synchronized String getGatewayServer() {
        return this.configuration[7];
    }

    public synchronized void setGatewayServer(String gatewayServer) {
        this.configuration[7] = gatewayServer;
    }

    public synchronized String getProgramId() {
        if (this.isMiddleware()) {
            if (this.getProfileName() == null) {
                return null;
            }
            return "SAPProfile:" + this.getProfileName().replace('/', '\\');
        }
        return this.configuration[8];
    }

    public synchronized void setProgramId(String programId) {
        this.configuration[8] = programId;
    }

    public synchronized boolean isLocal() {
        if (this.isMiddleware()) {
            return true;
        }
        return this.local;
    }

    public synchronized void setLocal(boolean localFlag) {
        this.local = localFlag;
    }

    public synchronized int getProcessesNumber() {
        return this.processes;
    }

    public synchronized void setProcessesNumber(int num) {
        this.processes = num;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void setRunningState(boolean state) {
        this.running = state;
    }

    public synchronized void setProfileName(String profile) {
        this.configuration[9] = profile;
        this.middleware = profile != null ? profile.length() != 0 : false;
    }

    public synchronized String getProfileName() {
        return this.configuration[9];
    }

    public synchronized void clearProfile() {
        this.configuration[9] = new String();
        this.middleware = false;
    }

    public synchronized boolean isMiddleware() {
        return this.middleware;
    }

    public synchronized boolean isUnicode() {
        return this.unicode;
    }

    public synchronized void setUnicodeState(boolean state) {
        this.unicode = state;
    }

    public synchronized boolean equals(BundleConfiguration cfg) {
        if (this.middleware != cfg.isMiddleware()) {
            return false;
        }
        if (this.middleware) {
            return cfg.getMaxConnections() == this.maxConnections && cfg.getProcessesNumber() == this.processes && cfg.getProfileName().equals(this.getProfileName()) && cfg.getProgramId().equals(this.configuration[8]) && cfg.isLocal() == this.local;
        }
        return cfg.getApplicationServerHost().equals(this.configuration[4]) && cfg.getGatewayHost().equals(this.configuration[6]) && cfg.getGatewayServer().equals(this.configuration[7]) && cfg.getLogonClient().equals(this.configuration[0]) && cfg.getLogonLanguage().equals(this.configuration[3]) && cfg.getLogonPassword().equals(this.configuration[2]) && cfg.getLogonUser().equals(this.configuration[1]) && cfg.getMaxConnections() == this.maxConnections && cfg.getProcessesNumber() == this.processes && cfg.getProgramId().equals(this.configuration[8]) && cfg.getSystemNumber().equals(this.configuration[5]) && cfg.isLocal() == this.local && cfg.isUnicode() == this.unicode && cfg.useSnc == this.useSnc && cfg.authPartner.equals(this.authPartner) && cfg.sncLib.equals(this.sncLib) && cfg.sncName.equals(this.sncName) && cfg.sncQop == this.sncQop;
    }

    public synchronized boolean equalsWithoutProcesses(BundleConfiguration cfg) {
        if (this.middleware != cfg.isMiddleware()) {
            return false;
        }
        if (this.middleware) {
            return cfg.getMaxConnections() == this.maxConnections && cfg.getProfileName().equals(this.getProfileName()) && cfg.getProgramId().equals(this.configuration[8]) && cfg.isLocal() == this.local;
        }
        return cfg.getApplicationServerHost().equals(this.configuration[4]) && cfg.getGatewayHost().equals(this.configuration[6]) && cfg.getGatewayServer().equals(this.configuration[7]) && cfg.getLogonClient().equals(this.configuration[0]) && cfg.getLogonLanguage().equals(this.configuration[3]) && cfg.getLogonPassword().equals(this.configuration[2]) && cfg.getLogonUser().equals(this.configuration[1]) && cfg.getMaxConnections() == this.maxConnections && cfg.getProgramId().equals(this.configuration[8]) && cfg.getSystemNumber().equals(this.configuration[5]) && cfg.isLocal() == this.local && cfg.isUnicode() == this.unicode && cfg.useSnc == this.useSnc && cfg.authPartner.equals(this.authPartner) && cfg.sncLib.equals(this.sncLib) && cfg.sncName.equals(this.sncName) && cfg.sncQop == this.sncQop;
    }

    public String getSncLib() {
        return this.sncLib;
    }

    public String getSncName() {
        return this.sncName;
    }

    public int getSncQop() {
        return this.sncQop;
    }

    public void setSncLib(String lib) {
        this.sncLib = lib;
    }

    public void setSncName(String name) {
        this.sncName = name;
    }

    public void setSncQop(int i) {
        this.sncQop = i;
    }

    public boolean getUseSnc() {
        return this.useSnc;
    }

    public void setUseSnc(boolean b) {
        this.useSnc = b;
    }

    public String getAuthPartner() {
        return this.authPartner;
    }

    public void setAuthPartner(String partner) {
        this.authPartner = partner;
    }
}

