/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.rfcengine;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.rfcengine.BundleConfiguration;
import com.sap.engine.services.rfcengine.JCOParadigm;
import com.sap.engine.services.rfcengine.RFCApplicationFrame;
import com.sap.engine.services.rfcengine.RFCResourceAccessor;
import com.sap.engine.services.rfcengine.RFCRuntimeInterfaceImpl;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.util.Vector;

public class Bundle {
    private Vector paradigms = new Vector();
    private BundleConfiguration config = null;
    private int max = 20;
    private int maxConn = 20;
    private IRepository repository = null;
    private ApplicationServiceContext serviceContext = null;
    private RFCRuntimeInterfaceImpl runtimeInterface = null;
    private String method = null;

    public boolean initBundle(BundleConfiguration conf, int max, int conn, boolean changingProperties, ApplicationServiceContext serviceContext, RFCRuntimeInterfaceImpl runtime) {
        this.config = conf;
        this.max = max;
        this.maxConn = conn;
        this.serviceContext = serviceContext;
        this.runtimeInterface = runtime;
        int num = this.config.getMaxConnections();
        if (num > this.maxConn) {
            conf.setMaxConnections(this.maxConn);
        }
        if ((num = this.config.getProcessesNumber()) > this.max) {
            conf.setProcessesNumber(this.max);
            num = this.max;
        }
        if (this.initialize(changingProperties)) {
            int i = 0;
            while (i < num) {
                JCOParadigm jcoParadigm = new JCOParadigm(serviceContext, this.runtimeInterface);
                jcoParadigm.setLogConfiguration();
                jcoParadigm.createServer(this.config, this.repository);
                this.paradigms.add(jcoParadigm);
                if (this.repository == null) {
                    conf.setRunningState(false);
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    private synchronized boolean initialize(boolean starting) {
        this.method = "Bundle.initialize(boolean starting)";
        try {
            if (!this.config.isMiddleware()) {
                JCO.Pool pool;
                JCO.PoolManager poolManager = JCO.getClientPoolManager();
                if (poolManager != null && (pool = poolManager.getPool(this.config.getProgramId() + "Bundle")) == null) {
                    JCO.addClientPool((String)(this.config.getProgramId() + "Bundle"), (int)this.config.getMaxConnections(), (String)this.config.getLogonClient(), (String)this.config.getLogonUser(), (String)this.config.getLogonPassword(), (String)this.config.getLogonLanguage(), (String)this.config.getApplicationServerHost(), (String)this.config.getSystemNumber());
                }
                this.repository = JCO.createRepository((String)(this.config.getProgramId() + "Repository"), (String)(this.config.getProgramId() + "Bundle"));
                this.repository.getFunctionTemplate("STFC_CONNECTION");
            }
        }
        catch (Throwable ex) {
            if (!starting) {
                RFCApplicationFrame.logError(this.method, "Failed to initialize connection with JCO ! Bundle ", new Object[]{this.config.getProgramId()});
            } else {
                RFCApplicationFrame.logError(this.method, "Client pool can not be added ! Bundle ", new Object[]{this.config.getProgramId()});
            }
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, ex);
            return false;
        }
        return true;
    }

    public synchronized boolean startAll() {
        boolean flag;
        block6: {
            this.method = "Bundle.startAll()";
            flag = true;
            try {
                if (this.initialize(true)) {
                    int i = 0;
                    while (i < this.paradigms.size()) {
                        JCOParadigm paradigm = (JCOParadigm)this.paradigms.get(i);
                        if (!paradigm.startServer(this.config, this.repository)) {
                            flag = false;
                        }
                        if (i <= 10) {
                            ++i;
                            continue;
                        }
                        break block6;
                    }
                    break block6;
                }
                flag = false;
            }
            catch (Exception e) {
                flag = false;
                LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, e);
            }
        }
        return flag;
    }

    public synchronized boolean stopAll() {
        this.method = "Bundle.stopAll()";
        boolean flag = true;
        try {
            int i = 0;
            while (i < this.paradigms.size()) {
                JCOParadigm paradigm = (JCOParadigm)this.paradigms.get(i);
                if (!paradigm.stopServer()) {
                    flag = false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            flag = false;
            LoggingHelper.traceThrowable(500, RFCResourceAccessor.location, this.method, e);
        }
        JCO.removeClientPool((String)(this.config.getProgramId() + "Bundle"));
        return flag;
    }

    public synchronized boolean add(int index) {
        if (this.paradigms.size() == this.max || index < 0 && index != -1) {
            return false;
        }
        boolean flag = true;
        JCOParadigm jcoParadigm = new JCOParadigm(this.serviceContext, this.runtimeInterface);
        jcoParadigm.setLogConfiguration();
        if (this.getProcessesNumber() == 0) {
            jcoParadigm.createServer(this.config, this.repository);
        }
        flag = jcoParadigm.startServer(this.config, this.repository);
        if (index == -1 || this.paradigms.size() <= index) {
            this.paradigms.add(jcoParadigm);
        } else {
            this.paradigms.insertElementAt(jcoParadigm, index);
        }
        this.config.setProcessesNumber(this.paradigms.size());
        return flag;
    }

    public synchronized boolean remove(int index) {
        if (this.paradigms.size() == 0 || this.paradigms.size() <= index || index < 0 && index != -1) {
            return false;
        }
        boolean flag = true;
        if (index == -1) {
            flag = ((JCOParadigm)this.paradigms.get(this.paradigms.size() - 1)).stopServer();
            if (flag) {
                this.paradigms.removeElementAt(this.paradigms.size() - 1);
            }
        } else {
            flag = ((JCOParadigm)this.paradigms.get(index)).stopServer();
            if (flag) {
                this.paradigms.removeElementAt(index);
            }
        }
        this.config.setProcessesNumber(this.paradigms.size());
        return flag;
    }

    public int getProcessesNumber() {
        return this.paradigms.size();
    }

    public BundleConfiguration getConfiguration() {
        return this.config;
    }
}

