/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.test;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.locking.test.BaseLockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public class RemoveLocksWildcardTest
extends BaseLockingContextTest {
    public String getName() {
        return "Remove locks which contain wildcards";
    }

    public String getDescription() {
        return "1) Create two lock\n2) Try to remove this lock using wildcards, which must not work\n   Wildcards are only for the creation of locks";
    }

    protected void test(ThreadSystem threadSystem, Properties properties, TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        String name1 = "X$$_TESTNAME_$$name1";
        String argument1 = "$$_TESTARGUMENT_$$argument1";
        String wildcardAArgument = "$$_TESTARGUMENT_$$argument@";
        String wildcardBArgument1 = "$$_TESTARGUMENT_$$argument1@";
        String wildcardCArgument1 = "$$_TESTARGUMENT_$$@rgument1";
        logging.log("Create two locks [owner1, name1, argument1, shared]");
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        logging.log("Remove lock [owner1, name1, <wildcardargument 1>, shared]");
        locking.unlock(owner1, name1, wildcardAArgument, 'S', false);
        this.checkLocks(logging, locking, owner1, name1, argument1);
        logging.log("Remove lock [owner1, name1, <wildcardargument 2>, shared]");
        locking.unlock(owner1, name1, wildcardBArgument1, 'S', false);
        this.checkLocks(logging, locking, owner1, name1, argument1);
        logging.log("Remove lock [owner1, name1, <wildcardargument 3>, shared]");
        locking.unlock(owner1, name1, wildcardCArgument1, 'S', false);
        this.checkLocks(logging, locking, owner1, name1, argument1);
    }

    private void checkLocks(TestResult logging, AdministrativeLocking locking, String owner, String name, String argument) throws Exception {
        logging.log("Check locks");
        LockEntry[] entries = locking.getLocks(name, argument);
        this.checkLockEntries(entries, new Integer(1), owner, name, argument, new Character('S'), new Integer(2));
    }
}

