/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.test;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.locking.test.BaseLockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public class RemoveLocksTest
extends BaseLockingContextTest {
    public String getName() {
        return "Remove locks";
    }

    public String getDescription() {
        return "1) Creates several locks and removes them with different procedures\n2) Receives the locks and checks them against the expected locks";
    }

    protected void test(ThreadSystem threadSystem, Properties properties, TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        String name1 = "X$$_TESTNAME_$$name1";
        String name2 = "X$$_TESTNAME_$$name2";
        String argument1 = "$$_TESTARGUMENT_$$argument1";
        String argument2 = "$$_TESTARGUMENT_$$argument2";
        String argument3 = "$$_TESTARGUMENT_$$argument3";
        logging.log("Create several locks of all modes for [owner1, name1]");
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner1, name1, argument3, 'X');
        logging.log("Create several locks of mode shared for [owner2, name1]");
        locking.lock(owner2, name1, argument1, 'S');
        locking.lock(owner2, name1, argument1, 'S');
        locking.lock(owner2, name1, argument1, 'S');
        logging.log("Remove the shared locks one by one");
        locking.unlock(owner1, name1, argument1, 'S', false);
        LockEntry[] entries = locking.getLocks(name1, argument1);
        this.checkLockEntries(entries, new Integer(2), null, name1, argument1, new Character('S'), null);
        locking.unlock(owner1, name1, argument1, 'S', false);
        locking.unlock(owner1, name1, argument1, 'S', false);
        entries = locking.getLocks(name1, argument1);
        this.checkLockEntries(entries, new Integer(1), owner2, name1, argument1, new Character('S'), new Integer(3));
        logging.log("Remove the exclusive cumulative locks one by one");
        locking.unlock(owner1, name1, argument2, 'E', false);
        entries = locking.getLocks(name1, argument2);
        this.checkLockEntries(entries, new Integer(1), owner1, name1, argument2, new Character('E'), new Integer(2));
        locking.unlock(owner1, name1, argument2, 'E', false);
        locking.unlock(owner1, name1, argument2, 'E', false);
        entries = locking.getLocks(name1, argument2);
        this.checkLockEntries(entries, new Integer(0), owner1, name1, argument2, new Character('E'), new Integer(0));
        logging.log("Remove the exclusive non-cumulative locks one by one");
        entries = locking.getLocks(name1, argument3);
        this.checkLockEntries(entries, new Integer(1), owner1, name1, argument3, new Character('X'), new Integer(1));
        locking.unlock(owner1, name1, argument3, 'X', false);
        entries = locking.getLocks(name1, argument3);
        this.checkLockEntries(entries, new Integer(0), owner1, name1, argument3, new Character('X'), new Integer(0));
        this.cleanupLocks(logging, locking, owner1, owner2);
        logging.log("Create one shared lock for [owner1, name1, argument1]");
        locking.lock(owner1, name1, argument1, 'S');
        logging.log("Remove several locks, which do not match => the lock should still remain");
        locking.unlock(owner2, name1, argument1, 'S', false);
        locking.unlock(owner1, name2, argument1, 'S', false);
        locking.unlock(owner1, name1, argument2, 'S', false);
        locking.unlock(owner1, name1, argument1, 'E', false);
        locking.unlock(owner1, name1, argument1, 'X', false);
        entries = locking.getLocks(name1, argument1);
        this.checkLockEntries(entries, new Integer(1), owner1, name1, argument1, new Character('S'), new Integer(1));
        this.cleanupLocks(logging, locking, owner1, owner2);
        logging.log("Create several locks of all modes for [owner1, name1]");
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner1, name1, argument3, 'X');
        logging.log("Create several locks of mode shared for [owner2, name1]");
        locking.lock(owner2, name1, argument1, 'S');
        locking.lock(owner2, name1, argument1, 'S');
        locking.lock(owner2, name1, argument1, 'S');
        logging.log("Remove the shared locks cumulative for owner1");
        locking.unlockAllCumulativeCounts(owner1, name1, argument1, 'S', false);
        entries = locking.getLocks(name1, argument1);
        this.checkLockEntries(entries, new Integer(1), owner2, name1, argument1, new Character('S'), new Integer(3));
        entries = locking.getLocks(name1, argument2);
        this.checkLockEntries(entries, new Integer(1), owner1, name1, argument2, new Character('E'), new Integer(3));
        entries = locking.getLocks(name1, argument3);
        this.checkLockEntries(entries, new Integer(1), owner1, name1, argument3, new Character('X'), new Integer(1));
        logging.log("Remove the exclusive cumulative locks cumulative for owner1");
        locking.unlockAllCumulativeCounts(owner1, name1, argument2, 'E', false);
        entries = locking.getLocks(name1, argument1);
        this.checkLockEntries(entries, new Integer(1), owner2, name1, argument1, new Character('S'), new Integer(3));
        entries = locking.getLocks(name1, argument2);
        this.checkLockEntries(entries, new Integer(0), owner1, name1, argument2, new Character('E'), new Integer(3));
        entries = locking.getLocks(name1, argument3);
        this.checkLockEntries(entries, new Integer(1), owner1, name1, argument3, new Character('X'), new Integer(1));
        logging.log("Remove the exclusive non-cumulative locks cumulative for owner1");
        locking.unlockAllCumulativeCounts(owner1, name1, argument3, 'X', false);
        entries = locking.getLocks(name1, argument1);
        this.checkLockEntries(entries, new Integer(1), owner2, name1, argument1, new Character('S'), new Integer(3));
        entries = locking.getLocks(name1, argument3);
        this.checkLockEntries(entries, new Integer(0), owner1, name1, argument3, new Character('X'), new Integer(1));
        this.cleanupLocks(logging, locking, owner1, owner2);
        logging.log("Create several locks for owner1 and owner2");
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner2, name1, argument1, 'S');
        locking.lock(owner2, name1, argument1, 'S');
        locking.lock(owner2, name1, argument1, 'S');
        locking.lock(owner2, name1, argument3, 'X');
        logging.log("Remove all locks for owner1 cumulative");
        locking.unlockAll(owner1, false);
        entries = locking.getLocks(name1, null);
        this.checkLockEntries(entries, new Integer(2), owner2, name1, null, null, null);
        logging.log("Remove all locks for owner2 cumulative");
        locking.unlockAll(owner2, false);
        entries = locking.getLocks(name1, null);
        this.checkLockEntries(entries, new Integer(0), null, name1, null, null, null);
    }

    private void cleanupLocks(TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        logging.log("Remove all locks");
        locking.unlockAll(owner1, false);
        locking.unlockAll(owner2, false);
        logging.log("");
    }
}

