/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.test;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.locking.test.BaseLockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public class RemoveLocksArrayTest
extends BaseLockingContextTest {
    public String getName() {
        return "Remove locks in array-operation";
    }

    public String getDescription() {
        return "1) Create several locks for owner1 and owner2\n2) Remove locks as created\n3) Repeat the step 1)\n4) Remove locks, but less than created\n5) Repeat the step 1)\n6) Remove locks, but more than created\n\nAfter every step the locks are always checked for consistency.";
    }

    protected void test(ThreadSystem threadSystem, Properties properties, TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        String name1 = "X$$_TESTNAME_$$name1";
        String argument1 = "$$_TESTARGUMENT_$$argument1";
        String argument2 = "$$_TESTARGUMENT_$$argument2";
        String argument3 = "$$_TESTARGUMENT_$$argument3";
        logging.log("Create locks for owner1");
        String[] names1 = new String[]{name1, name1, name1, name1, name1, name1};
        String[] arguments1 = new String[]{argument1, argument1, argument1, argument3, argument3, argument3};
        char[] modes1 = new char[]{'S', 'S', 'S', 'E', 'E', 'E'};
        locking.lock(owner1, names1, arguments1, modes1);
        logging.log("Create locks for owner2");
        String[] names2 = new String[]{name1, name1, name1, name1, name1, name1};
        String[] arguments2 = new String[]{argument1, argument1, argument1, argument2, argument2, argument2};
        char[] modes2 = new char[]{'S', 'S', 'S', 'E', 'E', 'E'};
        locking.lock(owner2, names2, arguments2, modes2);
        logging.log("Remove locks for owner1");
        locking.unlock(owner1, names1, arguments1, modes1, false);
        LockEntry[] entries = locking.getLocks(name1, null);
        this.checkLockEntries(entries, new Integer(2), owner2, name1, null, null, new Integer(3));
        logging.log("Remove locks for owner2");
        locking.unlock(owner2, names2, arguments2, modes2, false);
        entries = locking.getLocks(name1, null);
        this.checkLockEntries(entries, new Integer(0), null, name1, null, null, new Integer(3));
        this.cleanupLocks(logging, locking, owner1, owner2);
        logging.log("");
        logging.log("Create locks for owner1");
        locking.lock(owner1, names1, arguments1, modes1);
        logging.log("Create locks for owner2");
        locking.lock(owner2, names2, arguments2, modes2);
        logging.log("Remove locks for owner1");
        String[] names1a = new String[]{name1, name1, name1, name1};
        String[] arguments1a = new String[]{argument1, argument1, argument3, argument3};
        char[] modes1a = new char[]{'S', 'S', 'E', 'E'};
        locking.unlock(owner1, names1a, arguments1a, modes1a, false);
        entries = locking.getLocks(name1, null);
        this.checkLockEntries(entries, new Integer(4), null, name1, null, null, null);
        logging.log("Remove locks for owner2");
        String[] names2a = new String[]{name1, name1, name1, name1};
        String[] arguments2a = new String[]{argument1, argument1, argument2, argument2};
        char[] modes2a = new char[]{'S', 'S', 'E', 'E'};
        locking.unlock(owner2, names2a, arguments2a, modes2a, false);
        entries = locking.getLocks(name1, null);
        this.checkLockEntries(entries, new Integer(4), null, name1, null, null, new Integer(1));
        this.cleanupLocks(logging, locking, owner1, owner2);
        logging.log("");
        logging.log("Create locks for owner1");
        locking.lock(owner1, names1, arguments1, modes1);
        logging.log("Create locks for owner2");
        locking.lock(owner2, names2, arguments2, modes2);
        logging.log("Remove locks for owner1");
        String[] names1b = new String[]{name1, name1, name1, name1, name1, name1};
        String[] arguments1b = new String[]{argument1, argument1, argument1, argument1, argument3, argument3};
        char[] modes1b = new char[]{'S', 'S', 'S', 'S', 'E', 'E'};
        locking.unlock(owner1, names1b, arguments1b, modes1b, false);
        entries = locking.getLocks(name1, null);
        this.checkLockEntries(entries, new Integer(3), null, name1, null, null, null);
        entries = locking.getLocks(name1, argument3);
        this.checkLockEntries(entries, new Integer(1), null, name1, null, null, new Integer(1));
        logging.log("Remove locks for owner2");
        String[] names2b = new String[]{name1, name1, name1, name1, name1, name1};
        String[] arguments2b = new String[]{argument1, argument1, argument1, argument1, argument2, argument2};
        char[] modes2b = new char[]{'S', 'S', 'S', 'S', 'E', 'E'};
        locking.unlock(owner2, names2b, arguments2b, modes2b, false);
        entries = locking.getLocks(name1, null);
        this.checkLockEntries(entries, new Integer(2), null, name1, null, new Character('E'), new Integer(1));
    }

    private void cleanupLocks(TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        logging.log("Remove all locks");
        locking.unlockAll(owner1, false);
        locking.unlockAll(owner2, false);
        logging.log("");
    }
}

