/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.test;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.locking.test.BaseLockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public class LockSpecialParametersTest
extends BaseLockingContextTest {
    public String getName() {
        return "Create/remove locks with special parameters";
    }

    public String getDescription() {
        return "1) Creates locks where the paramters are invalid\n2) Creates/remove locks where one parameter contains the multi-wildcard\n";
    }

    protected void test(ThreadSystem threadSystem, Properties properties, TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        String name1 = "X$$_TESTNAME_$$name1";
        String argument1 = "$$_TESTARGUMENT_$$argument1";
        String name1Max = BaseLockingContextTest.UTIL.adjustStringLengthRight(name1, 30, 'X');
        String argument1Max = BaseLockingContextTest.UTIL.adjustStringLengthRight(argument1, 150, 'X');
        String name1WildcardMulti = name1 + '*';
        String argument1WildcardMulti = argument1 + '*';
        String name1WildcardSingle = "X$$_TESTNAME_$$@";
        String name1InvalidA = name1 + '\u0000';
        String name1InvalidB = name1 + '\u0019';
        String argument1InvalidA = argument1 + '\u0000';
        String argument1InvalidB = argument1 + '\u0019';
        logging.log("Create lock where every parameter has the maximum-size");
        locking.lock(owner1, name1Max, argument1Max, 'S');
        logging.log("Create locks where the maximum-size is exceeded => expect exception");
        this.lockExpectIllegalArgumentException(locking, owner1, name1Max + 'X', argument1Max, 'S');
        this.lockExpectIllegalArgumentException(locking, owner1, name1Max, argument1Max + 'X', 'S');
        logging.log("Create locks where the mode is invalid => expect exception");
        this.lockExpectIllegalArgumentException(locking, owner1, name1Max + 'X', argument1Max, '\u0000');
        this.lockExpectIllegalArgumentException(locking, owner1, name1Max + 'X', argument1Max, '\n');
        logging.log("Create locks with the invalid characters => expect exception");
        this.lockExpectIllegalArgumentException(locking, owner1, name1InvalidA, argument1, 'S');
        this.lockExpectIllegalArgumentException(locking, owner1, name1InvalidB, argument1, 'S');
        this.lockExpectIllegalArgumentException(locking, owner1, name1, argument1InvalidA, 'S');
        this.lockExpectIllegalArgumentException(locking, owner1, name1, argument1InvalidB, 'S');
        logging.log("Create locks with null => expect exception");
        this.lockExpectIllegalArgumentException(locking, null, name1, argument1, 'S');
        this.lockExpectIllegalArgumentException(locking, owner1, null, argument1, 'S');
        this.lockExpectIllegalArgumentException(locking, owner1, name1, null, 'S');
        logging.log("Create locks with the multi-wildcard => expect exception");
        this.lockExpectIllegalArgumentException(locking, owner1, name1WildcardMulti, argument1, 'S');
        this.lockExpectIllegalArgumentException(locking, owner1, name1, argument1WildcardMulti, 'S');
        this.lockExpectIllegalArgumentException(locking, owner1, new String[]{name1WildcardMulti}, new String[]{argument1}, new char[]{'S'});
        this.lockExpectIllegalArgumentException(locking, owner1, new String[]{name1}, new String[]{argument1WildcardMulti}, new char[]{'S'});
        logging.log("Create locks with the single-wildcard => expect exception");
        this.lockExpectIllegalArgumentException(locking, owner1, name1WildcardSingle, argument1, 'S');
        this.lockExpectIllegalArgumentException(locking, owner1, new String[]{name1WildcardSingle}, new String[]{argument1}, new char[]{'S'});
        logging.log("Remove locks with null => expect exception");
        this.unlockExpectIllegalArgumentException(locking, null, name1, argument1, 'S');
        this.unlockExpectIllegalArgumentException(locking, owner1, null, argument1, 'S');
        this.unlockExpectIllegalArgumentException(locking, owner1, name1, null, 'S');
        logging.log("Remove locks with the multi-wildcard => expect exception");
        this.unlockExpectIllegalArgumentException(locking, owner1, name1WildcardMulti, argument1, 'S');
        this.unlockExpectIllegalArgumentException(locking, owner1, name1, argument1WildcardMulti, 'S');
        this.unlockExpectIllegalArgumentException(locking, owner1, new String[]{name1WildcardMulti}, new String[]{argument1}, new char[]{'S'});
        this.unlockExpectIllegalArgumentException(locking, owner1, new String[]{name1}, new String[]{argument1WildcardMulti}, new char[]{'S'});
    }
}

