/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.test;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.locking.test.BaseLockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public class GetLocksTest
extends BaseLockingContextTest {
    public String getName() {
        return "Receive locks";
    }

    public String getDescription() {
        return "1) Creates several locks\n2) Receives the locks and checks them against the created locks";
    }

    protected void test(ThreadSystem threadSystem, Properties properties, TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        String name1 = "X$$_TESTNAME_$$name1";
        String name2 = "X$$_TESTNAME_$$name2";
        String argument1 = "$$_TESTARGUMENT_$$argument1";
        String argument2 = "$$_TESTARGUMENT_$$argument2";
        String wildcardAName = "X$$_TESTNAME_$$*";
        String wildcardBName1 = "X$$_TESTNAME_$$name1*";
        String wildcardCName1 = "*X$$_TESTNAME_$$name1";
        String wildcardDName = "*X$$_TESTNAME_$$*";
        String wildcardAArgument = "$$_TESTARGUMENT_$$*";
        String wildcardBArgument1 = "$$_TESTARGUMENT_$$argument1*";
        String wildcardCArgument1 = "*$$_TESTARGUMENT_$$argument1";
        String wildcardDArgument = "*$$_TESTARGUMENT_$$*";
        logging.log("CREATE LOCKS");
        logging.log("Create locks for owner1: 3x[name1, argument1], 3x[name1, argument2], 3x[name2, argument1]");
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument2, 'S');
        locking.lock(owner1, name1, argument2, 'S');
        locking.lock(owner1, name1, argument2, 'S');
        locking.lock(owner1, name2, argument1, 'S');
        locking.lock(owner1, name2, argument1, 'S');
        locking.lock(owner1, name2, argument1, 'S');
        logging.log("Create locks for owner2: 3x[name1, argument1]");
        locking.lock(owner2, name1, argument1, 'S');
        locking.lock(owner2, name1, argument1, 'S');
        locking.lock(owner2, name1, argument1, 'S');
        logging.log("RECEIVE LOCKS");
        logging.log("Receive locks for [name1, argument1]");
        LockEntry[] entries = locking.getLocks(name1, argument1);
        this.checkLockEntries(entries, new Integer(2), null, name1, argument1, new Character('S'), new Integer(3));
        logging.log("Receive locks for [name1, null]");
        entries = locking.getLocks(name1, null);
        this.checkLockEntries(entries, new Integer(3), null, name1, null, new Character('S'), new Integer(3));
        logging.log("Receive locks for [null, argument1]");
        entries = locking.getLocks(null, argument1);
        this.checkLockEntries(entries, new Integer(3), null, null, argument1, new Character('S'), new Integer(3));
        logging.log("Receive locks for [name1, argument2]");
        entries = locking.getLocks(name1, argument2);
        this.checkLockEntries(entries, new Integer(1), owner1, name1, argument2, new Character('S'), new Integer(3));
        logging.log("Receive locks for [name2, argument1]");
        entries = locking.getLocks(name2, argument1);
        this.checkLockEntries(entries, new Integer(1), owner1, name2, argument1, new Character('S'), new Integer(3));
        logging.log("");
        logging.log("RECEIVE LOCKS USING WILDCARDS");
        logging.log("Receive locks for [name1, wildcardAArgument]");
        entries = locking.getLocks(name1, wildcardAArgument);
        this.checkLockEntries(entries, new Integer(3), null, name1, null, new Character('S'), new Integer(3));
        logging.log("Receive locks for [name1, wildcardBArgument1]");
        entries = locking.getLocks(name1, wildcardBArgument1);
        this.checkLockEntries(entries, new Integer(2), null, name1, argument1, new Character('S'), new Integer(3));
        logging.log("Receive locks for [name1, wildcardCArgument1]");
        entries = locking.getLocks(name1, wildcardCArgument1);
        this.checkLockEntries(entries, new Integer(2), null, name1, argument1, new Character('S'), new Integer(3));
        logging.log("Receive locks for [name1, wildcardDArgument]");
        entries = locking.getLocks(name1, wildcardDArgument);
        this.checkLockEntries(entries, new Integer(3), null, name1, null, new Character('S'), new Integer(3));
        logging.log("Receive locks for [wildcardAName, argument1]");
        entries = locking.getLocks(wildcardAName, argument1);
        this.checkLockEntries(entries, new Integer(3), null, null, argument1, new Character('S'), new Integer(3));
        logging.log("Receive locks for [wildcardBName1, argument1]");
        entries = locking.getLocks(wildcardBName1, argument1);
        this.checkLockEntries(entries, new Integer(2), null, name1, argument1, new Character('S'), new Integer(3));
        logging.log("Receive locks for [wildcardCName1, argument1]");
        entries = locking.getLocks(wildcardCName1, argument1);
        this.checkLockEntries(entries, new Integer(2), null, name1, argument1, new Character('S'), new Integer(3));
        logging.log("Receive locks for [wildcardDName, argument1]");
        entries = locking.getLocks(wildcardDName, argument1);
        this.checkLockEntries(entries, new Integer(3), null, null, argument1, new Character('S'), new Integer(3));
    }
}

