/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.test;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.locking.test.BaseLockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public class CreateLocksWildcardTest
extends BaseLockingContextTest {
    public String getName() {
        return "Create locks which contain wildcards";
    }

    public String getDescription() {
        return "1) Create several locks (some arguments have wildcards) and force conflicts\n2) Create locks (some names have wildcards) => names must not support wildcards";
    }

    protected void test(ThreadSystem threadSystem, Properties properties, TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        String name1 = "X$$_TESTNAME_$$name1";
        String argument1 = "$$_TESTARGUMENT_$$argument1";
        String argument2 = "$$_TESTARGUMENT_$$argument2";
        String wildcardAArgument = "$$_TESTARGUMENT_$$argument@";
        String wildcardBArgument1 = "$$_TESTARGUMENT_$$argument1@";
        String wildcardCArgument1 = "$$_TESTARGUMENT_$$@rgument1";
        String wildcardDArgumentNone = "$$_TESTARGUMENT_$$@";
        logging.log("Create shared locks for owner1/owner2 [name1, argument1]");
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner2, name1, argument1, 'S');
        logging.log("Create shared locks for owner1/owner2 [name1, <all wildcardarguments>]");
        locking.lock(owner1, name1, wildcardAArgument, 'S');
        locking.lock(owner1, name1, wildcardBArgument1, 'S');
        locking.lock(owner1, name1, wildcardCArgument1, 'S');
        locking.lock(owner1, name1, wildcardDArgumentNone, 'S');
        locking.lock(owner2, name1, wildcardAArgument, 'S');
        locking.lock(owner2, name1, wildcardBArgument1, 'S');
        locking.lock(owner2, name1, wildcardCArgument1, 'S');
        locking.lock(owner2, name1, wildcardDArgumentNone, 'S');
        this.cleanupLocks(logging, locking, owner1, owner2);
        logging.log("Create shared lock for owner1 [name1, argument1]");
        locking.lock(owner1, name1, argument1, 'S');
        logging.log("Create exclusive lock for owner2 [name1, <all wildcardarguments>] => expect exception");
        this.lockExpectException(locking, owner2, name1, wildcardAArgument, 'E');
        this.lockExpectException(locking, owner2, name1, wildcardBArgument1, 'E');
        this.lockExpectException(locking, owner2, name1, wildcardCArgument1, 'E');
        locking.lock(owner2, name1, wildcardDArgumentNone, 'E');
        this.cleanupLocks(logging, locking, owner1, owner2);
        logging.log("Create shared lock for owner1 [name1, <wildcardargument 1>]");
        locking.lock(owner1, name1, wildcardAArgument, 'S');
        logging.log("Create exclusive lock for owner2 => some expect exception");
        this.lockExpectException(locking, owner2, name1, argument1, 'E');
        this.lockExpectException(locking, owner2, name1, argument2, 'E');
        this.lockExpectException(locking, owner2, name1, wildcardBArgument1, 'E');
        this.lockExpectException(locking, owner2, name1, wildcardCArgument1, 'E');
        locking.lock(owner2, name1, wildcardDArgumentNone, 'E');
        this.cleanupLocks(logging, locking, owner1, owner2);
        logging.log("Create shared lock for owner1 [name1, <wildcardargument 2>]");
        locking.lock(owner1, name1, wildcardBArgument1, 'S');
        logging.log("Create exclusive lock for owner2 => some expect exception");
        this.lockExpectException(locking, owner2, name1, argument1, 'E');
        this.lockExpectException(locking, owner2, name1, wildcardAArgument, 'E');
        this.lockExpectException(locking, owner2, name1, wildcardCArgument1, 'E');
        locking.lock(owner2, name1, argument2, 'E');
        locking.lock(owner2, name1, wildcardDArgumentNone, 'E');
        this.cleanupLocks(logging, locking, owner1, owner2);
        logging.log("Create shared lock for owner1 [name1, <wildcardargument 3>]");
        locking.lock(owner1, name1, wildcardCArgument1, 'S');
        logging.log("Create exclusive lock for owner2 => some expect exception");
        this.lockExpectException(locking, owner2, name1, argument1, 'E');
        this.lockExpectException(locking, owner2, name1, wildcardAArgument, 'E');
        this.lockExpectException(locking, owner2, name1, wildcardBArgument1, 'E');
        locking.lock(owner2, name1, argument2, 'E');
        locking.lock(owner2, name1, wildcardDArgumentNone, 'E');
        this.cleanupLocks(logging, locking, owner1, owner2);
        logging.log("Create shared lock for owner1 [name1, <wildcardargument 4>]");
        locking.lock(owner1, name1, wildcardDArgumentNone, 'S');
        logging.log("Create exclusive lock for owner2 => some expect exception");
        locking.lock(owner2, name1, argument1, 'E');
        locking.lock(owner2, name1, argument2, 'E');
        this.cleanupLocks(logging, locking, owner1, owner2);
    }

    private void cleanupLocks(TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        logging.log("Remove all locks");
        locking.unlockAll(owner1, false);
        locking.unlockAll(owner2, false);
        logging.log("");
    }
}

