/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.test;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.locking.test.BaseLockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public class CreateLocksTest
extends BaseLockingContextTest {
    public String getName() {
        return "Create locks";
    }

    public String getDescription() {
        return "1) Creates locks of all modes for owner1\n2) Creates locks of all modes for owner2 for the same arguments as before\n3) Creates locks for different name";
    }

    protected void test(ThreadSystem threadSystem, Properties properties, TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        String name1 = "X$$_TESTNAME_$$name1";
        String name2 = "X$$_TESTNAME_$$name2";
        String argument1 = "$$_TESTARGUMENT_$$argument1";
        String argument2 = "$$_TESTARGUMENT_$$argument2";
        String argument3 = "$$_TESTARGUMENT_$$argument3";
        logging.log("CREATE LOCKS FOR OWNER1 WITH SAME NAME BUT DIFFERENT ARGUMENTS");
        logging.log("Create several shared locks");
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        locking.lock(owner1, name1, argument1, 'S');
        logging.log("Create several cumulative exclusive locks");
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner1, name1, argument2, 'E');
        locking.lock(owner1, name1, argument2, 'E');
        logging.log("Create one non-cumulative exclusive lock");
        locking.lock(owner1, name1, argument3, 'X');
        logging.log("Create another non-cumulative exclusive lock => expect exception");
        this.lockExpectException(locking, owner1, name1, argument3, 'X');
        logging.log("");
        logging.log("CREATE LOCKS FOR OWNER2 FOR THE SAME ARGUMENTS AS BEFORE");
        logging.log("Create shared lock for shared lock");
        locking.lock(owner2, name1, argument1, 'S');
        logging.log("Create cumulative exclusiv lock for shared lock => expect exception");
        this.lockExpectException(locking, owner2, name1, argument1, 'E');
        logging.log("Create non-cumulative exclusiv lock for shared lock => expect exception");
        this.lockExpectException(locking, owner2, name1, argument1, 'X');
        logging.log("Create shared lock for cumulative exclusive lock => expect exception");
        this.lockExpectException(locking, owner2, name1, argument2, 'S');
        logging.log("Create cumulative exclusive lock for cumulative exclusive lock => expect exception");
        this.lockExpectException(locking, owner2, name1, argument2, 'E');
        logging.log("Create non-cumulative exclusive lock for cumulative exclusive lock => expect exception");
        this.lockExpectException(locking, owner2, name1, argument2, 'X');
        logging.log("Create shared lock for non-cumulative exclusive lock => expect exception");
        this.lockExpectException(locking, owner2, name1, argument3, 'S');
        logging.log("Create cumulative exclusive lock for non-cumulative exclusive lock => expect exception");
        this.lockExpectException(locking, owner2, name1, argument3, 'E');
        logging.log("Create shared lock for non-cumulative exclusive lock => expect exception");
        this.lockExpectException(locking, owner2, name1, argument3, 'X');
        logging.log("");
        logging.log("CREATE LOCKS FOR DIFFERENT NAME");
        logging.log("Create shared lock");
        locking.lock(owner1, name2, argument1, 'S');
        logging.log("Create cumulative exclusive lock");
        locking.lock(owner1, name2, argument2, 'E');
        logging.log("Create non-cumulative exclusive lock");
        locking.lock(owner1, name2, argument3, 'X');
    }
}

